/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.guava.deser.multimap;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public abstract class GuavaMultimapDeserializer<T extends Multimap<Object, Object>>
extends JsonDeserializer<T>
implements ContextualDeserializer {
    private static final List<String> METHOD_NAMES = ImmutableList.of((Object)"copyOf", (Object)"create");
    private final MapLikeType type;
    private final KeyDeserializer keyDeserializer;
    private final TypeDeserializer elementTypeDeserializer;
    private final JsonDeserializer<?> elementDeserializer;
    private final Method creatorMethod;

    public GuavaMultimapDeserializer(MapLikeType type, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) {
        this(type, keyDeserializer, elementTypeDeserializer, elementDeserializer, GuavaMultimapDeserializer.findTransformer(type.getRawClass()));
    }

    public GuavaMultimapDeserializer(MapLikeType type, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer, Method creatorMethod) {
        this.type = type;
        this.keyDeserializer = keyDeserializer;
        this.elementTypeDeserializer = elementTypeDeserializer;
        this.elementDeserializer = elementDeserializer;
        this.creatorMethod = creatorMethod;
    }

    private static Method findTransformer(Class<?> rawType) {
        Method m;
        if (rawType == LinkedListMultimap.class || rawType == ListMultimap.class || rawType == Multimap.class) {
            return null;
        }
        for (String methodName : METHOD_NAMES) {
            try {
                m = rawType.getMethod(methodName, Multimap.class);
                if (m == null) continue;
                return m;
            }
            catch (NoSuchMethodException e) {
            }
        }
        for (String methodName : METHOD_NAMES) {
            try {
                m = rawType.getMethod(methodName, Multimap.class);
                if (m == null) continue;
                return m;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return null;
    }

    protected abstract T createMultimap();

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        TypeDeserializer etd;
        JsonDeserializer ed;
        KeyDeserializer kd = this.keyDeserializer;
        if (kd == null) {
            kd = ctxt.findKeyDeserializer(this.type.getKeyType(), property);
        }
        if ((ed = this.elementDeserializer) == null) {
            ed = ctxt.findContextualValueDeserializer(this.type.getContentType(), property);
        }
        if ((etd = this.elementTypeDeserializer) != null && property != null) {
            etd = etd.forProperty(property);
        }
        return this._createContextual(this.type, kd, etd, ed, this.creatorMethod);
    }

    protected abstract JsonDeserializer<?> _createContextual(MapLikeType var1, KeyDeserializer var2, TypeDeserializer var3, JsonDeserializer<?> var4, Method var5);

    public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (ctxt.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) {
            return this.deserializeFromSingleValue(jp, ctxt);
        }
        return this.deserializeContents(jp, ctxt);
    }

    private T deserializeContents(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        T multimap = this.createMultimap();
        this.expect(jp, JsonToken.START_OBJECT);
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            Object key = this.keyDeserializer != null ? this.keyDeserializer.deserializeKey(jp.getCurrentName(), ctxt) : jp.getCurrentName();
            jp.nextToken();
            this.expect(jp, JsonToken.START_ARRAY);
            while (jp.nextToken() != JsonToken.END_ARRAY) {
                Object value = jp.getCurrentToken() == JsonToken.VALUE_NULL ? null : (this.elementTypeDeserializer != null ? this.elementDeserializer.deserializeWithType(jp, ctxt, this.elementTypeDeserializer) : this.elementDeserializer.deserialize(jp, ctxt));
                multimap.put(key, value);
            }
        }
        if (this.creatorMethod == null) {
            return multimap;
        }
        try {
            Multimap map = (Multimap)this.creatorMethod.invoke(null, multimap);
            return (T)map;
        }
        catch (InvocationTargetException e) {
            throw new JsonMappingException((Closeable)jp, "Could not map to " + this.type, this._peel(e));
        }
        catch (IllegalArgumentException e) {
            throw new JsonMappingException((Closeable)jp, "Could not map to " + this.type, this._peel(e));
        }
        catch (IllegalAccessException e) {
            throw new JsonMappingException((Closeable)jp, "Could not map to " + this.type, this._peel(e));
        }
    }

    private T deserializeFromSingleValue(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        T multimap = this.createMultimap();
        this.expect(jp, JsonToken.START_OBJECT);
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            Object value;
            Object key = this.keyDeserializer != null ? this.keyDeserializer.deserializeKey(jp.getCurrentName(), ctxt) : jp.getCurrentName();
            jp.nextToken();
            if (jp.currentToken() == JsonToken.START_ARRAY) {
                while (jp.nextToken() != JsonToken.END_ARRAY) {
                    value = this.getCurrentTokenValue(jp, ctxt);
                    multimap.put(key, value);
                }
                continue;
            }
            value = this.getCurrentTokenValue(jp, ctxt);
            multimap.put(key, value);
        }
        if (this.creatorMethod == null) {
            return multimap;
        }
        try {
            Multimap map = (Multimap)this.creatorMethod.invoke(null, multimap);
            return (T)map;
        }
        catch (InvocationTargetException e) {
            throw new JsonMappingException((Closeable)jp, "Could not map to " + this.type, this._peel(e));
        }
        catch (IllegalArgumentException e) {
            throw new JsonMappingException((Closeable)jp, "Could not map to " + this.type, this._peel(e));
        }
        catch (IllegalAccessException e) {
            throw new JsonMappingException((Closeable)jp, "Could not map to " + this.type, this._peel(e));
        }
    }

    private Object getCurrentTokenValue(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Object value = jp.getCurrentToken() == JsonToken.VALUE_NULL ? null : (this.elementTypeDeserializer != null ? this.elementDeserializer.deserializeWithType(jp, ctxt, this.elementTypeDeserializer) : this.elementDeserializer.deserialize(jp, ctxt));
        return value;
    }

    private void expect(JsonParser jp, JsonToken token) throws IOException {
        if (jp.getCurrentToken() != token) {
            throw new JsonMappingException((Closeable)jp, "Expecting " + token + ", found " + jp.getCurrentToken(), jp.getCurrentLocation());
        }
    }

    private Throwable _peel(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }
}

