/*
 * Decompiled with CFR 0.152.
 */
package com.lorne.core.framework.utils.excel;

import com.lorne.core.framework.utils.excel.model.LRow;
import com.lorne.core.framework.utils.excel.model.LSheet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtils {
    private static Cell withMergeCell(Sheet sheet, Cell cell, List<CellRangeAddress> ranges) {
        if (cell == null) {
            return null;
        }
        if (ranges == null || ranges.size() == 0) {
            return cell;
        }
        for (CellRangeAddress range : ranges) {
            if (!range.isInRange(cell)) continue;
            int firstColumn = range.getFirstColumn();
            int lastColumn = range.getLastColumn();
            int firstRow = range.getFirstRow();
            int lastRow = range.getLastRow();
            Row row = sheet.getRow(firstRow);
            Cell value = row.getCell(firstColumn);
            return value;
        }
        return cell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LSheet> getExcelData(File filePath) throws Exception {
        try (Object wb = null;){
            ArrayList<LSheet> sheets = new ArrayList<LSheet>();
            String fileName = filePath.getName();
            wb = fileName.endsWith(".xlsx") ? new XSSFWorkbook(filePath) : new HSSFWorkbook((InputStream)new FileInputStream(filePath));
            int sheetNumbers = wb.getNumberOfSheets();
            for (int page = 0; page < sheetNumbers; ++page) {
                Sheet sheet = wb.getSheetAt(page);
                LSheet lSheet = new LSheet();
                lSheet.setSheetName(sheet.getSheetName());
                List ranges = sheet.getMergedRegions();
                int rows = sheet.getPhysicalNumberOfRows();
                ArrayList<LRow> lRows = new ArrayList<LRow>();
                for (int rowIndex = 0; rowIndex < rows; ++rowIndex) {
                    LRow lRow = new LRow();
                    ArrayList<String> content = new ArrayList<String>();
                    Row row = sheet.getRow(rowIndex);
                    if (row == null) continue;
                    int colNumber = row.getPhysicalNumberOfCells();
                    for (int colIndex = 0; colIndex < colNumber; ++colIndex) {
                        Cell val = ExcelUtils.withMergeCell(sheet, row.getCell(colIndex), ranges);
                        String value = ExcelUtils.getCellValue(val);
                        content.add(value);
                    }
                    lRow.setContent(content);
                    lRows.add(lRow);
                }
                lSheet.setRows(lRows);
                sheets.add(lSheet);
            }
            ArrayList<LSheet> arrayList = sheets;
            return arrayList;
        }
    }

    private static String getCellValue(Cell cell) {
        String cellvalue = "";
        if (cell != null) {
            CellType cellType = cell.getCellTypeEnum();
            switch (cellType) {
                case NUMERIC: {
                    short format = cell.getCellStyle().getDataFormat();
                    if (format == 14 || format == 31 || format == 57 || format == 58) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        double value = cell.getNumericCellValue();
                        Date date = DateUtil.getJavaDate((double)value);
                        cellvalue = sdf.format(date);
                        break;
                    }
                    if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                        Date date = cell.getDateCellValue();
                        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd");
                        cellvalue = formater.format(date);
                        break;
                    }
                    cellvalue = NumberToTextConverter.toText((double)cell.getNumericCellValue());
                    break;
                }
                case STRING: {
                    cellvalue = cell.getStringCellValue().replaceAll("'", "''");
                    break;
                }
                case BLANK: {
                    cellvalue = "";
                    break;
                }
                case FORMULA: {
                    try {
                        DecimalFormat df = new DecimalFormat("#.##");
                        cellvalue = String.valueOf(df.format(cell.getNumericCellValue()));
                    }
                    catch (Exception e) {
                        cellvalue = String.valueOf(cell);
                    }
                    break;
                }
                default: {
                    cellvalue = " ";
                    break;
                }
            }
        } else {
            cellvalue = "";
        }
        return cellvalue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeExcel(File file, List<LSheet> sheets) throws Exception {
        Object wb = null;
        FileOutputStream os = null;
        try {
            String fileName = file.getName();
            os = new FileOutputStream(file);
            wb = fileName.endsWith(".xlsx") ? new XSSFWorkbook() : new HSSFWorkbook();
            for (int pageIndex = 0; pageIndex < sheets.size(); ++pageIndex) {
                LSheet lSheet = sheets.get(pageIndex);
                Sheet sheet = wb.createSheet(lSheet.getSheetName());
                List<LRow> rows = lSheet.getRows();
                for (int row = 0; row < rows.size(); ++row) {
                    Row rowData = sheet.createRow(row);
                    List<String> content = rows.get(row).getContent();
                    for (int j = 0; j < content.size(); ++j) {
                        String v = content.get(j);
                        rowData.createCell(j).setCellValue(v);
                    }
                }
            }
            wb.write((OutputStream)os);
        }
        finally {
            if (wb != null) {
                wb.close();
            }
            if (os != null) {
                ((OutputStream)os).close();
            }
        }
    }
}

