/*
 * Decompiled with CFR 0.152.
 */
package com.lorne.mysql.framework.dao.impl;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Map;

public class BeanProcessor
extends org.apache.commons.dbutils.BeanProcessor {
    private Map<String, String> columnToPropertyOverrides;

    public BeanProcessor() {
    }

    public BeanProcessor(Map<String, String> columnToPropertyOverrides) {
        super(columnToPropertyOverrides);
        this.columnToPropertyOverrides = columnToPropertyOverrides;
    }

    protected Object processColumn(ResultSet rs, int index, Class<?> propType) throws SQLException {
        if (!propType.isPrimitive() && rs.getObject(index) == null) {
            return null;
        }
        if (propType.equals(String.class)) {
            return rs.getString(index);
        }
        if (propType.equals(Integer.TYPE) || propType.equals(Integer.class)) {
            return rs.getInt(index);
        }
        if (propType.equals(Boolean.TYPE) || propType.equals(Boolean.class)) {
            return rs.getBoolean(index);
        }
        if (propType.equals(Long.TYPE) || propType.equals(Long.class)) {
            return rs.getLong(index);
        }
        if (propType.equals(Double.TYPE) || propType.equals(Double.class)) {
            return rs.getDouble(index);
        }
        if (propType.equals(Float.TYPE) || propType.equals(Float.class)) {
            return Float.valueOf(rs.getFloat(index));
        }
        if (propType.equals(Short.TYPE) || propType.equals(Short.class)) {
            return rs.getShort(index);
        }
        if (propType.equals(Byte.TYPE) || propType.equals(Byte.class)) {
            return rs.getByte(index);
        }
        if (propType.equals(Timestamp.class)) {
            return rs.getTimestamp(index);
        }
        if (propType.equals(SQLXML.class)) {
            return rs.getSQLXML(index);
        }
        if (propType.isEnum()) {
            try {
                Method getCode = propType.getMethod("getCode", new Class[0]);
                if (getCode != null) {
                    Method method = propType.getMethod("valueOfCode", getCode.getReturnType());
                    Object obj = method.invoke(Enum.class, rs.getObject(index));
                    return obj;
                }
            }
            catch (Exception e) {
                return null;
            }
            return null;
        }
        return rs.getObject(index);
    }

    protected int[] mapColumnsToProperties(ResultSetMetaData rsmd, PropertyDescriptor[] props) throws SQLException {
        int cols = rsmd.getColumnCount();
        int[] columnToProperty = new int[cols + 1];
        Arrays.fill(columnToProperty, -1);
        block0: for (int col = 1; col <= cols; ++col) {
            String propertyName;
            String columnName = rsmd.getColumnLabel(col);
            if (null == columnName || 0 == columnName.length()) {
                columnName = rsmd.getColumnName(col);
            }
            if ((propertyName = this.columnToPropertyOverrides.get(columnName.toUpperCase())) == null) {
                propertyName = columnName;
            }
            for (int i = 0; i < props.length; ++i) {
                if (!propertyName.equalsIgnoreCase(props[i].getName())) continue;
                columnToProperty[col] = i;
                continue block0;
            }
        }
        return columnToProperty;
    }
}

