/*
 * Decompiled with CFR 0.152.
 */
package com.lorne.mysql.framework.utils;

import java.util.Iterator;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.OracleHint;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.First;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.Skip;
import net.sf.jsqlparser.statement.select.Top;
import net.sf.jsqlparser.util.deparser.ExpressionDeParser;
import net.sf.jsqlparser.util.deparser.LimitDeparser;
import net.sf.jsqlparser.util.deparser.OrderByDeParser;
import net.sf.jsqlparser.util.deparser.SelectDeParser;

public class SelectCountParser
extends SelectDeParser {
    private boolean isAddCount = false;

    public SelectCountParser(String sql) throws JSQLParserException {
        StringBuilder buffer = new StringBuilder();
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        PlainSelect plainSelect = (PlainSelect)select.getSelectBody();
        ExpressionDeParser expressionDeParser = new ExpressionDeParser();
        super.setExpressionVisitor((ExpressionVisitor)expressionDeParser);
        super.setBuffer(buffer);
        expressionDeParser.setSelectVisitor((SelectVisitor)this);
        expressionDeParser.setBuffer(buffer);
        plainSelect.accept((SelectVisitor)this);
    }

    public String getCountSql() {
        return this.getBuffer().toString();
    }

    public void visit(PlainSelect plainSelect) {
        Top top;
        First first;
        Skip skip;
        if (plainSelect.isUseBrackets()) {
            this.getBuffer().append("(");
        }
        this.getBuffer().append("SELECT ");
        OracleHint hint = plainSelect.getOracleHint();
        if (hint != null) {
            this.getBuffer().append(hint).append(" ");
        }
        if ((skip = plainSelect.getSkip()) != null) {
            this.getBuffer().append(skip).append(" ");
        }
        if ((first = plainSelect.getFirst()) != null) {
            this.getBuffer().append(first).append(" ");
        }
        if (plainSelect.getDistinct() != null) {
            this.getBuffer().append("DISTINCT ");
            if (plainSelect.getDistinct().getOnSelectItems() != null) {
                this.getBuffer().append("ON (");
                Iterator iter = plainSelect.getDistinct().getOnSelectItems().iterator();
                while (iter.hasNext()) {
                    SelectItem selectItem = (SelectItem)iter.next();
                    selectItem.accept((SelectItemVisitor)this);
                    if (!iter.hasNext()) continue;
                    this.getBuffer().append(", ");
                }
                this.getBuffer().append(") ");
            }
        }
        if ((top = plainSelect.getTop()) != null) {
            this.getBuffer().append(top).append(" ");
        }
        Iterator iter = plainSelect.getSelectItems().iterator();
        while (iter.hasNext()) {
            SelectItem selectItem = (SelectItem)iter.next();
            selectItem.accept((SelectItemVisitor)this);
            if (this.isAddCount) break;
            if (!iter.hasNext()) continue;
            this.getBuffer().append(", ");
        }
        if (plainSelect.getIntoTables() != null) {
            this.getBuffer().append(" INTO ");
            iter = plainSelect.getIntoTables().iterator();
            while (iter.hasNext()) {
                this.visit((Table)iter.next());
                if (!iter.hasNext()) continue;
                this.getBuffer().append(", ");
            }
        }
        if (plainSelect.getFromItem() != null) {
            this.getBuffer().append(" FROM ");
            plainSelect.getFromItem().accept((FromItemVisitor)this);
        }
        if (plainSelect.getJoins() != null) {
            for (Join join : plainSelect.getJoins()) {
                this.deparseJoin(join);
            }
        }
        if (plainSelect.getWhere() != null) {
            this.getBuffer().append(" WHERE ");
            plainSelect.getWhere().accept(this.getExpressionVisitor());
        }
        if (plainSelect.getOracleHierarchical() != null) {
            plainSelect.getOracleHierarchical().accept(this.getExpressionVisitor());
        }
        if (plainSelect.getGroupByColumnReferences() != null) {
            this.getBuffer().append(" GROUP BY ");
            iter = plainSelect.getGroupByColumnReferences().iterator();
            while (iter.hasNext()) {
                Expression columnReference = (Expression)iter.next();
                columnReference.accept(this.getExpressionVisitor());
                if (!iter.hasNext()) continue;
                this.getBuffer().append(", ");
            }
        }
        if (plainSelect.getHaving() != null) {
            this.getBuffer().append(" HAVING ");
            plainSelect.getHaving().accept(this.getExpressionVisitor());
        }
        if (plainSelect.getOrderByElements() != null) {
            new OrderByDeParser(this.getExpressionVisitor(), this.getBuffer()).deParse(plainSelect.isOracleSiblings(), plainSelect.getOrderByElements());
        }
        if (plainSelect.getLimit() != null) {
            new LimitDeparser(this.getBuffer()).deParse(plainSelect.getLimit());
        }
        if (plainSelect.getOffset() != null) {
            this.deparseOffset(plainSelect.getOffset());
        }
        if (plainSelect.getFetch() != null) {
            this.deparseFetch(plainSelect.getFetch());
        }
        if (plainSelect.isForUpdate()) {
            this.getBuffer().append(" FOR UPDATE");
            if (plainSelect.getForUpdateTable() != null) {
                this.getBuffer().append(" OF ").append(plainSelect.getForUpdateTable());
            }
        }
        if (plainSelect.isUseBrackets()) {
            this.getBuffer().append(")");
        }
    }

    private void addCount() {
        if (!this.isAddCount) {
            this.getBuffer().append("count(1)");
            this.isAddCount = !this.isAddCount;
        }
    }

    public void visit(AllColumns allColumns) {
        if (!this.isAddCount) {
            this.addCount();
        } else {
            super.visit(allColumns);
        }
    }

    public void visit(AllTableColumns allTableColumns) {
        if (!this.isAddCount) {
            this.addCount();
        } else {
            super.visit(allTableColumns);
        }
    }

    public void visit(SelectExpressionItem selectExpressionItem) {
        if (!this.isAddCount) {
            this.addCount();
        } else {
            super.visit(selectExpressionItem);
        }
    }
}

