/*
 * Decompiled with CFR 0.152.
 */
package com.lorne.mysql.framework.dao.impl;

import com.lorne.core.framework.model.BaseEntity;
import com.lorne.core.framework.model.Page;
import com.lorne.mysql.framework.dao.impl.BeanProcessor;
import com.lorne.mysql.framework.dao.impl.JdbcTemplateProxy;
import com.lorne.mysql.framework.utils.SelectCountUtils;
import com.lorne.mysql.framework.utils.SelectLimitUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import net.sf.jsqlparser.JSQLParserException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

public class BaseJdbcTemplate<T extends BaseEntity> {
    private RowProcessor defaultConvert = new BasicRowProcessor();
    protected Class<?> clazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    protected String tableName;
    protected String className = this.clazz.getSimpleName();
    protected String idName;
    protected String generatorProperty;
    private Map<String, String> columnToPropertyOverrides;
    private Map<String, String> propertyToColumnOverrides;
    private String insertSql;
    private String updateSql;
    @Autowired
    private JdbcTemplateProxy jdbcTemplateProxy;

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplateProxy.getJdbcTemplate();
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    protected String loadTableName(String tableName) {
        return tableName;
    }

    public BaseJdbcTemplate() {
        Table table = this.clazz.getAnnotation(Table.class);
        this.tableName = table == null ? this.clazz.getSimpleName() : table.name();
        this.tableName = this.loadTableName(this.tableName);
        if (this.columnToPropertyOverrides == null) {
            this.columnToPropertyOverrides = this.getColumnToPropertyOverrides();
        }
        if (this.propertyToColumnOverrides == null) {
            this.propertyToColumnOverrides = this.getPropertyToColumnOverrides();
        }
        this.insertSql = this.getInsertSql();
        this.updateSql = this.getUpdateSql();
    }

    private String getInsertSql() {
        if (this.propertyToColumnOverrides == null || this.propertyToColumnOverrides.size() == 0) {
            return null;
        }
        String sql = "insert into  {table} ({columns}) values ({values})";
        String columns = "";
        String values = "";
        Set<String> sets = this.propertyToColumnOverrides.keySet();
        boolean isAdd = false;
        for (String propertyName : sets) {
            if (this.generatorProperty != null && this.generatorProperty.equals(propertyName)) continue;
            String columnName = this.propertyToColumnOverrides.get(propertyName);
            columns = columns + columnName + ",";
            values = values + "?,";
            isAdd = true;
        }
        if (isAdd) {
            columns = columns.substring(0, columns.length() - 1);
            values = values.substring(0, values.length() - 1);
        }
        sql = sql.replace("{columns}", columns);
        sql = sql.replace("{values}", values);
        return sql;
    }

    private String getUpdateSql() {
        if (this.propertyToColumnOverrides == null || this.propertyToColumnOverrides.size() == 0) {
            return null;
        }
        String sql = "update {table} set {set} where {id} = ? ";
        String set = "";
        Set<String> sets = this.propertyToColumnOverrides.keySet();
        boolean isAdd = false;
        for (String propertyName : sets) {
            if (this.generatorProperty != null && this.generatorProperty.equals(propertyName)) continue;
            String columnName = this.propertyToColumnOverrides.get(propertyName);
            set = set + columnName + "= ? ,";
            isAdd = true;
        }
        if (isAdd) {
            set = set.substring(0, set.length() - 1);
        }
        sql = sql.replace("{set}", set);
        sql = sql.replace("{id}", this.idName);
        return sql;
    }

    private Map<String, String> getColumnToPropertyOverrides() {
        HashMap<String, String> maps = new HashMap<String, String>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = this.propertyDescriptors(this.clazz)) {
                Method gmethod = propertyDescriptor.getReadMethod();
                if (null == gmethod) continue;
                Column column = gmethod.getAnnotation(Column.class);
                String columnName = "";
                columnName = column == null || StringUtils.isEmpty((String)column.name()) ? this.propertyToColumn(propertyDescriptor.getName()) : column.name();
                maps.put(columnName.toUpperCase(), propertyDescriptor.getName());
            }
            return maps;
        }
        catch (SQLException e) {
            return null;
        }
    }

    private Map<String, String> getPropertyToColumnOverrides() {
        HashMap<String, String> maps = new HashMap<String, String>();
        PropertyDescriptor[] propertyDescriptors = new PropertyDescriptor[]{};
        try {
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = this.propertyDescriptors(this.clazz)) {
                Transient aTransient;
                Method gmethod = propertyDescriptor.getReadMethod();
                Method smethod = propertyDescriptor.getWriteMethod();
                if (null == gmethod || smethod == null || (aTransient = gmethod.getAnnotation(Transient.class)) != null) continue;
                Column column = gmethod.getAnnotation(Column.class);
                GeneratedValue generator = gmethod.getAnnotation(GeneratedValue.class);
                if (generator != null) {
                    this.generatorProperty = propertyDescriptor.getName();
                }
                String columnName = column == null || StringUtils.isEmpty((String)column.name()) ? this.propertyToColumn(propertyDescriptor.getName()) : column.name();
                Id id = gmethod.getAnnotation(Id.class);
                if (id != null) {
                    this.idName = columnName;
                }
                columnName = columnName.toUpperCase();
                maps.put(propertyDescriptor.getName(), columnName);
            }
            if (this.idName == null || "".equals(this.idName)) {
                throw new RuntimeException(this.className + " id not exist!");
            }
            return maps;
        }
        catch (SQLException e) {
            return null;
        }
    }

    private String propertyToColumn(String propertyName) {
        char[] chs = propertyName.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < chs.length; ++i) {
            char c = chs[i];
            char index = c;
            if (index < 'a') {
                sb.append("_");
                sb.append((char)(c + 32));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private PropertyDescriptor[] propertyDescriptors(Class<?> c) throws SQLException {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(c);
        }
        catch (IntrospectionException var4) {
            throw new SQLException("Bean introspection failed: " + var4.getMessage());
        }
        return beanInfo.getPropertyDescriptors();
    }

    public Map<String, Object> toMap(ResultSet rs) throws SQLException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ResultSetMetaData rsmd = rs.getMetaData();
        int cols = rsmd.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            String propertyName;
            String columnName = rsmd.getColumnLabel(i);
            if (null == columnName || 0 == columnName.length()) {
                columnName = rsmd.getColumnName(i);
            }
            if ((propertyName = this.columnToPropertyOverrides.get(columnName.toUpperCase())) != null) {
                result.put(propertyName, rs.getObject(i));
                continue;
            }
            result.put(columnName, rs.getObject(i));
        }
        return result;
    }

    public <T> T toBean(ResultSet rs, Map<String, String> columnToPropertyOverrides) throws SQLException {
        Object convert = null;
        convert = columnToPropertyOverrides != null ? new BasicRowProcessor((org.apache.commons.dbutils.BeanProcessor)new BeanProcessor(columnToPropertyOverrides)) : this.defaultConvert;
        return (T)convert.toBean(rs, this.clazz);
    }

    public String initSql(String sql) {
        while (sql.contains("  ")) {
            sql = sql.replace("  ", " ");
        }
        sql = sql.replace("{table}", this.tableName);
        sql = sql.replace("{id}", this.idName);
        if (this.propertyToColumnOverrides != null) {
            for (String key : this.propertyToColumnOverrides.keySet()) {
                sql = sql.replace("{" + key + "}", this.propertyToColumnOverrides.get(key));
            }
        }
        return sql;
    }

    public <T> T queryForBean(String sql) {
        return (T)this.getJdbcTemplate().query(this.initSql(sql), new ResultSetExtractor<T>(){

            public T extractData(ResultSet rs) throws SQLException, DataAccessException {
                return rs.next() ? (Object)BaseJdbcTemplate.this.toBean(rs, BaseJdbcTemplate.this.columnToPropertyOverrides) : null;
            }
        });
    }

    public Map<String, Object> queryForMap(String sql) {
        return (Map)this.getJdbcTemplate().query(this.initSql(sql), (ResultSetExtractor)new ResultSetExtractor<Map<String, Object>>(){

            public Map<String, Object> extractData(ResultSet rs) throws SQLException, DataAccessException {
                return rs.next() ? BaseJdbcTemplate.this.toMap(rs) : null;
            }
        });
    }

    public Map<String, Object> queryForMap(String sql, Object ... args) {
        return (Map)this.getJdbcTemplate().query(this.initSql(sql), args, (ResultSetExtractor)new ResultSetExtractor<Map<String, Object>>(){

            public Map<String, Object> extractData(ResultSet rs) throws SQLException, DataAccessException {
                return rs.next() ? BaseJdbcTemplate.this.toMap(rs) : null;
            }
        });
    }

    public List<Map<String, Object>> queryForMapList(String sql) {
        return this.getJdbcTemplate().query(this.initSql(sql), (RowMapper)new RowMapper<Map<String, Object>>(){

            public Map<String, Object> mapRow(ResultSet rs, int i) throws SQLException {
                return BaseJdbcTemplate.this.toMap(rs);
            }
        });
    }

    public List<Map<String, Object>> queryForMapList(String sql, Object ... args) {
        return this.getJdbcTemplate().query(this.initSql(sql), args, (RowMapper)new RowMapper<Map<String, Object>>(){

            public Map<String, Object> mapRow(ResultSet rs, int i) throws SQLException {
                return BaseJdbcTemplate.this.toMap(rs);
            }
        });
    }

    public <T> T queryForBean(String sql, final Map<String, String> columnToPropertyOverrides, Object ... args) {
        return (T)this.getJdbcTemplate().query(this.initSql(sql), args, new ResultSetExtractor<T>(){

            public T extractData(ResultSet rs) throws SQLException, DataAccessException {
                return rs.next() ? (Object)BaseJdbcTemplate.this.toBean(rs, columnToPropertyOverrides) : null;
            }
        });
    }

    public <T> List<T> queryForBeanList(String sql, final Map<String, String> columnToPropertyOverrides, Object ... args) {
        return this.getJdbcTemplate().query(this.initSql(sql), args, new RowMapper<T>(){

            public T mapRow(ResultSet rs, int i) throws SQLException {
                return BaseJdbcTemplate.this.toBean(rs, columnToPropertyOverrides);
            }
        });
    }

    public <T> T queryForBean(String sql, Object ... args) {
        return (T)this.getJdbcTemplate().query(this.initSql(sql), args, new ResultSetExtractor<T>(){

            public T extractData(ResultSet rs) throws SQLException, DataAccessException {
                return rs.next() ? (Object)BaseJdbcTemplate.this.toBean(rs, BaseJdbcTemplate.this.columnToPropertyOverrides) : null;
            }
        });
    }

    public <T> List<T> queryForBeanList(String sql) {
        return this.getJdbcTemplate().query(this.initSql(sql), new RowMapper<T>(){

            public T mapRow(ResultSet rs, int i) throws SQLException {
                return BaseJdbcTemplate.this.toBean(rs, BaseJdbcTemplate.this.columnToPropertyOverrides);
            }
        });
    }

    public <T> List<T> queryForBeanList(String sql, Object ... args) {
        return this.getJdbcTemplate().query(this.initSql(sql), args, new RowMapper<T>(){

            public T mapRow(ResultSet rs, int i) throws SQLException {
                return BaseJdbcTemplate.this.toBean(rs, BaseJdbcTemplate.this.columnToPropertyOverrides);
            }
        });
    }

    private Object getValueByPropertyName(T t, String propertyName) {
        try {
            PropertyDescriptor propertyDescriptor = PropertyUtils.getPropertyDescriptor(t, (String)propertyName);
            Method method = propertyDescriptor.getReadMethod();
            Object val = method.invoke(t, new Object[0]);
            return val;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Page<Map<String, Object>> pageForMapList(String sql, int nowPage, int pageSize) {
        return this.pageForMapList(sql, nowPage, pageSize, null);
    }

    public Page<Map<String, Object>> pageForMapList(String sql, int nowPage, int pageSize, Object ... args) {
        sql = this.initSql(sql);
        String countSql = null;
        String limitSql = null;
        try {
            countSql = SelectCountUtils.getCountSql(sql);
            limitSql = SelectLimitUtils.getLimitSql(sql, nowPage, pageSize);
        }
        catch (JSQLParserException e) {
            System.out.println(sql + ",\u683c\u5f0f\u4e0d\u6b63\u786e,\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5.");
            return null;
        }
        Page page = new Page();
        ArrayList<Object> objs = new ArrayList<Object>();
        if (args != null && args.length > 0) {
            for (Object obj : args) {
                objs.add(obj);
            }
        }
        int count = this.queryForInt(countSql, objs.toArray());
        page.setTotal(count);
        List list = this.getJdbcTemplate().query(limitSql, objs.toArray(), (RowMapper)new RowMapper<Map<String, Object>>(){

            public Map<String, Object> mapRow(ResultSet rs, int i) throws SQLException {
                return BaseJdbcTemplate.this.toMap(rs);
            }
        });
        page.setRows((Collection)list);
        page.setNowPage(nowPage);
        page.setPageSize(pageSize);
        int pageNumber = 0;
        if (count > 0) {
            pageNumber = count % pageSize == 0 ? count / pageSize : count / pageSize + 1;
        }
        page.setPageNumber(pageNumber);
        return page;
    }

    public <T> Page<T> pageForBeanList(String sql, int nowPage, int pageSize) {
        return this.pageForBeanList(sql, nowPage, pageSize, null);
    }

    public <T> Page<T> pageForBeanList(String sql, int nowPage, int pageSize, final Map<String, String> columnToPropertyOverrides, Object ... args) {
        sql = this.initSql(sql);
        String countSql = null;
        String limitSql = null;
        try {
            countSql = SelectCountUtils.getCountSql(sql);
            limitSql = SelectLimitUtils.getLimitSql(sql, nowPage, pageSize);
        }
        catch (JSQLParserException e) {
            System.out.println(sql + ",\u683c\u5f0f\u4e0d\u6b63\u786e,\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5.");
            return null;
        }
        Page page = new Page();
        ArrayList<Object> objs = new ArrayList<Object>();
        if (args != null && args.length > 0) {
            for (Object obj : args) {
                objs.add(obj);
            }
        }
        int count = this.queryForInt(countSql, objs.toArray());
        page.setTotal(count);
        List list = this.getJdbcTemplate().query(limitSql, objs.toArray(), new RowMapper<T>(){

            public T mapRow(ResultSet rs, int i) throws SQLException {
                return BaseJdbcTemplate.this.toBean(rs, columnToPropertyOverrides);
            }
        });
        page.setRows((Collection)list);
        page.setNowPage(nowPage);
        page.setPageSize(pageSize);
        int pageNumber = 0;
        if (count > 0) {
            pageNumber = count % pageSize == 0 ? count / pageSize : count / pageSize + 1;
        }
        page.setPageNumber(pageNumber);
        return page;
    }

    public <T> Page<T> pageForBeanList(String sql, int nowPage, int pageSize, Object ... args) {
        return this.pageForBeanList(sql, nowPage, pageSize, this.columnToPropertyOverrides, args);
    }

    public int queryForInt(String sql, Object ... args) {
        if (args != null && args.length > 0) {
            return (Integer)this.getJdbcTemplate().query(this.initSql(sql), args, (ResultSetExtractor)new ResultSetExtractor<Integer>(){

                public Integer extractData(ResultSet rs) throws SQLException, DataAccessException {
                    return rs.next() ? rs.getInt(1) : 0;
                }
            });
        }
        return (Integer)this.getJdbcTemplate().query(this.initSql(sql), (ResultSetExtractor)new ResultSetExtractor<Integer>(){

            public Integer extractData(ResultSet rs) throws SQLException, DataAccessException {
                return rs.next() ? rs.getInt(1) : 0;
            }
        });
    }

    public int queryForInt(String sql) {
        return this.queryForInt(sql, null);
    }

    public <T> Page<T> pageAll(int nowPage, int pageSize) {
        String sql = "select * from " + this.tableName;
        return this.pageForBeanList(sql, nowPage, pageSize);
    }

    public List<Map<String, Object>> listForMapList(String sql, int nowPage, int pageSize) {
        return this.listForMapList(sql, nowPage, pageSize, null);
    }

    public List<Map<String, Object>> listForMapList(String sql, int nowPage, int pageSize, Object ... args) {
        sql = this.initSql(sql);
        String limitSql = null;
        try {
            limitSql = SelectLimitUtils.getLimitSql(sql, nowPage, pageSize);
        }
        catch (JSQLParserException e) {
            System.out.println(sql + ",\u683c\u5f0f\u4e0d\u6b63\u786e,\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5.");
            return null;
        }
        Page page = new Page();
        ArrayList<Object> objs = new ArrayList<Object>();
        if (args != null && args.length > 0) {
            for (Object obj : args) {
                objs.add(obj);
            }
        }
        return this.getJdbcTemplate().query(limitSql, objs.toArray(), (RowMapper)new RowMapper<Map<String, Object>>(){

            public Map<String, Object> mapRow(ResultSet rs, int i) throws SQLException {
                return BaseJdbcTemplate.this.toMap(rs);
            }
        });
    }

    public <T> List<T> listForBeanList(String sql, int nowPage, int pageSize) {
        return this.listForBeanList(sql, nowPage, pageSize, this.columnToPropertyOverrides, null);
    }

    public <T> List<T> listForBeanList(String sql, int nowPage, int pageSize, final Map<String, String> columnToPropertyOverrides, Object ... args) {
        sql = this.initSql(sql);
        String limitSql = null;
        try {
            limitSql = SelectLimitUtils.getLimitSql(sql, nowPage, pageSize);
        }
        catch (JSQLParserException e) {
            System.out.println(sql + ",\u683c\u5f0f\u4e0d\u6b63\u786e,\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5.");
            return null;
        }
        ArrayList<Object> objs = new ArrayList<Object>();
        if (args != null && args.length > 0) {
            for (Object obj : args) {
                objs.add(obj);
            }
        }
        return this.getJdbcTemplate().query(limitSql, objs.toArray(), new RowMapper<T>(){

            public T mapRow(ResultSet rs, int i) throws SQLException {
                return BaseJdbcTemplate.this.toBean(rs, columnToPropertyOverrides);
            }
        });
    }

    public <T> List<T> listForBeanList(String sql, int nowPage, int pageSize, Object ... args) {
        return this.listForBeanList(sql, nowPage, pageSize, this.columnToPropertyOverrides, args);
    }

    public <T> List<T> listAll(int nowPage, int pageSize) {
        String sql = "select * from {table}";
        return this.listForBeanList(sql, nowPage, pageSize);
    }

    public int update(String sql, Object ... args) {
        sql = this.initSql(sql);
        int f = this.getJdbcTemplate().update(sql, args);
        return f;
    }

    public int update(T t) {
        if (this.propertyToColumnOverrides == null || this.propertyToColumnOverrides.size() == 0) {
            return 0;
        }
        ArrayList<Object> objects = new ArrayList<Object>();
        Set<String> sets = this.propertyToColumnOverrides.keySet();
        Object idVal = null;
        for (String propertyName : sets) {
            Object val = this.getValueByPropertyName(t, propertyName);
            if (val != null && val.getClass().isEnum()) {
                try {
                    Method method = val.getClass().getMethod("getCode", new Class[0]);
                    try {
                        val = method.invoke(val, new Object[0]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
            if (this.generatorProperty != null && this.generatorProperty.equals(propertyName)) {
                idVal = val;
                continue;
            }
            objects.add(val);
        }
        objects.add(idVal);
        return this.update(this.updateSql, objects.toArray());
    }

    public Long insertAndGetKey(String sql, final Object ... args) {
        final String mSql = this.initSql(sql);
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement(mSql, 1);
                if (args != null && args.length > 0) {
                    for (int index = 0; index < args.length; ++index) {
                        ps.setObject(index + 1, args[index]);
                    }
                }
                return ps;
            }
        }, (KeyHolder)keyHolder);
        Long generatedId = keyHolder.getKey().longValue();
        return generatedId;
    }

    public int[] batchUpdate(String sql, List<Object[]> objects) {
        sql = this.initSql(sql);
        return this.getJdbcTemplate().batchUpdate(sql, objects);
    }

    private void pushUUIDtoArray(List<String> uuids, Object id) {
        if (id != null && id instanceof Serializable) {
            uuids.add(String.valueOf(id));
        }
    }

    public long save(T t) {
        if (this.propertyToColumnOverrides == null || this.propertyToColumnOverrides.size() == 0) {
            return 0L;
        }
        ArrayList<Object> objects = new ArrayList<Object>();
        Set<String> sets = this.propertyToColumnOverrides.keySet();
        for (String propertyName : sets) {
            if (this.generatorProperty != null && this.generatorProperty.equals(propertyName)) continue;
            Object val = this.getValueByPropertyName(t, propertyName);
            if (val != null && val.getClass().isEnum()) {
                try {
                    Method method = val.getClass().getMethod("getCode", new Class[0]);
                    try {
                        val = method.invoke(val, new Object[0]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
            objects.add(val);
        }
        return this.insertAndGetKey(this.insertSql, objects.toArray());
    }

    public int update(String whereSql, Map<String, Object> setValues, Object ... params) {
        String sql = "update {table} set {setValues} where " + whereSql;
        String setSql = "";
        ArrayList<Object> mparams = new ArrayList<Object>();
        boolean isAdd = false;
        if (setValues != null && setValues.size() > 0) {
            for (String key : setValues.keySet()) {
                String upKey = this.propertyToColumn(key);
                String msql = " " + upKey + " = ? ,";
                setSql = setSql + msql;
                mparams.add(setValues.get(key));
                isAdd = true;
            }
        }
        if (isAdd) {
            setSql = setSql.substring(0, setSql.length() - 1);
        }
        sql = sql.replace("{setValues}", setSql);
        if (params != null && params.length > 0) {
            for (Object p : params) {
                mparams.add(p);
            }
        }
        return this.update(sql, mparams.toArray());
    }

    public int delete(String whereSql, Object ... params) {
        String sql = "delete from {table} where " + whereSql;
        return this.update(sql, params);
    }
}

