/*
 * Decompiled with CFR 0.152.
 */
package com.lorne.weixin.pay.api;

import com.lorne.core.framework.exception.ServiceException;
import com.lorne.weixin.pay.model.TemplateMsg;
import com.lorne.weixin.pay.model.WxConfig;
import com.lorne.weixin.pay.util.WeixinApiUtils;
import java.util.List;
import java.util.Map;

public abstract class AbstractWxPay {
    public static final String APP = "APP";
    public static final String NATIVE = "NATIVE";
    public static final String JSAPI = "JSAPI";
    protected WxConfig wxConfig;

    public AbstractWxPay() {
    }

    public AbstractWxPay(WxConfig wxConfig) {
        this.wxConfig = wxConfig;
    }

    public WxConfig getWxConfig() {
        return this.wxConfig;
    }

    public void setWxConfig(WxConfig wxConfig) {
        this.wxConfig = wxConfig;
    }

    public Map<String, Object> getOrderQuery(String out_trade_no) {
        return WeixinApiUtils.getOrderQuery(this.wxConfig, out_trade_no);
    }

    public boolean refundOrder(String out_trade_no, String out_refund_no, int total_fee, int refund_fee) {
        Map<String, Object> map = WeixinApiUtils.refundOrder(this.wxConfig, out_trade_no, out_refund_no, total_fee, refund_fee);
        return "SUCCESS".equals(map.get("return_code")) && map.containsKey("result_code") && "SUCCESS".equals(map.get("result_code"));
    }

    public Map<String, Object> refundQueryOrder(String out_trade_no) {
        return WeixinApiUtils.refundQueryOrder(this.wxConfig, out_trade_no);
    }

    public boolean checkOrderHasPay(String orderNumber) {
        return WeixinApiUtils.hasOrder(this.wxConfig, orderNumber);
    }

    public boolean closeOrder(String out_trade_no) {
        return WeixinApiUtils.closeOrder(this.wxConfig, out_trade_no);
    }

    public Map<String, Object> getOpendIdAndSessionKey(String jsCode) throws ServiceException {
        return WeixinApiUtils.getOpendIdAndSessionKey(this.wxConfig, jsCode);
    }

    public Map<String, Object> getAccessToken() throws ServiceException {
        return WeixinApiUtils.getAccessToken(this.wxConfig);
    }

    public Map<String, Object> pushMsg(String accessToken, String touser, String templateId, String formId, List<TemplateMsg> value) throws ServiceException {
        return WeixinApiUtils.pushMsg(accessToken, touser, templateId, formId, value);
    }

    public String getOpendIdByJsCode(String jsCode) throws ServiceException {
        Map<String, Object> map = this.getOpendIdAndSessionKey(jsCode);
        if (map != null) {
            return (String)map.get("openid");
        }
        throw new ServiceException("\u83b7\u53d6openid \u5931\u8d25");
    }
}

