/*
 * Decompiled with CFR 0.152.
 */
package com.lorne.weixin.pay.service;

import com.lorne.weixin.pay.model.WxConfig;
import com.lorne.weixin.pay.service.INotifyBack;
import com.lorne.weixin.pay.util.LogUtils;
import com.lorne.weixin.pay.util.WeixinApiUtils;
import com.lorne.weixin.pay.util.XMLParser;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class WxNotifyService {
    public String notifyOrder(String xml, INotifyBack back, WxConfig wxConfig) {
        String flag = "SUCCESS";
        String msg = "OK";
        try {
            Map<String, Object> map = XMLParser.getMapFromXML(xml);
            LogUtils.logResult("\u5fae\u4fe1\u56de\u8c03\u53c2\u6570", map.toString());
            if (map != null && "SUCCESS".equals(map.get("return_code"))) {
                String out_trade_no = (String)map.get("out_trade_no");
                String transactionId = (String)map.get("transaction_id");
                if (back != null && WeixinApiUtils.hasOrder(wxConfig, out_trade_no)) {
                    back.success(out_trade_no, transactionId, map);
                }
            }
        }
        catch (Exception e) {
            flag = "FAIL";
            msg = e.getLocalizedMessage();
        }
        String res = "<xml>\n  <return_code><![CDATA[" + flag + "]]></return_code>\n  <return_msg><![CDATA[" + msg + "]]></return_msg>\n</xml>";
        return res;
    }
}

