/*
 * Decompiled with CFR 0.152.
 */
package com.lorne.weixin.pay.util;

import com.alibaba.fastjson.JSONObject;
import com.lorne.core.framework.utils.http.HttpUtils;
import com.lorne.weixin.pay.model.CloseOrderReqData;
import com.lorne.weixin.pay.model.MicroPayReqData;
import com.lorne.weixin.pay.model.RefundQueryReqData;
import com.lorne.weixin.pay.model.RefundReqData;
import com.lorne.weixin.pay.model.ScanPayQueryReqData;
import com.lorne.weixin.pay.model.TemplateMsg;
import com.lorne.weixin.pay.model.UnifiedorderPayReqData;
import com.lorne.weixin.pay.model.WxConfig;
import com.lorne.weixin.pay.util.HttpApiUrl;
import com.lorne.weixin.pay.util.HttpsRequest;
import com.lorne.weixin.pay.util.LogUtils;
import com.lorne.weixin.pay.util.XMLParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WeixinUtils {
    public static Map<String, Object> payUnifiedorder(WxConfig config, String name, String detail, int total_fee, String ip, String out_trade_no, String openid, String trade_type) {
        UnifiedorderPayReqData unifiedorderPayReqData = new UnifiedorderPayReqData(config.getKey(), config.getAppId(), config.getMchId(), "", name, detail, "", out_trade_no, "", total_fee, ip, "", "", "", config.getNotifyUrl(), trade_type, "", openid);
        String postDataXML = unifiedorderPayReqData.toXml();
        LogUtils.logResult("\u8bf7\u6c42\u7edf\u4e00\u4e0b\u5355\u53c2\u6570", postDataXML);
        try {
            String res = HttpUtils.postXml((String)HttpApiUrl.PAY_UNFIFIEDORDER, (String)postDataXML);
            LogUtils.logResult("\u54cd\u5e94\u7edf\u4e00\u4e0b\u5355\u53c2\u6570", res);
            Map<String, Object> map = XMLParser.getMapFromXML(res);
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Object> payMicropay(WxConfig config, String authCode, String deviceInfo, String body, String outTradeNo, String ip, int totalFee) {
        MicroPayReqData mPayReqData = new MicroPayReqData(config.getAppId(), config.getMchId(), authCode, config.getKey(), deviceInfo, body, outTradeNo, totalFee, ip);
        String postDataXML = mPayReqData.toXml();
        LogUtils.logResult("\u8bf7\u6c42\u7edf\u4e00\u4e0b\u5355\u53c2\u6570", postDataXML);
        try {
            String res = HttpUtils.postXml((String)HttpApiUrl.PAY_MICROPAY, (String)postDataXML);
            LogUtils.logResult("\u54cd\u5e94\u7edf\u4e00\u4e0b\u5355\u53c2\u6570", res);
            Map<String, Object> map = XMLParser.getMapFromXML(res);
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Object> refund(WxConfig config, String out_trade_no, String out_refund_no, int total_fee, int refund_fee) {
        RefundReqData reqData = new RefundReqData(config.getKey(), config.getAppId(), config.getMchId(), out_trade_no, out_refund_no, total_fee, refund_fee, config.getMchId());
        String postDataXML = reqData.toXml();
        LogUtils.logResult("\u8bf7\u6c42\u7533\u8bf7\u9000\u6b3e", postDataXML);
        try {
            HttpsRequest httpsRequest = new HttpsRequest(config);
            String res = httpsRequest.sendPost(HttpApiUrl.PAY_REFUND_API, postDataXML);
            LogUtils.logResult("\u54cd\u5e94\u7533\u8bf7\u9000\u6b3e", res);
            Map<String, Object> map = XMLParser.getMapFromXML(res);
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Object> closeOrder(WxConfig config, String out_trade_no) {
        CloseOrderReqData reqData = new CloseOrderReqData(config.getKey(), config.getAppId(), config.getMchId(), out_trade_no);
        String postDataXML = reqData.toXml();
        LogUtils.logResult("\u8bf7\u6c42\u5173\u95ed\u8ba2\u5355", postDataXML);
        try {
            String res = HttpUtils.postXml((String)HttpApiUrl.PAY_CLOSE_ORDER_API, (String)postDataXML);
            LogUtils.logResult("\u54cd\u5e94\u5173\u95ed\u8ba2\u5355", res);
            Map<String, Object> map = XMLParser.getMapFromXML(res);
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Object> refundQuery(WxConfig config, String out_trade_no) {
        RefundQueryReqData reqData = new RefundQueryReqData(config.getKey(), config.getAppId(), config.getMchId(), out_trade_no);
        String postDataXML = reqData.toXml();
        LogUtils.logResult("\u8bf7\u6c42\u67e5\u8be2\u9000\u6b3e\u8ba2\u5355", postDataXML);
        try {
            String res = HttpUtils.postXml((String)HttpApiUrl.PAY_REFUND_QUERY_API, (String)postDataXML);
            LogUtils.logResult("\u54cd\u5e94\u67e5\u8be2\u9000\u6b3e\u8ba2\u5355", res);
            Map<String, Object> map = XMLParser.getMapFromXML(res);
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Object> payOrderquery(WxConfig config, String out_trade_no) {
        ScanPayQueryReqData scanPayQueryReqData = new ScanPayQueryReqData(config, null, out_trade_no);
        String postDataXML = scanPayQueryReqData.toXml();
        LogUtils.logResult("\u8bf7\u6c42\u67e5\u8be2\u8ba2\u5355", postDataXML);
        try {
            String res = HttpUtils.postXml((String)HttpApiUrl.PAY_QUERY_API, (String)postDataXML);
            LogUtils.logResult("\u54cd\u5e94\u67e5\u8be2\u8ba2\u5355", res);
            Map<String, Object> map = XMLParser.getMapFromXML(res);
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Object> jscode2session(WxConfig config, String jsCode) {
        String url = HttpApiUrl.JSCODE_SESSION_API + "?appid=" + config.getAppId() + "&secret=" + config.getAppSecret() + "&js_code=" + jsCode + "&grant_type=authorization_code";
        JSONObject map = null;
        String res = HttpUtils.get((String)url);
        LogUtils.logResult("\u83b7\u53d6sessionKey\u4e0eopendId\u8ba2\u5355", res);
        try {
            map = JSONObject.parseObject((String)res);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return map;
    }

    public static Map<String, Object> getAccessToken(WxConfig config) {
        String url = String.format(HttpApiUrl.PAY_ACCESS_TOKEN, config.getAppId(), config.getAppSecret());
        JSONObject map = null;
        String res = HttpUtils.get((String)url);
        LogUtils.logResult("\u83b7\u53d6ACCESS_TOKEN", res);
        try {
            map = JSONObject.parseObject((String)res);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return map;
    }

    public static Map<String, Object> pushMsg(String accessToken, String touser, String templateId, String formId, List<TemplateMsg> value) {
        String url = String.format(HttpApiUrl.SEND_MSG, accessToken);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("touser", touser);
        data.put("template_id", templateId);
        data.put("form_id", formId);
        HashMap<String, TemplateMsg> msgs = new HashMap<String, TemplateMsg>();
        for (int i = 0; i < value.size(); ++i) {
            TemplateMsg msg = value.get(i);
            msgs.put("keyword" + (i + 1), msg);
        }
        data.put("data", msgs);
        String json = new JSONObject(data).toJSONString();
        System.out.println(json);
        String res = HttpUtils.postJson((String)url, (String)json);
        LogUtils.logResult("\u53d1\u9001\u6a21\u677f\u6d88\u606f", res);
        JSONObject map = null;
        try {
            map = JSONObject.parseObject((String)res);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return map;
    }
}

