/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.idworker.strategy;

import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Random;
import org.n3r.idworker.WorkerIdStatrategy;
import org.n3r.idworker.strategy.FileLock;
import org.n3r.idworker.utils.HttpReq;
import org.n3r.idworker.utils.Ip;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWorkerIdStrategy
implements WorkerIdStatrategy {
    static long workerIdBits = 10L;
    static long maxWorkerId = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)workerIdBits;
    static Random random = new SecureRandom();
    public static final WorkerIdStatrategy instance = new DefaultWorkerIdStrategy();
    private final String idWorkerServerUrl = "http://id.worker.server:18001";
    String userName = System.getProperty("user.name");
    File dir = new File(System.getProperty("user.home") + File.separator + ".idworkers");
    String ipDotUsername = Ip.ip + "." + this.userName;
    String ipudotlock = this.ipDotUsername + ".lock.";
    int workerIdIndex = this.ipudotlock.length();
    long workerId;
    FileLock fileLock;
    Logger logger = LoggerFactory.getLogger(DefaultWorkerIdStrategy.class);
    private boolean inited;

    private void init() {
        this.dir.mkdirs();
        if (!this.dir.exists()) {
            throw new RuntimeException("create id workers dir fail " + this.dir);
        }
        this.workerId = this.findAvailWorkerId();
        if (this.workerId >= 0L) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    DefaultWorkerIdStrategy.this.fileLock.destroy();
                }
            });
            new Thread(){

                @Override
                public void run() {
                    DefaultWorkerIdStrategy.this.syncWithWorkerIdServer();
                }
            }.start();
        } else {
            this.syncWithWorkerIdServer();
            this.workerId = this.findAvailWorkerId();
            if (this.workerId < 0L) {
                this.workerId = this.increaseWithWorkerIdServer();
            }
        }
        if (this.workerId < 0L) {
            this.workerId = this.tryToCreateOnIp();
        }
        if (this.workerId < 0L) {
            this.logger.warn("DANGEROUS!!! Try to use random worker id.");
            this.workerId = this.tryToRandomOnIp();
        }
        if (this.workerId < 0L) {
            this.logger.warn("the world may be ended!");
            throw new RuntimeException("the world may be ended");
        }
    }

    private long increaseWithWorkerIdServer() {
        String incId = HttpReq.get("http://id.worker.server:18001").req("/inc").param("ipu", this.ipDotUsername).exec();
        if (incId == null || incId.trim().isEmpty()) {
            return -1L;
        }
        long lid = Long.parseLong(incId);
        return this.checkAvail(lid);
    }

    private long tryToCreateOnIp() {
        long wid = Ip.lip & maxWorkerId;
        return this.checkAvail(wid);
    }

    private long tryToRandomOnIp() {
        long avaiWorkerId = -1L;
        long tryTimes = -1L;
        while (avaiWorkerId < 0L && ++tryTimes < maxWorkerId) {
            long wid = Ip.lip & (long)random.nextInt((int)maxWorkerId);
            avaiWorkerId = this.checkAvail(wid);
        }
        return avaiWorkerId;
    }

    private long checkAvail(long wid) {
        long availWorkerId = -1L;
        try {
            new File(this.dir, this.ipudotlock + String.format("%04d", wid)).createNewFile();
            availWorkerId = this.findAvailWorkerId();
        }
        catch (IOException e) {
            this.logger.warn("checkAvail error", (Throwable)e);
        }
        return availWorkerId;
    }

    private void syncWithWorkerIdServer() {
        String[] syncIdsArr;
        String syncIds = HttpReq.get("http://id.worker.server:18001").req("/sync").param("ipu", this.ipDotUsername).param("ids", this.buildWorkerIdsOfCurrentIp()).exec();
        if (syncIds == null || syncIds.trim().isEmpty()) {
            return;
        }
        for (String syncId : syncIdsArr = syncIds.split(",")) {
            try {
                new File(this.dir, this.ipudotlock + syncId).createNewFile();
            }
            catch (IOException e) {
                this.logger.warn("create workerid lock file error", (Throwable)e);
            }
        }
    }

    private String buildWorkerIdsOfCurrentIp() {
        StringBuilder sb = new StringBuilder();
        for (File lockFile : this.dir.listFiles()) {
            String workerId;
            if (!lockFile.getName().startsWith(this.ipudotlock) || !(workerId = lockFile.getName().substring(this.workerIdIndex)).matches("\\d\\d\\d\\d")) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(workerId);
        }
        return sb.toString();
    }

    private long findAvailWorkerId() {
        for (File lockFile : this.dir.listFiles()) {
            String workerId;
            if (!lockFile.getName().startsWith(this.ipudotlock) || !(workerId = lockFile.getName().substring(this.workerIdIndex)).matches("\\d\\d\\d\\d")) continue;
            FileLock fileLock = new FileLock(lockFile);
            if (!fileLock.tryLock()) {
                fileLock.destroy();
                continue;
            }
            this.fileLock = fileLock;
            return Long.parseLong(workerId);
        }
        return -1L;
    }

    @Override
    public void initialize() {
        if (this.inited) {
            return;
        }
        this.init();
        this.inited = true;
    }

    @Override
    public long availableWorkerId() {
        return this.workerId;
    }

    @Override
    public void release() {
        if (this.fileLock != null) {
            this.fileLock.destroy();
        }
        this.inited = false;
    }
}

