/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.idworker.strategy;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLock {
    private final File file;
    private FileChannel channel;
    private java.nio.channels.FileLock flock = null;
    Logger logger = LoggerFactory.getLogger(FileLock.class);

    public FileLock(File file) {
        this.file = file;
        try {
            file.createNewFile();
            this.channel = new RandomAccessFile(file, "rw").getChannel();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        try {
            FileLock fileLock = this;
            synchronized (fileLock) {
                this.logger.trace("Acquiring lock on {}", (Object)this.file.getAbsolutePath());
                this.flock = this.channel.lock();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean tryLock() {
        FileLock fileLock = this;
        synchronized (fileLock) {
            this.logger.trace("Acquiring lock on {}", (Object)this.file.getAbsolutePath());
            try {
                this.flock = this.channel.tryLock();
                return this.flock != null;
            }
            catch (OverlappingFileLockException e) {
                return false;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        FileLock fileLock = this;
        synchronized (fileLock) {
            this.logger.trace("Releasing lock on {}", (Object)this.file.getAbsolutePath());
            if (this.flock == null) {
                return;
            }
            try {
                this.flock.release();
            }
            catch (ClosedChannelException e) {
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        FileLock fileLock = this;
        synchronized (fileLock) {
            this.unlock();
            try {
                this.channel.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

