/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.idworker.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpReq {
    private final String baseUrl;
    private String req;
    private StringBuilder params = new StringBuilder();
    Logger logger = LoggerFactory.getLogger(HttpReq.class);

    public HttpReq(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public static HttpReq get(String baseUrl) {
        return new HttpReq(baseUrl);
    }

    public HttpReq req(String req) {
        this.req = req;
        return this;
    }

    public HttpReq param(String name, String value) {
        if (this.params.length() > 0) {
            this.params.append('&');
        }
        try {
            this.params.append(name).append('=').append(URLEncoder.encode(value, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exec() {
        HttpURLConnection http = null;
        try {
            http = (HttpURLConnection)new URL(this.baseUrl + this.req + (this.params.length() > 0 ? "?" + this.params : "")).openConnection();
            http.setRequestProperty("Accept-Charset", "UTF-8");
            HttpURLConnection.setFollowRedirects(false);
            http.setConnectTimeout(5000);
            http.setReadTimeout(5000);
            http.connect();
            int status = http.getResponseCode();
            String charset = HttpReq.getCharset(http.getHeaderField("Content-Type"));
            if (status == 200) {
                String string = HttpReq.readResponseBody(http, charset);
                return string;
            }
            this.logger.warn("non 200 respoonse :" + HttpReq.readErrorResponseBody(http, status, charset));
            String string = null;
            return string;
        }
        catch (Exception e) {
            this.logger.error("exec error", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (http != null) {
                http.disconnect();
            }
        }
    }

    private static String readErrorResponseBody(HttpURLConnection http, int status, String charset) throws IOException {
        InputStream errorStream = http.getErrorStream();
        if (errorStream != null) {
            String error = HttpReq.toString(charset, errorStream);
            return "STATUS CODE =" + status + "\n\n" + error;
        }
        return "STATUS CODE =" + status;
    }

    private static String readResponseBody(HttpURLConnection http, String charset) throws IOException {
        InputStream inputStream = http.getInputStream();
        return HttpReq.toString(charset, inputStream);
    }

    private static String toString(String charset, InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        return new String(baos.toByteArray(), charset);
    }

    private static String getCharset(String contentType) {
        if (contentType == null) {
            return "UTF-8";
        }
        String charset = null;
        for (String param : contentType.replace(" ", "").split(";")) {
            if (!param.startsWith("charset=")) continue;
            charset = param.split("=", 2)[1];
            break;
        }
        return charset == null ? "UTF-8" : charset;
    }
}

