/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.idworker.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class Utils {
    static String defaultRange = "0123456789ABCDFGHKMNPRSTWXYZ";

    public static ClassLoader getClassLoader() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        return contextClassLoader != null ? contextClassLoader : Utils.class.getClassLoader();
    }

    public static InputStream classResourceToStream(String resourceName) {
        return Utils.getClassLoader().getResourceAsStream(resourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String firstLine(String classResourceName) {
        InputStream inputStream = null;
        try {
            inputStream = Utils.classResourceToStream(classResourceName);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            String string = bufferedReader.readLine();
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static String checkNotEmpty(String param, String name) {
        if (param == null || param.isEmpty()) {
            throw new IllegalArgumentException(name + " is empty");
        }
        return param;
    }

    public static long midnightMillis() {
        Calendar date = Calendar.getInstance();
        date.set(11, 0);
        date.set(12, 0);
        date.set(13, 0);
        date.set(14, 0);
        return date.getTimeInMillis();
    }

    public static void main(String[] args) {
        System.out.println(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Timestamp(Utils.midnightMillis())));
        System.out.println(Utils.encode(0xFFFFFFFFFFFFL));
    }

    public static long decode(String s, String symbols) {
        int B = symbols.length();
        long num = 0L;
        for (char ch : s.toCharArray()) {
            num *= (long)B;
            num += (long)symbols.indexOf(ch);
        }
        return num;
    }

    public static String encode(long num) {
        return Utils.encode(num, defaultRange);
    }

    public static String encode(long num, String symbols) {
        int B = symbols.length();
        StringBuilder sb = new StringBuilder();
        while (num != 0L) {
            sb.append(symbols.charAt((int)(num % (long)B)));
            num /= (long)B;
        }
        return sb.reverse().toString();
    }

    public static String padLeft(String str, int size, char padChar) {
        if (str.length() >= size) {
            return str;
        }
        StringBuilder s = new StringBuilder();
        for (int i = size - str.length(); i > 0; --i) {
            s.append(padChar);
        }
        s.append(str);
        return s.toString();
    }
}

