/*
 * Decompiled with CFR 0.152.
 */
package com.github.botaruibo.xvcode.generator;

import com.github.botaruibo.xvcode.generator.Generator;
import com.github.botaruibo.xvcode.generator.XRandoms;
import com.github.botaruibo.xvcode.gifencoder.AnimatedGifEncoder;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.OutputStream;

public class Gif3VCGenerator
extends Generator {
    private static float bkAlpha = 0.7f;
    private static float ovalSize = 4.0f;
    private static int ovalCount = 10;
    private static int gifDelayTime = 500;

    public Gif3VCGenerator() {
    }

    public Gif3VCGenerator(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public Gif3VCGenerator(int width, int height, int len) {
        this(width, height);
        this.len = len;
    }

    public Gif3VCGenerator(int width, int height, int len, Font font) {
        this(width, height, len);
        this.font = font;
    }

    public Gif3VCGenerator(int width, int height, int len, Font font, float pbkAlpha, float pOvalSize, int pOvalCount, int pGifDelayTime) {
        this(width, height, len, font);
        bkAlpha = pbkAlpha;
        ovalSize = pOvalSize;
        ovalCount = pOvalCount;
        gifDelayTime = pGifDelayTime;
    }

    @Override
    public OutputStream write2out(OutputStream out) {
        int i;
        if (out == null) {
            return null;
        }
        AnimatedGifEncoder gifEncoder = new AnimatedGifEncoder();
        gifEncoder.start(out);
        gifEncoder.setQuality(180);
        gifEncoder.setDelay(gifDelayTime);
        gifEncoder.setRepeat(0);
        char[] rands = this.alphas();
        Color[] fontcolor = new Color[this.len];
        for (int i2 = 0; i2 < this.len; ++i2) {
            fontcolor[i2] = new Color(20 + XRandoms.num(110), 20 + XRandoms.num(110), 20 + XRandoms.num(110));
        }
        int[] ovalPosition = new int[ovalCount * 4];
        Color[] colors = new Color[ovalCount];
        for (i = 0; i < ovalPosition.length; i += 4) {
            ovalPosition[i] = XRandoms.num(this.width);
            ovalPosition[i + 1] = XRandoms.num(this.height);
            ovalPosition[i + 2] = 10 + XRandoms.num(10);
            ovalPosition[i + 3] = 10 + XRandoms.num(10);
            colors[i >> 2] = this.color(150, 250);
        }
        for (i = 0; i < this.len; ++i) {
            BufferedImage frame = this.getValidCodeImage(fontcolor, rands, ovalPosition, colors, i);
            gifEncoder.addFrame(frame);
            frame.flush();
        }
        gifEncoder.finish();
        return out;
    }

    private BufferedImage getValidCodeImage(Color[] fontcolor, char[] strs, int[] ovalPosition, Color[] colors, int flag) {
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, this.width, this.height);
        g2d.setStroke(new BasicStroke(ovalSize));
        AlphaComposite ac3 = AlphaComposite.getInstance(3, bkAlpha);
        g2d.setComposite(ac3);
        for (int i = 0; i < ovalPosition.length; i += 4) {
            g2d.setColor(colors[i >> 2]);
            g2d.drawOval(ovalPosition[i], ovalPosition[i + 1], ovalPosition[i + 2], ovalPosition[i + 3]);
        }
        int h = this.height - (this.height - this.font.getSize() >> 1);
        int w = this.width / this.len;
        g2d.setFont(this.font);
        for (int i = 0; i < this.len; ++i) {
            ac3 = AlphaComposite.getInstance(3, this.getAlpha(flag, i));
            g2d.setComposite(ac3);
            g2d.setColor(fontcolor[i]);
            int degree = XRandoms.num(90);
            degree = XRandoms.num(2) == 0 ? -degree : degree;
            g2d.rotate(Math.toRadians(degree), this.width - (this.len - i) * w + (w >> 1), (this.height >> 1) + 2);
            g2d.drawString(strs[i] + "", this.width - (this.len - i) * w + (w - this.font.getSize()) + 1, h - 4);
            g2d.rotate(-Math.toRadians(degree), this.width - (this.len - i) * w + (w >> 1), (this.height >> 1) + 2);
        }
        g2d.dispose();
        return image;
    }

    private float getAlpha(int i, int j) {
        int num = i + j;
        float r = 1.0f / (float)this.len;
        float s = (float)(this.len + 1) * r;
        return num > this.len ? (float)num * r - s : (float)num * r;
    }

    @Override
    public BufferedImage getValidCodeImage() {
        return null;
    }
}

