/* CCJSqlParser.java */
/* Generated By:JJTree&JavaCC: Do not edit this line. CCJSqlParser.java */
/*
 * #%L
 * JSQLParser library
 * %%
 * Copyright (C) 2004 - 2014 JSQLParser
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-2.1.html>.
 * #L%
 */

package net.sf.jsqlparser.parser;

import net.sf.jsqlparser.expression.*;
import net.sf.jsqlparser.expression.operators.arithmetic.*;
import net.sf.jsqlparser.expression.operators.conditional.*;
import net.sf.jsqlparser.expression.operators.relational.*;
import net.sf.jsqlparser.schema.*;
import net.sf.jsqlparser.statement.*;
import net.sf.jsqlparser.statement.alter.*;
import net.sf.jsqlparser.statement.create.index.*;
import net.sf.jsqlparser.statement.create.table.*;
import net.sf.jsqlparser.statement.create.view.*;
import net.sf.jsqlparser.statement.delete.*;
import net.sf.jsqlparser.statement.drop.*;
import net.sf.jsqlparser.statement.insert.*;
import net.sf.jsqlparser.statement.replace.*;
import net.sf.jsqlparser.statement.execute.*;
import net.sf.jsqlparser.statement.select.*;
import net.sf.jsqlparser.statement.truncate.*;
import net.sf.jsqlparser.statement.update.*;
import net.sf.jsqlparser.statement.upsert.*;
import net.sf.jsqlparser.statement.merge.*;
import java.util.*;

/**
 * The parser generated by JavaCC
 */
public class CCJSqlParser/*@bgen(jjtree)*/implements CCJSqlParserTreeConstants, CCJSqlParserConstants {/*@bgen(jjtree)*/
  protected JJTCCJSqlParserState jjtree = new JJTCCJSqlParserState();int jdbcParameterIndex = 0;
    boolean errorRecovery = false;
    List<ParseException> parseErrors = new ArrayList<ParseException>();

    private void linkAST(ASTNodeAccess access, SimpleNode node) {
        access.setASTNode(node);
        node.jjtSetValue(access);
    }

    public Node getASTRoot() {
        return jjtree.rootNode();
    }

    public void setErrorRecovery(boolean errorRecovery) {
        this.errorRecovery = errorRecovery;
    }

    public List<ParseException> getParseErrors() {
        return parseErrors;
    }

  final public Statement Statement() throws ParseException {/*@bgen(jjtree) Statement */
  SimpleNode jjtn000 = new SimpleNode(JJTSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));Statement stm = null;
    try {
      try {
        stm = SingleStatement();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ST_SEMICOLON:{
          jj_consume_token(ST_SEMICOLON);
          break;
          }
        default:
          jj_la1[0] = jj_gen;
          ;
        }
        jj_consume_token(0);
      } catch (ParseException e) {
if (errorRecovery) {
            parseErrors.add(e);
            error_skipto(ST_SEMICOLON);
        }
        else
            {if (true) throw e;}
      }
jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          jjtn000.jjtSetLastToken(getToken(0));
return stm;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Statement SingleStatement() throws ParseException {Statement stm = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_SELECT:
      case K_WITH:
      case 184:{
        stm = Select();
        break;
        }
      case K_UPDATE:{
        stm = Update();
        break;
        }
      case K_INSERT:{
        stm = Insert();
        break;
        }
      case K_UPSERT:{
        stm = Upsert();
        break;
        }
      case K_DELETE:{
        stm = Delete();
        break;
        }
      case K_REPLACE:{
        stm = Replace();
        break;
        }
      default:
        jj_la1[1] = jj_gen;
        if (jj_2_1(2)) {
          stm = AlterTable();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_MERGE:{
            stm = Merge();
            break;
            }
          default:
            jj_la1[2] = jj_gen;
            if (jj_2_2(2147483647)) {
              stm = CreateIndex();
            } else if (jj_2_3(2147483647)) {
              stm = CreateTable();
            } else if (jj_2_4(2147483647)) {
              stm = CreateView();
            } else {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_ALTER:{
                stm = AlterView();
                break;
                }
              case K_DROP:{
                stm = Drop();
                break;
                }
              case K_TRUNCATE:{
                stm = Truncate();
                break;
                }
              case K_CALL:
              case K_EXEC:
              case K_EXECUTE:{
                stm = Execute();
                break;
                }
              case K_SET:{
                stm = Set();
                break;
                }
              case K_USE:{
                stm = Use();
                break;
                }
              case K_COMMIT:{
                stm = Commit();
                break;
                }
              default:
                jj_la1[3] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
          }
        }
      }
return stm;
    } catch (ParseException e) {
if (errorRecovery) {
            parseErrors.add(e);
            error_skipto(ST_SEMICOLON);
                        return null;
        }
        else
            {if (true) throw e;}
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Statements Statements() throws ParseException {/*@bgen(jjtree) Statements */
  SimpleNode jjtn000 = new SimpleNode(JJTSTATEMENTS);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));Statements stmts = new Statements();
  List<Statement> list = new ArrayList<Statement>();
  Statement stm;
    try {
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ST_SEMICOLON:{
          ;
          break;
          }
        default:
          jj_la1[4] = jj_gen;
          break label_1;
        }
        jj_consume_token(ST_SEMICOLON);
      }
      try {
        stm = SingleStatement();
list.add(stm);
        label_2:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case ST_SEMICOLON:{
            ;
            break;
            }
          default:
            jj_la1[5] = jj_gen;
            break label_2;
          }
          jj_consume_token(ST_SEMICOLON);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ALTER:
          case K_CALL:
          case K_COMMIT:
          case K_CREATE:
          case K_DELETE:
          case K_DROP:
          case K_EXEC:
          case K_EXECUTE:
          case K_INSERT:
          case K_MERGE:
          case K_REPLACE:
          case K_SELECT:
          case K_SET:
          case K_TRUNCATE:
          case K_UPDATE:
          case K_UPSERT:
          case K_USE:
          case K_WITH:
          case 184:{
            stm = SingleStatement();
list.add(stm);
            break;
            }
          default:
            jj_la1[6] = jj_gen;
            ;
          }
        }
        jj_consume_token(0);
      } catch (ParseException e) {
if (errorRecovery) {
            parseErrors.add(e);
            error_skipto(ST_SEMICOLON);
        }
        else
            {if (true) throw e;}
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
stmts.setStatements(list);
        return stmts;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  void error_skipto(int kind) throws ParseException {ParseException e = generateParseException();
  System.out.println(e.toString());
  Token t;
  do {
    t = getNextToken();
  } while (t.kind != kind && t.kind != EOF);
  }

  final public SetStatement Set() throws ParseException {String name;
    Expression value;
    boolean useEqual = false;
    jj_consume_token(K_SET);
    name = RelObjectNameExt();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 182:{
      jj_consume_token(182);
useEqual=true;
      break;
      }
    default:
      jj_la1[7] = jj_gen;
      ;
    }
    value = SimpleExpression();
return new SetStatement(name,value).setUseEqual(useEqual);
}

  final public UseStatement Use() throws ParseException {String name;
    jj_consume_token(K_USE);
    name = RelObjectNameExt();
return new UseStatement(name);
}

  final public Update Update() throws ParseException {Update update = new Update();
    Table table = null;
    List<Table> tables = new ArrayList<Table>();
    Expression where = null;
    Column tableColumn = null;
    List<Expression> expList = new ArrayList<Expression>();
    List<Column> columns = new ArrayList<Column>();
    Expression value = null;
    FromItem fromItem = null;
    List<Join> joins = null;
    Select select = null;
    Limit limit = null;
    List<OrderByElement> orderByElements;
    boolean useColumnsBrackets = false;
    List<SelectExpressionItem> returning = null;
    jj_consume_token(K_UPDATE);
    table = TableWithAlias();
tables.add(table);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 183:{
        ;
        break;
        }
      default:
        jj_la1[8] = jj_gen;
        break label_3;
      }
      jj_consume_token(183);
      table = TableWithAlias();
tables.add(table);
    }
    jj_consume_token(K_SET);
    if (jj_2_5(3)) {
      tableColumn = Column();
      jj_consume_token(182);
      value = SimpleExpression();
columns.add(tableColumn); expList.add(value);
      label_4:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 183:{
          ;
          break;
          }
        default:
          jj_la1[9] = jj_gen;
          break label_4;
        }
        jj_consume_token(183);
        tableColumn = Column();
        jj_consume_token(182);
        value = SimpleExpression();
columns.add(tableColumn); expList.add(value);
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ANY:
      case K_CASCADE:
      case K_CAST:
      case K_COLUMN:
      case K_COMMIT:
      case K_DATETIMELITERAL:
      case K_DO:
      case K_ENABLE:
      case K_END:
      case K_EXTRACT:
      case K_FIRST:
      case K_FOLLOWING:
      case K_INDEX:
      case K_INSERT:
      case K_KEY:
      case K_LAST:
      case K_MATERIALIZED:
      case K_NO:
      case K_NULLS:
      case K_OPEN:
      case K_OVER:
      case K_PARTITION:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_RANGE:
      case K_REPLACE:
      case K_ROW:
      case K_ROWS:
      case K_SEPARATOR:
      case K_SIBLINGS:
      case K_TABLE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TRUNCATE:
      case K_UNSIGNED:
      case K_VALUE:
      case K_VALUES:
      case K_XML:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
      case 184:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 184:{
          jj_consume_token(184);
useColumnsBrackets = true;
          break;
          }
        default:
          jj_la1[10] = jj_gen;
          ;
        }
        tableColumn = Column();
columns.add(tableColumn);
        label_5:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 183:{
            ;
            break;
            }
          default:
            jj_la1[11] = jj_gen;
            break label_5;
          }
          jj_consume_token(183);
          tableColumn = Column();
columns.add(tableColumn);
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 185:{
          jj_consume_token(185);
          break;
          }
        default:
          jj_la1[12] = jj_gen;
          ;
        }
        jj_consume_token(182);
        jj_consume_token(184);
update.setUseSelect(true);
        select = Select();
        jj_consume_token(185);
        break;
        }
      default:
        jj_la1[13] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FROM:{
      jj_consume_token(K_FROM);
      fromItem = FromItem();
      joins = JoinsList();
      break;
      }
    default:
      jj_la1[14] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHERE:{
      where = WhereClause();
update.setWhere(where);
      break;
      }
    default:
      jj_la1[15] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      orderByElements = OrderByElements();
update.setOrderByElements(orderByElements);
      break;
      }
    default:
      jj_la1[16] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LIMIT:{
      limit = PlainLimit();
update.setLimit(limit);
      break;
      }
    default:
      jj_la1[17] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_RETURNING:{
      jj_consume_token(K_RETURNING);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 186:{
        jj_consume_token(186);
update.setReturningAllColumns(true);
        break;
        }
      case K_ACTION:
      case K_ANY:
      case K_CASCADE:
      case K_CASE:
      case K_CAST:
      case K_COLUMN:
      case K_COMMIT:
      case K_DATETIMELITERAL:
      case K_DO:
      case K_DOUBLE:
      case K_ENABLE:
      case K_END:
      case K_EXTRACT:
      case K_FIRST:
      case K_FOLLOWING:
      case K_GROUP_CONCAT:
      case K_IF:
      case K_INDEX:
      case K_INSERT:
      case K_INTERVAL:
      case K_KEY:
      case K_LAST:
      case K_LEFT:
      case K_MATERIALIZED:
      case K_NO:
      case K_NULL:
      case K_NULLS:
      case K_OPEN:
      case K_OVER:
      case K_PARTITION:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_RANGE:
      case K_REPLACE:
      case K_RIGHT:
      case K_ROW:
      case K_ROWS:
      case K_SEPARATOR:
      case K_SET:
      case K_SIBLINGS:
      case K_TABLE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TRUNCATE:
      case K_UNSIGNED:
      case K_VALUE:
      case K_VALUES:
      case K_XML:
      case S_DOUBLE:
      case S_LONG:
      case S_HEX:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 184:
      case 188:
      case 189:
      case 190:
      case 193:
      case 194:
      case 202:
      case 211:
      case 213:
      case 214:
      case 216:
      case 221:{
        returning = ListExpressionItem();
        break;
        }
      default:
        jj_la1[18] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[19] = jj_gen;
      ;
    }
update.setColumns(columns);
           update.setExpressions(expList);
           update.setTables(tables);
        update.setFromItem(fromItem);
        update.setJoins(joins);
        update.setSelect(select);
        update.setUseColumnsBrackets(useColumnsBrackets);
        update.setReturningExpressionList(returning);
        return update;
}

  final public Replace Replace() throws ParseException {Replace replace = new Replace();
    Table table = null;
    Column tableColumn = null;
    Expression value = null;

    List<Column> columns = new ArrayList<Column>();
    List<Expression> expList = new ArrayList<Expression>();
    MultiExpressionList multiExpr = null;
    ItemsList itemsList = null;
    Expression exp = null;
    jj_consume_token(K_REPLACE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_INTO:{
      jj_consume_token(K_INTO);
replace.setUseIntoTables(true);
      break;
      }
    default:
      jj_la1[20] = jj_gen;
      ;
    }
    table = Table();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_SET:{
      jj_consume_token(K_SET);
      tableColumn = Column();
      jj_consume_token(182);
      value = SimpleExpression();
columns.add(tableColumn); expList.add(value);
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 183:{
          ;
          break;
          }
        default:
          jj_la1[21] = jj_gen;
          break label_6;
        }
        jj_consume_token(183);
        tableColumn = Column();
        jj_consume_token(182);
        value = SimpleExpression();
columns.add(tableColumn); expList.add(value);
      }
replace.setExpressions(expList);
      break;
      }
    case K_SELECT:
    case K_VALUE:
    case K_VALUES:
    case K_WITH:
    case 184:{
      if (jj_2_6(2)) {
        jj_consume_token(184);
        tableColumn = Column();
columns.add(tableColumn);
        label_7:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 183:{
            ;
            break;
            }
          default:
            jj_la1[22] = jj_gen;
            break label_7;
          }
          jj_consume_token(183);
          tableColumn = Column();
columns.add(tableColumn);
        }
        jj_consume_token(185);
      } else {
        ;
      }
      if (jj_2_7(2)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_VALUE:
        case K_VALUES:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_VALUES:{
            jj_consume_token(K_VALUES);
            break;
            }
          case K_VALUE:{
            jj_consume_token(K_VALUE);
            break;
            }
          default:
            jj_la1[23] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[24] = jj_gen;
          ;
        }
        jj_consume_token(184);
        exp = PrimaryExpression();
expList.add(exp);
        label_8:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 183:{
            ;
            break;
            }
          default:
            jj_la1[25] = jj_gen;
            break label_8;
          }
          jj_consume_token(183);
          exp = PrimaryExpression();
expList.add(exp);
        }
        jj_consume_token(185);
itemsList = new ExpressionList(expList);
        label_9:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 183:{
            ;
            break;
            }
          default:
            jj_la1[26] = jj_gen;
            break label_9;
          }
          jj_consume_token(183);
          jj_consume_token(184);
          exp = SimpleExpression();
if (multiExpr==null) {
                                multiExpr=new MultiExpressionList();
                                multiExpr.addExpressionList((ExpressionList)itemsList);
                                itemsList = multiExpr;
                            }
                            expList = new ArrayList<Expression>();
                            expList.add(exp);
          label_10:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case 183:{
              ;
              break;
              }
            default:
              jj_la1[27] = jj_gen;
              break label_10;
            }
            jj_consume_token(183);
            exp = SimpleExpression();
expList.add(exp);
          }
          jj_consume_token(185);
multiExpr.addExpressionList(expList);
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_SELECT:
        case K_WITH:
        case 184:{
replace.setUseValues(false);
          itemsList = SubSelect();
((SubSelect)itemsList).setUseBrackets(false);
          break;
          }
        default:
          jj_la1[28] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
replace.setItemsList(itemsList);
      break;
      }
    default:
      jj_la1[29] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (columns.size() > 0)
               replace.setColumns(columns);
           replace.setTable(table);
        return replace;
}

  final public List<SelectExpressionItem> ListExpressionItem() throws ParseException {List<SelectExpressionItem> retval = new ArrayList<SelectExpressionItem>();
   SelectExpressionItem item;
    item = SelectExpressionItem();
retval.add(item);
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 183:{
        ;
        break;
        }
      default:
        jj_la1[30] = jj_gen;
        break label_11;
      }
      jj_consume_token(183);
      item = SelectExpressionItem();
retval.add(item);
    }
return retval;
}

  final public Insert Insert() throws ParseException {Insert insert = new Insert();
    Table table = null;
    Column tableColumn = null;
    List<Column> columns = new ArrayList<Column>();
    List<Expression> primaryExpList = new ArrayList<Expression>();
    ItemsList itemsList = null;
    Expression exp = null;
    MultiExpressionList multiExpr = null;
    List<SelectExpressionItem> returning = null;
    Select select = null;
    boolean useValues = true;
    boolean useSelectBrackets = false;
    boolean useDuplicate = false;
    List<Column> duplicateUpdateColumns = null;
    List<Expression> duplicateUpdateExpressionList = null;
    Token tk = null;
    InsertModifierPriority modifierPriority = null;
    boolean modifierIgnore = false;
    boolean useSet = false;
    List<Column> setColumns = new ArrayList<Column>();
    List<Expression> setExpressionList = new ArrayList<Expression>();
    String name = null;
    boolean useAs = false;
    jj_consume_token(K_INSERT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_DELAYED:
    case K_HIGH_PRIORITY:
    case K_LOW_PRIORITY:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_LOW_PRIORITY:{
        tk = jj_consume_token(K_LOW_PRIORITY);
        break;
        }
      case K_DELAYED:{
        tk = jj_consume_token(K_DELAYED);
        break;
        }
      case K_HIGH_PRIORITY:{
        tk = jj_consume_token(K_HIGH_PRIORITY);
        break;
        }
      default:
        jj_la1[31] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
if (tk!=null)
        modifierPriority = InsertModifierPriority.valueOf(tk.image.toUpperCase());
      break;
      }
    default:
      jj_la1[32] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_IGNORE:{
      jj_consume_token(K_IGNORE);
modifierIgnore = true;
      break;
      }
    default:
      jj_la1[33] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_INTO:{
      jj_consume_token(K_INTO);
      break;
      }
    default:
      jj_la1[34] = jj_gen;
      ;
    }
    table = Table();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_AS:
    case K_CASCADE:
    case K_CAST:
    case K_COLUMN:
    case K_COMMIT:
    case K_DATETIMELITERAL:
    case K_DO:
    case K_ENABLE:
    case K_END:
    case K_EXTRACT:
    case K_FIRST:
    case K_FOLLOWING:
    case K_INDEX:
    case K_INSERT:
    case K_KEY:
    case K_LAST:
    case K_MATERIALIZED:
    case K_NO:
    case K_NULLS:
    case K_OPEN:
    case K_OVER:
    case K_PARTITION:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SEPARATOR:
    case K_SIBLINGS:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TRUNCATE:
    case K_UNSIGNED:
    case K_XML:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_AS:{
        jj_consume_token(K_AS);
useAs = true;
        break;
        }
      default:
        jj_la1[35] = jj_gen;
        ;
      }
      name = RelObjectNameWithoutValue();
table.setAlias(new Alias(name,useAs));
      break;
      }
    default:
      jj_la1[36] = jj_gen;
      ;
    }
    if (jj_2_8(2)) {
      jj_consume_token(184);
      tableColumn = Column();
columns.add(tableColumn);
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 183:{
          ;
          break;
          }
        default:
          jj_la1[37] = jj_gen;
          break label_12;
        }
        jj_consume_token(183);
        tableColumn = Column();
columns.add(tableColumn);
      }
      jj_consume_token(185);
    } else {
      ;
    }
    if (jj_2_10(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_VALUE:
      case K_VALUES:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_VALUES:{
          jj_consume_token(K_VALUES);
          break;
          }
        case K_VALUE:{
          jj_consume_token(K_VALUE);
          break;
          }
        default:
          jj_la1[38] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[39] = jj_gen;
        ;
      }
      jj_consume_token(184);
      exp = SimpleExpression();
primaryExpList.add(exp);
      label_13:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 183:{
          ;
          break;
          }
        default:
          jj_la1[40] = jj_gen;
          break label_13;
        }
        jj_consume_token(183);
        exp = SimpleExpression();
primaryExpList.add(exp);
      }
      jj_consume_token(185);
itemsList = new ExpressionList(primaryExpList);
      label_14:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 183:{
          ;
          break;
          }
        default:
          jj_la1[41] = jj_gen;
          break label_14;
        }
        jj_consume_token(183);
        jj_consume_token(184);
        exp = SimpleExpression();
if (multiExpr==null) {
                        multiExpr=new MultiExpressionList();
                        multiExpr.addExpressionList((ExpressionList)itemsList);
                        itemsList = multiExpr;
                    }
                    primaryExpList = new ArrayList<Expression>();
                    primaryExpList.add(exp);
        label_15:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 183:{
            ;
            break;
            }
          default:
            jj_la1[42] = jj_gen;
            break label_15;
          }
          jj_consume_token(183);
          exp = SimpleExpression();
primaryExpList.add(exp);
        }
        jj_consume_token(185);
multiExpr.addExpressionList(primaryExpList);
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_SELECT:
      case K_WITH:
      case 184:{
        if (jj_2_9(2)) {
          jj_consume_token(184);
useSelectBrackets = true;
insert.setUseValues(false);
          select = Select();
          jj_consume_token(185);
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_SELECT:
          case K_WITH:
          case 184:{
insert.setUseValues(false);
            select = Select();
            break;
            }
          default:
            jj_la1[43] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      case K_SET:{
        jj_consume_token(K_SET);
useSet = true;
                insert.setUseValues(false);
        tableColumn = Column();
        jj_consume_token(182);
        exp = SimpleExpression();
setColumns = new ArrayList<Column>();
                setExpressionList = new ArrayList<Expression>();
                setColumns.add(tableColumn);
                setExpressionList.add(exp);
        label_16:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 183:{
            ;
            break;
            }
          default:
            jj_la1[44] = jj_gen;
            break label_16;
          }
          jj_consume_token(183);
          tableColumn = Column();
          jj_consume_token(182);
          exp = SimpleExpression();
setColumns.add(tableColumn);
                setExpressionList.add(exp);
        }
        break;
        }
      default:
        jj_la1[45] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ON:{
      jj_consume_token(K_ON);
      jj_consume_token(K_DUPLICATE);
      jj_consume_token(K_KEY);
      jj_consume_token(K_UPDATE);
useDuplicate = true;
      tableColumn = Column();
      jj_consume_token(182);
      exp = SimpleExpression();
duplicateUpdateColumns = new ArrayList<Column>();
            duplicateUpdateExpressionList = new ArrayList<Expression>();
            duplicateUpdateColumns.add(tableColumn);
            duplicateUpdateExpressionList.add(exp);
      label_17:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 183:{
          ;
          break;
          }
        default:
          jj_la1[46] = jj_gen;
          break label_17;
        }
        jj_consume_token(183);
        tableColumn = Column();
        jj_consume_token(182);
        exp = SimpleExpression();
duplicateUpdateColumns.add(tableColumn);
        duplicateUpdateExpressionList.add(exp);
      }
      break;
      }
    default:
      jj_la1[47] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_RETURNING:{
      jj_consume_token(K_RETURNING);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 186:{
        jj_consume_token(186);
insert.setReturningAllColumns(true);
        break;
        }
      case K_ACTION:
      case K_ANY:
      case K_CASCADE:
      case K_CASE:
      case K_CAST:
      case K_COLUMN:
      case K_COMMIT:
      case K_DATETIMELITERAL:
      case K_DO:
      case K_DOUBLE:
      case K_ENABLE:
      case K_END:
      case K_EXTRACT:
      case K_FIRST:
      case K_FOLLOWING:
      case K_GROUP_CONCAT:
      case K_IF:
      case K_INDEX:
      case K_INSERT:
      case K_INTERVAL:
      case K_KEY:
      case K_LAST:
      case K_LEFT:
      case K_MATERIALIZED:
      case K_NO:
      case K_NULL:
      case K_NULLS:
      case K_OPEN:
      case K_OVER:
      case K_PARTITION:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_RANGE:
      case K_REPLACE:
      case K_RIGHT:
      case K_ROW:
      case K_ROWS:
      case K_SEPARATOR:
      case K_SET:
      case K_SIBLINGS:
      case K_TABLE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TRUNCATE:
      case K_UNSIGNED:
      case K_VALUE:
      case K_VALUES:
      case K_XML:
      case S_DOUBLE:
      case S_LONG:
      case S_HEX:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 184:
      case 188:
      case 189:
      case 190:
      case 193:
      case 194:
      case 202:
      case 211:
      case 213:
      case 214:
      case 216:
      case 221:{
        returning = ListExpressionItem();
        break;
        }
      default:
        jj_la1[48] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[49] = jj_gen;
      ;
    }
insert.setItemsList(itemsList);
        insert.setUseSelectBrackets(useSelectBrackets);
        insert.setSelect(select);
        insert.setTable(table);
        if (columns.size() > 0)
            insert.setColumns(columns);
        insert.setUseDuplicate(useDuplicate);
        insert.setDuplicateUpdateColumns(duplicateUpdateColumns);
        insert.setDuplicateUpdateExpressionList(duplicateUpdateExpressionList);
        insert.setReturningExpressionList(returning);
        insert.setModifierPriority(modifierPriority);
        insert.setModifierIgnore(modifierIgnore);
        insert.setUseSet(useSet);
        insert.setSetColumns(setColumns);
        insert.setSetExpressionList(setExpressionList);
        return insert;
}

  final public Upsert Upsert() throws ParseException {Upsert upsert = new Upsert();
    Table table = null;
    Column tableColumn = null;
    List<Column> columns = new ArrayList<Column>();
    List<Expression> primaryExpList = new ArrayList<Expression>();
    ItemsList itemsList = null;
    Expression exp = null;
    MultiExpressionList multiExpr = null;
    List<SelectExpressionItem> returning = null;
    Select select = null;
    boolean useSelectBrackets = false;
    boolean useDuplicate = false;
    List<Column> duplicateUpdateColumns = null;
    List<Expression> duplicateUpdateExpressionList = null;
    Token tk = null;
    jj_consume_token(K_UPSERT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_INTO:{
      jj_consume_token(K_INTO);
      break;
      }
    default:
      jj_la1[50] = jj_gen;
      ;
    }
    table = Table();
    if (jj_2_11(2)) {
      jj_consume_token(184);
      tableColumn = Column();
columns.add(tableColumn);
      label_18:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 183:{
          ;
          break;
          }
        default:
          jj_la1[51] = jj_gen;
          break label_18;
        }
        jj_consume_token(183);
        tableColumn = Column();
columns.add(tableColumn);
      }
      jj_consume_token(185);
    } else {
      ;
    }
    if (jj_2_13(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_VALUE:
      case K_VALUES:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_VALUES:{
          jj_consume_token(K_VALUES);
          break;
          }
        case K_VALUE:{
          jj_consume_token(K_VALUE);
          break;
          }
        default:
          jj_la1[52] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[53] = jj_gen;
        ;
      }
      jj_consume_token(184);
      exp = SimpleExpression();
primaryExpList.add(exp);
      label_19:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 183:{
          ;
          break;
          }
        default:
          jj_la1[54] = jj_gen;
          break label_19;
        }
        jj_consume_token(183);
        exp = SimpleExpression();
primaryExpList.add(exp);
      }
      jj_consume_token(185);
itemsList = new ExpressionList(primaryExpList);
      label_20:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 183:{
          ;
          break;
          }
        default:
          jj_la1[55] = jj_gen;
          break label_20;
        }
        jj_consume_token(183);
        jj_consume_token(184);
        exp = SimpleExpression();
if (multiExpr==null) {
                        multiExpr=new MultiExpressionList();
                        multiExpr.addExpressionList((ExpressionList)itemsList);
                        itemsList = multiExpr;
                    }
                    primaryExpList = new ArrayList<Expression>();
                    primaryExpList.add(exp);
        label_21:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 183:{
            ;
            break;
            }
          default:
            jj_la1[56] = jj_gen;
            break label_21;
          }
          jj_consume_token(183);
          exp = SimpleExpression();
primaryExpList.add(exp);
        }
        jj_consume_token(185);
multiExpr.addExpressionList(primaryExpList);
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_SELECT:
      case K_WITH:
      case 184:{
        if (jj_2_12(2)) {
          jj_consume_token(184);
useSelectBrackets = true;
upsert.setUseValues(false);
          select = Select();
          jj_consume_token(185);
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_SELECT:
          case K_WITH:
          case 184:{
upsert.setUseValues(false);
            select = Select();
            break;
            }
          default:
            jj_la1[57] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[58] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ON:{
      jj_consume_token(K_ON);
      jj_consume_token(K_DUPLICATE);
      jj_consume_token(K_KEY);
      jj_consume_token(K_UPDATE);
useDuplicate = true;
      tableColumn = Column();
      jj_consume_token(182);
      exp = SimpleExpression();
duplicateUpdateColumns = new ArrayList<Column>();
            duplicateUpdateExpressionList = new ArrayList<Expression>();
            duplicateUpdateColumns.add(tableColumn);
            duplicateUpdateExpressionList.add(exp);
      label_22:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 183:{
          ;
          break;
          }
        default:
          jj_la1[59] = jj_gen;
          break label_22;
        }
        jj_consume_token(183);
        tableColumn = Column();
        jj_consume_token(182);
        exp = SimpleExpression();
duplicateUpdateColumns.add(tableColumn);
        duplicateUpdateExpressionList.add(exp);
      }
      break;
      }
    default:
      jj_la1[60] = jj_gen;
      ;
    }
upsert.setItemsList(itemsList);
        upsert.setUseSelectBrackets(useSelectBrackets);
        upsert.setSelect(select);
        upsert.setTable(table);
        if (columns.size() > 0) {
            upsert.setColumns(columns);
        }
        upsert.setUseDuplicate(useDuplicate);
        upsert.setDuplicateUpdateColumns(duplicateUpdateColumns);
        upsert.setDuplicateUpdateExpressionList(duplicateUpdateExpressionList);
        return upsert;
}

  final public Delete Delete() throws ParseException {Delete delete = new Delete();
    Table table = null;
    List<Table> tables = new ArrayList<Table>();
    List<Join> joins = null;
    Expression where = null;
    Limit limit = null;
    List<OrderByElement> orderByElements;
    jj_consume_token(K_DELETE);
    if (jj_2_14(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ANY:
      case K_CASCADE:
      case K_CAST:
      case K_COLUMN:
      case K_COMMIT:
      case K_DATETIMELITERAL:
      case K_DO:
      case K_ENABLE:
      case K_END:
      case K_EXTRACT:
      case K_FIRST:
      case K_FOLLOWING:
      case K_INDEX:
      case K_INSERT:
      case K_KEY:
      case K_LAST:
      case K_MATERIALIZED:
      case K_NO:
      case K_NULLS:
      case K_OPEN:
      case K_OVER:
      case K_PARTITION:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_RANGE:
      case K_REPLACE:
      case K_ROW:
      case K_ROWS:
      case K_SEPARATOR:
      case K_SIBLINGS:
      case K_TABLE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TRUNCATE:
      case K_UNSIGNED:
      case K_VALUE:
      case K_VALUES:
      case K_XML:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:{
        table = TableWithAlias();
tables.add(table);
        label_23:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 183:{
            ;
            break;
            }
          default:
            jj_la1[61] = jj_gen;
            break label_23;
          }
          jj_consume_token(183);
          table = TableWithAlias();
tables.add(table);
        }
        jj_consume_token(K_FROM);
        break;
        }
      case K_FROM:{
        jj_consume_token(K_FROM);
        break;
        }
      default:
        jj_la1[62] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_CASCADE:
    case K_CAST:
    case K_COLUMN:
    case K_COMMIT:
    case K_DATETIMELITERAL:
    case K_DO:
    case K_ENABLE:
    case K_END:
    case K_EXTRACT:
    case K_FIRST:
    case K_FOLLOWING:
    case K_INDEX:
    case K_INSERT:
    case K_KEY:
    case K_LAST:
    case K_MATERIALIZED:
    case K_NO:
    case K_NULLS:
    case K_OPEN:
    case K_OVER:
    case K_PARTITION:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SEPARATOR:
    case K_SIBLINGS:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TRUNCATE:
    case K_UNSIGNED:
    case K_VALUE:
    case K_VALUES:
    case K_XML:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      table = TableWithAlias();
      joins = JoinsList();
      break;
      }
    default:
      jj_la1[63] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHERE:{
      where = WhereClause();
delete.setWhere(where);
      break;
      }
    default:
      jj_la1[64] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      orderByElements = OrderByElements();
delete.setOrderByElements(orderByElements);
      break;
      }
    default:
      jj_la1[65] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LIMIT:{
      limit = PlainLimit();
delete.setLimit(limit);
      break;
      }
    default:
      jj_la1[66] = jj_gen;
      ;
    }
delete.setTables(tables);
        if (joins != null && joins.size() > 0)
            delete.setJoins(joins);
        delete.setTable(table);
        return delete;
}

  final public Statement Merge() throws ParseException {Merge merge = new Merge();
    Table table;
    SubSelect select;
    Alias alias;
    Expression condition;
    MergeUpdate update;
    MergeInsert insert;
    jj_consume_token(K_MERGE);
    jj_consume_token(K_INTO);
    table = TableWithAlias();
merge.setTable(table);
    jj_consume_token(K_USING);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_CASCADE:
    case K_CAST:
    case K_COLUMN:
    case K_COMMIT:
    case K_DATETIMELITERAL:
    case K_DO:
    case K_ENABLE:
    case K_END:
    case K_EXTRACT:
    case K_FIRST:
    case K_FOLLOWING:
    case K_INDEX:
    case K_INSERT:
    case K_KEY:
    case K_LAST:
    case K_MATERIALIZED:
    case K_NO:
    case K_NULLS:
    case K_OPEN:
    case K_OVER:
    case K_PARTITION:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SEPARATOR:
    case K_SIBLINGS:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TRUNCATE:
    case K_UNSIGNED:
    case K_VALUE:
    case K_VALUES:
    case K_XML:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      table = Table();
merge.setUsingTable(table);
      break;
      }
    case 184:{
      jj_consume_token(184);
      select = SubSelect();
merge.setUsingSelect(select);
      jj_consume_token(185);
      break;
      }
    default:
      jj_la1[67] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_AS:
    case K_CASCADE:
    case K_CAST:
    case K_COLUMN:
    case K_COMMIT:
    case K_DATETIMELITERAL:
    case K_DO:
    case K_ENABLE:
    case K_END:
    case K_EXTRACT:
    case K_FIRST:
    case K_FOLLOWING:
    case K_INDEX:
    case K_INSERT:
    case K_KEY:
    case K_LAST:
    case K_MATERIALIZED:
    case K_NO:
    case K_NULLS:
    case K_OPEN:
    case K_OVER:
    case K_PARTITION:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SEPARATOR:
    case K_SIBLINGS:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TRUNCATE:
    case K_UNSIGNED:
    case K_VALUE:
    case K_VALUES:
    case K_XML:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
merge.setUsingAlias(alias);
      break;
      }
    default:
      jj_la1[68] = jj_gen;
      ;
    }
    jj_consume_token(K_ON);
    jj_consume_token(184);
    condition = Expression();
merge.setOnCondition(condition);
    jj_consume_token(185);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHEN:{
      if (jj_2_15(2)) {
        update = MergeUpdateClause();
merge.setMergeUpdate(update);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_WHEN:{
          insert = MergeInsertClause();
merge.setMergeInsert(insert);
          break;
          }
        default:
          jj_la1[69] = jj_gen;
          ;
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_WHEN:{
          insert = MergeInsertClause();
merge.setMergeInsert(insert); merge.setInsertFirst(true);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_WHEN:{
            update = MergeUpdateClause();
merge.setMergeUpdate(update);
            break;
            }
          default:
            jj_la1[70] = jj_gen;
            ;
          }
          break;
          }
        default:
          jj_la1[71] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[72] = jj_gen;
      ;
    }
return merge;
}

  final public MergeUpdate MergeUpdateClause() throws ParseException {MergeUpdate mu = new MergeUpdate();
    List<Column> columns = new ArrayList<Column>();
    List<Expression> expList = new ArrayList<Expression>();
    Column col;
    Expression exp;
    Expression condition;
    jj_consume_token(K_WHEN);
    jj_consume_token(K_MATCHED);
    jj_consume_token(K_THEN);
    jj_consume_token(K_UPDATE);
    jj_consume_token(K_SET);
    col = Column();
    jj_consume_token(182);
    exp = SimpleExpression();
columns.add(col); expList.add(exp);
    label_24:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 183:{
        ;
        break;
        }
      default:
        jj_la1[73] = jj_gen;
        break label_24;
      }
      jj_consume_token(183);
      col = Column();
      jj_consume_token(182);
      exp = SimpleExpression();
columns.add(col); expList.add(exp);
    }
mu.setColumns(columns); mu.setValues(expList);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHERE:{
      jj_consume_token(K_WHERE);
      condition = Expression();
mu.setWhereCondition(condition);
      break;
      }
    default:
      jj_la1[74] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_DELETE:{
      jj_consume_token(K_DELETE);
      jj_consume_token(K_WHERE);
      condition = Expression();
mu.setDeleteWhereCondition(condition);
      break;
      }
    default:
      jj_la1[75] = jj_gen;
      ;
    }
return mu;
}

  final public MergeInsert MergeInsertClause() throws ParseException {MergeInsert mi = new MergeInsert();
    List<Column> columns = new ArrayList<Column>();
    List<Expression> expList = new ArrayList<Expression>();
    Column col;
    Expression exp;
    jj_consume_token(K_WHEN);
    jj_consume_token(K_NOT);
    jj_consume_token(K_MATCHED);
    jj_consume_token(K_THEN);
    jj_consume_token(K_INSERT);
    jj_consume_token(184);
    col = Column();
columns.add(col);
    label_25:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 183:{
        ;
        break;
        }
      default:
        jj_la1[76] = jj_gen;
        break label_25;
      }
      jj_consume_token(183);
      col = Column();
columns.add(col);
    }
    jj_consume_token(185);
    jj_consume_token(K_VALUES);
    jj_consume_token(184);
    exp = SimpleExpression();
expList.add(exp);
    label_26:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 183:{
        ;
        break;
        }
      default:
        jj_la1[77] = jj_gen;
        break label_26;
      }
      jj_consume_token(183);
      exp = SimpleExpression();
expList.add(exp);
    }
    jj_consume_token(185);
mi.setColumns(columns);
        mi.setValues(expList);
        return mi;
}

// See: http://technet.microsoft.com/en-us/library/ms187879%28v=sql.105%29.aspx
  final public 
Column Column() throws ParseException {/*@bgen(jjtree) Column */
    SimpleNode jjtn000 = new SimpleNode(JJTCOLUMN);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));String databaseName = null, schemaName = null, tableName = null, columnName = null;
    String token = null;
    try {
      columnName = RelObjectName();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 187:{
        jj_consume_token(187);
        if (jj_2_16(2)) {
          token = RelObjectName();
        } else {
          ;
        }
tableName = columnName; columnName = token; token = null;
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 187:{
          jj_consume_token(187);
          token = RelObjectName();
schemaName = tableName; tableName = columnName; columnName = token; token = null;
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 187:{
            jj_consume_token(187);
            token = RelObjectName();
databaseName = schemaName; schemaName = tableName; tableName = columnName; columnName = token;
            break;
            }
          default:
            jj_la1[78] = jj_gen;
            ;
          }
          break;
          }
        default:
          jj_la1[79] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[80] = jj_gen;
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
if (tableName==null && (databaseName!=null || schemaName!=null)) {
                        {if (true) throw generateParseException();}
                }

        final Database database = new Database(databaseName);
        final Table table = new Table(database, schemaName, tableName);
        Column col = new Column(table, columnName);
        linkAST(col,jjtn000);
        return col;
    } catch (Throwable jjte000) {
if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
            jjtn000.jjtSetLastToken(getToken(0));
          }
    }
    throw new RuntimeException("Missing return statement in function");
}

/*
Not all names should be allowed for aliases.
*/
  final public String RelObjectNameWithoutValue() throws ParseException {Token tk = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      tk = jj_consume_token(S_IDENTIFIER);
      break;
      }
    case S_QUOTED_IDENTIFIER:{
      tk = jj_consume_token(S_QUOTED_IDENTIFIER);
      break;
      }
    case K_CAST:{
      tk = jj_consume_token(K_CAST);
      break;
      }
    case K_DO:{
      tk = jj_consume_token(K_DO);
      break;
      }
    case K_EXTRACT:{
      tk = jj_consume_token(K_EXTRACT);
      break;
      }
    case K_FIRST:{
      tk = jj_consume_token(K_FIRST);
      break;
      }
    case K_FOLLOWING:{
      tk = jj_consume_token(K_FOLLOWING);
      break;
      }
    case K_LAST:{
      tk = jj_consume_token(K_LAST);
      break;
      }
    case K_MATERIALIZED:{
      tk = jj_consume_token(K_MATERIALIZED);
      break;
      }
    case K_NULLS:{
      tk = jj_consume_token(K_NULLS);
      break;
      }
    case K_PARTITION:{
      tk = jj_consume_token(K_PARTITION);
      break;
      }
    case K_RANGE:{
      tk = jj_consume_token(K_RANGE);
      break;
      }
    case K_ROW:{
      tk = jj_consume_token(K_ROW);
      break;
      }
    case K_ROWS:{
      tk = jj_consume_token(K_ROWS);
      break;
      }
    case K_SIBLINGS:{
      tk = jj_consume_token(K_SIBLINGS);
      break;
      }
    case K_XML:{
      tk = jj_consume_token(K_XML);
      break;
      }
    case K_COLUMN:{
      tk = jj_consume_token(K_COLUMN);
      break;
      }
    case K_REPLACE:{
      tk = jj_consume_token(K_REPLACE);
      break;
      }
    case K_TRUNCATE:{
      tk = jj_consume_token(K_TRUNCATE);
      break;
      }
    case K_KEY:{
      tk = jj_consume_token(K_KEY);
      break;
      }
    case K_ANY:{
      tk = jj_consume_token(K_ANY);
      break;
      }
    case K_OPEN:{
      tk = jj_consume_token(K_OPEN);
      break;
      }
    case K_OVER:{
      tk = jj_consume_token(K_OVER);
      break;
      }
    case K_PERCENT:{
      tk = jj_consume_token(K_PERCENT);
      break;
      }
    case K_PRIOR:{
      tk = jj_consume_token(K_PRIOR);
      break;
      }
    case K_SEPARATOR:{
      tk = jj_consume_token(K_SEPARATOR);
      break;
      }
    case K_NO:{
      tk = jj_consume_token(K_NO);
      break;
      }
    case K_ACTION:{
      tk = jj_consume_token(K_ACTION);
      break;
      }
    case K_CASCADE:{
      tk = jj_consume_token(K_CASCADE);
      break;
      }
    case K_END:{
      tk = jj_consume_token(K_END);
      break;
      }
    case K_TABLE:{
      tk = jj_consume_token(K_TABLE);
      break;
      }
    case K_DATETIMELITERAL:{
      tk = jj_consume_token(K_DATETIMELITERAL);
      break;
      }
    case K_COMMIT:{
      tk = jj_consume_token(K_COMMIT);
      break;
      }
    case K_PRECISION:{
      tk = jj_consume_token(K_PRECISION);
      break;
      }
    case K_INSERT:{
      tk = jj_consume_token(K_INSERT);
      break;
      }
    case K_INDEX:{
      tk = jj_consume_token(K_INDEX);
      break;
      }
    case K_PRIMARY:{
      tk = jj_consume_token(K_PRIMARY);
      break;
      }
    case K_ENABLE:{
      tk = jj_consume_token(K_ENABLE);
      break;
      }
    case K_UNSIGNED:{
      tk = jj_consume_token(K_UNSIGNED);
      break;
      }
    case K_TEMP:{
      tk = jj_consume_token(K_TEMP);
      break;
      }
    case K_TEMPORARY:{
      tk = jj_consume_token(K_TEMPORARY);
      break;
      }
    default:
      jj_la1[81] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return tk.image;
}

/*
Normal names.
*/
  final public String RelObjectName() throws ParseException {Token tk = null; String result = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_CASCADE:
    case K_CAST:
    case K_COLUMN:
    case K_COMMIT:
    case K_DATETIMELITERAL:
    case K_DO:
    case K_ENABLE:
    case K_END:
    case K_EXTRACT:
    case K_FIRST:
    case K_FOLLOWING:
    case K_INDEX:
    case K_INSERT:
    case K_KEY:
    case K_LAST:
    case K_MATERIALIZED:
    case K_NO:
    case K_NULLS:
    case K_OPEN:
    case K_OVER:
    case K_PARTITION:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SEPARATOR:
    case K_SIBLINGS:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TRUNCATE:
    case K_UNSIGNED:
    case K_XML:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      result = RelObjectNameWithoutValue();
      break;
      }
    case K_VALUE:{
      tk = jj_consume_token(K_VALUE);
      break;
      }
    case K_VALUES:{
      tk = jj_consume_token(K_VALUES);
      break;
      }
    default:
      jj_la1[82] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (tk!=null) result=tk.image;
                return result;
}

/*
Extended version of object names.
*/
  final public String RelObjectNameExt() throws ParseException {Token tk = null;
  String result=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_CASCADE:
    case K_CAST:
    case K_COLUMN:
    case K_COMMIT:
    case K_DATETIMELITERAL:
    case K_DO:
    case K_ENABLE:
    case K_END:
    case K_EXTRACT:
    case K_FIRST:
    case K_FOLLOWING:
    case K_INDEX:
    case K_INSERT:
    case K_KEY:
    case K_LAST:
    case K_MATERIALIZED:
    case K_NO:
    case K_NULLS:
    case K_OPEN:
    case K_OVER:
    case K_PARTITION:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SEPARATOR:
    case K_SIBLINGS:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TRUNCATE:
    case K_UNSIGNED:
    case K_VALUE:
    case K_VALUES:
    case K_XML:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      result = RelObjectName();
      break;
      }
    case K_LEFT:{
      tk = jj_consume_token(K_LEFT);
      break;
      }
    case K_RIGHT:{
      tk = jj_consume_token(K_RIGHT);
      break;
      }
    case K_SET:{
      tk = jj_consume_token(K_SET);
      break;
      }
    case K_DOUBLE:{
      tk = jj_consume_token(K_DOUBLE);
      break;
      }
    case K_IF:{
      tk = jj_consume_token(K_IF);
      break;
      }
    default:
      jj_la1[83] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (tk!=null) result=tk.image;
        return result;
}

/*
Extended usage of object names - part 2.
*/
  final public String RelObjectNameExt2() throws ParseException {Token tk = null;
  String result=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_CASCADE:
    case K_CAST:
    case K_COLUMN:
    case K_COMMIT:
    case K_DATETIMELITERAL:
    case K_DO:
    case K_DOUBLE:
    case K_ENABLE:
    case K_END:
    case K_EXTRACT:
    case K_FIRST:
    case K_FOLLOWING:
    case K_IF:
    case K_INDEX:
    case K_INSERT:
    case K_KEY:
    case K_LAST:
    case K_LEFT:
    case K_MATERIALIZED:
    case K_NO:
    case K_NULLS:
    case K_OPEN:
    case K_OVER:
    case K_PARTITION:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_REPLACE:
    case K_RIGHT:
    case K_ROW:
    case K_ROWS:
    case K_SEPARATOR:
    case K_SET:
    case K_SIBLINGS:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TRUNCATE:
    case K_UNSIGNED:
    case K_VALUE:
    case K_VALUES:
    case K_XML:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      result = RelObjectNameExt();
      break;
      }
    case K_TOP:{
      tk = jj_consume_token(K_TOP);
      break;
      }
    case K_FROM:{
      tk = jj_consume_token(K_FROM);
      break;
      }
    default:
      jj_la1[84] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (tk!=null) result=tk.image;
        return result;
}

  final public Table Table() throws ParseException {/*@bgen(jjtree) Table */
    SimpleNode jjtn000 = new SimpleNode(JJTTABLE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));String serverName = null, databaseName = null, schemaName = null, tableName = null;
    try {
      if (jj_2_17(7)) {
        serverName = RelObjectName();
        jj_consume_token(187);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ACTION:
        case K_ANY:
        case K_CASCADE:
        case K_CAST:
        case K_COLUMN:
        case K_COMMIT:
        case K_DATETIMELITERAL:
        case K_DO:
        case K_ENABLE:
        case K_END:
        case K_EXTRACT:
        case K_FIRST:
        case K_FOLLOWING:
        case K_INDEX:
        case K_INSERT:
        case K_KEY:
        case K_LAST:
        case K_MATERIALIZED:
        case K_NO:
        case K_NULLS:
        case K_OPEN:
        case K_OVER:
        case K_PARTITION:
        case K_PERCENT:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_RANGE:
        case K_REPLACE:
        case K_ROW:
        case K_ROWS:
        case K_SEPARATOR:
        case K_SIBLINGS:
        case K_TABLE:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TRUNCATE:
        case K_UNSIGNED:
        case K_VALUE:
        case K_VALUES:
        case K_XML:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:{
          databaseName = RelObjectName();
          break;
          }
        default:
          jj_la1[85] = jj_gen;
          ;
        }
        jj_consume_token(187);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ACTION:
        case K_ANY:
        case K_CASCADE:
        case K_CAST:
        case K_COLUMN:
        case K_COMMIT:
        case K_DATETIMELITERAL:
        case K_DO:
        case K_ENABLE:
        case K_END:
        case K_EXTRACT:
        case K_FIRST:
        case K_FOLLOWING:
        case K_INDEX:
        case K_INSERT:
        case K_KEY:
        case K_LAST:
        case K_MATERIALIZED:
        case K_NO:
        case K_NULLS:
        case K_OPEN:
        case K_OVER:
        case K_PARTITION:
        case K_PERCENT:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_RANGE:
        case K_REPLACE:
        case K_ROW:
        case K_ROWS:
        case K_SEPARATOR:
        case K_SIBLINGS:
        case K_TABLE:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TRUNCATE:
        case K_UNSIGNED:
        case K_VALUE:
        case K_VALUES:
        case K_XML:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:{
          schemaName = RelObjectName();
          break;
          }
        default:
          jj_la1[86] = jj_gen;
          ;
        }
        jj_consume_token(187);
        tableName = RelObjectName();
      } else if (jj_2_18(5)) {
        databaseName = RelObjectName();
        jj_consume_token(187);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ACTION:
        case K_ANY:
        case K_CASCADE:
        case K_CAST:
        case K_COLUMN:
        case K_COMMIT:
        case K_DATETIMELITERAL:
        case K_DO:
        case K_ENABLE:
        case K_END:
        case K_EXTRACT:
        case K_FIRST:
        case K_FOLLOWING:
        case K_INDEX:
        case K_INSERT:
        case K_KEY:
        case K_LAST:
        case K_MATERIALIZED:
        case K_NO:
        case K_NULLS:
        case K_OPEN:
        case K_OVER:
        case K_PARTITION:
        case K_PERCENT:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_RANGE:
        case K_REPLACE:
        case K_ROW:
        case K_ROWS:
        case K_SEPARATOR:
        case K_SIBLINGS:
        case K_TABLE:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TRUNCATE:
        case K_UNSIGNED:
        case K_VALUE:
        case K_VALUES:
        case K_XML:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:{
          schemaName = RelObjectName();
          break;
          }
        default:
          jj_la1[87] = jj_gen;
          ;
        }
        jj_consume_token(187);
        tableName = RelObjectName();
      } else if (jj_2_19(3)) {
        schemaName = RelObjectName();
        jj_consume_token(187);
        tableName = RelObjectName();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ACTION:
        case K_ANY:
        case K_CASCADE:
        case K_CAST:
        case K_COLUMN:
        case K_COMMIT:
        case K_DATETIMELITERAL:
        case K_DO:
        case K_ENABLE:
        case K_END:
        case K_EXTRACT:
        case K_FIRST:
        case K_FOLLOWING:
        case K_INDEX:
        case K_INSERT:
        case K_KEY:
        case K_LAST:
        case K_MATERIALIZED:
        case K_NO:
        case K_NULLS:
        case K_OPEN:
        case K_OVER:
        case K_PARTITION:
        case K_PERCENT:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_RANGE:
        case K_REPLACE:
        case K_ROW:
        case K_ROWS:
        case K_SEPARATOR:
        case K_SIBLINGS:
        case K_TABLE:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TRUNCATE:
        case K_UNSIGNED:
        case K_VALUE:
        case K_VALUES:
        case K_XML:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:{
          tableName = RelObjectName();
          break;
          }
        default:
          jj_la1[88] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
final Server server = new Server(serverName);
        final Database database = new Database(server, databaseName);
        Table table = new Table(database, schemaName, tableName);
        return table;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Table TableWithAlias() throws ParseException {Table table = null;
    Alias alias = null;
    table = Table();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_AS:
    case K_CASCADE:
    case K_CAST:
    case K_COLUMN:
    case K_COMMIT:
    case K_DATETIMELITERAL:
    case K_DO:
    case K_ENABLE:
    case K_END:
    case K_EXTRACT:
    case K_FIRST:
    case K_FOLLOWING:
    case K_INDEX:
    case K_INSERT:
    case K_KEY:
    case K_LAST:
    case K_MATERIALIZED:
    case K_NO:
    case K_NULLS:
    case K_OPEN:
    case K_OVER:
    case K_PARTITION:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SEPARATOR:
    case K_SIBLINGS:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TRUNCATE:
    case K_UNSIGNED:
    case K_VALUE:
    case K_VALUES:
    case K_XML:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
table.setAlias(alias);
      break;
      }
    default:
      jj_la1[89] = jj_gen;
      ;
    }
return table;
}

  final public Select Select() throws ParseException {Select select = new Select();
    SelectBody selectBody = null;
    List<WithItem> with = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WITH:{
      with = WithList();

      break;
      }
    default:
      jj_la1[90] = jj_gen;
      ;
    }
    selectBody = SelectBody();
select.setWithItemsList(with);
        select.setSelectBody(selectBody);
        return select;
}

  final public SelectBody SelectBody() throws ParseException {SelectBody selectBody = null;
    selectBody = SetOperationList();
return selectBody;
}

  final public PlainSelect PlainSelect() throws ParseException {/*@bgen(jjtree) PlainSelect */
    SimpleNode jjtn000 = new SimpleNode(JJTPLAINSELECT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));PlainSelect plainSelect = new PlainSelect();
    List<SelectItem> selectItems = null;
    FromItem fromItem = null;
    List<Join> joins = null;
    List<SelectItem> distinctOn = null;
    Expression where = null;
    List<OrderByElement> orderByElements;
    List<Expression> groupByColumnReferences = null;
    Expression having = null;
    Limit limit = null;
    Offset offset = null;
    Fetch fetch = null;
    Top top = null;
        Skip skip = null;
        First first = null;
    OracleHierarchicalExpression oracleHierarchicalQueryClause = null;
    List<Table> intoTables = null;
    Table updateTable = null;
    Wait wait = null;
    boolean mySqlSqlCalcFoundRows = false;
    try {
      jj_consume_token(K_SELECT);
plainSelect.setOracleHint(getOracleHint());
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_SKIP:{
        skip = Skip();
plainSelect.setSkip(skip);
        break;
        }
      default:
        jj_la1[91] = jj_gen;
        ;
      }
      if (jj_2_20(2)) {
        first = First();
plainSelect.setFirst(first);
      } else {
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ALL:
      case K_DISTINCT:
      case K_UNIQUE:
      case K_SQL_CALC_FOUND_ROWS:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ALL:{
          jj_consume_token(K_ALL);
          break;
          }
        case K_DISTINCT:{
          jj_consume_token(K_DISTINCT);
Distinct distinct = new Distinct(); plainSelect.setDistinct(distinct);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ON:{
            jj_consume_token(K_ON);
            jj_consume_token(184);
            distinctOn = SelectItemsList();
plainSelect.getDistinct().setOnSelectItems(distinctOn);
            jj_consume_token(185);
            break;
            }
          default:
            jj_la1[92] = jj_gen;
            ;
          }
          break;
          }
        case K_UNIQUE:{
          jj_consume_token(K_UNIQUE);
Distinct distinct = new Distinct(true); plainSelect.setDistinct(distinct);
          break;
          }
        case K_SQL_CALC_FOUND_ROWS:{
          jj_consume_token(K_SQL_CALC_FOUND_ROWS);
plainSelect.setMySqlSqlCalcFoundRows(true);
          break;
          }
        default:
          jj_la1[93] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[94] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_TOP:{
        top = Top();
plainSelect.setTop(top);
        break;
        }
      default:
        jj_la1[95] = jj_gen;
        ;
      }
      selectItems = SelectItemsList();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_INTO:{
        intoTables = IntoClause();
plainSelect.setIntoTables(intoTables);
        break;
        }
      default:
        jj_la1[96] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FROM:{
        jj_consume_token(K_FROM);
        fromItem = FromItem();
        joins = JoinsList();
        break;
        }
      default:
        jj_la1[97] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_WHERE:{
        where = WhereClause();
plainSelect.setWhere(where);
        break;
        }
      default:
        jj_la1[98] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CONNECT:
      case K_START:{
        oracleHierarchicalQueryClause = OracleHierarchicalQueryClause();
plainSelect.setOracleHierarchical(oracleHierarchicalQueryClause);
        break;
        }
      default:
        jj_la1[99] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_GROUP:{
        groupByColumnReferences = GroupByColumnReferences();
plainSelect.setGroupByColumnReferences(groupByColumnReferences);
        break;
        }
      default:
        jj_la1[100] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_HAVING:{
        having = Having();
plainSelect.setHaving(having);
        break;
        }
      default:
        jj_la1[101] = jj_gen;
        ;
      }
      if (jj_2_21(2147483647)) {
        orderByElements = OrderByElements();
plainSelect.setOracleSiblings(true); plainSelect.setOrderByElements(orderByElements);
      } else {
        ;
      }
      if (jj_2_22(2147483647)) {
        orderByElements = OrderByElements();
plainSelect.setOrderByElements(orderByElements);
      } else {
        ;
      }
      if (jj_2_23(2147483647)) {
        limit = LimitWithOffset();
plainSelect.setLimit(limit);
      } else {
        ;
      }
      if (jj_2_24(2147483647)) {
        offset = Offset();
plainSelect.setOffset(offset);
      } else {
        ;
      }
      if (jj_2_25(2147483647)) {
        fetch = Fetch();
plainSelect.setFetch(fetch);
      } else {
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FOR:{
        jj_consume_token(K_FOR);
        jj_consume_token(K_UPDATE);
plainSelect.setForUpdate(true);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_OF:{
          jj_consume_token(K_OF);
          updateTable = Table();
plainSelect.setForUpdateTable(updateTable);
          break;
          }
        default:
          jj_la1[102] = jj_gen;
          ;
        }
        if (jj_2_26(2147483647)) {
          wait = Wait();
plainSelect.setWait(wait);
        } else {
          ;
        }
        break;
        }
      default:
        jj_la1[103] = jj_gen;
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
plainSelect.setSelectItems(selectItems);
        plainSelect.setFromItem(fromItem);
        if (joins != null && joins.size() > 0)
            plainSelect.setJoins(joins);
        linkAST(plainSelect,jjtn000);
        return plainSelect;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public SelectBody SetOperationList() throws ParseException {/*@bgen(jjtree) SetOperationList */
    SimpleNode jjtn000 = new SimpleNode(JJTSETOPERATIONLIST);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));SetOperationList list = new SetOperationList();
    List<OrderByElement> orderByElements = null;
    Limit limit = null;
    Offset offset = null;
    Fetch fetch = null;
    SelectBody select = null;
    List<SelectBody> selects = new ArrayList<SelectBody>();
    List<SetOperation> operations = new ArrayList<SetOperation>();
    List<Boolean> brackets = new ArrayList<Boolean>();
    boolean bracket;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 184:{
        jj_consume_token(184);
        select = SelectBody();
        jj_consume_token(185);
bracket=true;
        break;
        }
      case K_SELECT:{
        select = PlainSelect();
bracket=false;
        break;
        }
      default:
        jj_la1[104] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
selects.add(select);brackets.add(bracket);
      label_27:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_EXCEPT:
        case K_INTERSECT:
        case K_MINUS:
        case K_UNION:{
          ;
          break;
          }
        default:
          jj_la1[105] = jj_gen;
          break label_27;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_UNION:{
          jj_consume_token(K_UNION);
UnionOp union = new UnionOp();linkAST(union,jjtn000);operations.add(union);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ALL:
          case K_DISTINCT:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_ALL:{
              jj_consume_token(K_ALL);
union.setAll(true);
              break;
              }
            case K_DISTINCT:{
              jj_consume_token(K_DISTINCT);
union.setDistinct(true);
              break;
              }
            default:
              jj_la1[106] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
            }
          default:
            jj_la1[107] = jj_gen;
            ;
          }
          break;
          }
        case K_INTERSECT:{
          jj_consume_token(K_INTERSECT);
operations.add(new IntersectOp());
          break;
          }
        case K_MINUS:{
          jj_consume_token(K_MINUS);
operations.add(new MinusOp());
          break;
          }
        case K_EXCEPT:{
          jj_consume_token(K_EXCEPT);
operations.add(new ExceptOp());
          break;
          }
        default:
          jj_la1[108] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 184:{
          jj_consume_token(184);
          select = SelectBody();
          jj_consume_token(185);
bracket=true;
          break;
          }
        case K_SELECT:{
          select = PlainSelect();
bracket=false;
          break;
          }
        default:
          jj_la1[109] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
selects.add(select);brackets.add(bracket);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ORDER:{
        orderByElements = OrderByElements();
list.setOrderByElements(orderByElements);
        break;
        }
      default:
        jj_la1[110] = jj_gen;
        ;
      }
      if (jj_2_27(2147483647)) {
        limit = LimitWithOffset();
list.setLimit(limit);
      } else {
        ;
      }
      if (jj_2_28(2147483647)) {
        offset = Offset();
list.setOffset(offset);
      } else {
        ;
      }
      if (jj_2_29(2147483647)) {
        fetch = Fetch();
list.setFetch(fetch);
      } else {
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
if (selects.size()==1 && selects.get(0) instanceof PlainSelect) {
            if (brackets.get(0))
                ((PlainSelect)selects.get(0)).setUseBrackets(true);
            return selects.get(0);
        } else {
            list.setBracketsOpsAndSelects(brackets,selects,operations);
            return list;
        }
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public List<WithItem> WithList() throws ParseException {List<WithItem> withItemsList = new ArrayList<WithItem>();
    WithItem with = null;
    jj_consume_token(K_WITH);
    with = WithItem();
withItemsList.add(with);
    label_28:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 183:{
        ;
        break;
        }
      default:
        jj_la1[111] = jj_gen;
        break label_28;
      }
      jj_consume_token(183);
      with = WithItem();
withItemsList.add(with);
    }
return withItemsList;
}

  final public WithItem WithItem() throws ParseException {/*@bgen(jjtree) WithItem */
    SimpleNode jjtn000 = new SimpleNode(JJTWITHITEM);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));WithItem with = new WithItem();
    String name = null;
    List<SelectItem> selectItems = null;
    SelectBody selectBody = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_RECURSIVE:{
        jj_consume_token(K_RECURSIVE);
with.setRecursive(true);
        break;
        }
      default:
        jj_la1[112] = jj_gen;
        ;
      }
      name = RelObjectName();
with.setName(name);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 184:{
        jj_consume_token(184);
        selectItems = SelectItemsList();
        jj_consume_token(185);
with.setWithItemList(selectItems);
        break;
        }
      default:
        jj_la1[113] = jj_gen;
        ;
      }
      jj_consume_token(K_AS);
      jj_consume_token(184);
      selectBody = SelectBody();
with.setSelectBody(selectBody);
      jj_consume_token(185);
jjtree.closeNodeScope(jjtn000, true);
       jjtc000 = false;
       jjtn000.jjtSetLastToken(getToken(0));
return with;
    } catch (Throwable jjte000) {
if (jjtc000) {
         jjtree.clearNodeScope(jjtn000);
         jjtc000 = false;
       } else {
         jjtree.popNode();
       }
       if (jjte000 instanceof RuntimeException) {
         {if (true) throw (RuntimeException)jjte000;}
       }
       if (jjte000 instanceof ParseException) {
         {if (true) throw (ParseException)jjte000;}
       }
       {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
         jjtree.closeNodeScope(jjtn000, true);
         jjtn000.jjtSetLastToken(getToken(0));
       }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public List<SelectItem> SelectItemsList() throws ParseException {List<SelectItem> selectItemsList = new ArrayList<SelectItem>();
    SelectItem selectItem = null;
    selectItem = SelectItem();
selectItemsList.add(selectItem);
    label_29:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 183:{
        ;
        break;
        }
      default:
        jj_la1[114] = jj_gen;
        break label_29;
      }
      jj_consume_token(183);
      selectItem = SelectItem();
selectItemsList.add(selectItem);
    }
return selectItemsList;
}

  final public SelectExpressionItem SelectExpressionItem() throws ParseException {SelectExpressionItem selectExpressionItem = null;
    Expression expression = null;
    Alias alias = null;
    expression = SimpleExpression();
selectExpressionItem = new SelectExpressionItem(); selectExpressionItem.setExpression(expression);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_AS:
    case K_CASCADE:
    case K_CAST:
    case K_COLUMN:
    case K_COMMIT:
    case K_DATETIMELITERAL:
    case K_DO:
    case K_ENABLE:
    case K_END:
    case K_EXTRACT:
    case K_FIRST:
    case K_FOLLOWING:
    case K_INDEX:
    case K_INSERT:
    case K_KEY:
    case K_LAST:
    case K_MATERIALIZED:
    case K_NO:
    case K_NULLS:
    case K_OPEN:
    case K_OVER:
    case K_PARTITION:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SEPARATOR:
    case K_SIBLINGS:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TRUNCATE:
    case K_UNSIGNED:
    case K_VALUE:
    case K_VALUES:
    case K_XML:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
selectExpressionItem.setAlias(alias);
      break;
      }
    default:
      jj_la1[115] = jj_gen;
      ;
    }
return selectExpressionItem;
}

  final public SelectItem SelectItem() throws ParseException {/*@bgen(jjtree) SelectItem */
    SimpleNode jjtn000 = new SimpleNode(JJTSELECTITEM);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));SelectItem selectItem = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 186:{
        jj_consume_token(186);
selectItem = new AllColumns();
        break;
        }
      default:
        jj_la1[116] = jj_gen;
        if (jj_2_30(2147483647)) {
          selectItem = AllTableColumns();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ACTION:
          case K_ANY:
          case K_CASCADE:
          case K_CASE:
          case K_CAST:
          case K_COLUMN:
          case K_COMMIT:
          case K_DATETIMELITERAL:
          case K_DO:
          case K_DOUBLE:
          case K_ENABLE:
          case K_END:
          case K_EXTRACT:
          case K_FIRST:
          case K_FOLLOWING:
          case K_GROUP_CONCAT:
          case K_IF:
          case K_INDEX:
          case K_INSERT:
          case K_INTERVAL:
          case K_KEY:
          case K_LAST:
          case K_LEFT:
          case K_MATERIALIZED:
          case K_NO:
          case K_NULL:
          case K_NULLS:
          case K_OPEN:
          case K_OVER:
          case K_PARTITION:
          case K_PERCENT:
          case K_PRECISION:
          case K_PRIMARY:
          case K_PRIOR:
          case K_RANGE:
          case K_REPLACE:
          case K_RIGHT:
          case K_ROW:
          case K_ROWS:
          case K_SEPARATOR:
          case K_SET:
          case K_SIBLINGS:
          case K_TABLE:
          case K_TEMP:
          case K_TEMPORARY:
          case K_TIME_KEY_EXPR:
          case K_TRUNCATE:
          case K_UNSIGNED:
          case K_VALUE:
          case K_VALUES:
          case K_XML:
          case S_DOUBLE:
          case S_LONG:
          case S_HEX:
          case S_IDENTIFIER:
          case S_CHAR_LITERAL:
          case S_QUOTED_IDENTIFIER:
          case 184:
          case 188:
          case 189:
          case 190:
          case 193:
          case 194:
          case 202:
          case 211:
          case 213:
          case 214:
          case 216:
          case 221:{
            selectItem = SelectExpressionItem();
            break;
            }
          default:
            jj_la1[117] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(selectItem,jjtn000);
        return selectItem;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public AllTableColumns AllTableColumns() throws ParseException {Table table = null;
    table = Table();
    jj_consume_token(187);
    jj_consume_token(186);
return new AllTableColumns(table);
}

  final public Alias Alias() throws ParseException {String name = null;
  Token token = null;
  boolean useAs = false;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_AS:{
      jj_consume_token(K_AS);
useAs = true;
      break;
      }
    default:
      jj_la1[118] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_CASCADE:
    case K_CAST:
    case K_COLUMN:
    case K_COMMIT:
    case K_DATETIMELITERAL:
    case K_DO:
    case K_ENABLE:
    case K_END:
    case K_EXTRACT:
    case K_FIRST:
    case K_FOLLOWING:
    case K_INDEX:
    case K_INSERT:
    case K_KEY:
    case K_LAST:
    case K_MATERIALIZED:
    case K_NO:
    case K_NULLS:
    case K_OPEN:
    case K_OVER:
    case K_PARTITION:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SEPARATOR:
    case K_SIBLINGS:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TRUNCATE:
    case K_UNSIGNED:
    case K_VALUE:
    case K_VALUES:
    case K_XML:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      name = RelObjectName();
      break;
      }
    case S_CHAR_LITERAL:{
      token = jj_consume_token(S_CHAR_LITERAL);
name=token.image;
      break;
      }
    default:
      jj_la1[119] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return new Alias(name,useAs);
}

  final public MySQLIndexHint MySQLIndexHint() throws ParseException {Token actionToken = null;
        Token indexToken = null;
        String indexName = null;
        List<String> indexNameList = new ArrayList<String>();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_USE:{
      actionToken = jj_consume_token(K_USE);
      break;
      }
    case K_IGNORE:{
      actionToken = jj_consume_token(K_IGNORE);
      break;
      }
    case K_FORCE:{
      actionToken = jj_consume_token(K_FORCE);
      break;
      }
    default:
      jj_la1[120] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_INDEX:{
      indexToken = jj_consume_token(K_INDEX);
      break;
      }
    case K_KEY:{
      indexToken = jj_consume_token(K_KEY);
      break;
      }
    default:
      jj_la1[121] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(184);
    indexName = Identifier();
indexNameList.add(indexName);
    label_30:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 183:{
        ;
        break;
        }
      default:
        jj_la1[122] = jj_gen;
        break label_30;
      }
      jj_consume_token(183);
      indexName = Identifier();
indexNameList.add(indexName);
    }
    jj_consume_token(185);
return new MySQLIndexHint(actionToken.image, indexToken.image, indexNameList);
}

  final public String Identifier() throws ParseException {Token tk = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      tk = jj_consume_token(S_IDENTIFIER);
      break;
      }
    case S_QUOTED_IDENTIFIER:{
      tk = jj_consume_token(S_QUOTED_IDENTIFIER);
      break;
      }
    default:
      jj_la1[123] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return tk.image;
}

  final public FunctionItem FunctionItem() throws ParseException {Alias alias = null;
    Function function;
    FunctionItem functionItem;
    function = Function();
functionItem = new FunctionItem(); functionItem.setFunction(function);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_AS:
    case K_CASCADE:
    case K_CAST:
    case K_COLUMN:
    case K_COMMIT:
    case K_DATETIMELITERAL:
    case K_DO:
    case K_ENABLE:
    case K_END:
    case K_EXTRACT:
    case K_FIRST:
    case K_FOLLOWING:
    case K_INDEX:
    case K_INSERT:
    case K_KEY:
    case K_LAST:
    case K_MATERIALIZED:
    case K_NO:
    case K_NULLS:
    case K_OPEN:
    case K_OVER:
    case K_PARTITION:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SEPARATOR:
    case K_SIBLINGS:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TRUNCATE:
    case K_UNSIGNED:
    case K_VALUE:
    case K_VALUES:
    case K_XML:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
functionItem.setAlias(alias);
      break;
      }
    default:
      jj_la1[124] = jj_gen;
      ;
    }
return functionItem;
}

  final public List<Column> PivotForColumns() throws ParseException {List<Column> columns = new ArrayList<Column>();
    Column column;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 184:{
      jj_consume_token(184);
      column = Column();
columns.add(column);
      label_31:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 183:{
          ;
          break;
          }
        default:
          jj_la1[125] = jj_gen;
          break label_31;
        }
        jj_consume_token(183);
        column = Column();
columns.add(column);
      }
      jj_consume_token(185);
      break;
      }
    case K_ACTION:
    case K_ANY:
    case K_CASCADE:
    case K_CAST:
    case K_COLUMN:
    case K_COMMIT:
    case K_DATETIMELITERAL:
    case K_DO:
    case K_ENABLE:
    case K_END:
    case K_EXTRACT:
    case K_FIRST:
    case K_FOLLOWING:
    case K_INDEX:
    case K_INSERT:
    case K_KEY:
    case K_LAST:
    case K_MATERIALIZED:
    case K_NO:
    case K_NULLS:
    case K_OPEN:
    case K_OVER:
    case K_PARTITION:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SEPARATOR:
    case K_SIBLINGS:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TRUNCATE:
    case K_UNSIGNED:
    case K_VALUE:
    case K_VALUES:
    case K_XML:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      column = Column();
columns.add(column);
      break;
      }
    default:
      jj_la1[126] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return columns;
}

  final public List<FunctionItem> PivotFunctionItems() throws ParseException {List<FunctionItem> functionItems = new ArrayList<FunctionItem>();
    FunctionItem item;
    item = FunctionItem();
functionItems.add(item);
    label_32:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 183:{
        ;
        break;
        }
      default:
        jj_la1[127] = jj_gen;
        break label_32;
      }
      jj_consume_token(183);
      item = FunctionItem();
functionItems.add(item);
    }
return functionItems;
}

  final public List<SelectExpressionItem> PivotSingleInItems() throws ParseException {List<SelectExpressionItem> retval = new ArrayList<SelectExpressionItem>();
   SelectExpressionItem item;
    item = SelectExpressionItem();
retval.add(item);
    label_33:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 183:{
        ;
        break;
        }
      default:
        jj_la1[128] = jj_gen;
        break label_33;
      }
      jj_consume_token(183);
      item = SelectExpressionItem();
retval.add(item);
    }
return retval;
}

  final public ExpressionListItem ExpressionListItem() throws ParseException {ExpressionListItem expressionListItem = null;
    ExpressionList expressionList = null;
    Alias alias = null;
    jj_consume_token(184);
    expressionList = SimpleExpressionList();
expressionListItem = new ExpressionListItem(); expressionListItem.setExpressionList(expressionList);
    jj_consume_token(185);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_AS:
    case K_CASCADE:
    case K_CAST:
    case K_COLUMN:
    case K_COMMIT:
    case K_DATETIMELITERAL:
    case K_DO:
    case K_ENABLE:
    case K_END:
    case K_EXTRACT:
    case K_FIRST:
    case K_FOLLOWING:
    case K_INDEX:
    case K_INSERT:
    case K_KEY:
    case K_LAST:
    case K_MATERIALIZED:
    case K_NO:
    case K_NULLS:
    case K_OPEN:
    case K_OVER:
    case K_PARTITION:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SEPARATOR:
    case K_SIBLINGS:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TRUNCATE:
    case K_UNSIGNED:
    case K_VALUE:
    case K_VALUES:
    case K_XML:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
expressionListItem.setAlias(alias);
      break;
      }
    default:
      jj_la1[129] = jj_gen;
      ;
    }
return expressionListItem;
}

  final public List<ExpressionListItem> PivotMultiInItems() throws ParseException {List<ExpressionListItem> retval = new ArrayList<ExpressionListItem>();
   ExpressionListItem item;
    item = ExpressionListItem();
retval.add(item);
    label_34:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 183:{
        ;
        break;
        }
      default:
        jj_la1[130] = jj_gen;
        break label_34;
      }
      jj_consume_token(183);
      item = ExpressionListItem();
retval.add(item);
    }
return retval;
}

  final public Pivot Pivot() throws ParseException {Pivot retval = new Pivot();
    List<FunctionItem> functionItems;
    List<Column> forColumns;
    List<SelectExpressionItem> singleInItems = null;
    List<ExpressionListItem> multiInItems = null;
    Alias alias = null;
    jj_consume_token(K_PIVOT);
    jj_consume_token(184);
    functionItems = PivotFunctionItems();
    jj_consume_token(K_FOR);
    forColumns = PivotForColumns();
    jj_consume_token(K_IN);
    jj_consume_token(184);
    if (jj_2_31(3)) {
      singleInItems = PivotSingleInItems();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 184:{
        multiInItems = PivotMultiInItems();
        break;
        }
      default:
        jj_la1[131] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(185);
    jj_consume_token(185);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_AS:
    case K_CASCADE:
    case K_CAST:
    case K_COLUMN:
    case K_COMMIT:
    case K_DATETIMELITERAL:
    case K_DO:
    case K_ENABLE:
    case K_END:
    case K_EXTRACT:
    case K_FIRST:
    case K_FOLLOWING:
    case K_INDEX:
    case K_INSERT:
    case K_KEY:
    case K_LAST:
    case K_MATERIALIZED:
    case K_NO:
    case K_NULLS:
    case K_OPEN:
    case K_OVER:
    case K_PARTITION:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SEPARATOR:
    case K_SIBLINGS:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TRUNCATE:
    case K_UNSIGNED:
    case K_VALUE:
    case K_VALUES:
    case K_XML:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
      break;
      }
    default:
      jj_la1[132] = jj_gen;
      ;
    }
retval.setFunctionItems(functionItems);
        retval.setForColumns(forColumns);
        retval.setSingleInItems(singleInItems);
        retval.setMultiInItems(multiInItems);
        retval.setAlias(alias);
        return retval;
}

  final public PivotXml PivotXml() throws ParseException {PivotXml retval = new PivotXml();
    List<FunctionItem> functionItems;
    List<Column> forColumns;
    List<SelectExpressionItem> singleInItems = null;
    List<ExpressionListItem> multiInItems = null;
    SelectBody inSelect = null;
    jj_consume_token(K_PIVOT);
    jj_consume_token(K_XML);
    jj_consume_token(184);
    functionItems = PivotFunctionItems();
    jj_consume_token(K_FOR);
    forColumns = PivotForColumns();
    jj_consume_token(K_IN);
    jj_consume_token(184);
    if (jj_2_32(2)) {
      jj_consume_token(K_ANY);
retval.setInAny(true);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_SELECT:
      case 184:{
        inSelect = SelectBody();
        break;
        }
      default:
        jj_la1[133] = jj_gen;
        if (jj_2_33(2)) {
          singleInItems = PivotSingleInItems();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 184:{
            multiInItems = PivotMultiInItems();
            break;
            }
          default:
            jj_la1[134] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
    jj_consume_token(185);
    jj_consume_token(185);
retval.setFunctionItems(functionItems);
        retval.setForColumns(forColumns);
        retval.setSingleInItems(singleInItems);
        retval.setMultiInItems(multiInItems);
        retval.setInSelect(inSelect);
        return retval;
}

  final public List<Table> IntoClause() throws ParseException {List<Table> tables = new ArrayList<Table>();
    Table table;
    jj_consume_token(K_INTO);
    table = Table();
tables.add(table);
    label_35:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 183:{
        ;
        break;
        }
      default:
        jj_la1[135] = jj_gen;
        break label_35;
      }
      jj_consume_token(183);
      table = Table();
tables.add(table);
    }
return tables;
}

  final public FromItem FromItem() throws ParseException {FromItem fromItem = null;
    Pivot pivot = null;
    Alias alias = null;
    MySQLIndexHint indexHint = null;
    if (jj_2_39(2147483647)) {
      fromItem = ValuesList();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ANY:
      case K_CASCADE:
      case K_CAST:
      case K_COLUMN:
      case K_COMMIT:
      case K_DATETIMELITERAL:
      case K_DO:
      case K_DOUBLE:
      case K_ENABLE:
      case K_END:
      case K_EXTRACT:
      case K_FIRST:
      case K_FOLLOWING:
      case K_IF:
      case K_INDEX:
      case K_INSERT:
      case K_KEY:
      case K_LAST:
      case K_LATERAL:
      case K_LEFT:
      case K_MATERIALIZED:
      case K_NO:
      case K_NULLS:
      case K_OPEN:
      case K_OVER:
      case K_PARTITION:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_RANGE:
      case K_REPLACE:
      case K_RIGHT:
      case K_ROW:
      case K_ROWS:
      case K_SEPARATOR:
      case K_SET:
      case K_SIBLINGS:
      case K_TABLE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TRUNCATE:
      case K_UNSIGNED:
      case K_VALUE:
      case K_VALUES:
      case K_XML:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
      case 184:
      case 221:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 184:{
          jj_consume_token(184);
          if (jj_2_34(2147483647)) {
            fromItem = SubJoin();
          } else if (jj_2_35(3)) {
            fromItem = SubSelect();
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_ACTION:
            case K_ANY:
            case K_CASCADE:
            case K_CAST:
            case K_COLUMN:
            case K_COMMIT:
            case K_DATETIMELITERAL:
            case K_DO:
            case K_DOUBLE:
            case K_ENABLE:
            case K_END:
            case K_EXTRACT:
            case K_FIRST:
            case K_FOLLOWING:
            case K_IF:
            case K_INDEX:
            case K_INSERT:
            case K_KEY:
            case K_LAST:
            case K_LATERAL:
            case K_LEFT:
            case K_MATERIALIZED:
            case K_NO:
            case K_NULLS:
            case K_OPEN:
            case K_OVER:
            case K_PARTITION:
            case K_PERCENT:
            case K_PRECISION:
            case K_PRIMARY:
            case K_PRIOR:
            case K_RANGE:
            case K_REPLACE:
            case K_RIGHT:
            case K_ROW:
            case K_ROWS:
            case K_SEPARATOR:
            case K_SET:
            case K_SIBLINGS:
            case K_TABLE:
            case K_TEMP:
            case K_TEMPORARY:
            case K_TRUNCATE:
            case K_UNSIGNED:
            case K_VALUE:
            case K_VALUES:
            case K_XML:
            case S_IDENTIFIER:
            case S_QUOTED_IDENTIFIER:
            case 184:
            case 221:{
              fromItem = FromItem();
fromItem = new ParenthesisFromItem(fromItem);
              break;
              }
            default:
              jj_la1[136] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          jj_consume_token(185);
          break;
          }
        default:
          jj_la1[137] = jj_gen;
          if (jj_2_36(2147483647)) {
            fromItem = TableFunction();
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_ACTION:
            case K_ANY:
            case K_CASCADE:
            case K_CAST:
            case K_COLUMN:
            case K_COMMIT:
            case K_DATETIMELITERAL:
            case K_DO:
            case K_ENABLE:
            case K_END:
            case K_EXTRACT:
            case K_FIRST:
            case K_FOLLOWING:
            case K_INDEX:
            case K_INSERT:
            case K_KEY:
            case K_LAST:
            case K_MATERIALIZED:
            case K_NO:
            case K_NULLS:
            case K_OPEN:
            case K_OVER:
            case K_PARTITION:
            case K_PERCENT:
            case K_PRECISION:
            case K_PRIMARY:
            case K_PRIOR:
            case K_RANGE:
            case K_REPLACE:
            case K_ROW:
            case K_ROWS:
            case K_SEPARATOR:
            case K_SIBLINGS:
            case K_TABLE:
            case K_TEMP:
            case K_TEMPORARY:
            case K_TRUNCATE:
            case K_UNSIGNED:
            case K_VALUE:
            case K_VALUES:
            case K_XML:
            case S_IDENTIFIER:
            case S_QUOTED_IDENTIFIER:{
              fromItem = Table();
              break;
              }
            case K_LATERAL:{
              fromItem = LateralSubSelect();
              break;
              }
            default:
              jj_la1[138] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ACTION:
        case K_ANY:
        case K_AS:
        case K_CASCADE:
        case K_CAST:
        case K_COLUMN:
        case K_COMMIT:
        case K_DATETIMELITERAL:
        case K_DO:
        case K_ENABLE:
        case K_END:
        case K_EXTRACT:
        case K_FIRST:
        case K_FOLLOWING:
        case K_INDEX:
        case K_INSERT:
        case K_KEY:
        case K_LAST:
        case K_MATERIALIZED:
        case K_NO:
        case K_NULLS:
        case K_OPEN:
        case K_OVER:
        case K_PARTITION:
        case K_PERCENT:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_RANGE:
        case K_REPLACE:
        case K_ROW:
        case K_ROWS:
        case K_SEPARATOR:
        case K_SIBLINGS:
        case K_TABLE:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TRUNCATE:
        case K_UNSIGNED:
        case K_VALUE:
        case K_VALUES:
        case K_XML:
        case S_IDENTIFIER:
        case S_CHAR_LITERAL:
        case S_QUOTED_IDENTIFIER:{
          alias = Alias();
fromItem.setAlias(alias);
          break;
          }
        default:
          jj_la1[139] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_PIVOT:{
          if (jj_2_37(2)) {
            pivot = PivotXml();
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_PIVOT:{
              pivot = Pivot();
              break;
              }
            default:
              jj_la1[140] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
fromItem.setPivot(pivot);
          break;
          }
        default:
          jj_la1[141] = jj_gen;
          ;
        }
        if (jj_2_38(2)) {
          indexHint = MySQLIndexHint();
if (fromItem instanceof Table)
                                                ((Table) fromItem).setHint(indexHint);
        } else {
          ;
        }
        break;
        }
      default:
        jj_la1[142] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return fromItem;
}

  final public FromItem ValuesList() throws ParseException {MultiExpressionList exprList = new MultiExpressionList();
    List<Expression> primaryExpList = new ArrayList<Expression>();
    ValuesList valuesList = new ValuesList();
    Expression exp = null;
    List<String> colNames = null;
    String colName;
    Alias alias;
    jj_consume_token(184);
    jj_consume_token(K_VALUES);
    if (jj_2_40(3)) {
      jj_consume_token(184);
      exp = SimpleExpression();
primaryExpList.add(exp);
      label_36:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 183:{
          ;
          break;
          }
        default:
          jj_la1[143] = jj_gen;
          break label_36;
        }
        jj_consume_token(183);
        exp = SimpleExpression();
primaryExpList.add(exp);
      }
      jj_consume_token(185);
exprList.addExpressionList(primaryExpList);
      label_37:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 183:{
          ;
          break;
          }
        default:
          jj_la1[144] = jj_gen;
          break label_37;
        }
        jj_consume_token(183);
        jj_consume_token(184);
        exp = SimpleExpression();
primaryExpList = new ArrayList<Expression>();
                    primaryExpList.add(exp);
        label_38:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 183:{
            ;
            break;
            }
          default:
            jj_la1[145] = jj_gen;
            break label_38;
          }
          jj_consume_token(183);
          exp = SimpleExpression();
primaryExpList.add(exp);
        }
        jj_consume_token(185);
exprList.addExpressionList(primaryExpList);
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ANY:
      case K_CASCADE:
      case K_CASE:
      case K_CAST:
      case K_COLUMN:
      case K_COMMIT:
      case K_DATETIMELITERAL:
      case K_DO:
      case K_DOUBLE:
      case K_ENABLE:
      case K_END:
      case K_EXTRACT:
      case K_FIRST:
      case K_FOLLOWING:
      case K_GROUP_CONCAT:
      case K_IF:
      case K_INDEX:
      case K_INSERT:
      case K_INTERVAL:
      case K_KEY:
      case K_LAST:
      case K_LEFT:
      case K_MATERIALIZED:
      case K_NO:
      case K_NULL:
      case K_NULLS:
      case K_OPEN:
      case K_OVER:
      case K_PARTITION:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_RANGE:
      case K_REPLACE:
      case K_RIGHT:
      case K_ROW:
      case K_ROWS:
      case K_SEPARATOR:
      case K_SET:
      case K_SIBLINGS:
      case K_TABLE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TRUNCATE:
      case K_UNSIGNED:
      case K_VALUE:
      case K_VALUES:
      case K_XML:
      case S_DOUBLE:
      case S_LONG:
      case S_HEX:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 184:
      case 188:
      case 189:
      case 190:
      case 193:
      case 194:
      case 202:
      case 211:
      case 213:
      case 214:
      case 216:
      case 221:{
        exp = SimpleExpression();
exprList.addExpressionList(exp); valuesList.setNoBrackets(true);
        label_39:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 183:{
            ;
            break;
            }
          default:
            jj_la1[146] = jj_gen;
            break label_39;
          }
          jj_consume_token(183);
          exp = SimpleExpression();
exprList.addExpressionList(exp);
        }
        break;
        }
      default:
        jj_la1[147] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(185);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_AS:
    case K_CASCADE:
    case K_CAST:
    case K_COLUMN:
    case K_COMMIT:
    case K_DATETIMELITERAL:
    case K_DO:
    case K_ENABLE:
    case K_END:
    case K_EXTRACT:
    case K_FIRST:
    case K_FOLLOWING:
    case K_INDEX:
    case K_INSERT:
    case K_KEY:
    case K_LAST:
    case K_MATERIALIZED:
    case K_NO:
    case K_NULLS:
    case K_OPEN:
    case K_OVER:
    case K_PARTITION:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SEPARATOR:
    case K_SIBLINGS:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TRUNCATE:
    case K_UNSIGNED:
    case K_VALUE:
    case K_VALUES:
    case K_XML:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
valuesList.setAlias(alias);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 184:{
        jj_consume_token(184);
        colName = RelObjectName();
colNames = new ArrayList<String>(); colNames.add(colName);
        label_40:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 183:{
            ;
            break;
            }
          default:
            jj_la1[148] = jj_gen;
            break label_40;
          }
          jj_consume_token(183);
          colName = RelObjectName();
colNames.add(colName);
        }
        jj_consume_token(185);
valuesList.setColumnNames(colNames);
        break;
        }
      default:
        jj_la1[149] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[150] = jj_gen;
      ;
    }
valuesList.setMultiExpressionList(exprList);
        return valuesList;
}

  final public LateralSubSelect LateralSubSelect() throws ParseException {LateralSubSelect lateralSubSelect = new LateralSubSelect();
    SubSelect subSelect = null;
    jj_consume_token(K_LATERAL);
    jj_consume_token(184);
    subSelect = SubSelect();
    jj_consume_token(185);
lateralSubSelect.setSubSelect(subSelect);
        return lateralSubSelect;
}

  final public FromItem SubJoin() throws ParseException {FromItem fromItem = null;
    Join join = null;
    List joinList = null;
    SubJoin subJoin = new SubJoin();
    fromItem = FromItem();
subJoin.setLeft(fromItem);
    joinList = SubJoinsList();
subJoin.setJoinList(joinList);
return subJoin;
}

  final public List<Join> JoinsList() throws ParseException {List<Join> joinsList = new ArrayList<Join>();
    Join join = null;
    label_41:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CROSS:
      case K_FULL:
      case K_INNER:
      case K_JOIN:
      case K_LEFT:
      case K_NATURAL:
      case K_RIGHT:
      case 183:{
        ;
        break;
        }
      default:
        jj_la1[151] = jj_gen;
        break label_41;
      }
      join = JoinerExpression();
joinsList.add(join);
    }
return joinsList;
}

  final public List SubJoinsList() throws ParseException {List<Join> joinsList = new ArrayList<Join>();
    Join join = null;
    label_42:
    while (true) {
      join = JoinerExpression();
joinsList.add(join);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CROSS:
      case K_FULL:
      case K_INNER:
      case K_JOIN:
      case K_LEFT:
      case K_NATURAL:
      case K_RIGHT:
      case 183:{
        ;
        break;
        }
      default:
        jj_la1[152] = jj_gen;
        break label_42;
      }
    }
return joinsList;
}

  final public Join JoinerExpression() throws ParseException {/*@bgen(jjtree) JoinerExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTJOINEREXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Join join = new Join();
    FromItem right = null;
    Expression onExpression = null;
    Column tableColumn;
    List<Column> columns = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CROSS:
      case K_FULL:
      case K_INNER:
      case K_LEFT:
      case K_NATURAL:
      case K_RIGHT:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_LEFT:{
          jj_consume_token(K_LEFT);
join.setLeft(true);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_OUTER:
          case K_SEMI:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_SEMI:{
              jj_consume_token(K_SEMI);
join.setSemi(true);
              break;
              }
            case K_OUTER:{
              jj_consume_token(K_OUTER);
join.setOuter(true);
              break;
              }
            default:
              jj_la1[153] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
            }
          default:
            jj_la1[154] = jj_gen;
            ;
          }
          break;
          }
        case K_FULL:
        case K_RIGHT:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_RIGHT:{
            jj_consume_token(K_RIGHT);
join.setRight(true);
            break;
            }
          case K_FULL:{
            jj_consume_token(K_FULL);
join.setFull(true);
            break;
            }
          default:
            jj_la1[155] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_OUTER:{
            jj_consume_token(K_OUTER);
join.setOuter(true);
            break;
            }
          default:
            jj_la1[156] = jj_gen;
            ;
          }
          break;
          }
        case K_INNER:{
          jj_consume_token(K_INNER);
join.setInner(true);
          break;
          }
        case K_NATURAL:{
          jj_consume_token(K_NATURAL);
join.setNatural(true);
          break;
          }
        case K_CROSS:{
          jj_consume_token(K_CROSS);
join.setCross(true);
          break;
          }
        default:
          jj_la1[157] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[158] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_JOIN:{
        jj_consume_token(K_JOIN);
        break;
        }
      case 183:{
        jj_consume_token(183);
join.setSimple(true);
        break;
        }
      default:
        jj_la1[159] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = FromItem();
      if (jj_2_41(2)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ON:{
          jj_consume_token(K_ON);
          onExpression = Expression();
join.setOnExpression(onExpression);
          break;
          }
        case K_USING:{
          jj_consume_token(K_USING);
          jj_consume_token(184);
          tableColumn = Column();
columns = new ArrayList(); columns.add(tableColumn);
          label_43:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case 183:{
              ;
              break;
              }
            default:
              jj_la1[160] = jj_gen;
              break label_43;
            }
            jj_consume_token(183);
            tableColumn = Column();
columns.add(tableColumn);
          }
          jj_consume_token(185);
join.setUsingColumns(columns);
          break;
          }
        default:
          jj_la1[161] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.jjtSetLastToken(getToken(0));
linkAST(join,jjtn000);
      join.setRightItem(right);
    return join;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Expression WhereClause() throws ParseException {Expression retval = null;
    jj_consume_token(K_WHERE);
    retval = Expression();
return retval;
}

  final public OracleHierarchicalExpression OracleHierarchicalQueryClause() throws ParseException {OracleHierarchicalExpression result = new OracleHierarchicalExpression();
    Expression expr;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_START:{
      jj_consume_token(K_START);
      jj_consume_token(K_WITH);
      expr = AndExpression();
result.setStartExpression(expr);
      jj_consume_token(K_CONNECT);
      jj_consume_token(K_BY);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOCYCLE:{
        jj_consume_token(K_NOCYCLE);
result.setNoCycle(true);
        break;
        }
      default:
        jj_la1[162] = jj_gen;
        ;
      }
      expr = AndExpression();
result.setConnectExpression(expr);
      break;
      }
    case K_CONNECT:{
      jj_consume_token(K_CONNECT);
      jj_consume_token(K_BY);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOCYCLE:{
        jj_consume_token(K_NOCYCLE);
result.setNoCycle(true);
        break;
        }
      default:
        jj_la1[163] = jj_gen;
        ;
      }
      expr = AndExpression();
result.setConnectExpression(expr);
                    result.setConnectFirst(true);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_START:{
        jj_consume_token(K_START);
        jj_consume_token(K_WITH);
        expr = AndExpression();
result.setStartExpression(expr);
        break;
        }
      default:
        jj_la1[164] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[165] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return result;
}

  final public List<Expression> GroupByColumnReferences() throws ParseException {Expression columnReference = null;
    List<Expression> columnReferences = new ArrayList<Expression>();
    jj_consume_token(K_GROUP);
    jj_consume_token(K_BY);
    columnReference = SimpleExpression();
columnReferences.add(columnReference);
    label_44:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 183:{
        ;
        break;
        }
      default:
        jj_la1[166] = jj_gen;
        break label_44;
      }
      jj_consume_token(183);
      columnReference = SimpleExpression();
columnReferences.add(columnReference);
    }
return columnReferences;
}

  final public Expression Having() throws ParseException {Expression having = null;
    jj_consume_token(K_HAVING);
    having = Expression();
return having;
}

  final public List<OrderByElement> OrderByElements() throws ParseException {List<OrderByElement> orderByList = new ArrayList<OrderByElement>();
    OrderByElement orderByElement = null;
    jj_consume_token(K_ORDER);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_SIBLINGS:{
      jj_consume_token(K_SIBLINGS);
      break;
      }
    default:
      jj_la1[167] = jj_gen;
      ;
    }
    jj_consume_token(K_BY);
    orderByElement = OrderByElement();
orderByList.add(orderByElement);
    label_45:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 183:{
        ;
        break;
        }
      default:
        jj_la1[168] = jj_gen;
        break label_45;
      }
      jj_consume_token(183);
      orderByElement = OrderByElement();
orderByList.add(orderByElement);
    }
return orderByList;
}

  final public OrderByElement OrderByElement() throws ParseException {OrderByElement orderByElement = new OrderByElement();
    Expression columnReference = null;
    columnReference = SimpleExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ASC:
    case K_DESC:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ASC:{
        jj_consume_token(K_ASC);
        break;
        }
      case K_DESC:{
        jj_consume_token(K_DESC);
orderByElement.setAsc(false);
        break;
        }
      default:
        jj_la1[169] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
orderByElement.setAscDescPresent(true);
      break;
      }
    default:
      jj_la1[170] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NULLS:{
      jj_consume_token(K_NULLS);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FIRST:
      case K_LAST:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_FIRST:{
          jj_consume_token(K_FIRST);
orderByElement.setNullOrdering(OrderByElement.NullOrdering.NULLS_FIRST);
          break;
          }
        case K_LAST:{
          jj_consume_token(K_LAST);
orderByElement.setNullOrdering(OrderByElement.NullOrdering.NULLS_LAST);
          break;
          }
        default:
          jj_la1[171] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[172] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[173] = jj_gen;
      ;
    }
orderByElement.setExpression(columnReference);
        return orderByElement;
}

  final public JdbcParameter SimpleJdbcParameter() throws ParseException {JdbcParameter retval;
    jj_consume_token(188);
retval = new JdbcParameter(++jdbcParameterIndex, false);
    if (jj_2_42(2)) {
      token = jj_consume_token(S_LONG);
retval.setUseFixedIndex(true); retval.setIndex(Integer.valueOf(token.image));
    } else {
      ;
    }
return retval;
}

  final public Limit LimitWithOffset() throws ParseException {/*@bgen(jjtree) LimitWithOffset */
    SimpleNode jjtn000 = new SimpleNode(JJTLIMITWITHOFFSET);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Limit limit = new Limit();
    Token token = null;
    JdbcParameter jdbc = null;
    try {
      if (jj_2_45(5)) {
        jj_consume_token(K_LIMIT);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_LONG:{
          token = jj_consume_token(S_LONG);
limit.setOffset(new LongValue(token.image));
          break;
          }
        case 188:{
          jdbc = SimpleJdbcParameter();
limit.setOffset(jdbc);
          break;
          }
        case 189:{
          jj_consume_token(189);
limit.setOffset(new JdbcNamedParameter());
          if (jj_2_43(2)) {
            token = jj_consume_token(S_IDENTIFIER);
((JdbcNamedParameter)limit.getOffset()).setName(token.image);
          } else {
            ;
          }
          break;
          }
        default:
          jj_la1[174] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(183);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_LONG:{
          token = jj_consume_token(S_LONG);
limit.setRowCount(new LongValue(token.image));
          break;
          }
        case 188:{
          jdbc = SimpleJdbcParameter();
limit.setRowCount(jdbc);
          break;
          }
        case 189:{
          jj_consume_token(189);
limit.setRowCount(new JdbcNamedParameter());
          if (jj_2_44(2)) {
            token = jj_consume_token(S_IDENTIFIER);
((JdbcNamedParameter)limit.getRowCount()).setName(token.image);
          } else {
            ;
          }
          break;
          }
        default:
          jj_la1[175] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_LIMIT:{
          limit = PlainLimit();
          break;
          }
        default:
          jj_la1[176] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(limit,jjtn000);
        return limit;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Limit PlainLimit() throws ParseException {/*@bgen(jjtree) PlainLimit */
    SimpleNode jjtn000 = new SimpleNode(JJTPLAINLIMIT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Limit limit = new Limit();
    Token token = null;
    JdbcParameter jdbc;
    try {
      jj_consume_token(K_LIMIT);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_LONG:{
        token = jj_consume_token(S_LONG);
limit.setRowCount(new LongValue(token.image));
        break;
        }
      case 188:{
        jdbc = SimpleJdbcParameter();
limit.setRowCount(jdbc);
        break;
        }
      case 189:{
        jj_consume_token(189);
limit.setRowCount(new JdbcNamedParameter());
        if (jj_2_46(2)) {
          token = jj_consume_token(S_IDENTIFIER);
((JdbcNamedParameter)limit.getRowCount()).setName(token.image);
        } else {
          ;
        }
        break;
        }
      case K_ALL:{
        jj_consume_token(K_ALL);
limit.setLimitAll(true);
        break;
        }
      case K_NULL:{
        jj_consume_token(K_NULL);
limit.setLimitNull(true);
        break;
        }
      default:
        jj_la1[177] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(limit,jjtn000);
        return limit;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Offset Offset() throws ParseException {Offset offset = new Offset();
    Token token = null;
    JdbcParameter jdbc;
    jj_consume_token(K_OFFSET);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
offset.setOffset(Long.parseLong(token.image));
      break;
      }
    case 188:{
      jdbc = SimpleJdbcParameter();
offset.setOffsetJdbcParameter(jdbc);
      break;
      }
    default:
      jj_la1[178] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ROW:
    case K_ROWS:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ROWS:{
        jj_consume_token(K_ROWS);
offset.setOffsetParam("ROWS");
        break;
        }
      case K_ROW:{
        jj_consume_token(K_ROW);
offset.setOffsetParam("ROW");
        break;
        }
      default:
        jj_la1[179] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[180] = jj_gen;
      ;
    }
return offset;
}

  final public Fetch Fetch() throws ParseException {Fetch fetch = new Fetch();
    Token token = null;
    JdbcParameter jdbc;
    jj_consume_token(K_FETCH);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FIRST:{
      jj_consume_token(K_FIRST);
fetch.setFetchParamFirst(true);
      break;
      }
    case K_NEXT:{
      jj_consume_token(K_NEXT);
      break;
      }
    default:
      jj_la1[181] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
fetch.setRowCount(Long.parseLong(token.image));
      break;
      }
    case 188:{
      jdbc = SimpleJdbcParameter();
fetch.setFetchJdbcParameter(jdbc);
      break;
      }
    default:
      jj_la1[182] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ROWS:{
      jj_consume_token(K_ROWS);
fetch.setFetchParam("ROWS");
      break;
      }
    case K_ROW:{
      jj_consume_token(K_ROW);
      break;
      }
    default:
      jj_la1[183] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(K_ONLY);
return fetch;
}

// according to http://technet.microsoft.com/en-us/library/ms189463.aspx
  final public Top Top() throws ParseException {Top top = new Top();
    Token token = null;
    Expression expr = null;
    JdbcParameter jdbc = null;
    jj_consume_token(K_TOP);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
top.setExpression(new LongValue(token.image));
      break;
      }
    case 188:{
      jdbc = SimpleJdbcParameter();
top.setExpression(jdbc);
      break;
      }
    case 189:{
      jj_consume_token(189);
top.setExpression(new JdbcNamedParameter());
      if (jj_2_47(2)) {
        token = jj_consume_token(S_IDENTIFIER);
((JdbcNamedParameter)top.getExpression()).setName(token.image);
      } else {
        ;
      }
      break;
      }
    case 184:{
      jj_consume_token(184);
      expr = AdditiveExpression();
top.setExpression(expr);
top.setParenthesis(true);
      jj_consume_token(185);
      break;
      }
    default:
      jj_la1[184] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_48(2)) {
      jj_consume_token(K_PERCENT);
top.setPercentage(true);
    } else {
      ;
    }
return top;
}

// according to http://www-01.ibm.com/support/knowledgecenter/SSGU8G_12.1.0/com.ibm.sqls.doc/ids_sqs_0156.htm
  final public Skip Skip() throws ParseException {Skip skip = new Skip();
    Token token = null;
    JdbcParameter jdbc;
    jj_consume_token(K_SKIP);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
skip.setRowCount(Long.parseLong(token.image));
      break;
      }
    case S_IDENTIFIER:{
      token = jj_consume_token(S_IDENTIFIER);
skip.setVariable(token.image);
      break;
      }
    case 188:{
      jdbc = SimpleJdbcParameter();
skip.setJdbcParameter(jdbc);
      break;
      }
    default:
      jj_la1[185] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return skip;
}

  OracleHint getOracleHint() throws ParseException {OracleHint hint = null;
  Token tok = getToken(1);
  // Retrieve first comment (if any) prior next token
  if (tok.specialToken != null) {
    tok = tok.specialToken;
    while (tok.specialToken != null) tok = tok.specialToken;
    // Check if it matches Hint pattern?
    if (OracleHint.isHintMatch(tok.image)) {
      hint = new OracleHint();
      hint.setComment(tok.image);
    }
  }
  return hint;
  }

  final public First First() throws ParseException {First first = new First();
    Token token = null;
    JdbcParameter jdbc;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FIRST:{
      jj_consume_token(K_FIRST);
first.setKeyword(First.Keyword.FIRST);
      break;
      }
    case K_LIMIT:{
      jj_consume_token(K_LIMIT);
first.setKeyword(First.Keyword.LIMIT);
      break;
      }
    default:
      jj_la1[186] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
first.setRowCount(Long.parseLong(token.image));
      break;
      }
    case S_IDENTIFIER:{
      token = jj_consume_token(S_IDENTIFIER);
first.setVariable(token.image);
      break;
      }
    case 188:{
      jdbc = SimpleJdbcParameter();
first.setJdbcParameter(jdbc);
      break;
      }
    default:
      jj_la1[187] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return first;
}

  final public Expression Expression() throws ParseException {/*@bgen(jjtree) Expression */
    SimpleNode jjtn000 = new SimpleNode(JJTEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Expression retval = null;
    try {
      retval = OrExpression();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
return retval;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Expression OrExpression() throws ParseException {Expression left, right, result;
    left = AndExpression();
result = left;
    label_46:
    while (true) {
      if (jj_2_49(2147483647)) {
        ;
      } else {
        break label_46;
      }
      jj_consume_token(K_OR);
      right = AndExpression();
result = new OrExpression(left, right);
                left = result;
    }
return result;
}

  final public Expression AndExpression() throws ParseException {Expression left, right, result;
    boolean not = false;
    if (jj_2_50(2147483647)) {
      left = Condition();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:
      case 184:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOT:{
          jj_consume_token(K_NOT);
not = true;
          break;
          }
        default:
          jj_la1[188] = jj_gen;
          ;
        }
        jj_consume_token(184);
        left = OrExpression();
        jj_consume_token(185);
left = new Parenthesis(left); if (not) { ((Parenthesis)left).setNot(); not = false; }
        break;
        }
      default:
        jj_la1[189] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
result = left;
    label_47:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_AND:{
        ;
        break;
        }
      default:
        jj_la1[190] = jj_gen;
        break label_47;
      }
      jj_consume_token(K_AND);
      if (jj_2_51(2147483647)) {
        right = Condition();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOT:
        case 184:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_NOT:{
            jj_consume_token(K_NOT);
not = true;
            break;
            }
          default:
            jj_la1[191] = jj_gen;
            ;
          }
          jj_consume_token(184);
          right = OrExpression();
          jj_consume_token(185);
right = new Parenthesis(right); if (not) { ((Parenthesis)right).setNot(); not = false; }
          break;
          }
        default:
          jj_la1[192] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
result = new AndExpression(left, right);
            left = result;
    }
return result;
}

  final public Expression Condition() throws ParseException {Expression result;
    Token token;
    if (jj_2_52(2147483647)) {
      result = SQLCondition();
    } else if (jj_2_53(2147483647)) {
      result = RegularCondition();
    } else if (jj_2_54(2147483647)) {
      result = Function();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
        result = Column();
result = new NotExpression(result);
        break;
        }
      case K_ACTION:
      case K_ANY:
      case K_CASCADE:
      case K_CAST:
      case K_COLUMN:
      case K_COMMIT:
      case K_DATETIMELITERAL:
      case K_DO:
      case K_ENABLE:
      case K_END:
      case K_EXTRACT:
      case K_FIRST:
      case K_FOLLOWING:
      case K_INDEX:
      case K_INSERT:
      case K_KEY:
      case K_LAST:
      case K_MATERIALIZED:
      case K_NO:
      case K_NULLS:
      case K_OPEN:
      case K_OVER:
      case K_PARTITION:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_RANGE:
      case K_REPLACE:
      case K_ROW:
      case K_ROWS:
      case K_SEPARATOR:
      case K_SIBLINGS:
      case K_TABLE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TRUNCATE:
      case K_UNSIGNED:
      case K_VALUE:
      case K_VALUES:
      case K_XML:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:{
        result = Column();
        break;
        }
      default:
        jj_la1[193] = jj_gen;
        if ("0".equals(getToken(1).image) || "1".equals(getToken(1).image)) {
          token = jj_consume_token(S_LONG);
result = new LongValue(token.image);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
return result;
}

  final public Expression RegularCondition() throws ParseException {/*@bgen(jjtree) RegularCondition */
    SimpleNode jjtn000 = new SimpleNode(JJTREGULARCONDITION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Expression result = null;
    Expression leftExpression;
    Expression rightExpression;
    boolean not = false;
    int oracleJoin=EqualsTo.NO_ORACLE_JOIN;
    int oraclePrior=EqualsTo.NO_ORACLE_PRIOR;
    boolean binary = false;
    try {
      if (jj_2_55(2)) {
        jj_consume_token(K_PRIOR);
oraclePrior = EqualsTo.ORACLE_PRIOR_START;
      } else {
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
not = true;
        break;
        }
      default:
        jj_la1[194] = jj_gen;
        ;
      }
      leftExpression = ComparisonItem();
result = leftExpression;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 184:{
        jj_consume_token(184);
        jj_consume_token(190);
        jj_consume_token(185);
oracleJoin=EqualsTo.ORACLE_JOIN_RIGHT;
        break;
        }
      default:
        jj_la1[195] = jj_gen;
        ;
      }
      if (jj_2_56(2)) {
        jj_consume_token(191);
result = new GreaterThan();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 192:{
          jj_consume_token(192);
result = new MinorThan();
          break;
          }
        case 182:{
          jj_consume_token(182);
result = new EqualsTo();
          break;
          }
        case OP_GREATERTHANEQUALS:{
          token = jj_consume_token(OP_GREATERTHANEQUALS);
result = new GreaterThanEquals(token.image);
          break;
          }
        case OP_MINORTHANEQUALS:{
          token = jj_consume_token(OP_MINORTHANEQUALS);
result = new MinorThanEquals(token.image);
          break;
          }
        case OP_NOTEQUALSSTANDARD:{
          token = jj_consume_token(OP_NOTEQUALSSTANDARD);
result = new NotEqualsTo(token.image);
          break;
          }
        case OP_NOTEQUALSBANG:{
          token = jj_consume_token(OP_NOTEQUALSBANG);
result = new NotEqualsTo(token.image);
          break;
          }
        case 193:{
          jj_consume_token(193);
result = new Matches();
          break;
          }
        case 194:{
          jj_consume_token(194);
result = new RegExpMatchOperator(RegExpMatchOperatorType.MATCH_CASESENSITIVE);
          break;
          }
        case K_REGEXP:{
          jj_consume_token(K_REGEXP);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_BINARY:{
            jj_consume_token(K_BINARY);
binary=true;
            break;
            }
          default:
            jj_la1[196] = jj_gen;
            ;
          }
result = new RegExpMySQLOperator(binary?RegExpMatchOperatorType.MATCH_CASESENSITIVE:RegExpMatchOperatorType.MATCH_CASEINSENSITIVE);
          break;
          }
        case K_RLIKE:{
          jj_consume_token(K_RLIKE);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_BINARY:{
            jj_consume_token(K_BINARY);
binary=true;
            break;
            }
          default:
            jj_la1[197] = jj_gen;
            ;
          }
result = new RegExpMySQLOperator(binary?RegExpMatchOperatorType.MATCH_CASESENSITIVE:RegExpMatchOperatorType.MATCH_CASEINSENSITIVE).useRLike();
          break;
          }
        case 195:{
          jj_consume_token(195);
result = new RegExpMatchOperator(RegExpMatchOperatorType.MATCH_CASEINSENSITIVE);
          break;
          }
        case 196:{
          jj_consume_token(196);
result = new RegExpMatchOperator(RegExpMatchOperatorType.NOT_MATCH_CASESENSITIVE);
          break;
          }
        case 197:{
          jj_consume_token(197);
result = new RegExpMatchOperator(RegExpMatchOperatorType.NOT_MATCH_CASEINSENSITIVE);
          break;
          }
        case 198:{
          jj_consume_token(198);
result = new JsonOperator("@>");
          break;
          }
        case 199:{
          jj_consume_token(199);
result = new JsonOperator("<@");
          break;
          }
        case 188:{
          jj_consume_token(188);
result = new JsonOperator("?");
          break;
          }
        case 200:{
          jj_consume_token(200);
result = new JsonOperator("?|");
          break;
          }
        case 201:{
          jj_consume_token(201);
result = new JsonOperator("?&");
          break;
          }
        case OP_CONCAT:{
          jj_consume_token(OP_CONCAT);
result = new JsonOperator("||");
          break;
          }
        case 202:{
          jj_consume_token(202);
result = new JsonOperator("-");
          break;
          }
        case 203:{
          jj_consume_token(203);
result = new JsonOperator("-#");
          break;
          }
        default:
          jj_la1[198] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      if (jj_2_57(2)) {
        jj_consume_token(K_PRIOR);
        rightExpression = ComparisonItem();
oraclePrior = EqualsTo.ORACLE_PRIOR_END;
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ACTION:
        case K_ALL:
        case K_ANY:
        case K_CASCADE:
        case K_CASE:
        case K_CAST:
        case K_COLUMN:
        case K_COMMIT:
        case K_DATETIMELITERAL:
        case K_DO:
        case K_DOUBLE:
        case K_ENABLE:
        case K_END:
        case K_EXTRACT:
        case K_FIRST:
        case K_FOLLOWING:
        case K_GROUP_CONCAT:
        case K_IF:
        case K_INDEX:
        case K_INSERT:
        case K_INTERVAL:
        case K_KEY:
        case K_LAST:
        case K_LEFT:
        case K_MATERIALIZED:
        case K_NO:
        case K_NULL:
        case K_NULLS:
        case K_OPEN:
        case K_OVER:
        case K_PARTITION:
        case K_PERCENT:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_RANGE:
        case K_REPLACE:
        case K_RIGHT:
        case K_ROW:
        case K_ROWS:
        case K_SEPARATOR:
        case K_SET:
        case K_SIBLINGS:
        case K_SOME:
        case K_TABLE:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIME_KEY_EXPR:
        case K_TRUNCATE:
        case K_UNSIGNED:
        case K_VALUE:
        case K_VALUES:
        case K_XML:
        case S_DOUBLE:
        case S_LONG:
        case S_HEX:
        case S_IDENTIFIER:
        case S_CHAR_LITERAL:
        case S_QUOTED_IDENTIFIER:
        case 184:
        case 188:
        case 189:
        case 190:
        case 193:
        case 194:
        case 202:
        case 211:
        case 213:
        case 214:
        case 216:
        case 221:{
          rightExpression = ComparisonItem();
          break;
          }
        default:
          jj_la1[199] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 184:{
        jj_consume_token(184);
        jj_consume_token(190);
        jj_consume_token(185);
oracleJoin=EqualsTo.ORACLE_JOIN_LEFT;
        break;
        }
      default:
        jj_la1[200] = jj_gen;
        ;
      }
BinaryExpression regCond = (BinaryExpression) result;
        regCond.setLeftExpression(leftExpression);
        regCond.setRightExpression(rightExpression);
        if (not)
            regCond.setNot();

        if (oracleJoin>0)
            ((SupportsOldOracleJoinSyntax)result).setOldOracleJoinSyntax(oracleJoin);

        if (oraclePrior!=EqualsTo.NO_ORACLE_PRIOR)
            ((SupportsOldOracleJoinSyntax)result).setOraclePriorPosition(oraclePrior);
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(result,jjtn000);
        return result;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Expression SQLCondition() throws ParseException {Expression result;
    if (jj_2_58(2147483647)) {
      result = InExpression();
    } else if (jj_2_59(2147483647)) {
      result = Between();
    } else if (jj_2_60(2147483647)) {
      result = IsNullExpression();
    } else if (jj_2_61(2147483647)) {
      result = ExistsExpression();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ANY:
      case K_CASCADE:
      case K_CASE:
      case K_CAST:
      case K_COLUMN:
      case K_COMMIT:
      case K_DATETIMELITERAL:
      case K_DO:
      case K_DOUBLE:
      case K_ENABLE:
      case K_END:
      case K_EXTRACT:
      case K_FIRST:
      case K_FOLLOWING:
      case K_GROUP_CONCAT:
      case K_IF:
      case K_INDEX:
      case K_INSERT:
      case K_INTERVAL:
      case K_KEY:
      case K_LAST:
      case K_LEFT:
      case K_MATERIALIZED:
      case K_NO:
      case K_NOT:
      case K_NULL:
      case K_NULLS:
      case K_OPEN:
      case K_OVER:
      case K_PARTITION:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_RANGE:
      case K_REPLACE:
      case K_RIGHT:
      case K_ROW:
      case K_ROWS:
      case K_SEPARATOR:
      case K_SET:
      case K_SIBLINGS:
      case K_TABLE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TRUNCATE:
      case K_UNSIGNED:
      case K_VALUE:
      case K_VALUES:
      case K_XML:
      case S_DOUBLE:
      case S_LONG:
      case S_HEX:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 184:
      case 188:
      case 189:
      case 190:
      case 193:
      case 194:
      case 202:
      case 211:
      case 213:
      case 214:
      case 216:
      case 221:{
        result = LikeExpression();
        break;
        }
      default:
        jj_la1[201] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return result;
}

  final public Expression InExpression() throws ParseException {InExpression result = new InExpression();
    ItemsList leftItemsList = null;
    ItemsList rightItemsList = null;
    Expression leftExpression = null;
    if (jj_2_63(3)) {
      jj_consume_token(184);
      if (jj_2_62(2147483647)) {
        leftItemsList = SimpleExpressionList();
result.setLeftItemsList(leftItemsList);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ACTION:
        case K_ANY:
        case K_CASCADE:
        case K_CASE:
        case K_CAST:
        case K_COLUMN:
        case K_COMMIT:
        case K_DATETIMELITERAL:
        case K_DO:
        case K_DOUBLE:
        case K_ENABLE:
        case K_END:
        case K_EXTRACT:
        case K_FIRST:
        case K_FOLLOWING:
        case K_GROUP_CONCAT:
        case K_IF:
        case K_INDEX:
        case K_INSERT:
        case K_INTERVAL:
        case K_KEY:
        case K_LAST:
        case K_LEFT:
        case K_MATERIALIZED:
        case K_NO:
        case K_NULL:
        case K_NULLS:
        case K_OPEN:
        case K_OVER:
        case K_PARTITION:
        case K_PERCENT:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_RANGE:
        case K_REPLACE:
        case K_RIGHT:
        case K_ROW:
        case K_ROWS:
        case K_SEPARATOR:
        case K_SET:
        case K_SIBLINGS:
        case K_TABLE:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIME_KEY_EXPR:
        case K_TRUNCATE:
        case K_UNSIGNED:
        case K_VALUE:
        case K_VALUES:
        case K_XML:
        case S_DOUBLE:
        case S_LONG:
        case S_HEX:
        case S_IDENTIFIER:
        case S_CHAR_LITERAL:
        case S_QUOTED_IDENTIFIER:
        case 184:
        case 188:
        case 189:
        case 190:
        case 193:
        case 194:
        case 202:
        case 211:
        case 213:
        case 214:
        case 216:
        case 221:{
          leftExpression = SimpleExpression();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 184:{
            jj_consume_token(184);
            jj_consume_token(190);
            jj_consume_token(185);
result.setOldOracleJoinSyntax(EqualsTo.ORACLE_JOIN_RIGHT);
            break;
            }
          default:
            jj_la1[202] = jj_gen;
            ;
          }
          break;
          }
        default:
          jj_la1[203] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(185);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ANY:
      case K_CASCADE:
      case K_CASE:
      case K_CAST:
      case K_COLUMN:
      case K_COMMIT:
      case K_DATETIMELITERAL:
      case K_DO:
      case K_DOUBLE:
      case K_ENABLE:
      case K_END:
      case K_EXTRACT:
      case K_FIRST:
      case K_FOLLOWING:
      case K_GROUP_CONCAT:
      case K_IF:
      case K_INDEX:
      case K_INSERT:
      case K_INTERVAL:
      case K_KEY:
      case K_LAST:
      case K_LEFT:
      case K_MATERIALIZED:
      case K_NO:
      case K_NULL:
      case K_NULLS:
      case K_OPEN:
      case K_OVER:
      case K_PARTITION:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_RANGE:
      case K_REPLACE:
      case K_RIGHT:
      case K_ROW:
      case K_ROWS:
      case K_SEPARATOR:
      case K_SET:
      case K_SIBLINGS:
      case K_TABLE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TRUNCATE:
      case K_UNSIGNED:
      case K_VALUE:
      case K_VALUES:
      case K_XML:
      case S_DOUBLE:
      case S_LONG:
      case S_HEX:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 184:
      case 188:
      case 189:
      case 190:
      case 193:
      case 194:
      case 202:
      case 211:
      case 213:
      case 214:
      case 216:
      case 221:{
        leftExpression = SimpleExpression();
result.setLeftExpression(leftExpression);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 184:{
          jj_consume_token(184);
          jj_consume_token(190);
          jj_consume_token(185);
result.setOldOracleJoinSyntax(EqualsTo.ORACLE_JOIN_RIGHT);
          break;
          }
        default:
          jj_la1[204] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[205] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NOT:{
      jj_consume_token(K_NOT);
result.setNot(true);
      break;
      }
    default:
      jj_la1[206] = jj_gen;
      ;
    }
    jj_consume_token(K_IN);
    jj_consume_token(184);
    if (jj_2_64(3)) {
      rightItemsList = SubSelect();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ANY:
      case K_CASCADE:
      case K_CASE:
      case K_CAST:
      case K_COLUMN:
      case K_COMMIT:
      case K_DATETIMELITERAL:
      case K_DO:
      case K_DOUBLE:
      case K_ENABLE:
      case K_END:
      case K_EXTRACT:
      case K_FIRST:
      case K_FOLLOWING:
      case K_GROUP_CONCAT:
      case K_IF:
      case K_INDEX:
      case K_INSERT:
      case K_INTERVAL:
      case K_KEY:
      case K_LAST:
      case K_LEFT:
      case K_MATERIALIZED:
      case K_NO:
      case K_NULL:
      case K_NULLS:
      case K_OPEN:
      case K_OVER:
      case K_PARTITION:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_RANGE:
      case K_REPLACE:
      case K_RIGHT:
      case K_ROW:
      case K_ROWS:
      case K_SEPARATOR:
      case K_SET:
      case K_SIBLINGS:
      case K_TABLE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TRUNCATE:
      case K_UNSIGNED:
      case K_VALUE:
      case K_VALUES:
      case K_XML:
      case S_DOUBLE:
      case S_LONG:
      case S_HEX:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 184:
      case 188:
      case 189:
      case 190:
      case 193:
      case 194:
      case 202:
      case 211:
      case 213:
      case 214:
      case 216:
      case 221:{
        rightItemsList = SimpleExpressionList();
        break;
        }
      default:
        jj_la1[207] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(185);
result.setRightItemsList(rightItemsList);
        return result;
}

  final public Expression Between() throws ParseException {Between result = new Between();
    Expression leftExpression = null;
    Expression betweenExpressionStart = null;
    Expression betweenExpressionEnd = null;
    leftExpression = SimpleExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NOT:{
      jj_consume_token(K_NOT);
result.setNot(true);
      break;
      }
    default:
      jj_la1[208] = jj_gen;
      ;
    }
    jj_consume_token(K_BETWEEN);
    betweenExpressionStart = SimpleExpression();
    jj_consume_token(K_AND);
    betweenExpressionEnd = SimpleExpression();
result.setLeftExpression(leftExpression);
        result.setBetweenExpressionStart(betweenExpressionStart);
        result.setBetweenExpressionEnd(betweenExpressionEnd);
        return result;
}

  final public Expression LikeExpression() throws ParseException {/*@bgen(jjtree) LikeExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTLIKEEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));LikeExpression result = new LikeExpression();
    Expression leftExpression = null;
    Expression rightExpression = null;
    try {
      if (jj_2_65(3)) {
        leftExpression = SimpleExpression();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOT:{
          jj_consume_token(K_NOT);
result.setNot(true);
          break;
          }
        default:
          jj_la1[209] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_LIKE:{
          jj_consume_token(K_LIKE);
          break;
          }
        case K_ILIKE:{
          jj_consume_token(K_ILIKE);
result.setCaseInsensitive(true);
          break;
          }
        default:
          jj_la1[210] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        rightExpression = SimpleExpression();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ESCAPE:{
          jj_consume_token(K_ESCAPE);
          token = jj_consume_token(S_CHAR_LITERAL);
result.setEscape((new StringValue(token.image)).getValue());
          break;
          }
        default:
          jj_la1[211] = jj_gen;
          ;
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ACTION:
        case K_ANY:
        case K_CASCADE:
        case K_CASE:
        case K_CAST:
        case K_COLUMN:
        case K_COMMIT:
        case K_DATETIMELITERAL:
        case K_DO:
        case K_DOUBLE:
        case K_ENABLE:
        case K_END:
        case K_EXTRACT:
        case K_FIRST:
        case K_FOLLOWING:
        case K_GROUP_CONCAT:
        case K_IF:
        case K_INDEX:
        case K_INSERT:
        case K_INTERVAL:
        case K_KEY:
        case K_LAST:
        case K_LEFT:
        case K_MATERIALIZED:
        case K_NO:
        case K_NOT:
        case K_NULL:
        case K_NULLS:
        case K_OPEN:
        case K_OVER:
        case K_PARTITION:
        case K_PERCENT:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_RANGE:
        case K_REPLACE:
        case K_RIGHT:
        case K_ROW:
        case K_ROWS:
        case K_SEPARATOR:
        case K_SET:
        case K_SIBLINGS:
        case K_TABLE:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIME_KEY_EXPR:
        case K_TRUNCATE:
        case K_UNSIGNED:
        case K_VALUE:
        case K_VALUES:
        case K_XML:
        case S_DOUBLE:
        case S_LONG:
        case S_HEX:
        case S_IDENTIFIER:
        case S_CHAR_LITERAL:
        case S_QUOTED_IDENTIFIER:
        case 184:
        case 188:
        case 189:
        case 190:
        case 193:
        case 194:
        case 202:
        case 211:
        case 213:
        case 214:
        case 216:
        case 221:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_NOT:{
            jj_consume_token(K_NOT);
result.setNot(true);
            break;
            }
          default:
            jj_la1[212] = jj_gen;
            ;
          }
          leftExpression = SimpleExpression();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_LIKE:{
            jj_consume_token(K_LIKE);
            break;
            }
          case K_ILIKE:{
            jj_consume_token(K_ILIKE);
result.setCaseInsensitive(true);
            break;
            }
          default:
            jj_la1[213] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          rightExpression = SimpleExpression();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ESCAPE:{
            jj_consume_token(K_ESCAPE);
            token = jj_consume_token(S_CHAR_LITERAL);
result.setEscape((new StringValue(token.image)).getValue());
            break;
            }
          default:
            jj_la1[214] = jj_gen;
            ;
          }
          break;
          }
        default:
          jj_la1[215] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
result.setLeftExpression(leftExpression);
        result.setRightExpression(rightExpression);
        linkAST(result,jjtn000);
        return result;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Expression IsNullExpression() throws ParseException {IsNullExpression result = new IsNullExpression();
    Expression leftExpression = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NOT:{
      jj_consume_token(K_NOT);
result.setNot(true);
      leftExpression = SimpleExpression();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ISNULL:{
        jj_consume_token(K_ISNULL);
result.setUseIsNull(true);
        break;
        }
      case K_IS:{
        jj_consume_token(K_IS);
        jj_consume_token(K_NULL);
        break;
        }
      default:
        jj_la1[216] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case K_ACTION:
    case K_ANY:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_COLUMN:
    case K_COMMIT:
    case K_DATETIMELITERAL:
    case K_DO:
    case K_DOUBLE:
    case K_ENABLE:
    case K_END:
    case K_EXTRACT:
    case K_FIRST:
    case K_FOLLOWING:
    case K_GROUP_CONCAT:
    case K_IF:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_KEY:
    case K_LAST:
    case K_LEFT:
    case K_MATERIALIZED:
    case K_NO:
    case K_NULL:
    case K_NULLS:
    case K_OPEN:
    case K_OVER:
    case K_PARTITION:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_REPLACE:
    case K_RIGHT:
    case K_ROW:
    case K_ROWS:
    case K_SEPARATOR:
    case K_SET:
    case K_SIBLINGS:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TRUNCATE:
    case K_UNSIGNED:
    case K_VALUE:
    case K_VALUES:
    case K_XML:
    case S_DOUBLE:
    case S_LONG:
    case S_HEX:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:
    case 184:
    case 188:
    case 189:
    case 190:
    case 193:
    case 194:
    case 202:
    case 211:
    case 213:
    case 214:
    case 216:
    case 221:{
      leftExpression = SimpleExpression();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ISNULL:{
        jj_consume_token(K_ISNULL);
result.setUseIsNull(true);
        break;
        }
      case K_IS:{
        jj_consume_token(K_IS);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOT:{
          jj_consume_token(K_NOT);
result.setNot(true);
          break;
          }
        default:
          jj_la1[217] = jj_gen;
          ;
        }
        jj_consume_token(K_NULL);
        break;
        }
      default:
        jj_la1[218] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[219] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
result.setLeftExpression(leftExpression);
        return result;
}

  final public Expression ExistsExpression() throws ParseException {ExistsExpression result = new ExistsExpression();
    Expression rightExpression = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NOT:{
      jj_consume_token(K_NOT);
result.setNot(true);
      break;
      }
    default:
      jj_la1[220] = jj_gen;
      ;
    }
    jj_consume_token(K_EXISTS);
    rightExpression = SimpleExpression();
result.setRightExpression(rightExpression);
        return result;
}

  final public ExpressionList SQLExpressionList() throws ParseException {ExpressionList retval = new ExpressionList();
    List<Expression> expressions = new ArrayList<Expression>();
    Expression expr = null;
    expr = Expression();
expressions.add(expr);
    label_48:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 183:{
        ;
        break;
        }
      default:
        jj_la1[221] = jj_gen;
        break label_48;
      }
      jj_consume_token(183);
      expr = Expression();
expressions.add(expr);
    }
retval.setExpressions(expressions);
        return retval;
}

  final public ExpressionList SimpleExpressionList() throws ParseException {ExpressionList retval = new ExpressionList();
    List<Expression> expressions = new ArrayList<Expression>();
    Expression expr = null;
    expr = SimpleExpression();
expressions.add(expr);
    label_49:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 183:{
        ;
        break;
        }
      default:
        jj_la1[222] = jj_gen;
        break label_49;
      }
      jj_consume_token(183);
      expr = SimpleExpression();
expressions.add(expr);
    }
retval.setExpressions(expressions);
        return retval;
}

  final public ExpressionList SimpleExpressionListAtLeastTwoItems() throws ParseException {ExpressionList retval = new ExpressionList();
    List<Expression> expressions = new ArrayList<Expression>();
    Expression expr = null;
    expr = SimpleExpression();
expressions.add(expr);
    label_50:
    while (true) {
      jj_consume_token(183);
      expr = SimpleExpression();
expressions.add(expr);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 183:{
        ;
        break;
        }
      default:
        jj_la1[223] = jj_gen;
        break label_50;
      }
    }
retval.setExpressions(expressions);
        return retval;
}

  final public Expression ComparisonItem() throws ParseException {Expression retval = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ALL:{
      retval = AllComparisonExpression();
      break;
      }
    default:
      jj_la1[224] = jj_gen;
      if (jj_2_66(3)) {
        retval = AnyComparisonExpression();
      } else if (jj_2_67(2147483647)) {
        retval = ValueListExpression();
      } else if (jj_2_68(3)) {
        retval = SimpleExpression();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ROW:
        case 184:{
          retval = RowConstructor();
          break;
          }
        default:
          jj_la1[225] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
return retval;
}

  final public Expression AllComparisonExpression() throws ParseException {AllComparisonExpression retval = null;
    SubSelect subselect = null;
    jj_consume_token(K_ALL);
    jj_consume_token(184);
    subselect = SubSelect();
    jj_consume_token(185);
retval = new AllComparisonExpression(subselect);
return retval;
}

  final public Expression AnyComparisonExpression() throws ParseException {AnyComparisonExpression retval = null;
    AnyType anyType;
    SubSelect subselect = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ANY:{
      jj_consume_token(K_ANY);
anyType = AnyType.ANY;
      break;
      }
    case K_SOME:{
      jj_consume_token(K_SOME);
anyType = AnyType.SOME;
      break;
      }
    default:
      jj_la1[226] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(184);
    subselect = SubSelect();
    jj_consume_token(185);
retval = new AnyComparisonExpression(anyType, subselect);
return retval;
}

  final public Expression SimpleExpression() throws ParseException {Expression retval = null;
    retval = ConcatExpression();
return retval;
}

  final public Expression ConcatExpression() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = BitwiseAndOr();
result = leftExpression;
    label_51:
    while (true) {
      if (jj_2_69(3)) {
        ;
      } else {
        break label_51;
      }
      jj_consume_token(OP_CONCAT);
      /* Oracle allows space between the bars. */
              rightExpression = BitwiseAndOr();
Concat binExp = new Concat();
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            result = binExp;
            leftExpression = result;
    }
return result;
}

  final public Expression BitwiseAndOr() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = AdditiveExpression();
result = leftExpression;
    label_52:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 204:
      case 205:
      case 206:
      case 207:{
        ;
        break;
        }
      default:
        jj_la1[227] = jj_gen;
        break label_52;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 204:{
        jj_consume_token(204);
result = new BitwiseOr();
        break;
        }
      case 205:{
        jj_consume_token(205);
result = new BitwiseAnd();
        break;
        }
      case 206:{
        jj_consume_token(206);
result = new BitwiseLeftShift();
        break;
        }
      case 207:{
        jj_consume_token(207);
result = new BitwiseRightShift();
        break;
        }
      default:
        jj_la1[228] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightExpression = AdditiveExpression();
BinaryExpression binExp = (BinaryExpression) result;
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            leftExpression = result;
    }
return result;
}

  final public Expression AdditiveExpression() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = MultiplicativeExpression();
result = leftExpression;
    label_53:
    while (true) {
      if (jj_2_70(2)) {
        ;
      } else {
        break label_53;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 190:{
        jj_consume_token(190);
result = new Addition();
        break;
        }
      case 202:{
        jj_consume_token(202);
result = new Subtraction();
        break;
        }
      default:
        jj_la1[229] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightExpression = MultiplicativeExpression();
BinaryExpression binExp = (BinaryExpression) result;
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            leftExpression = result;
    }
return result;
}

  final public Expression MultiplicativeExpression() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = BitwiseXor();
result = leftExpression;
    label_54:
    while (true) {
      if (jj_2_71(2)) {
        ;
      } else {
        break label_54;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 186:{
        jj_consume_token(186);
result = new Multiplication();
        break;
        }
      case 208:{
        jj_consume_token(208);
result = new Division();
        break;
        }
      case 209:{
        jj_consume_token(209);
result = new Modulo();
        break;
        }
      default:
        jj_la1[230] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightExpression = BitwiseXor();
BinaryExpression binExp = (BinaryExpression) result;
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            leftExpression = result;
    }
return result;
}

  final public Expression BitwiseXor() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = PrimaryExpression();
result = leftExpression;
    label_55:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 210:{
        ;
        break;
        }
      default:
        jj_la1[231] = jj_gen;
        break label_55;
      }
      jj_consume_token(210);
      rightExpression = PrimaryExpression();
BitwiseXor binExp = new BitwiseXor();
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            result = binExp;
            leftExpression = result;
    }
return result;
}

  final public Expression PrimaryExpression() throws ParseException {/*@bgen(jjtree) PrimaryExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTPRIMARYEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Expression retval = null;
    CastExpression castExpr = null;
    Token token = null;
    Token sign = null;
    String tmp = "";
    ColDataType type = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 190:
      case 194:
      case 202:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 190:{
          sign = jj_consume_token(190);
          break;
          }
        case 202:{
          sign = jj_consume_token(202);
          break;
          }
        case 194:{
          sign = jj_consume_token(194);
          break;
          }
        default:
          jj_la1[232] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[233] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NULL:{
        jj_consume_token(K_NULL);
retval = new NullValue();
        break;
        }
      case K_CASE:{
        retval = CaseWhenExpression();
        break;
        }
      case 188:{
        retval = SimpleJdbcParameter();
        break;
        }
      default:
        jj_la1[234] = jj_gen;
        if (jj_2_72(2)) {
          retval = JdbcNamedParameter();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 193:
          case 216:{
            retval = UserVariable();
            break;
            }
          default:
            jj_la1[235] = jj_gen;
            if (jj_2_73(2)) {
              retval = NumericBind();
            } else if (jj_2_74(2147483647)) {
              retval = AnalyticExpression();
            } else if (jj_2_75(3)) {
              retval = ExtractExpression();
            } else {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_GROUP_CONCAT:{
                retval = MySQLGroupConcat();
                break;
                }
              default:
                jj_la1[236] = jj_gen;
                if (jj_2_76(2147483647)) {
                  retval = JsonExpression();
                } else if (jj_2_77(2147483647)) {
                  retval = Function();
                } else {
                  switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                  case S_DOUBLE:{
                    token = jj_consume_token(S_DOUBLE);
retval = new DoubleValue(token.image);
                    break;
                    }
                  case S_LONG:{
                    token = jj_consume_token(S_LONG);
retval = new LongValue(token.image);
                    break;
                    }
                  case S_HEX:{
                    token = jj_consume_token(S_HEX);
retval = new HexValue(token.image);
                    break;
                    }
                  default:
                    jj_la1[237] = jj_gen;
                    if (jj_2_78(2)) {
                      retval = CastExpression();
                    } else {
                      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                      case K_TIME_KEY_EXPR:{
                        token = jj_consume_token(K_TIME_KEY_EXPR);
retval = new TimeKeyExpression(token.image);
                        break;
                        }
                      default:
                        jj_la1[238] = jj_gen;
                        if (jj_2_79(2)) {
                          retval = DateTimeLiteralExpression();
                        } else {
                          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                          case K_ACTION:
                          case K_ANY:
                          case K_CASCADE:
                          case K_CAST:
                          case K_COLUMN:
                          case K_COMMIT:
                          case K_DATETIMELITERAL:
                          case K_DO:
                          case K_ENABLE:
                          case K_END:
                          case K_EXTRACT:
                          case K_FIRST:
                          case K_FOLLOWING:
                          case K_INDEX:
                          case K_INSERT:
                          case K_KEY:
                          case K_LAST:
                          case K_MATERIALIZED:
                          case K_NO:
                          case K_NULLS:
                          case K_OPEN:
                          case K_OVER:
                          case K_PARTITION:
                          case K_PERCENT:
                          case K_PRECISION:
                          case K_PRIMARY:
                          case K_PRIOR:
                          case K_RANGE:
                          case K_REPLACE:
                          case K_ROW:
                          case K_ROWS:
                          case K_SEPARATOR:
                          case K_SIBLINGS:
                          case K_TABLE:
                          case K_TEMP:
                          case K_TEMPORARY:
                          case K_TRUNCATE:
                          case K_UNSIGNED:
                          case K_VALUE:
                          case K_VALUES:
                          case K_XML:
                          case S_IDENTIFIER:
                          case S_QUOTED_IDENTIFIER:{
                            retval = Column();
                            break;
                            }
                          default:
                            jj_la1[239] = jj_gen;
                            if (jj_2_80(2147483647)) {
                              jj_consume_token(184);
                              retval = SimpleExpression();
                              jj_consume_token(185);
retval = new Parenthesis(retval);
                            } else if (jj_2_81(3)) {
                              jj_consume_token(184);
                              retval = SubSelect();
                              jj_consume_token(185);
                            } else {
                              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                              case S_CHAR_LITERAL:{
                                token = jj_consume_token(S_CHAR_LITERAL);
retval = new StringValue(token.image); linkAST(retval,jjtn000);
                                break;
                                }
                              case 211:{
                                jj_consume_token(211);
                                token = jj_consume_token(S_CHAR_LITERAL);
                                jj_consume_token(212);
retval = new DateValue(token.image);
                                break;
                                }
                              case 213:{
                                jj_consume_token(213);
                                token = jj_consume_token(S_CHAR_LITERAL);
                                jj_consume_token(212);
retval = new TimeValue(token.image);
                                break;
                                }
                              case 214:{
                                jj_consume_token(214);
                                token = jj_consume_token(S_CHAR_LITERAL);
                                jj_consume_token(212);
retval = new TimestampValue(token.image);
                                break;
                                }
                              case K_INTERVAL:{
                                retval = IntervalExpression();
                                break;
                                }
                              default:
                                jj_la1[240] = jj_gen;
                                jj_consume_token(-1);
                                throw new ParseException();
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 215:{
        jj_consume_token(215);
        type = ColDataType();
castExpr = new CastExpression();
        castExpr.setUseCastKeyword(false);
        castExpr.setLeftExpression(retval);
        castExpr.setType(type);
        retval=castExpr;
        break;
        }
      default:
        jj_la1[241] = jj_gen;
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
if (sign != null) {
            retval = new SignedExpression(sign.image.charAt(0), retval);
        }
        return retval;
    } catch (Throwable jjte000) {
if (jjtc000) {
    jjtree.clearNodeScope(jjtn000);
    jjtc000 = false;
  } else {
    jjtree.popNode();
  }
  if (jjte000 instanceof RuntimeException) {
    {if (true) throw (RuntimeException)jjte000;}
  }
  if (jjte000 instanceof ParseException) {
    {if (true) throw (ParseException)jjte000;}
  }
  {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
    jjtree.closeNodeScope(jjtn000, true);
    jjtn000.jjtSetLastToken(getToken(0));
  }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public JdbcNamedParameter JdbcNamedParameter() throws ParseException {JdbcNamedParameter parameter = new JdbcNamedParameter();
    String name;
    jj_consume_token(189);
    name = RelObjectNameExt2();
parameter.setName(name);
return parameter;
}

  final public UserVariable UserVariable() throws ParseException {UserVariable var = new UserVariable();
    String varName;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 216:{
      jj_consume_token(216);
      break;
      }
    case 193:{
      jj_consume_token(193);
var.setDoubleAdd(true);
      break;
      }
    default:
      jj_la1[242] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    varName = RelObjectNameExt2();
var.setName(varName);
        return var;
}

  final public NumericBind NumericBind() throws ParseException {NumericBind var = new NumericBind();
    Token token;
    jj_consume_token(189);
    token = jj_consume_token(S_LONG);
var.setBindId(Integer.valueOf(token.image));
        return var;
}

  final public DateTimeLiteralExpression DateTimeLiteralExpression() throws ParseException {DateTimeLiteralExpression expr = new DateTimeLiteralExpression();
    Token t;
    t = jj_consume_token(K_DATETIMELITERAL);
expr.setType(DateTimeLiteralExpression.DateTime.valueOf(t.image.toUpperCase()));
    t = jj_consume_token(S_CHAR_LITERAL);
expr.setValue(t.image); return expr;
}

  final public JsonExpression JsonExpression() throws ParseException {JsonExpression result = new JsonExpression();
  Column column;
  Token token;
    column = Column();
    label_56:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 217:{
        jj_consume_token(217);
        token = jj_consume_token(S_CHAR_LITERAL);
result.addIdent(token.image,"->");
        break;
        }
      case 218:{
        jj_consume_token(218);
        token = jj_consume_token(S_CHAR_LITERAL);
result.addIdent(token.image,"->>");
        break;
        }
      case 219:{
        jj_consume_token(219);
        token = jj_consume_token(S_CHAR_LITERAL);
result.addIdent(token.image,"#>");
        break;
        }
      case 220:{
        jj_consume_token(220);
        token = jj_consume_token(S_CHAR_LITERAL);
result.addIdent(token.image,"#>>");
        break;
        }
      default:
        jj_la1[243] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 217:
      case 218:
      case 219:
      case 220:{
        ;
        break;
        }
      default:
        jj_la1[244] = jj_gen;
        break label_56;
      }
    }
result.setColumn(column);
        return result;
}

  final public IntervalExpression IntervalExpression() throws ParseException {IntervalExpression interval = new IntervalExpression();
    Token token;
    boolean signed = false;
    jj_consume_token(K_INTERVAL);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 202:{
      jj_consume_token(202);
signed=true;
      break;
      }
    default:
      jj_la1[245] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
      break;
      }
    case S_DOUBLE:{
      token = jj_consume_token(S_DOUBLE);
      break;
      }
    case S_CHAR_LITERAL:{
      token = jj_consume_token(S_CHAR_LITERAL);
      break;
      }
    default:
      jj_la1[246] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
interval.setParameter((signed?"-":"") + token.image);
    if (jj_2_82(2)) {
      token = jj_consume_token(S_IDENTIFIER);
interval.setIntervalType(token.image);
    } else {
      ;
    }
return interval;
}

  final public KeepExpression KeepExpression() throws ParseException {KeepExpression keep = new KeepExpression();
    Token token;
    List<OrderByElement> list;
    jj_consume_token(K_KEEP);
    jj_consume_token(184);
    token = jj_consume_token(S_IDENTIFIER);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FIRST:{
      jj_consume_token(K_FIRST);
keep.setFirst(true);
      break;
      }
    case K_LAST:{
      jj_consume_token(K_LAST);
keep.setFirst(false);
      break;
      }
    default:
      jj_la1[247] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    list = OrderByElements();
    jj_consume_token(185);
keep.setName(token.image);
        keep.setOrderByElements(list);
        return keep;
}

  final public AnalyticExpression AnalyticExpression() throws ParseException {AnalyticExpression retval = new AnalyticExpression();
    ExpressionList expressionList = null;
    List<OrderByElement> olist = null;
    Token token = null;
    Expression expr = null;
    Expression offset = null;
    Expression defaultValue = null;
    WindowElement windowElement = null;
    KeepExpression keep = null;
    boolean distinct = false;
    token = jj_consume_token(S_IDENTIFIER);
retval.setName(token.image);
    jj_consume_token(184);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_COLUMN:
    case K_COMMIT:
    case K_DATETIMELITERAL:
    case K_DISTINCT:
    case K_DO:
    case K_DOUBLE:
    case K_ENABLE:
    case K_END:
    case K_EXTRACT:
    case K_FIRST:
    case K_FOLLOWING:
    case K_GROUP_CONCAT:
    case K_IF:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_KEY:
    case K_LAST:
    case K_LEFT:
    case K_MATERIALIZED:
    case K_NO:
    case K_NULL:
    case K_NULLS:
    case K_OPEN:
    case K_OVER:
    case K_PARTITION:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_REPLACE:
    case K_RIGHT:
    case K_ROW:
    case K_ROWS:
    case K_SEPARATOR:
    case K_SET:
    case K_SIBLINGS:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TRUNCATE:
    case K_UNSIGNED:
    case K_VALUE:
    case K_VALUES:
    case K_XML:
    case S_DOUBLE:
    case S_LONG:
    case S_HEX:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:
    case 184:
    case 186:
    case 188:
    case 189:
    case 190:
    case 193:
    case 194:
    case 202:
    case 211:
    case 213:
    case 214:
    case 216:
    case 221:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DISTINCT:{
        jj_consume_token(K_DISTINCT);
distinct = true;
        break;
        }
      default:
        jj_la1[248] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ANY:
      case K_CASCADE:
      case K_CASE:
      case K_CAST:
      case K_COLUMN:
      case K_COMMIT:
      case K_DATETIMELITERAL:
      case K_DO:
      case K_DOUBLE:
      case K_ENABLE:
      case K_END:
      case K_EXTRACT:
      case K_FIRST:
      case K_FOLLOWING:
      case K_GROUP_CONCAT:
      case K_IF:
      case K_INDEX:
      case K_INSERT:
      case K_INTERVAL:
      case K_KEY:
      case K_LAST:
      case K_LEFT:
      case K_MATERIALIZED:
      case K_NO:
      case K_NULL:
      case K_NULLS:
      case K_OPEN:
      case K_OVER:
      case K_PARTITION:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_RANGE:
      case K_REPLACE:
      case K_RIGHT:
      case K_ROW:
      case K_ROWS:
      case K_SEPARATOR:
      case K_SET:
      case K_SIBLINGS:
      case K_TABLE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TRUNCATE:
      case K_UNSIGNED:
      case K_VALUE:
      case K_VALUES:
      case K_XML:
      case S_DOUBLE:
      case S_LONG:
      case S_HEX:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 184:
      case 188:
      case 189:
      case 190:
      case 193:
      case 194:
      case 202:
      case 211:
      case 213:
      case 214:
      case 216:
      case 221:{
        expr = SimpleExpression();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 183:{
          jj_consume_token(183);
          offset = SimpleExpression();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 183:{
            jj_consume_token(183);
            defaultValue = SimpleExpression();
            break;
            }
          default:
            jj_la1[249] = jj_gen;
            ;
          }
          break;
          }
        default:
          jj_la1[250] = jj_gen;
          ;
        }
        break;
        }
      case 186:{
        jj_consume_token(186);
retval.setAllColumns(true);
        break;
        }
      default:
        jj_la1[251] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[252] = jj_gen;
      ;
    }
    jj_consume_token(185);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_KEEP:{
      keep = KeepExpression();
      break;
      }
    default:
      jj_la1[253] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_OVER:{
      jj_consume_token(K_OVER);
retval.setType(AnalyticType.OVER);
      break;
      }
    case K_WITHIN:{
      jj_consume_token(K_WITHIN);
      jj_consume_token(K_GROUP);
retval.setType(AnalyticType.WITHIN_GROUP);
      break;
      }
    default:
      jj_la1[254] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(184);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_PARTITION:{
      jj_consume_token(K_PARTITION);
      jj_consume_token(K_BY);
      expressionList = SimpleExpressionList();
      break;
      }
    default:
      jj_la1[255] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      olist = OrderByElements();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_RANGE:
      case K_ROWS:{
        windowElement = WindowElement();
        break;
        }
      default:
        jj_la1[256] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[257] = jj_gen;
      ;
    }
retval.setDistinct(distinct);
        retval.setExpression(expr);
        retval.setOffset(offset);
        retval.setDefaultValue(defaultValue);
        retval.setKeep(keep);
        retval.setPartitionExpressionList(expressionList);
        retval.setOrderByElements(olist);
        retval.setWindowElement(windowElement);
    jj_consume_token(185);
return retval;
}

  final public WindowElement WindowElement() throws ParseException {WindowElement windowElement = new WindowElement();
    WindowRange range = new WindowRange();
    WindowOffset offset = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ROWS:{
      jj_consume_token(K_ROWS);
windowElement.setType(WindowElement.Type.ROWS);
      break;
      }
    case K_RANGE:{
      jj_consume_token(K_RANGE);
windowElement.setType(WindowElement.Type.RANGE);
      break;
      }
    default:
      jj_la1[258] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_BETWEEN:{
      jj_consume_token(K_BETWEEN);
windowElement.setRange(range);
      offset = WindowOffset();
range.setStart(offset);
      jj_consume_token(K_AND);
      offset = WindowOffset();
range.setEnd(offset);
      break;
      }
    case K_ACTION:
    case K_ANY:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_COLUMN:
    case K_COMMIT:
    case K_CURRENT:
    case K_DATETIMELITERAL:
    case K_DO:
    case K_DOUBLE:
    case K_ENABLE:
    case K_END:
    case K_EXTRACT:
    case K_FIRST:
    case K_FOLLOWING:
    case K_GROUP_CONCAT:
    case K_IF:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_KEY:
    case K_LAST:
    case K_LEFT:
    case K_MATERIALIZED:
    case K_NO:
    case K_NULL:
    case K_NULLS:
    case K_OPEN:
    case K_OVER:
    case K_PARTITION:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_REPLACE:
    case K_RIGHT:
    case K_ROW:
    case K_ROWS:
    case K_SEPARATOR:
    case K_SET:
    case K_SIBLINGS:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TRUNCATE:
    case K_UNBOUNDED:
    case K_UNSIGNED:
    case K_VALUE:
    case K_VALUES:
    case K_XML:
    case S_DOUBLE:
    case S_LONG:
    case S_HEX:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:
    case 184:
    case 188:
    case 189:
    case 190:
    case 193:
    case 194:
    case 202:
    case 211:
    case 213:
    case 214:
    case 216:
    case 221:{
      offset = WindowOffset();
windowElement.setOffset(offset);
      break;
      }
    default:
      jj_la1[259] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return windowElement;
}

  final public WindowOffset WindowOffset() throws ParseException {WindowOffset offset = new WindowOffset();
    Expression expr = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_UNBOUNDED:{
      jj_consume_token(K_UNBOUNDED);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_PRECEDING:{
        jj_consume_token(K_PRECEDING);
offset.setType(WindowOffset.Type.PRECEDING);
        break;
        }
      case K_FOLLOWING:{
        jj_consume_token(K_FOLLOWING);
offset.setType(WindowOffset.Type.FOLLOWING);
        break;
        }
      default:
        jj_la1[260] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case K_CURRENT:{
      jj_consume_token(K_CURRENT);
      jj_consume_token(K_ROW);
offset.setType(WindowOffset.Type.CURRENT);
      break;
      }
    case K_ACTION:
    case K_ANY:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_COLUMN:
    case K_COMMIT:
    case K_DATETIMELITERAL:
    case K_DO:
    case K_DOUBLE:
    case K_ENABLE:
    case K_END:
    case K_EXTRACT:
    case K_FIRST:
    case K_FOLLOWING:
    case K_GROUP_CONCAT:
    case K_IF:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_KEY:
    case K_LAST:
    case K_LEFT:
    case K_MATERIALIZED:
    case K_NO:
    case K_NULL:
    case K_NULLS:
    case K_OPEN:
    case K_OVER:
    case K_PARTITION:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_REPLACE:
    case K_RIGHT:
    case K_ROW:
    case K_ROWS:
    case K_SEPARATOR:
    case K_SET:
    case K_SIBLINGS:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TRUNCATE:
    case K_UNSIGNED:
    case K_VALUE:
    case K_VALUES:
    case K_XML:
    case S_DOUBLE:
    case S_LONG:
    case S_HEX:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:
    case 184:
    case 188:
    case 189:
    case 190:
    case 193:
    case 194:
    case 202:
    case 211:
    case 213:
    case 214:
    case 216:
    case 221:{
      expr = SimpleExpression();
offset.setType(WindowOffset.Type.EXPR);
                        offset.setExpression(expr);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_PRECEDING:{
        jj_consume_token(K_PRECEDING);
offset.setType(WindowOffset.Type.PRECEDING);
        break;
        }
      case K_FOLLOWING:{
        jj_consume_token(K_FOLLOWING);
offset.setType(WindowOffset.Type.FOLLOWING);
        break;
        }
      default:
        jj_la1[261] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[262] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return offset;
}

  final public ExtractExpression ExtractExpression() throws ParseException {ExtractExpression retval = new ExtractExpression();
    Token token = null;
    Expression expr = null;
    jj_consume_token(K_EXTRACT);
    jj_consume_token(184);
    token = jj_consume_token(S_IDENTIFIER);
retval.setName(token.image);
    jj_consume_token(K_FROM);
    expr = SimpleExpression();
retval.setExpression(expr);
    jj_consume_token(185);
return retval;
}

  final public CastExpression CastExpression() throws ParseException {CastExpression retval = new CastExpression();
    ColDataType type = null;
    Expression expression = null;
    boolean    useCastKeyword;
    jj_consume_token(K_CAST);
    jj_consume_token(184);
    expression = SimpleExpression();
    jj_consume_token(K_AS);
    type = ColDataType();
    jj_consume_token(185);
retval.setUseCastKeyword(true);
retval.setLeftExpression(expression);
        retval.setType(type);
        return retval;
}

  final public Expression CaseWhenExpression() throws ParseException {/*@bgen(jjtree) CaseWhenExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTCASEWHENEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));CaseExpression caseExp = new CaseExpression();
    Expression switchExp = null;
    WhenClause clause;
    List<WhenClause> whenClauses = new ArrayList<WhenClause>();
    Expression elseExp = null;
    try {
      jj_consume_token(K_CASE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_WHEN:{
        label_57:
        while (true) {
          clause = WhenThenSearchCondition();
whenClauses.add(clause);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_WHEN:{
            ;
            break;
            }
          default:
            jj_la1[263] = jj_gen;
            break label_57;
          }
        }
        break;
        }
      case K_ACTION:
      case K_ALL:
      case K_ANY:
      case K_CASCADE:
      case K_CASE:
      case K_CAST:
      case K_COLUMN:
      case K_COMMIT:
      case K_DATETIMELITERAL:
      case K_DO:
      case K_DOUBLE:
      case K_ENABLE:
      case K_END:
      case K_EXTRACT:
      case K_FIRST:
      case K_FOLLOWING:
      case K_GROUP_CONCAT:
      case K_IF:
      case K_INDEX:
      case K_INSERT:
      case K_INTERVAL:
      case K_KEY:
      case K_LAST:
      case K_LEFT:
      case K_MATERIALIZED:
      case K_NO:
      case K_NOT:
      case K_NULL:
      case K_NULLS:
      case K_OPEN:
      case K_OVER:
      case K_PARTITION:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_RANGE:
      case K_REPLACE:
      case K_RIGHT:
      case K_ROW:
      case K_ROWS:
      case K_SEPARATOR:
      case K_SET:
      case K_SIBLINGS:
      case K_SOME:
      case K_TABLE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TRUNCATE:
      case K_UNSIGNED:
      case K_VALUE:
      case K_VALUES:
      case K_XML:
      case S_DOUBLE:
      case S_LONG:
      case S_HEX:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 184:
      case 188:
      case 189:
      case 190:
      case 193:
      case 194:
      case 202:
      case 211:
      case 213:
      case 214:
      case 216:
      case 221:{
        if (jj_2_83(2147483647)) {
          switchExp = RegularCondition();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ACTION:
          case K_ANY:
          case K_CASCADE:
          case K_CASE:
          case K_CAST:
          case K_COLUMN:
          case K_COMMIT:
          case K_DATETIMELITERAL:
          case K_DO:
          case K_DOUBLE:
          case K_ENABLE:
          case K_END:
          case K_EXTRACT:
          case K_FIRST:
          case K_FOLLOWING:
          case K_GROUP_CONCAT:
          case K_IF:
          case K_INDEX:
          case K_INSERT:
          case K_INTERVAL:
          case K_KEY:
          case K_LAST:
          case K_LEFT:
          case K_MATERIALIZED:
          case K_NO:
          case K_NULL:
          case K_NULLS:
          case K_OPEN:
          case K_OVER:
          case K_PARTITION:
          case K_PERCENT:
          case K_PRECISION:
          case K_PRIMARY:
          case K_PRIOR:
          case K_RANGE:
          case K_REPLACE:
          case K_RIGHT:
          case K_ROW:
          case K_ROWS:
          case K_SEPARATOR:
          case K_SET:
          case K_SIBLINGS:
          case K_TABLE:
          case K_TEMP:
          case K_TEMPORARY:
          case K_TIME_KEY_EXPR:
          case K_TRUNCATE:
          case K_UNSIGNED:
          case K_VALUE:
          case K_VALUES:
          case K_XML:
          case S_DOUBLE:
          case S_LONG:
          case S_HEX:
          case S_IDENTIFIER:
          case S_CHAR_LITERAL:
          case S_QUOTED_IDENTIFIER:
          case 184:
          case 188:
          case 189:
          case 190:
          case 193:
          case 194:
          case 202:
          case 211:
          case 213:
          case 214:
          case 216:
          case 221:{
            switchExp = BitwiseAndOr();
            break;
            }
          default:
            jj_la1[264] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        label_58:
        while (true) {
          clause = WhenThenValue();
whenClauses.add(clause);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_WHEN:{
            ;
            break;
            }
          default:
            jj_la1[265] = jj_gen;
            break label_58;
          }
        }
        break;
        }
      default:
        jj_la1[266] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ELSE:{
        jj_consume_token(K_ELSE);
        elseExp = SimpleExpression();
        break;
        }
      default:
        jj_la1[267] = jj_gen;
        ;
      }
      jj_consume_token(K_END);
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
caseExp.setSwitchExpression(switchExp);
        caseExp.setWhenClauses(whenClauses);
        caseExp.setElseExpression(elseExp);
        return caseExp;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public WhenClause WhenThenSearchCondition() throws ParseException {WhenClause whenThen = new WhenClause();
    Expression whenExp = null;
    Expression thenExp = null;
    jj_consume_token(K_WHEN);
    if (jj_2_84(2147483647)) {
      whenExp = Expression();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ANY:
      case K_CASCADE:
      case K_CASE:
      case K_CAST:
      case K_COLUMN:
      case K_COMMIT:
      case K_DATETIMELITERAL:
      case K_DO:
      case K_DOUBLE:
      case K_ENABLE:
      case K_END:
      case K_EXTRACT:
      case K_FIRST:
      case K_FOLLOWING:
      case K_GROUP_CONCAT:
      case K_IF:
      case K_INDEX:
      case K_INSERT:
      case K_INTERVAL:
      case K_KEY:
      case K_LAST:
      case K_LEFT:
      case K_MATERIALIZED:
      case K_NO:
      case K_NULL:
      case K_NULLS:
      case K_OPEN:
      case K_OVER:
      case K_PARTITION:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_RANGE:
      case K_REPLACE:
      case K_RIGHT:
      case K_ROW:
      case K_ROWS:
      case K_SEPARATOR:
      case K_SET:
      case K_SIBLINGS:
      case K_TABLE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TRUNCATE:
      case K_UNSIGNED:
      case K_VALUE:
      case K_VALUES:
      case K_XML:
      case S_DOUBLE:
      case S_LONG:
      case S_HEX:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 184:
      case 188:
      case 189:
      case 190:
      case 193:
      case 194:
      case 202:
      case 211:
      case 213:
      case 214:
      case 216:
      case 221:{
        whenExp = SimpleExpression();
        break;
        }
      default:
        jj_la1[268] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(K_THEN);
    thenExp = SimpleExpression();
whenThen.setWhenExpression(whenExp);
       whenThen.setThenExpression(thenExp);
       return whenThen;
}

  final public WhenClause WhenThenValue() throws ParseException {WhenClause whenThen = new WhenClause();
    Expression whenExp = null;
    Expression thenExp = null;
    jj_consume_token(K_WHEN);
    whenExp = SimpleExpression();
    jj_consume_token(K_THEN);
    thenExp = SimpleExpression();
whenThen.setWhenExpression(whenExp);
       whenThen.setThenExpression(thenExp);
       return whenThen;
}

  final public RowConstructor RowConstructor() throws ParseException {ExpressionList list = null;
    RowConstructor rowConstructor = new RowConstructor();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ROW:{
      jj_consume_token(K_ROW);
rowConstructor.setName("ROW");
      break;
      }
    default:
      jj_la1[269] = jj_gen;
      ;
    }
    jj_consume_token(184);
    list = SimpleExpressionList();
    jj_consume_token(185);
rowConstructor.setExprList(list);
        return rowConstructor;
}

  final public Execute Execute() throws ParseException {String funcName = null;
    ExpressionList expressionList = null;
    Execute execute = new Execute();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_EXEC:{
      jj_consume_token(K_EXEC);
execute.setExecType(Execute.EXEC_TYPE.EXEC);
      break;
      }
    case K_EXECUTE:{
      jj_consume_token(K_EXECUTE);
execute.setExecType(Execute.EXEC_TYPE.EXECUTE);
      break;
      }
    case K_CALL:{
      jj_consume_token(K_CALL);
execute.setExecType(Execute.EXEC_TYPE.CALL);
      break;
      }
    default:
      jj_la1[270] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    funcName = RelObjectName();
execute.setName(funcName);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_COLUMN:
    case K_COMMIT:
    case K_DATETIMELITERAL:
    case K_DO:
    case K_DOUBLE:
    case K_ENABLE:
    case K_END:
    case K_EXTRACT:
    case K_FIRST:
    case K_FOLLOWING:
    case K_GROUP_CONCAT:
    case K_IF:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_KEY:
    case K_LAST:
    case K_LEFT:
    case K_MATERIALIZED:
    case K_NO:
    case K_NULL:
    case K_NULLS:
    case K_OPEN:
    case K_OVER:
    case K_PARTITION:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_REPLACE:
    case K_RIGHT:
    case K_ROW:
    case K_ROWS:
    case K_SEPARATOR:
    case K_SET:
    case K_SIBLINGS:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TRUNCATE:
    case K_UNSIGNED:
    case K_VALUE:
    case K_VALUES:
    case K_XML:
    case S_DOUBLE:
    case S_LONG:
    case S_HEX:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:
    case 184:
    case 188:
    case 189:
    case 190:
    case 193:
    case 194:
    case 202:
    case 211:
    case 213:
    case 214:
    case 216:
    case 221:{
      expressionList = SimpleExpressionList();
      break;
      }
    default:
      jj_la1[271] = jj_gen;
      ;
    }
execute.setExprList(expressionList);
        return execute;
}

  final public Function Function() throws ParseException {/*@bgen(jjtree) Function */
    SimpleNode jjtn000 = new SimpleNode(JJTFUNCTION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Function retval = new Function();
    String funcName = null;
    String tmp = null;
    ExpressionList expressionList = null;
    KeepExpression keep = null;
    SubSelect expr = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 221:{
        jj_consume_token(221);
retval.setEscaped(true);
        break;
        }
      default:
        jj_la1[272] = jj_gen;
        ;
      }
      funcName = RelObjectNameExt();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 187:{
        jj_consume_token(187);
        tmp = RelObjectNameExt();
funcName+= "." + tmp;
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 187:{
          jj_consume_token(187);
          tmp = RelObjectNameExt();
funcName+= "." + tmp;
          break;
          }
        default:
          jj_la1[273] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[274] = jj_gen;
        ;
      }
      jj_consume_token(184);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ALL:
      case K_ANY:
      case K_CASCADE:
      case K_CASE:
      case K_CAST:
      case K_COLUMN:
      case K_COMMIT:
      case K_DATETIMELITERAL:
      case K_DISTINCT:
      case K_DO:
      case K_DOUBLE:
      case K_ENABLE:
      case K_END:
      case K_EXTRACT:
      case K_FIRST:
      case K_FOLLOWING:
      case K_GROUP_CONCAT:
      case K_IF:
      case K_INDEX:
      case K_INSERT:
      case K_INTERVAL:
      case K_KEY:
      case K_LAST:
      case K_LEFT:
      case K_MATERIALIZED:
      case K_NO:
      case K_NULL:
      case K_NULLS:
      case K_OPEN:
      case K_OVER:
      case K_PARTITION:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_RANGE:
      case K_REPLACE:
      case K_RIGHT:
      case K_ROW:
      case K_ROWS:
      case K_SELECT:
      case K_SEPARATOR:
      case K_SET:
      case K_SIBLINGS:
      case K_TABLE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TRUNCATE:
      case K_UNSIGNED:
      case K_VALUE:
      case K_VALUES:
      case K_WITH:
      case K_XML:
      case S_DOUBLE:
      case S_LONG:
      case S_HEX:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 184:
      case 186:
      case 188:
      case 189:
      case 190:
      case 193:
      case 194:
      case 202:
      case 211:
      case 213:
      case 214:
      case 216:
      case 221:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ALL:
        case K_DISTINCT:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_DISTINCT:{
            jj_consume_token(K_DISTINCT);
retval.setDistinct(true);
            break;
            }
          case K_ALL:{
            jj_consume_token(K_ALL);
retval.setAllColumns(true);
            break;
            }
          default:
            jj_la1[275] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[276] = jj_gen;
          ;
        }
        if (jj_2_85(3)) {
          expressionList = SimpleExpressionList();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 186:{
            jj_consume_token(186);
retval.setAllColumns(true);
            break;
            }
          case K_SELECT:
          case K_WITH:
          case 184:{
            expr = SubSelect();
expr.setUseBrackets(false); expressionList = new ExpressionList(expr);
            break;
            }
          default:
            jj_la1[277] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[278] = jj_gen;
        ;
      }
      jj_consume_token(185);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 187:{
        jj_consume_token(187);
        tmp = RelObjectName();
retval.setAttribute(tmp);
        break;
        }
      default:
        jj_la1[279] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_KEEP:{
        keep = KeepExpression();
        break;
        }
      default:
        jj_la1[280] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 212:{
        jj_consume_token(212);
        break;
        }
      default:
        jj_la1[281] = jj_gen;
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
retval.setParameters(expressionList);
        retval.setName(funcName);
        retval.setKeep(keep);
        linkAST(retval,jjtn000);
        return retval;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public MySQLGroupConcat MySQLGroupConcat() throws ParseException {MySQLGroupConcat retval = new MySQLGroupConcat();
    ExpressionList expressionList = null;
    List<OrderByElement> orderByList = null;
    Token t;
    jj_consume_token(K_GROUP_CONCAT);
    jj_consume_token(184);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_DISTINCT:{
      jj_consume_token(K_DISTINCT);
retval.setDistinct(true);
      break;
      }
    default:
      jj_la1[282] = jj_gen;
      ;
    }
    expressionList = SimpleExpressionList();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      orderByList = OrderByElements();
retval.setOrderByElements(orderByList);
      break;
      }
    default:
      jj_la1[283] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_SEPARATOR:{
      jj_consume_token(K_SEPARATOR);
      t = jj_consume_token(S_CHAR_LITERAL);
retval.setSeparator(t.image);
      break;
      }
    default:
      jj_la1[284] = jj_gen;
      ;
    }
    jj_consume_token(185);
retval.setExpressionList(expressionList);
        return retval;
}

  final public ValueListExpression ValueListExpression() throws ParseException {ValueListExpression retval = new ValueListExpression();
    ExpressionList expressionList = null;
    jj_consume_token(184);
    expressionList = SimpleExpressionListAtLeastTwoItems();
    jj_consume_token(185);
retval.setExpressionList(expressionList);
        return retval;
}

  final public TableFunction TableFunction() throws ParseException {Alias alias = null;
    Function function;
    TableFunction functionItem;
    function = Function();
functionItem = new TableFunction(); functionItem.setFunction(function);
    if (jj_2_86(2)) {
      alias = Alias();
functionItem.setAlias(alias);
    } else {
      ;
    }
return functionItem;
}

  final public SubSelect SubSelect() throws ParseException {/*@bgen(jjtree) SubSelect */
    SimpleNode jjtn000 = new SimpleNode(JJTSUBSELECT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));SelectBody selectBody = null;
    SubSelect subSelect = new SubSelect();
    List<WithItem> with = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_WITH:{
        with = WithList();
subSelect.setWithItemsList(with);
        break;
        }
      default:
        jj_la1[285] = jj_gen;
        ;
      }
      selectBody = SelectBody();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
subSelect.setSelectBody(selectBody);
        return subSelect;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public CreateIndex CreateIndex() throws ParseException {CreateIndex createIndex = new CreateIndex();
    Table table = null;
    List<String> colNames = new ArrayList<String>();
    Token columnName;
    Index index = null;
    String name = null;
    List<String> parameter = new ArrayList<String>();
    jj_consume_token(K_CREATE);
    label_59:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CASCADE:
      case K_CHECK:
      case K_COMMIT:
      case K_CONSTRAINT:
      case K_DELETE:
      case K_EXCLUDE:
      case K_FOREIGN:
      case K_KEY:
      case K_NOT:
      case K_NULL:
      case K_ON:
      case K_PRIMARY:
      case K_REFERENCES:
      case K_ROWS:
      case K_TABLESPACE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_UNIQUE:
      case K_UPDATE:
      case K_USING:
      case K_UNSIGNED:
      case K_WHERE:
      case K_WITH:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 182:
      case 184:
      case 190:
      case 202:{
        ;
        break;
        }
      default:
        jj_la1[286] = jj_gen;
        break label_59;
      }
      parameter = CreateParameter();
    }
    jj_consume_token(K_INDEX);
    name = RelObjectName();
index = new Index();
        index.setName(name);
        index.setType(parameter.isEmpty()?null:parameter.get(0));
    jj_consume_token(K_ON);
    table = Table();
    jj_consume_token(184);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      columnName = jj_consume_token(S_IDENTIFIER);
      break;
      }
    case S_QUOTED_IDENTIFIER:{
      columnName = jj_consume_token(S_QUOTED_IDENTIFIER);
      break;
      }
    default:
      jj_la1[287] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_60:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ASC:
      case K_CASCADE:
      case K_CHECK:
      case K_COMMIT:
      case K_CONSTRAINT:
      case K_DELETE:
      case K_DESC:
      case K_EXCLUDE:
      case K_FOREIGN:
      case K_KEY:
      case K_NOT:
      case K_NULL:
      case K_ON:
      case K_PRIMARY:
      case K_REFERENCES:
      case K_ROWS:
      case K_TABLESPACE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_UNIQUE:
      case K_UPDATE:
      case K_USING:
      case K_UNSIGNED:
      case K_WHERE:
      case K_WITH:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 182:
      case 184:
      case 190:
      case 202:{
        ;
        break;
        }
      default:
        jj_la1[288] = jj_gen;
        break label_60;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CASCADE:
      case K_CHECK:
      case K_COMMIT:
      case K_CONSTRAINT:
      case K_DELETE:
      case K_EXCLUDE:
      case K_FOREIGN:
      case K_KEY:
      case K_NOT:
      case K_NULL:
      case K_ON:
      case K_PRIMARY:
      case K_REFERENCES:
      case K_ROWS:
      case K_TABLESPACE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_UNIQUE:
      case K_UPDATE:
      case K_USING:
      case K_UNSIGNED:
      case K_WHERE:
      case K_WITH:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 182:
      case 184:
      case 190:
      case 202:{
        CreateParameter();
        break;
        }
      case K_ASC:{
        jj_consume_token(K_ASC);
        break;
        }
      case K_DESC:{
        jj_consume_token(K_DESC);
        break;
        }
      default:
        jj_la1[289] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
colNames.add(columnName.image);
    label_61:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 183:{
        ;
        break;
        }
      default:
        jj_la1[290] = jj_gen;
        break label_61;
      }
      jj_consume_token(183);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        columnName = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        columnName = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[291] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_62:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ASC:
        case K_CASCADE:
        case K_CHECK:
        case K_COMMIT:
        case K_CONSTRAINT:
        case K_DELETE:
        case K_DESC:
        case K_EXCLUDE:
        case K_FOREIGN:
        case K_KEY:
        case K_NOT:
        case K_NULL:
        case K_ON:
        case K_PRIMARY:
        case K_REFERENCES:
        case K_ROWS:
        case K_TABLESPACE:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIME_KEY_EXPR:
        case K_UNIQUE:
        case K_UPDATE:
        case K_USING:
        case K_UNSIGNED:
        case K_WHERE:
        case K_WITH:
        case S_DOUBLE:
        case S_LONG:
        case S_IDENTIFIER:
        case S_CHAR_LITERAL:
        case S_QUOTED_IDENTIFIER:
        case 182:
        case 184:
        case 190:
        case 202:{
          ;
          break;
          }
        default:
          jj_la1[292] = jj_gen;
          break label_62;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_CASCADE:
        case K_CHECK:
        case K_COMMIT:
        case K_CONSTRAINT:
        case K_DELETE:
        case K_EXCLUDE:
        case K_FOREIGN:
        case K_KEY:
        case K_NOT:
        case K_NULL:
        case K_ON:
        case K_PRIMARY:
        case K_REFERENCES:
        case K_ROWS:
        case K_TABLESPACE:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIME_KEY_EXPR:
        case K_UNIQUE:
        case K_UPDATE:
        case K_USING:
        case K_UNSIGNED:
        case K_WHERE:
        case K_WITH:
        case S_DOUBLE:
        case S_LONG:
        case S_IDENTIFIER:
        case S_CHAR_LITERAL:
        case S_QUOTED_IDENTIFIER:
        case 182:
        case 184:
        case 190:
        case 202:{
          CreateParameter();
          break;
          }
        case K_ASC:{
          jj_consume_token(K_ASC);
          break;
          }
        case K_DESC:{
          jj_consume_token(K_DESC);
          break;
          }
        default:
          jj_la1[293] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
colNames.add(columnName.image);
    }
    jj_consume_token(185);
    label_63:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CASCADE:
      case K_CHECK:
      case K_COMMIT:
      case K_CONSTRAINT:
      case K_DELETE:
      case K_EXCLUDE:
      case K_FOREIGN:
      case K_KEY:
      case K_NOT:
      case K_NULL:
      case K_ON:
      case K_PRIMARY:
      case K_REFERENCES:
      case K_ROWS:
      case K_TABLESPACE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_UNIQUE:
      case K_UPDATE:
      case K_USING:
      case K_UNSIGNED:
      case K_WHERE:
      case K_WITH:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 182:
      case 184:
      case 190:
      case 202:{
        ;
        break;
        }
      default:
        jj_la1[294] = jj_gen;
        break label_63;
      }
      CreateParameter();

    }
index.setColumnsNames(colNames);
        createIndex.setIndex(index);
        createIndex.setTable(table);
        return createIndex;
}

  final public CreateTable CreateTable() throws ParseException {CreateTable createTable = new CreateTable();
    Table table = null;
    List columnDefinitions = new ArrayList();
    List columnSpecs = null;
    List<String> tableOptions = new ArrayList<String>();
    List<String> createOptions = new ArrayList<String>();
    String columnName;
    Token tk = null;
    Token tk2 = null;
    Token tk3 = null;
    String sk3 = null;
    ColDataType colDataType = null;
    String stringList = null;
    ColumnDefinition coldef = null;
    List indexes = new ArrayList();
    List colNames = null;
    Index index = null;
    ForeignKeyIndex fkIndex = null;
    List<String> parameter = new ArrayList<String>();
    List<String> idxSpec = new ArrayList<String>();
    Table fkTable = null;
    Select select = null;
    CheckConstraint checkCs = null;
    ExcludeConstraint excludeC = null;
    jj_consume_token(K_CREATE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_UNLOGGED:{
      jj_consume_token(K_UNLOGGED);
createTable.setUnlogged(true);
      break;
      }
    default:
      jj_la1[295] = jj_gen;
      ;
    }
    label_64:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CASCADE:
      case K_CHECK:
      case K_COMMIT:
      case K_CONSTRAINT:
      case K_DELETE:
      case K_EXCLUDE:
      case K_FOREIGN:
      case K_KEY:
      case K_NOT:
      case K_NULL:
      case K_ON:
      case K_PRIMARY:
      case K_REFERENCES:
      case K_ROWS:
      case K_TABLESPACE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_UNIQUE:
      case K_UPDATE:
      case K_USING:
      case K_UNSIGNED:
      case K_WHERE:
      case K_WITH:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 182:
      case 184:
      case 190:
      case 202:{
        ;
        break;
        }
      default:
        jj_la1[296] = jj_gen;
        break label_64;
      }
      parameter = CreateParameter();
createOptions.addAll(parameter);
    }
    jj_consume_token(K_TABLE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_IF:{
      jj_consume_token(K_IF);
      jj_consume_token(K_NOT);
      jj_consume_token(K_EXISTS);
createTable.setIfNotExists(true);
      break;
      }
    default:
      jj_la1[297] = jj_gen;
      ;
    }
    table = Table();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_AS:
    case 184:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 184:{
        jj_consume_token(184);
        columnName = RelObjectName();
        colDataType = ColDataType();
columnSpecs = new ArrayList();
        label_65:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_CASCADE:
          case K_CHECK:
          case K_COMMIT:
          case K_CONSTRAINT:
          case K_DELETE:
          case K_EXCLUDE:
          case K_FOREIGN:
          case K_KEY:
          case K_NOT:
          case K_NULL:
          case K_ON:
          case K_PRIMARY:
          case K_REFERENCES:
          case K_ROWS:
          case K_TABLESPACE:
          case K_TEMP:
          case K_TEMPORARY:
          case K_TIME_KEY_EXPR:
          case K_UNIQUE:
          case K_UPDATE:
          case K_USING:
          case K_UNSIGNED:
          case K_WHERE:
          case K_WITH:
          case S_DOUBLE:
          case S_LONG:
          case S_IDENTIFIER:
          case S_CHAR_LITERAL:
          case S_QUOTED_IDENTIFIER:
          case 182:
          case 184:
          case 190:
          case 202:{
            ;
            break;
            }
          default:
            jj_la1[298] = jj_gen;
            break label_65;
          }
          parameter = CreateParameter();
columnSpecs.addAll(parameter);
        }
coldef = new ColumnDefinition();
            coldef.setColumnName(columnName);
            coldef.setColDataType(colDataType);
            if (columnSpecs.size() > 0)
                coldef.setColumnSpecStrings(columnSpecs);
            columnDefinitions.add(coldef);
        label_66:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 183:{
            ;
            break;
            }
          default:
            jj_la1[299] = jj_gen;
            break label_66;
          }
          jj_consume_token(183);
          if (jj_2_89(3)) {
            tk = jj_consume_token(K_INDEX);
            sk3 = RelObjectName();
            colNames = ColumnsNamesList();
index = new Index();
                            index.setType(tk.image);
                            index.setName(sk3);
                            index.setColumnsNames(colNames);
                            indexes.add(index);
          } else if (jj_2_90(3)) {
index = new NamedConstraint();
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_CONSTRAINT:{
              jj_consume_token(K_CONSTRAINT);
              sk3 = RelObjectName();
index.setName(sk3);
              break;
              }
            default:
              jj_la1[300] = jj_gen;
              ;
            }
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_PRIMARY:{
              tk = jj_consume_token(K_PRIMARY);
              tk2 = jj_consume_token(K_KEY);
index.setType(tk.image + " " + tk2.image);
              break;
              }
            case K_UNIQUE:{
              tk = jj_consume_token(K_UNIQUE);
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_KEY:{
                tk2 = jj_consume_token(K_KEY);
                break;
                }
              default:
                jj_la1[301] = jj_gen;
                ;
              }
index.setType(tk.image + (tk2!=null?" " + tk2.image:""));
              break;
              }
            default:
              jj_la1[302] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            colNames = ColumnsNamesList();
            label_67:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_CASCADE:
              case K_CHECK:
              case K_COMMIT:
              case K_CONSTRAINT:
              case K_DELETE:
              case K_EXCLUDE:
              case K_FOREIGN:
              case K_KEY:
              case K_NOT:
              case K_NULL:
              case K_ON:
              case K_PRIMARY:
              case K_REFERENCES:
              case K_ROWS:
              case K_TABLESPACE:
              case K_TEMP:
              case K_TEMPORARY:
              case K_TIME_KEY_EXPR:
              case K_UNIQUE:
              case K_UPDATE:
              case K_USING:
              case K_UNSIGNED:
              case K_WHERE:
              case K_WITH:
              case S_DOUBLE:
              case S_LONG:
              case S_IDENTIFIER:
              case S_CHAR_LITERAL:
              case S_QUOTED_IDENTIFIER:
              case 182:
              case 184:
              case 190:
              case 202:{
                ;
                break;
                }
              default:
                jj_la1[303] = jj_gen;
                break label_67;
              }
              parameter = CreateParameter();
idxSpec.addAll(parameter);
            }
index.setColumnsNames(colNames);
                            index.setIndexSpec(idxSpec);
                            indexes.add(index);
          } else if (jj_2_91(3)) {
tk=null;
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_UNIQUE:{
              tk = jj_consume_token(K_UNIQUE);
              break;
              }
            default:
              jj_la1[304] = jj_gen;
              ;
            }
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_FULLTEXT:{
              tk3 = jj_consume_token(K_FULLTEXT);
              break;
              }
            default:
              jj_la1[305] = jj_gen;
              ;
            }
            tk2 = jj_consume_token(K_KEY);
            sk3 = RelObjectName();
            colNames = ColumnsNamesList();
index = new Index();
                            index.setType((tk!=null?tk.image + " ":"") + (tk3!=null?tk3.image + " ":"") + tk2.image);
                            index.setName(sk3);
                            index.setColumnsNames(colNames);
                            indexes.add(index);
          } else if (jj_2_92(3)) {
fkIndex = new ForeignKeyIndex();
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_CONSTRAINT:{
              jj_consume_token(K_CONSTRAINT);
              sk3 = RelObjectName();
fkIndex.setName(sk3);
              break;
              }
            default:
              jj_la1[306] = jj_gen;
              ;
            }
            tk = jj_consume_token(K_FOREIGN);
            tk2 = jj_consume_token(K_KEY);
            colNames = ColumnsNamesList();
fkIndex.setType(tk.image + " " + tk2.image);
                            fkIndex.setColumnsNames(colNames);
            jj_consume_token(K_REFERENCES);
            fkTable = Table();
            colNames = ColumnsNamesList();
fkIndex.setTable(fkTable);
                            fkIndex.setReferencedColumnNames(colNames);
                            indexes.add(fkIndex);
            if (jj_2_87(2)) {
              jj_consume_token(K_ON);
              jj_consume_token(K_DELETE);
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_CASCADE:{
                jj_consume_token(K_CASCADE);
fkIndex.setOnDeleteReferenceOption("CASCADE");
                break;
                }
              case K_NO:{
                jj_consume_token(K_NO);
                jj_consume_token(K_ACTION);
fkIndex.setOnDeleteReferenceOption("NO ACTION");
                break;
                }
              case K_SET:{
                jj_consume_token(K_SET);
                jj_consume_token(K_NULL);
fkIndex.setOnDeleteReferenceOption("SET NULL");
                break;
                }
              default:
                jj_la1[307] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            } else {
              ;
            }
            if (jj_2_88(2)) {
              jj_consume_token(K_ON);
              jj_consume_token(K_UPDATE);
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_CASCADE:{
                jj_consume_token(K_CASCADE);
fkIndex.setOnUpdateReferenceOption("CASCADE");
                break;
                }
              case K_NO:{
                jj_consume_token(K_NO);
                jj_consume_token(K_ACTION);
fkIndex.setOnUpdateReferenceOption("NO ACTION");
                break;
                }
              default:
                jj_la1[308] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            } else {
              ;
            }
          } else if (jj_2_93(3)) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_CONSTRAINT:{
              jj_consume_token(K_CONSTRAINT);
              sk3 = RelObjectName();
              break;
              }
            default:
              jj_la1[309] = jj_gen;
              ;
            }
Expression exp = null;
            jj_consume_token(K_CHECK);
            label_68:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case 184:{
                ;
                break;
                }
              default:
                jj_la1[310] = jj_gen;
                break label_68;
              }
              jj_consume_token(184);
              exp = Expression();
              jj_consume_token(185);
            }
checkCs = new CheckConstraint();
                       checkCs.setName(sk3);
                       checkCs.setExpression(exp);
                       indexes.add(checkCs);
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_EXCLUDE:{
              tk = jj_consume_token(K_EXCLUDE);
excludeC = new ExcludeConstraint(); Expression exp = null;
              tk2 = jj_consume_token(K_WHERE);
              label_69:
              while (true) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case 184:{
                  ;
                  break;
                  }
                default:
                  jj_la1[311] = jj_gen;
                  break label_69;
                }
                jj_consume_token(184);
                exp = Expression();
                jj_consume_token(185);
              }
excludeC.setExpression(exp);
indexes.add(excludeC);
              break;
              }
            case K_ACTION:
            case K_ANY:
            case K_CASCADE:
            case K_CAST:
            case K_COLUMN:
            case K_COMMIT:
            case K_DATETIMELITERAL:
            case K_DO:
            case K_ENABLE:
            case K_END:
            case K_EXTRACT:
            case K_FIRST:
            case K_FOLLOWING:
            case K_INDEX:
            case K_INSERT:
            case K_KEY:
            case K_LAST:
            case K_MATERIALIZED:
            case K_NO:
            case K_NULLS:
            case K_OPEN:
            case K_OVER:
            case K_PARTITION:
            case K_PERCENT:
            case K_PRECISION:
            case K_PRIMARY:
            case K_PRIOR:
            case K_RANGE:
            case K_REPLACE:
            case K_ROW:
            case K_ROWS:
            case K_SEPARATOR:
            case K_SIBLINGS:
            case K_TABLE:
            case K_TEMP:
            case K_TEMPORARY:
            case K_TRUNCATE:
            case K_UNSIGNED:
            case K_VALUE:
            case K_VALUES:
            case K_XML:
            case S_IDENTIFIER:
            case S_QUOTED_IDENTIFIER:{
              columnName = RelObjectName();
              colDataType = ColDataType();
columnSpecs = new ArrayList();
              label_70:
              while (true) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_CASCADE:
                case K_CHECK:
                case K_COMMIT:
                case K_CONSTRAINT:
                case K_DELETE:
                case K_EXCLUDE:
                case K_FOREIGN:
                case K_KEY:
                case K_NOT:
                case K_NULL:
                case K_ON:
                case K_PRIMARY:
                case K_REFERENCES:
                case K_ROWS:
                case K_TABLESPACE:
                case K_TEMP:
                case K_TEMPORARY:
                case K_TIME_KEY_EXPR:
                case K_UNIQUE:
                case K_UPDATE:
                case K_USING:
                case K_UNSIGNED:
                case K_WHERE:
                case K_WITH:
                case S_DOUBLE:
                case S_LONG:
                case S_IDENTIFIER:
                case S_CHAR_LITERAL:
                case S_QUOTED_IDENTIFIER:
                case 182:
                case 184:
                case 190:
                case 202:{
                  ;
                  break;
                  }
                default:
                  jj_la1[312] = jj_gen;
                  break label_70;
                }
                parameter = CreateParameter();
columnSpecs.addAll(parameter);
              }
coldef = new ColumnDefinition();
                        coldef.setColumnName(columnName);
                        coldef.setColDataType(colDataType);
                        if (columnSpecs.size() > 0)
                            coldef.setColumnSpecStrings(columnSpecs);
                        columnDefinitions.add(coldef);
              break;
              }
            default:
              jj_la1[313] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
        jj_consume_token(185);
        label_71:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_CASCADE:
          case K_CHECK:
          case K_COMMIT:
          case K_CONSTRAINT:
          case K_DELETE:
          case K_EXCLUDE:
          case K_FOREIGN:
          case K_KEY:
          case K_NOT:
          case K_NULL:
          case K_ON:
          case K_PRIMARY:
          case K_REFERENCES:
          case K_ROWS:
          case K_TABLESPACE:
          case K_TEMP:
          case K_TEMPORARY:
          case K_TIME_KEY_EXPR:
          case K_UNIQUE:
          case K_UPDATE:
          case K_USING:
          case K_UNSIGNED:
          case K_WHERE:
          case K_WITH:
          case S_DOUBLE:
          case S_LONG:
          case S_IDENTIFIER:
          case S_CHAR_LITERAL:
          case S_QUOTED_IDENTIFIER:
          case 182:
          case 184:
          case 190:
          case 202:{
            ;
            break;
            }
          default:
            jj_la1[314] = jj_gen;
            break label_71;
          }
          parameter = CreateParameter();
tableOptions.addAll(parameter);
        }
        break;
        }
      case K_AS:{
        jj_consume_token(K_AS);
        if (jj_2_94(2147483647)) {
          jj_consume_token(184);
          select = Select();
createTable.setSelect(select, true);
          jj_consume_token(185);
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_SELECT:
          case K_WITH:
          case 184:{
            select = Select();
createTable.setSelect(select, false);
            break;
            }
          default:
            jj_la1[315] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[316] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[317] = jj_gen;
      ;
    }
createTable.setTable(table);
        if (indexes.size() > 0)
            createTable.setIndexes(indexes);
        if (createOptions.size() > 0)
            createTable.setCreateOptionsStrings(createOptions);
        if (tableOptions.size() > 0)
            createTable.setTableOptionsStrings(tableOptions);
        if (columnDefinitions.size() > 0)
            createTable.setColumnDefinitions(columnDefinitions);
        return createTable;
}

  final public ColDataType ColDataType() throws ParseException {ColDataType colDataType = new ColDataType();
    Token tk = null;
    Token tk2 = null;
    ArrayList argumentsStringList = new ArrayList();
    List<Integer> array = new ArrayList<Integer>();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_BIT:
    case K_CHARACTER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CHARACTER:{
        tk = jj_consume_token(K_CHARACTER);
        break;
        }
      case K_BIT:{
        tk = jj_consume_token(K_BIT);
        break;
        }
      default:
        jj_la1[318] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_VARYING:{
        tk2 = jj_consume_token(K_VARYING);
        break;
        }
      default:
        jj_la1[319] = jj_gen;
        ;
      }
colDataType.setDataType(tk.image + (tk2!=null?" " + tk2.image:""));
      break;
      }
    case K_DOUBLE:{
      tk = jj_consume_token(K_DOUBLE);
      if (jj_2_95(2)) {
        tk2 = jj_consume_token(K_PRECISION);
      } else {
        ;
      }
colDataType.setDataType(tk.image + (tk2!=null?" " + tk2.image:""));
      break;
      }
    case K_DATETIMELITERAL:
    case K_INTERVAL:
    case K_XML:
    case DT_ZONE:
    case S_IDENTIFIER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case K_DATETIMELITERAL:{
        tk = jj_consume_token(K_DATETIMELITERAL);
        break;
        }
      case K_XML:{
        tk = jj_consume_token(K_XML);
        break;
        }
      case K_INTERVAL:{
        tk = jj_consume_token(K_INTERVAL);
        break;
        }
      case DT_ZONE:{
        tk = jj_consume_token(DT_ZONE);
        break;
        }
      default:
        jj_la1[320] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
colDataType.setDataType(tk.image);
      break;
      }
    case K_UNSIGNED:{
      tk = jj_consume_token(K_UNSIGNED);
      tk2 = jj_consume_token(S_IDENTIFIER);
colDataType.setDataType(tk.image + " " + tk2.image);
      break;
      }
    default:
      jj_la1[321] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_96(2)) {
      jj_consume_token(184);
      label_72:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_LONG:
        case S_IDENTIFIER:
        case S_CHAR_LITERAL:{
          ;
          break;
          }
        default:
          jj_la1[322] = jj_gen;
          break label_72;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_LONG:{
          tk = jj_consume_token(S_LONG);
          break;
          }
        case S_CHAR_LITERAL:{
          tk = jj_consume_token(S_CHAR_LITERAL);
          break;
          }
        case S_IDENTIFIER:{
          tk = jj_consume_token(S_IDENTIFIER);
          break;
          }
        default:
          jj_la1[323] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
argumentsStringList.add(tk.image);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 183:{
          jj_consume_token(183);

          break;
          }
        default:
          jj_la1[324] = jj_gen;
          ;
        }
      }
      jj_consume_token(185);
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 222:{
      label_73:
      while (true) {
        jj_consume_token(222);
tk=null;
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_LONG:{
          tk = jj_consume_token(S_LONG);
          break;
          }
        default:
          jj_la1[325] = jj_gen;
          ;
        }
array.add(tk!=null?Integer.valueOf(tk.image):null);
        jj_consume_token(223);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 222:{
          ;
          break;
          }
        default:
          jj_la1[326] = jj_gen;
          break label_73;
        }
      }
colDataType.setArrayData(array);
      break;
      }
    default:
      jj_la1[327] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_CHARACTER:{
      jj_consume_token(K_CHARACTER);
      jj_consume_token(K_SET);
      tk = jj_consume_token(S_IDENTIFIER);
colDataType.setCharacterSet(tk.image);
      break;
      }
    default:
      jj_la1[328] = jj_gen;
      ;
    }
if (argumentsStringList.size() > 0)
            colDataType.setArgumentsStringList(argumentsStringList);
        return colDataType;
}

  final public CreateView CreateView() throws ParseException {CreateView createView = new CreateView();
    Table view = null;
    SelectBody select = null;
    List<String> columnNames = null;
    jj_consume_token(K_CREATE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_OR:{
      jj_consume_token(K_OR);
      jj_consume_token(K_REPLACE);
createView.setOrReplace(true);
      break;
      }
    default:
      jj_la1[329] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FORCE:
    case K_NO:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NO:{
        jj_consume_token(K_NO);
        jj_consume_token(K_FORCE);
createView.setForce(ForceOption.NO_FORCE);
        break;
        }
      case K_FORCE:{
        jj_consume_token(K_FORCE);
createView.setForce(ForceOption.FORCE);
        break;
        }
      default:
        jj_la1[330] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[331] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_TEMP:
    case K_TEMPORARY:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_TEMP:{
        jj_consume_token(K_TEMP);
createView.setTemporary(TemporaryOption.TEMP);
        break;
        }
      case K_TEMPORARY:{
        jj_consume_token(K_TEMPORARY);
createView.setTemporary(TemporaryOption.TEMPORARY);
        break;
        }
      default:
        jj_la1[332] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[333] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_MATERIALIZED:{
      jj_consume_token(K_MATERIALIZED);
createView.setMaterialized(true);
      break;
      }
    default:
      jj_la1[334] = jj_gen;
      ;
    }
    jj_consume_token(K_VIEW);
    view = Table();
createView.setView(view);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 184:{
      columnNames = ColumnsNamesList();
createView.setColumnNames(columnNames);
      break;
      }
    default:
      jj_la1[335] = jj_gen;
      ;
    }
    jj_consume_token(K_AS);
    select = SelectBody();
createView.setSelectBody(select);
return createView;
}

  final public AlterView AlterView() throws ParseException {AlterView alterView = new AlterView();
    Table view = null;
    SelectBody select = null;
    List<String> columnNames = null;
    jj_consume_token(K_ALTER);
    jj_consume_token(K_VIEW);
    view = Table();
alterView.setView(view);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 184:{
      columnNames = ColumnsNamesList();
alterView.setColumnNames(columnNames);
      break;
      }
    default:
      jj_la1[336] = jj_gen;
      ;
    }
    jj_consume_token(K_AS);
    select = SelectBody();
alterView.setSelectBody(select);
return alterView;
}

  final public List<String> CreateParameter() throws ParseException {String retval = "";
    Token tk = null;
    Token tk2 = null;
    StringBuilder identifier = new StringBuilder("");
    Expression exp = null;
    List<String> param = new ArrayList<String>();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[337] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
identifier.append(tk.image);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 187:{
        jj_consume_token(187);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_IDENTIFIER:{
          tk2 = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case S_QUOTED_IDENTIFIER:{
          tk2 = jj_consume_token(S_QUOTED_IDENTIFIER);
          break;
          }
        default:
          jj_la1[338] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
identifier.append("."); identifier.append(tk2.image);
        break;
        }
      default:
        jj_la1[339] = jj_gen;
        ;
      }
param.add(identifier.toString());
      break;
      }
    case K_NULL:{
      tk = jj_consume_token(K_NULL);
param.add(tk.image);
      break;
      }
    case K_NOT:{
      tk = jj_consume_token(K_NOT);
param.add(tk.image);
      break;
      }
    case K_PRIMARY:{
      tk = jj_consume_token(K_PRIMARY);
param.add(tk.image);
      break;
      }
    case K_FOREIGN:{
      tk = jj_consume_token(K_FOREIGN);
param.add(tk.image);
      break;
      }
    case K_REFERENCES:{
      tk = jj_consume_token(K_REFERENCES);
param.add(tk.image);
      break;
      }
    case K_KEY:{
      tk = jj_consume_token(K_KEY);
param.add(tk.image);
      break;
      }
    case S_CHAR_LITERAL:{
      tk = jj_consume_token(S_CHAR_LITERAL);
param.add(tk.image);
      break;
      }
    case S_DOUBLE:
    case S_LONG:
    case 190:
    case 202:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 190:
      case 202:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 190:{
          jj_consume_token(190);
retval = "+";
          break;
          }
        case 202:{
          jj_consume_token(202);
retval = "-";
          break;
          }
        default:
          jj_la1[340] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[341] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_LONG:{
        tk = jj_consume_token(S_LONG);
retval += tk.image;
        break;
        }
      case S_DOUBLE:{
        tk = jj_consume_token(S_DOUBLE);
retval += tk.image;
        break;
        }
      default:
        jj_la1[342] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
param.add(retval);
      break;
      }
    case K_ON:{
      tk = jj_consume_token(K_ON);
param.add(tk.image);
      break;
      }
    case K_COMMIT:{
      tk = jj_consume_token(K_COMMIT);
param.add(tk.image);
      break;
      }
    case K_ROWS:{
      tk = jj_consume_token(K_ROWS);
param.add(tk.image);
      break;
      }
    case K_UNIQUE:{
      tk = jj_consume_token(K_UNIQUE);
param.add(tk.image);
      break;
      }
    case K_CASCADE:{
      tk = jj_consume_token(K_CASCADE);
param.add(tk.image);
      break;
      }
    case K_DELETE:{
      tk = jj_consume_token(K_DELETE);
param.add(tk.image);
      break;
      }
    case K_UPDATE:{
      tk = jj_consume_token(K_UPDATE);
param.add(tk.image);
      break;
      }
    case K_TIME_KEY_EXPR:{
      tk = jj_consume_token(K_TIME_KEY_EXPR);
param.add(new TimeKeyExpression(tk.image).toString());
      break;
      }
    case 182:{
      jj_consume_token(182);
param.add("=");
      break;
      }
    default:
      jj_la1[343] = jj_gen;
      if (jj_2_97(3)) {
        jj_consume_token(K_USING);
        jj_consume_token(K_INDEX);
        jj_consume_token(K_TABLESPACE);
        retval = RelObjectName();
param.add("USING"); param.add("INDEX"); param.add("TABLESPACE"); param.add(retval);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_TABLESPACE:{
          jj_consume_token(K_TABLESPACE);
          retval = RelObjectName();
param.add("TABLESPACE"); param.add(retval);
          break;
          }
        case 184:{
          retval = AList();
param.add(retval);
          break;
          }
        case K_CHECK:{
          jj_consume_token(K_CHECK);
          jj_consume_token(184);
          exp = Expression();
          jj_consume_token(185);
param.add("CHECK"); param.add("(" + exp.toString() + ")");
          break;
          }
        case K_CONSTRAINT:{
          tk = jj_consume_token(K_CONSTRAINT);
param.add(tk.image);
          break;
          }
        case K_WITH:{
          tk = jj_consume_token(K_WITH);
param.add(tk.image);
          break;
          }
        case K_EXCLUDE:{
          tk = jj_consume_token(K_EXCLUDE);
param.add(tk.image);
          break;
          }
        case K_WHERE:{
          tk = jj_consume_token(K_WHERE);
param.add(tk.image);
          break;
          }
        case K_UNSIGNED:{
          tk = jj_consume_token(K_UNSIGNED);
param.add(tk.image);
          break;
          }
        case K_TEMP:{
          tk = jj_consume_token(K_TEMP);
param.add(tk.image);
          break;
          }
        case K_TEMPORARY:{
          tk = jj_consume_token(K_TEMPORARY);
param.add(tk.image);
          break;
          }
        default:
          jj_la1[344] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
return param;
}

  final public String AList() throws ParseException {StringBuilder retval = new StringBuilder("(");
    Token tk = null;
    Token tk2 = null;
    jj_consume_token(184);
    label_74:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:{
        ;
        break;
        }
      default:
        jj_la1[345] = jj_gen;
        break label_74;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_LONG:{
        tk = jj_consume_token(S_LONG);
        break;
        }
      case S_DOUBLE:{
        tk = jj_consume_token(S_DOUBLE);
        break;
        }
      case S_CHAR_LITERAL:{
        tk = jj_consume_token(S_CHAR_LITERAL);
        break;
        }
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[346] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
retval.append(tk.image);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 182:
      case 183:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 183:{
          jj_consume_token(183);
retval.append(",");
          break;
          }
        case 182:{
          jj_consume_token(182);
retval.append("=");
          break;
          }
        default:
          jj_la1[347] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[348] = jj_gen;
        ;
      }
    }
    jj_consume_token(185);
retval.append(")");
        return retval.toString();
}

  final public List<String> ColumnsNamesList() throws ParseException {List<String> retval = new ArrayList<String>();
    Token tk = null;
    jj_consume_token(184);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      tk = jj_consume_token(S_IDENTIFIER);
      break;
      }
    case S_QUOTED_IDENTIFIER:{
      tk = jj_consume_token(S_QUOTED_IDENTIFIER);
      break;
      }
    default:
      jj_la1[349] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
retval.add(tk.image);
    label_75:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 183:{
        ;
        break;
        }
      default:
        jj_la1[350] = jj_gen;
        break label_75;
      }
      jj_consume_token(183);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[351] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
retval.add(tk.image);
    }
    jj_consume_token(185);
return retval;
}

  final public Drop Drop() throws ParseException {Drop drop = new Drop();
    Token tk = null;
    Table name;
    List<String> dropArgs = new ArrayList<String>();
    jj_consume_token(K_DROP);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      tk = jj_consume_token(S_IDENTIFIER);
      break;
      }
    case K_TABLE:{
      tk = jj_consume_token(K_TABLE);
      break;
      }
    case K_INDEX:{
      tk = jj_consume_token(K_INDEX);
      break;
      }
    case K_VIEW:{
      tk = jj_consume_token(K_VIEW);
      break;
      }
    default:
      jj_la1[352] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
drop.setType(tk.image);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_IF:{
      jj_consume_token(K_IF);
      jj_consume_token(K_EXISTS);
drop.setIfExists(true);
      break;
      }
    default:
      jj_la1[353] = jj_gen;
      ;
    }
    name = Table();
drop.setName(name);
    label_76:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CASCADE:
      case K_RESTRICT:
      case S_IDENTIFIER:{
        ;
        break;
        }
      default:
        jj_la1[354] = jj_gen;
        break label_76;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case K_CASCADE:{
        tk = jj_consume_token(K_CASCADE);
        break;
        }
      case K_RESTRICT:{
        tk = jj_consume_token(K_RESTRICT);
        break;
        }
      default:
        jj_la1[355] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
dropArgs.add(tk.image);
    }
if (dropArgs.size() > 0)
            drop.setParameters(dropArgs);
        return drop;
}

  final public Truncate Truncate() throws ParseException {Truncate truncate = new Truncate();
    Table table;
    jj_consume_token(K_TRUNCATE);
    jj_consume_token(K_TABLE);
    table = Table();
truncate.setTable(table);
return truncate;
}

  final public AlterExpression.ColumnDataType AlterExpressionColumnDataType() throws ParseException {String columnName = null;
    ColDataType dataType = null;
    List<String> columnSpecs = null;
    List<String> parameter = null;
    columnName = RelObjectName();
    dataType = ColDataType();
columnSpecs = new ArrayList();
    label_77:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CASCADE:
      case K_CHECK:
      case K_COMMIT:
      case K_CONSTRAINT:
      case K_DELETE:
      case K_EXCLUDE:
      case K_FOREIGN:
      case K_KEY:
      case K_NOT:
      case K_NULL:
      case K_ON:
      case K_PRIMARY:
      case K_REFERENCES:
      case K_ROWS:
      case K_TABLESPACE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_UNIQUE:
      case K_UPDATE:
      case K_USING:
      case K_UNSIGNED:
      case K_WHERE:
      case K_WITH:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 182:
      case 184:
      case 190:
      case 202:{
        ;
        break;
        }
      default:
        jj_la1[356] = jj_gen;
        break label_77;
      }
      parameter = CreateParameter();
columnSpecs.addAll(parameter);
    }
return new AlterExpression.ColumnDataType(columnName, dataType, columnSpecs);
}

  final public List<ConstraintState> AlterExpressionConstraintState() throws ParseException {List<ConstraintState> retval = new ArrayList<ConstraintState>();
    label_78:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DEFERRABLE:
      case K_DISABLE:
      case K_ENABLE:
      case K_NOT:
      case K_NOVALIDATE:
      case K_VALIDATE:{
        ;
        break;
        }
      default:
        jj_la1[357] = jj_gen;
        break label_78;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DEFERRABLE:{
        jj_consume_token(K_DEFERRABLE);
retval.add(new DeferrableConstraint(false));
        break;
        }
      case K_NOT:{
        jj_consume_token(K_NOT);
        jj_consume_token(K_DEFERRABLE);
retval.add(new DeferrableConstraint(true));
        break;
        }
      case K_VALIDATE:{
        jj_consume_token(K_VALIDATE);
retval.add(new ValidateConstraint(false));
        break;
        }
      case K_NOVALIDATE:{
        jj_consume_token(K_NOVALIDATE);
retval.add(new ValidateConstraint(true));
        break;
        }
      case K_ENABLE:{
        jj_consume_token(K_ENABLE);
retval.add(new EnableConstraint(false));
        break;
        }
      case K_DISABLE:{
        jj_consume_token(K_DISABLE);
retval.add(new EnableConstraint(true));
        break;
        }
      default:
        jj_la1[358] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return retval;
}

  final public AlterExpression AlterExpression() throws ParseException {AlterExpression alterExp = new AlterExpression();
    Token tk;
    Token tk2 = null;
    String sk3 = null;
    ColDataType dataType;
    List<String> columnNames = null;
    List<ConstraintState> constraints = null;
    ForeignKeyIndex fkIndex = null;
    NamedConstraint index = null;
    Table fkTable = null;
    AlterExpression.ColumnDataType alterExpressionColumnDataType = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ADD:
    case K_MODIFY:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ADD:{
        jj_consume_token(K_ADD);
alterExp.setOperation(AlterOperation.ADD);
        break;
        }
      case K_MODIFY:{
        jj_consume_token(K_MODIFY);
alterExp.setOperation(AlterOperation.MODIFY);
        break;
        }
      default:
        jj_la1[359] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_99(2)) {
        jj_consume_token(K_PRIMARY);
        jj_consume_token(K_KEY);
        columnNames = ColumnsNamesList();
alterExp.setPkColumns(columnNames);
        constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ACTION:
        case K_ANY:
        case K_CASCADE:
        case K_CAST:
        case K_COLUMN:
        case K_COMMIT:
        case K_DATETIMELITERAL:
        case K_DO:
        case K_ENABLE:
        case K_END:
        case K_EXTRACT:
        case K_FIRST:
        case K_FOLLOWING:
        case K_INDEX:
        case K_INSERT:
        case K_KEY:
        case K_LAST:
        case K_MATERIALIZED:
        case K_NO:
        case K_NULLS:
        case K_OPEN:
        case K_OVER:
        case K_PARTITION:
        case K_PERCENT:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_RANGE:
        case K_REPLACE:
        case K_ROW:
        case K_ROWS:
        case K_SEPARATOR:
        case K_SIBLINGS:
        case K_TABLE:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TRUNCATE:
        case K_UNSIGNED:
        case K_VALUE:
        case K_VALUES:
        case K_XML:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:{
          if (jj_2_98(2)) {
            jj_consume_token(K_COLUMN);
          } else {
            ;
          }
          alterExpressionColumnDataType = AlterExpressionColumnDataType();
alterExp.addColDataType(alterExpressionColumnDataType);
          break;
          }
        case 184:{
          jj_consume_token(184);
          alterExpressionColumnDataType = AlterExpressionColumnDataType();
alterExp.addColDataType(alterExpressionColumnDataType);
          label_79:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case 183:{
              ;
              break;
              }
            default:
              jj_la1[360] = jj_gen;
              break label_79;
            }
            jj_consume_token(183);
            alterExpressionColumnDataType = AlterExpressionColumnDataType();
alterExp.addColDataType(alterExpressionColumnDataType);
          }
          jj_consume_token(185);
          break;
          }
        case K_UNIQUE:{
          jj_consume_token(K_UNIQUE);
          jj_consume_token(K_KEY);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S_IDENTIFIER:{
            tk = jj_consume_token(S_IDENTIFIER);
            break;
            }
          case S_QUOTED_IDENTIFIER:{
            tk = jj_consume_token(S_QUOTED_IDENTIFIER);
            break;
            }
          default:
            jj_la1[361] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          columnNames = ColumnsNamesList();
alterExp.setUkName(tk.image); alterExp.setUkColumns(columnNames);
          break;
          }
        case K_FOREIGN:{
          jj_consume_token(K_FOREIGN);
          jj_consume_token(K_KEY);
          columnNames = ColumnsNamesList();
alterExp.setFkColumns(columnNames);
          jj_consume_token(K_REFERENCES);
          tk = jj_consume_token(S_IDENTIFIER);
          columnNames = ColumnsNamesList();
alterExp.setFkSourceTable(tk.image); alterExp.setFkSourceColumns(columnNames);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ON:{
            jj_consume_token(K_ON);
            jj_consume_token(K_DELETE);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_CASCADE:{
              jj_consume_token(K_CASCADE);
alterExp.setOnDeleteCascade(true);
              break;
              }
            case K_RESTRICT:{
              jj_consume_token(K_RESTRICT);
alterExp.setOnDeleteRestrict(true);
              break;
              }
            case K_SET:{
              jj_consume_token(K_SET);
              jj_consume_token(K_NULL);
alterExp.setOnDeleteSetNull(true);
              break;
              }
            default:
              jj_la1[362] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
            }
          default:
            jj_la1[363] = jj_gen;
            ;
          }
          break;
          }
        case K_CONSTRAINT:{
          jj_consume_token(K_CONSTRAINT);
          sk3 = RelObjectName();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_FOREIGN:{
            tk = jj_consume_token(K_FOREIGN);
            tk2 = jj_consume_token(K_KEY);
            columnNames = ColumnsNamesList();
fkIndex = new ForeignKeyIndex();
                    fkIndex.setName(sk3);
                    fkIndex.setType(tk.image + " " + tk2.image);
                    fkIndex.setColumnsNames(columnNames);
            jj_consume_token(K_REFERENCES);
            fkTable = Table();
            columnNames = ColumnsNamesList();
fkIndex.setTable(fkTable);
                    fkIndex.setReferencedColumnNames(columnNames);
                    alterExp.setIndex(fkIndex);
            constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
            break;
            }
          case K_PRIMARY:{
            tk = jj_consume_token(K_PRIMARY);
            tk2 = jj_consume_token(K_KEY);
            columnNames = ColumnsNamesList();
index = new NamedConstraint();
                    index.setName(sk3);
                    index.setType(tk.image + " " + tk2.image);
                    index.setColumnsNames(columnNames);
                    alterExp.setIndex(index);
            constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
            break;
            }
          case K_CHECK:{
            jj_consume_token(K_CHECK);
Expression exp = null;
            label_80:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case 184:{
                ;
                break;
                }
              default:
                jj_la1[364] = jj_gen;
                break label_80;
              }
              jj_consume_token(184);
              exp = Expression();
              jj_consume_token(185);
            }
CheckConstraint checkCs = new CheckConstraint();
                checkCs.setName(sk3);
                checkCs.setExpression(exp);
                alterExp.setIndex(checkCs);
            break;
            }
          case K_UNIQUE:{
            tk = jj_consume_token(K_UNIQUE);
            tk2 = jj_consume_token(K_KEY);
            columnNames = ColumnsNamesList();
index = new NamedConstraint();
                      index.setName(sk3);
                      index.setType(tk.image + " " + tk2.image);
                      index.setColumnsNames(columnNames);
                      alterExp.setIndex(index);
            constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
            break;
            }
          case K_KEY:{
            tk = jj_consume_token(K_KEY);
            columnNames = ColumnsNamesList();
index = new NamedConstraint();
                      index.setName(sk3);
                      index.setType(tk.image);
                      index.setColumnsNames(columnNames);
                      alterExp.setIndex(index);
            constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
            break;
            }
          default:
            jj_la1[365] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[366] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    case K_DROP:{
      jj_consume_token(K_DROP);
alterExp.setOperation(AlterOperation.DROP);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COLUMN:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:{
        if (jj_2_100(2)) {
          jj_consume_token(K_COLUMN);
        } else {
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_IDENTIFIER:{
          tk = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case S_QUOTED_IDENTIFIER:{
          tk = jj_consume_token(S_QUOTED_IDENTIFIER);
          break;
          }
        default:
          jj_la1[367] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
alterExp.setColumnName(tk.image);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_CASCADE:{
          tk = jj_consume_token(K_CASCADE);
alterExp.addParameters(tk.image);
          break;
          }
        default:
          jj_la1[368] = jj_gen;
          ;
        }
        break;
        }
      case K_CONSTRAINT:{
        jj_consume_token(K_CONSTRAINT);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_IDENTIFIER:{
          tk = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case S_QUOTED_IDENTIFIER:{
          tk = jj_consume_token(S_QUOTED_IDENTIFIER);
          break;
          }
        default:
          jj_la1[369] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
alterExp.setConstraintName(tk.image);
        break;
        }
      default:
        jj_la1[370] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[371] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return alterExp;
}

  final public Alter AlterTable() throws ParseException {Alter alter = new Alter();
    Table table;
    AlterExpression alterExp;
    jj_consume_token(K_ALTER);
    jj_consume_token(K_TABLE);
    table = Table();
alter.setTable(table);
    alterExp = AlterExpression();
alter.addAlterExpression(alterExp);
    label_81:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 183:{
        ;
        break;
        }
      default:
        jj_la1[372] = jj_gen;
        break label_81;
      }
      jj_consume_token(183);
      alterExp = AlterExpression();
alter.addAlterExpression(alterExp);
    }
return alter;
}

  final public Wait Wait() throws ParseException {Wait wait = new Wait();
    Token token = null;
    jj_consume_token(K_WAIT);
    token = jj_consume_token(S_LONG);
wait.setTimeout(Long.parseLong(token.image));
return wait;
}

  final public Commit Commit() throws ParseException {Commit commit=new Commit();
    jj_consume_token(K_COMMIT);
return commit;
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_7()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_8()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_9()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_10()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_11()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_12()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_13()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_14()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_15()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_16()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_17()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_18()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_19()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_20()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_21()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_22()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_23()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_24()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_25()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_26()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_27()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_28()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_2_29(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_29()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  private boolean jj_2_30(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_30()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  private boolean jj_2_31(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_31()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  private boolean jj_2_32(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_32()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  private boolean jj_2_33(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_33()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  private boolean jj_2_34(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_34()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  private boolean jj_2_35(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_35()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  private boolean jj_2_36(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_36()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  private boolean jj_2_37(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_37()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  private boolean jj_2_38(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_38()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  private boolean jj_2_39(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_39()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  private boolean jj_2_40(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_40()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  private boolean jj_2_41(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_41()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  private boolean jj_2_42(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_42()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  private boolean jj_2_43(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_43()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  private boolean jj_2_44(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_44()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  private boolean jj_2_45(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_45()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  private boolean jj_2_46(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_46()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  private boolean jj_2_47(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_47()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  private boolean jj_2_48(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_48()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  private boolean jj_2_49(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_49()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  private boolean jj_2_50(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_50()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  private boolean jj_2_51(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_51()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  private boolean jj_2_52(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_52()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  private boolean jj_2_53(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_53()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(52, xla); }
  }

  private boolean jj_2_54(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_54()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(53, xla); }
  }

  private boolean jj_2_55(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_55()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(54, xla); }
  }

  private boolean jj_2_56(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_56()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(55, xla); }
  }

  private boolean jj_2_57(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_57()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(56, xla); }
  }

  private boolean jj_2_58(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_58()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(57, xla); }
  }

  private boolean jj_2_59(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_59()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(58, xla); }
  }

  private boolean jj_2_60(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_60()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(59, xla); }
  }

  private boolean jj_2_61(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_61()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(60, xla); }
  }

  private boolean jj_2_62(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_62()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(61, xla); }
  }

  private boolean jj_2_63(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_63()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(62, xla); }
  }

  private boolean jj_2_64(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_64()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(63, xla); }
  }

  private boolean jj_2_65(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_65()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(64, xla); }
  }

  private boolean jj_2_66(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_66()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(65, xla); }
  }

  private boolean jj_2_67(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_67()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(66, xla); }
  }

  private boolean jj_2_68(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_68()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(67, xla); }
  }

  private boolean jj_2_69(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_69()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(68, xla); }
  }

  private boolean jj_2_70(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_70()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(69, xla); }
  }

  private boolean jj_2_71(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_71()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(70, xla); }
  }

  private boolean jj_2_72(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_72()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(71, xla); }
  }

  private boolean jj_2_73(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_73()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(72, xla); }
  }

  private boolean jj_2_74(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_74()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(73, xla); }
  }

  private boolean jj_2_75(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_75()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(74, xla); }
  }

  private boolean jj_2_76(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_76()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(75, xla); }
  }

  private boolean jj_2_77(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_77()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(76, xla); }
  }

  private boolean jj_2_78(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_78()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(77, xla); }
  }

  private boolean jj_2_79(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_79()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(78, xla); }
  }

  private boolean jj_2_80(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_80()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(79, xla); }
  }

  private boolean jj_2_81(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_81()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(80, xla); }
  }

  private boolean jj_2_82(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_82()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(81, xla); }
  }

  private boolean jj_2_83(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_83()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(82, xla); }
  }

  private boolean jj_2_84(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_84()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(83, xla); }
  }

  private boolean jj_2_85(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_85()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(84, xla); }
  }

  private boolean jj_2_86(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_86()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(85, xla); }
  }

  private boolean jj_2_87(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_87()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(86, xla); }
  }

  private boolean jj_2_88(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_88()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(87, xla); }
  }

  private boolean jj_2_89(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_89()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(88, xla); }
  }

  private boolean jj_2_90(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_90()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(89, xla); }
  }

  private boolean jj_2_91(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_91()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(90, xla); }
  }

  private boolean jj_2_92(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_92()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(91, xla); }
  }

  private boolean jj_2_93(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_93()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(92, xla); }
  }

  private boolean jj_2_94(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_94()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(93, xla); }
  }

  private boolean jj_2_95(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_95()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(94, xla); }
  }

  private boolean jj_2_96(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_96()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(95, xla); }
  }

  private boolean jj_2_97(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_97()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(96, xla); }
  }

  private boolean jj_2_98(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_98()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(97, xla); }
  }

  private boolean jj_2_99(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_99()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(98, xla); }
  }

  private boolean jj_2_100(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_100()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(99, xla); }
  }

  private boolean jj_3R_107()
 {
    if (jj_scan_token(184)) return true;
    if (jj_scan_token(K_VALUES)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_40()) {
    jj_scanpos = xsp;
    if (jj_3R_209()) return true;
    }
    if (jj_scan_token(185)) return true;
    xsp = jj_scanpos;
    if (jj_3R_210()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_37()
 {
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3R_391()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_37()) {
    jj_scanpos = xsp;
    if (jj_3R_437()) return true;
    }
    return false;
  }

  private boolean jj_3_89()
 {
    if (jj_scan_token(K_INDEX)) return true;
    if (jj_3R_95()) return true;
    if (jj_3R_150()) return true;
    return false;
  }

  private boolean jj_3_38()
 {
    if (jj_3R_106()) return true;
    return false;
  }

  private boolean jj_3_36()
 {
    if (jj_3R_104()) return true;
    return false;
  }

  private boolean jj_3R_373()
 {
    if (jj_scan_token(183)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_89()) {
    jj_scanpos = xsp;
    if (jj_3_90()) {
    jj_scanpos = xsp;
    if (jj_3_91()) {
    jj_scanpos = xsp;
    if (jj_3_92()) {
    jj_scanpos = xsp;
    if (jj_3_93()) {
    jj_scanpos = xsp;
    if (jj_3R_422()) {
    jj_scanpos = xsp;
    if (jj_3R_423()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_34()
 {
    if (jj_3R_102()) return true;
    return false;
  }

  private boolean jj_3R_389()
 {
    if (jj_3R_436()) return true;
    return false;
  }

  private boolean jj_3R_390()
 {
    if (jj_3R_149()) return true;
    return false;
  }

  private boolean jj_3R_388()
 {
    if (jj_3R_159()) return true;
    return false;
  }

  private boolean jj_3R_435()
 {
    if (jj_3R_206()) return true;
    return false;
  }

  private boolean jj_3R_559()
 {
    if (jj_scan_token(183)) return true;
    if (jj_3R_159()) return true;
    return false;
  }

  private boolean jj_3R_387()
 {
    if (jj_3R_104()) return true;
    return false;
  }

  private boolean jj_3_35()
 {
    if (jj_3R_103()) return true;
    return false;
  }

  private boolean jj_3R_434()
 {
    if (jj_3R_102()) return true;
    return false;
  }

  private boolean jj_3R_372()
 {
    if (jj_3R_283()) return true;
    return false;
  }

  private boolean jj_3R_386()
 {
    if (jj_scan_token(184)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_434()) {
    jj_scanpos = xsp;
    if (jj_3_35()) {
    jj_scanpos = xsp;
    if (jj_3R_435()) return true;
    }
    }
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_166()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_287()) {
    jj_scanpos = xsp;
    if (jj_3R_288()) return true;
    }
    return false;
  }

  private boolean jj_3R_287()
 {
    if (jj_scan_token(184)) return true;
    if (jj_3R_95()) return true;
    if (jj_3R_371()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_372()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_373()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(185)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_374()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_39()
 {
    if (jj_3R_107()) return true;
    return false;
  }

  private boolean jj_3R_165()
 {
    if (jj_scan_token(K_IF)) return true;
    if (jj_scan_token(K_NOT)) return true;
    if (jj_scan_token(K_EXISTS)) return true;
    return false;
  }

  private boolean jj_3R_164()
 {
    if (jj_3R_283()) return true;
    return false;
  }

  private boolean jj_3R_304()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_386()) {
    jj_scanpos = xsp;
    if (jj_3R_387()) {
    jj_scanpos = xsp;
    if (jj_3R_388()) {
    jj_scanpos = xsp;
    if (jj_3R_389()) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_390()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_391()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_38()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_303()
 {
    if (jj_3R_107()) return true;
    return false;
  }

  private boolean jj_3R_163()
 {
    if (jj_scan_token(K_UNLOGGED)) return true;
    return false;
  }

  private boolean jj_3R_84()
 {
    if (jj_scan_token(K_CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_163()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_164()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(K_TABLE)) return true;
    xsp = jj_scanpos;
    if (jj_3R_165()) jj_scanpos = xsp;
    if (jj_3R_159()) return true;
    xsp = jj_scanpos;
    if (jj_3R_166()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_206()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_303()) {
    jj_scanpos = xsp;
    if (jj_3R_304()) return true;
    }
    return false;
  }

  private boolean jj_3R_315()
 {
    if (jj_scan_token(186)) return true;
    return false;
  }

  private boolean jj_3R_517()
 {
    if (jj_scan_token(K_INTO)) return true;
    if (jj_3R_159()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_559()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_533()
 {
    if (jj_3R_574()) return true;
    return false;
  }

  private boolean jj_3_33()
 {
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3R_532()
 {
    if (jj_3R_172()) return true;
    return false;
  }

  private boolean jj_3_32()
 {
    if (jj_scan_token(K_ANY)) return true;
    return false;
  }

  private boolean jj_3R_162()
 {
    if (jj_3R_283()) return true;
    return false;
  }

  private boolean jj_3R_286()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_370()) {
    jj_scanpos = xsp;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(32)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_370()
 {
    if (jj_3R_283()) return true;
    return false;
  }

  private boolean jj_3R_105()
 {
    if (jj_scan_token(K_PIVOT)) return true;
    if (jj_scan_token(K_XML)) return true;
    if (jj_scan_token(184)) return true;
    if (jj_3R_530()) return true;
    if (jj_scan_token(K_FOR)) return true;
    if (jj_3R_531()) return true;
    if (jj_scan_token(K_IN)) return true;
    if (jj_scan_token(184)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_32()) {
    jj_scanpos = xsp;
    if (jj_3R_532()) {
    jj_scanpos = xsp;
    if (jj_3_33()) {
    jj_scanpos = xsp;
    if (jj_3R_533()) return true;
    }
    }
    }
    if (jj_scan_token(185)) return true;
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_161()
 {
    if (jj_scan_token(183)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(176)) {
    jj_scanpos = xsp;
    if (jj_scan_token(180)) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_286()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_160()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_285()) {
    jj_scanpos = xsp;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(32)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_285()
 {
    if (jj_3R_283()) return true;
    return false;
  }

  private boolean jj_3R_535()
 {
    if (jj_3R_149()) return true;
    return false;
  }

  private boolean jj_3R_534()
 {
    if (jj_3R_574()) return true;
    return false;
  }

  private boolean jj_3_31()
 {
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3_85()
 {
    if (jj_3R_126()) return true;
    return false;
  }

  private boolean jj_3R_490()
 {
    if (jj_scan_token(K_PIVOT)) return true;
    if (jj_scan_token(184)) return true;
    if (jj_3R_530()) return true;
    if (jj_scan_token(K_FOR)) return true;
    if (jj_3R_531()) return true;
    if (jj_scan_token(K_IN)) return true;
    if (jj_scan_token(184)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_31()) {
    jj_scanpos = xsp;
    if (jj_3R_534()) return true;
    }
    if (jj_scan_token(185)) return true;
    if (jj_scan_token(185)) return true;
    xsp = jj_scanpos;
    if (jj_3R_535()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_158()
 {
    if (jj_3R_283()) return true;
    return false;
  }

  private boolean jj_3R_83()
 {
    if (jj_scan_token(K_CREATE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_158()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(K_INDEX)) return true;
    if (jj_3R_95()) return true;
    if (jj_scan_token(K_ON)) return true;
    if (jj_3R_159()) return true;
    if (jj_scan_token(184)) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(176)) {
    jj_scanpos = xsp;
    if (jj_scan_token(180)) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_160()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_161()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(185)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_162()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_590()
 {
    if (jj_scan_token(183)) return true;
    if (jj_3R_589()) return true;
    return false;
  }

  private boolean jj_3R_574()
 {
    if (jj_3R_589()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_590()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_208()
 {
    if (jj_3R_299()) return true;
    return false;
  }

  private boolean jj_3R_103()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_208()) jj_scanpos = xsp;
    if (jj_3R_172()) return true;
    return false;
  }

  private boolean jj_3_86()
 {
    if (jj_3R_149()) return true;
    return false;
  }

  private boolean jj_3R_594()
 {
    if (jj_3R_149()) return true;
    return false;
  }

  private boolean jj_3R_589()
 {
    if (jj_scan_token(184)) return true;
    if (jj_3R_126()) return true;
    if (jj_scan_token(185)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_594()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_104()
 {
    if (jj_3R_120()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_86()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_313()
 {
    if (jj_scan_token(187)) return true;
    if (jj_3R_249()) return true;
    return false;
  }

  private boolean jj_3R_398()
 {
    if (jj_scan_token(K_ALL)) return true;
    return false;
  }

  private boolean jj_3R_205()
 {
    if (jj_scan_token(183)) return true;
    if (jj_3R_204()) return true;
    return false;
  }

  private boolean jj_3R_101()
 {
    if (jj_3R_204()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_205()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_571()
 {
    if (jj_scan_token(183)) return true;
    if (jj_3R_570()) return true;
    return false;
  }

  private boolean jj_3R_132()
 {
    if (jj_scan_token(184)) return true;
    if (jj_3R_268()) return true;
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_530()
 {
    if (jj_3R_570()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_571()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_599()
 {
    if (jj_scan_token(K_SEPARATOR)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_598()
 {
    if (jj_3R_334()) return true;
    return false;
  }

  private boolean jj_3R_588()
 {
    if (jj_scan_token(183)) return true;
    if (jj_3R_86()) return true;
    return false;
  }

  private boolean jj_3R_573()
 {
    if (jj_3R_86()) return true;
    return false;
  }

  private boolean jj_3R_595()
 {
    if (jj_scan_token(K_DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_572()
 {
    if (jj_scan_token(184)) return true;
    if (jj_3R_86()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_588()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_587()
 {
    if (jj_3R_149()) return true;
    return false;
  }

  private boolean jj_3R_531()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_572()) {
    jj_scanpos = xsp;
    if (jj_3R_573()) return true;
    }
    return false;
  }

  private boolean jj_3R_297()
 {
    if (jj_scan_token(K_GROUP_CONCAT)) return true;
    if (jj_scan_token(184)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_595()) jj_scanpos = xsp;
    if (jj_3R_126()) return true;
    xsp = jj_scanpos;
    if (jj_3R_598()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_599()) jj_scanpos = xsp;
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_570()
 {
    if (jj_3R_120()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_587()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_253()
 {
    if (jj_3R_317()) return true;
    return false;
  }

  private boolean jj_3R_314()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_397()) {
    jj_scanpos = xsp;
    if (jj_3R_398()) return true;
    }
    return false;
  }

  private boolean jj_3R_316()
 {
    if (jj_3R_103()) return true;
    return false;
  }

  private boolean jj_3R_397()
 {
    if (jj_scan_token(K_DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_251()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_314()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_85()) {
    jj_scanpos = xsp;
    if (jj_3R_315()) {
    jj_scanpos = xsp;
    if (jj_3R_316()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_491()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(176)) {
    jj_scanpos = xsp;
    if (jj_scan_token(180)) return true;
    }
    return false;
  }

  private boolean jj_3R_252()
 {
    if (jj_scan_token(187)) return true;
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_250()
 {
    if (jj_scan_token(187)) return true;
    if (jj_3R_249()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_313()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_526()
 {
    if (jj_scan_token(K_DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_282()
 {
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_248()
 {
    if (jj_scan_token(221)) return true;
    return false;
  }

  private boolean jj_3R_120()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_248()) jj_scanpos = xsp;
    if (jj_3R_249()) return true;
    xsp = jj_scanpos;
    if (jj_3R_250()) jj_scanpos = xsp;
    if (jj_scan_token(184)) return true;
    xsp = jj_scanpos;
    if (jj_3R_251()) jj_scanpos = xsp;
    if (jj_scan_token(185)) return true;
    xsp = jj_scanpos;
    if (jj_3R_252()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_253()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(212)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_492()
 {
    if (jj_scan_token(183)) return true;
    if (jj_3R_491()) return true;
    return false;
  }

  private boolean jj_3R_106()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(145)) {
    jj_scanpos = xsp;
    if (jj_scan_token(63)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(66)) {
    jj_scanpos = xsp;
    if (jj_scan_token(76)) return true;
    }
    if (jj_scan_token(184)) return true;
    if (jj_3R_491()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_492()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_603()
 {
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3R_516()
 {
    if (jj_scan_token(183)) return true;
    if (jj_3R_515()) return true;
    return false;
  }

  private boolean jj_3R_593()
 {
    if (jj_3R_133()) return true;
    return false;
  }

  private boolean jj_3R_281()
 {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_280()
 {
    if (jj_scan_token(K_AS)) return true;
    return false;
  }

  private boolean jj_3R_149()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_280()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_281()) {
    jj_scanpos = xsp;
    if (jj_3R_282()) return true;
    }
    return false;
  }

  private boolean jj_3R_525()
 {
    if (jj_scan_token(K_ALL)) return true;
    return false;
  }

  private boolean jj_3R_481()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_525()) {
    jj_scanpos = xsp;
    if (jj_3R_526()) return true;
    }
    return false;
  }

  private boolean jj_3R_100()
 {
    if (jj_3R_159()) return true;
    if (jj_scan_token(187)) return true;
    if (jj_scan_token(186)) return true;
    return false;
  }

  private boolean jj_3R_401()
 {
    if (jj_scan_token(K_ROW)) return true;
    return false;
  }

  private boolean jj_3R_319()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_401()) jj_scanpos = xsp;
    if (jj_scan_token(184)) return true;
    if (jj_3R_126()) return true;
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3_30()
 {
    if (jj_3R_100()) return true;
    return false;
  }

  private boolean jj_3R_410()
 {
    if (jj_scan_token(183)) return true;
    if (jj_3R_393()) return true;
    return false;
  }

  private boolean jj_3_84()
 {
    if (jj_3R_148()) return true;
    return false;
  }

  private boolean jj_3R_558()
 {
    if (jj_3R_204()) return true;
    return false;
  }

  private boolean jj_3R_302()
 {
    if (jj_3R_149()) return true;
    return false;
  }

  private boolean jj_3R_601()
 {
    if (jj_scan_token(K_WHEN)) return true;
    if (jj_3R_87()) return true;
    if (jj_scan_token(K_THEN)) return true;
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3R_557()
 {
    if (jj_3R_100()) return true;
    return false;
  }

  private boolean jj_3R_556()
 {
    if (jj_scan_token(186)) return true;
    return false;
  }

  private boolean jj_3R_515()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_556()) {
    jj_scanpos = xsp;
    if (jj_3R_557()) {
    jj_scanpos = xsp;
    if (jj_3R_558()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_602()
 {
    if (jj_3R_148()) return true;
    return false;
  }

  private boolean jj_3R_583()
 {
    if (jj_scan_token(K_FOLLOWING)) return true;
    return false;
  }

  private boolean jj_3R_204()
 {
    if (jj_3R_87()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_302()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_430()
 {
    if (jj_3R_424()) return true;
    return false;
  }

  private boolean jj_3R_596()
 {
    if (jj_scan_token(K_WHEN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_602()) {
    jj_scanpos = xsp;
    if (jj_3R_603()) return true;
    }
    if (jj_scan_token(K_THEN)) return true;
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3_83()
 {
    if (jj_3R_119()) return true;
    return false;
  }

  private boolean jj_3R_581()
 {
    if (jj_scan_token(K_FOLLOWING)) return true;
    return false;
  }

  private boolean jj_3R_468()
 {
    if (jj_3R_515()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_516()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_600()
 {
    if (jj_3R_601()) return true;
    return false;
  }

  private boolean jj_3R_592()
 {
    if (jj_3R_119()) return true;
    return false;
  }

  private boolean jj_3R_591()
 {
    if (jj_3R_596()) return true;
    return false;
  }

  private boolean jj_3R_578()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_592()) {
    jj_scanpos = xsp;
    if (jj_3R_593()) return true;
    }
    if (jj_3R_600()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_600()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_577()
 {
    Token xsp;
    if (jj_3R_591()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_591()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_441()
 {
    if (jj_scan_token(184)) return true;
    if (jj_3R_468()) return true;
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_597()
 {
    if (jj_scan_token(K_ELSE)) return true;
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3R_440()
 {
    if (jj_scan_token(K_RECURSIVE)) return true;
    return false;
  }

  private boolean jj_3R_393()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_440()) jj_scanpos = xsp;
    if (jj_3R_95()) return true;
    xsp = jj_scanpos;
    if (jj_3R_441()) jj_scanpos = xsp;
    if (jj_scan_token(K_AS)) return true;
    if (jj_scan_token(184)) return true;
    if (jj_3R_172()) return true;
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_295()
 {
    if (jj_scan_token(K_CASE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_577()) {
    jj_scanpos = xsp;
    if (jj_3R_578()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_597()) jj_scanpos = xsp;
    if (jj_scan_token(K_END)) return true;
    return false;
  }

  private boolean jj_3R_299()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_3R_393()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_410()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_29()
 {
    if (jj_scan_token(K_FETCH)) return true;
    return false;
  }

  private boolean jj_3R_333()
 {
    if (jj_scan_token(186)) return true;
    return false;
  }

  private boolean jj_3_28()
 {
    if (jj_scan_token(K_OFFSET)) return true;
    return false;
  }

  private boolean jj_3_27()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    return false;
  }

  private boolean jj_3R_146()
 {
    if (jj_scan_token(K_CAST)) return true;
    if (jj_scan_token(184)) return true;
    if (jj_3R_87()) return true;
    if (jj_scan_token(K_AS)) return true;
    if (jj_3R_371()) return true;
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_451()
 {
    if (jj_scan_token(K_RANGE)) return true;
    return false;
  }

  private boolean jj_3R_429()
 {
    if (jj_scan_token(184)) return true;
    if (jj_3R_172()) return true;
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_384()
 {
    if (jj_3R_433()) return true;
    return false;
  }

  private boolean jj_3R_383()
 {
    if (jj_3R_432()) return true;
    return false;
  }

  private boolean jj_3R_428()
 {
    if (jj_scan_token(K_EXCEPT)) return true;
    return false;
  }

  private boolean jj_3R_379()
 {
    if (jj_3R_424()) return true;
    return false;
  }

  private boolean jj_3R_382()
 {
    if (jj_3R_431()) return true;
    return false;
  }

  private boolean jj_3R_427()
 {
    if (jj_scan_token(K_MINUS)) return true;
    return false;
  }

  private boolean jj_3R_580()
 {
    if (jj_scan_token(K_PRECEDING)) return true;
    return false;
  }

  private boolean jj_3R_381()
 {
    if (jj_3R_334()) return true;
    return false;
  }

  private boolean jj_3R_426()
 {
    if (jj_scan_token(K_INTERSECT)) return true;
    return false;
  }

  private boolean jj_3R_425()
 {
    if (jj_scan_token(K_UNION)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_481()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_380()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_425()) {
    jj_scanpos = xsp;
    if (jj_3R_426()) {
    jj_scanpos = xsp;
    if (jj_3R_427()) {
    jj_scanpos = xsp;
    if (jj_3R_428()) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_429()) {
    jj_scanpos = xsp;
    if (jj_3R_430()) return true;
    }
    return false;
  }

  private boolean jj_3R_582()
 {
    if (jj_scan_token(K_PRECEDING)) return true;
    return false;
  }

  private boolean jj_3R_378()
 {
    if (jj_scan_token(184)) return true;
    if (jj_3R_172()) return true;
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_144()
 {
    if (jj_scan_token(K_EXTRACT)) return true;
    if (jj_scan_token(184)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    if (jj_scan_token(K_FROM)) return true;
    if (jj_3R_87()) return true;
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_545()
 {
    if (jj_3R_87()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_582()) {
    jj_scanpos = xsp;
    if (jj_3R_583()) return true;
    }
    return false;
  }

  private boolean jj_3R_544()
 {
    if (jj_scan_token(K_CURRENT)) return true;
    if (jj_scan_token(K_ROW)) return true;
    return false;
  }

  private boolean jj_3R_293()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_378()) {
    jj_scanpos = xsp;
    if (jj_3R_379()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_380()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_381()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_382()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_383()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_384()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_543()
 {
    if (jj_scan_token(K_UNBOUNDED)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_580()) {
    jj_scanpos = xsp;
    if (jj_3R_581()) return true;
    }
    return false;
  }

  private boolean jj_3R_447()
 {
    if (jj_scan_token(183)) return true;
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3_26()
 {
    if (jj_scan_token(K_WAIT)) return true;
    return false;
  }

  private boolean jj_3R_501()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_543()) {
    jj_scanpos = xsp;
    if (jj_3R_544()) {
    jj_scanpos = xsp;
    if (jj_3R_545()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_25()
 {
    if (jj_scan_token(K_FETCH)) return true;
    return false;
  }

  private boolean jj_3R_524()
 {
    if (jj_3R_564()) return true;
    return false;
  }

  private boolean jj_3_24()
 {
    if (jj_scan_token(K_OFFSET)) return true;
    return false;
  }

  private boolean jj_3R_523()
 {
    if (jj_scan_token(K_OF)) return true;
    if (jj_3R_159()) return true;
    return false;
  }

  private boolean jj_3_23()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    return false;
  }

  private boolean jj_3_22()
 {
    if (jj_scan_token(K_ORDER)) return true;
    if (jj_scan_token(K_BY)) return true;
    return false;
  }

  private boolean jj_3_21()
 {
    if (jj_scan_token(K_ORDER)) return true;
    if (jj_scan_token(K_SIBLINGS)) return true;
    if (jj_scan_token(K_BY)) return true;
    return false;
  }

  private boolean jj_3R_400()
 {
    if (jj_scan_token(K_LAST)) return true;
    return false;
  }

  private boolean jj_3R_480()
 {
    if (jj_scan_token(K_FOR)) return true;
    if (jj_scan_token(K_UPDATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_523()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_524()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_453()
 {
    if (jj_3R_501()) return true;
    return false;
  }

  private boolean jj_3R_479()
 {
    if (jj_3R_433()) return true;
    return false;
  }

  private boolean jj_3R_478()
 {
    if (jj_3R_432()) return true;
    return false;
  }

  private boolean jj_3R_477()
 {
    if (jj_3R_431()) return true;
    return false;
  }

  private boolean jj_3R_476()
 {
    if (jj_3R_334()) return true;
    return false;
  }

  private boolean jj_3R_335()
 {
    if (jj_3R_406()) return true;
    return false;
  }

  private boolean jj_3R_474()
 {
    if (jj_3R_522()) return true;
    return false;
  }

  private boolean jj_3R_475()
 {
    if (jj_3R_334()) return true;
    return false;
  }

  private boolean jj_3R_473()
 {
    if (jj_3R_521()) return true;
    return false;
  }

  private boolean jj_3R_452()
 {
    if (jj_scan_token(K_BETWEEN)) return true;
    if (jj_3R_501()) return true;
    if (jj_scan_token(K_AND)) return true;
    if (jj_3R_501()) return true;
    return false;
  }

  private boolean jj_3R_472()
 {
    if (jj_3R_520()) return true;
    return false;
  }

  private boolean jj_3R_471()
 {
    if (jj_3R_519()) return true;
    return false;
  }

  private boolean jj_3R_450()
 {
    if (jj_scan_token(K_ROWS)) return true;
    return false;
  }

  private boolean jj_3R_406()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_450()) {
    jj_scanpos = xsp;
    if (jj_3R_451()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_452()) {
    jj_scanpos = xsp;
    if (jj_3R_453()) return true;
    }
    return false;
  }

  private boolean jj_3R_403()
 {
    if (jj_scan_token(183)) return true;
    if (jj_3R_87()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_447()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_470()
 {
    if (jj_scan_token(K_FROM)) return true;
    if (jj_3R_206()) return true;
    if (jj_3R_518()) return true;
    return false;
  }

  private boolean jj_3R_551()
 {
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(184)) return true;
    if (jj_3R_468()) return true;
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_469()
 {
    if (jj_3R_517()) return true;
    return false;
  }

  private boolean jj_3R_513()
 {
    if (jj_scan_token(K_SQL_CALC_FOUND_ROWS)) return true;
    return false;
  }

  private boolean jj_3R_467()
 {
    if (jj_3R_514()) return true;
    return false;
  }

  private boolean jj_3R_512()
 {
    if (jj_scan_token(K_UNIQUE)) return true;
    return false;
  }

  private boolean jj_3R_511()
 {
    if (jj_scan_token(K_DISTINCT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_551()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_97()
 {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_277()
 {
    if (jj_3R_334()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_335()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_276()
 {
    if (jj_scan_token(K_PARTITION)) return true;
    if (jj_scan_token(K_BY)) return true;
    if (jj_3R_126()) return true;
    return false;
  }

  private boolean jj_3R_466()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(4)) {
    jj_scanpos = xsp;
    if (jj_3R_511()) {
    jj_scanpos = xsp;
    if (jj_3R_512()) {
    jj_scanpos = xsp;
    if (jj_3R_513()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_275()
 {
    if (jj_scan_token(K_WITHIN)) return true;
    if (jj_scan_token(K_GROUP)) return true;
    return false;
  }

  private boolean jj_3R_399()
 {
    if (jj_scan_token(K_FIRST)) return true;
    return false;
  }

  private boolean jj_3R_331()
 {
    if (jj_scan_token(K_DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_332()
 {
    if (jj_3R_87()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_403()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_20()
 {
    if (jj_3R_99()) return true;
    return false;
  }

  private boolean jj_3R_272()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_331()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_332()) {
    jj_scanpos = xsp;
    if (jj_3R_333()) return true;
    }
    return false;
  }

  private boolean jj_3R_274()
 {
    if (jj_scan_token(K_OVER)) return true;
    return false;
  }

  private boolean jj_3R_465()
 {
    if (jj_3R_510()) return true;
    return false;
  }

  private boolean jj_3R_273()
 {
    if (jj_3R_317()) return true;
    return false;
  }

  private boolean jj_3R_424()
 {
    if (jj_scan_token(K_SELECT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_465()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_20()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_466()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_467()) jj_scanpos = xsp;
    if (jj_3R_468()) return true;
    xsp = jj_scanpos;
    if (jj_3R_469()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_470()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_471()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_472()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_473()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_474()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_475()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_476()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_477()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_478()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_479()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_480()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_143()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    if (jj_scan_token(184)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_272()) jj_scanpos = xsp;
    if (jj_scan_token(185)) return true;
    xsp = jj_scanpos;
    if (jj_3R_273()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_274()) {
    jj_scanpos = xsp;
    if (jj_3R_275()) return true;
    }
    if (jj_scan_token(184)) return true;
    xsp = jj_scanpos;
    if (jj_3R_276()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_277()) jj_scanpos = xsp;
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_98()
 {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_96()
 {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_579()
 {
    if (jj_scan_token(202)) return true;
    return false;
  }

  private boolean jj_3R_317()
 {
    if (jj_scan_token(K_KEEP)) return true;
    if (jj_scan_token(184)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_399()) {
    jj_scanpos = xsp;
    if (jj_3R_400()) return true;
    }
    if (jj_3R_334()) return true;
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_172()
 {
    if (jj_3R_293()) return true;
    return false;
  }

  private boolean jj_3R_300()
 {
    if (jj_3R_149()) return true;
    return false;
  }

  private boolean jj_3R_195()
 {
    if (jj_3R_299()) return true;
    return false;
  }

  private boolean jj_3_82()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_90()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_195()) jj_scanpos = xsp;
    if (jj_3R_172()) return true;
    return false;
  }

  private boolean jj_3R_298()
 {
    if (jj_scan_token(K_INTERVAL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_579()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(170)) {
    jj_scanpos = xsp;
    if (jj_scan_token(169)) {
    jj_scanpos = xsp;
    if (jj_scan_token(179)) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3_82()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_196()
 {
    if (jj_3R_159()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_300()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_339()
 {
    if (jj_scan_token(220)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_338()
 {
    if (jj_scan_token(219)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_337()
 {
    if (jj_scan_token(218)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_278()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_336()) {
    jj_scanpos = xsp;
    if (jj_3R_337()) {
    jj_scanpos = xsp;
    if (jj_3R_338()) {
    jj_scanpos = xsp;
    if (jj_3R_339()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_336()
 {
    if (jj_scan_token(217)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_145()
 {
    if (jj_3R_86()) return true;
    Token xsp;
    if (jj_3R_278()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_278()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_284()
 {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3_19()
 {
    if (jj_3R_95()) return true;
    if (jj_scan_token(187)) return true;
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3_18()
 {
    if (jj_3R_95()) return true;
    if (jj_scan_token(187)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_98()) jj_scanpos = xsp;
    if (jj_scan_token(187)) return true;
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3_17()
 {
    if (jj_3R_95()) return true;
    if (jj_scan_token(187)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_96()) jj_scanpos = xsp;
    if (jj_scan_token(187)) return true;
    xsp = jj_scanpos;
    if (jj_3R_97()) jj_scanpos = xsp;
    if (jj_scan_token(187)) return true;
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_159()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_17()) {
    jj_scanpos = xsp;
    if (jj_3_18()) {
    jj_scanpos = xsp;
    if (jj_3_19()) {
    jj_scanpos = xsp;
    if (jj_3R_284()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_147()
 {
    if (jj_scan_token(K_DATETIMELITERAL)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_330()
 {
    if (jj_3R_249()) return true;
    return false;
  }

  private boolean jj_3R_142()
 {
    if (jj_scan_token(189)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_271()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_330()) {
    jj_scanpos = xsp;
    if (jj_scan_token(137)) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_385()
 {
    if (jj_scan_token(193)) return true;
    return false;
  }

  private boolean jj_3R_296()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(216)) {
    jj_scanpos = xsp;
    if (jj_3R_385()) return true;
    }
    if (jj_3R_271()) return true;
    return false;
  }

  private boolean jj_3R_312()
 {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_249()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_312()) {
    jj_scanpos = xsp;
    if (jj_scan_token(79)) {
    jj_scanpos = xsp;
    if (jj_scan_token(120)) {
    jj_scanpos = xsp;
    if (jj_scan_token(126)) {
    jj_scanpos = xsp;
    if (jj_scan_token(36)) {
    jj_scanpos = xsp;
    if (jj_scan_token(62)) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_141()
 {
    if (jj_scan_token(189)) return true;
    if (jj_3R_271()) return true;
    return false;
  }

  private boolean jj_3R_198()
 {
    if (jj_3R_301()) return true;
    return false;
  }

  private boolean jj_3R_95()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_198()) {
    jj_scanpos = xsp;
    if (jj_scan_token(150)) {
    jj_scanpos = xsp;
    if (jj_scan_token(151)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_194()
 {
    if (jj_3R_298()) return true;
    return false;
  }

  private boolean jj_3R_498()
 {
    if (jj_scan_token(215)) return true;
    if (jj_3R_371()) return true;
    return false;
  }

  private boolean jj_3R_193()
 {
    if (jj_scan_token(214)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(212)) return true;
    return false;
  }

  private boolean jj_3_80()
 {
    if (jj_scan_token(184)) return true;
    if (jj_3R_87()) return true;
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_192()
 {
    if (jj_scan_token(213)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(212)) return true;
    return false;
  }

  private boolean jj_3R_191()
 {
    if (jj_scan_token(211)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(212)) return true;
    return false;
  }

  private boolean jj_3R_301()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(176)) {
    jj_scanpos = xsp;
    if (jj_scan_token(180)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(35)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(77)) {
    jj_scanpos = xsp;
    if (jj_scan_token(84)) {
    jj_scanpos = xsp;
    if (jj_scan_token(95)) {
    jj_scanpos = xsp;
    if (jj_scan_token(105)) {
    jj_scanpos = xsp;
    if (jj_scan_token(112)) {
    jj_scanpos = xsp;
    if (jj_scan_token(121)) {
    jj_scanpos = xsp;
    if (jj_scan_token(122)) {
    jj_scanpos = xsp;
    if (jj_scan_token(127)) {
    jj_scanpos = xsp;
    if (jj_scan_token(160)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(117)) {
    jj_scanpos = xsp;
    if (jj_scan_token(138)) {
    jj_scanpos = xsp;
    if (jj_scan_token(76)) {
    jj_scanpos = xsp;
    if (jj_scan_token(7)) {
    jj_scanpos = xsp;
    if (jj_scan_token(100)) {
    jj_scanpos = xsp;
    if (jj_scan_token(104)) {
    jj_scanpos = xsp;
    if (jj_scan_token(106)) {
    jj_scanpos = xsp;
    if (jj_scan_token(111)) {
    jj_scanpos = xsp;
    if (jj_scan_token(125)) {
    jj_scanpos = xsp;
    if (jj_scan_token(90)) {
    jj_scanpos = xsp;
    if (jj_scan_token(2)) {
    jj_scanpos = xsp;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(41)) {
    jj_scanpos = xsp;
    if (jj_scan_token(131)) {
    jj_scanpos = xsp;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_scan_token(22)) {
    jj_scanpos = xsp;
    if (jj_scan_token(109)) {
    jj_scanpos = xsp;
    if (jj_scan_token(68)) {
    jj_scanpos = xsp;
    if (jj_scan_token(66)) {
    jj_scanpos = xsp;
    if (jj_scan_token(110)) {
    jj_scanpos = xsp;
    if (jj_scan_token(40)) {
    jj_scanpos = xsp;
    if (jj_scan_token(148)) {
    jj_scanpos = xsp;
    if (jj_scan_token(134)) {
    jj_scanpos = xsp;
    if (jj_scan_token(135)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_190()
 {
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3_81()
 {
    if (jj_scan_token(184)) return true;
    if (jj_3R_103()) return true;
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_189()
 {
    if (jj_scan_token(184)) return true;
    if (jj_3R_87()) return true;
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_188()
 {
    if (jj_3R_86()) return true;
    return false;
  }

  private boolean jj_3_79()
 {
    if (jj_3R_147()) return true;
    return false;
  }

  private boolean jj_3R_454()
 {
    if (jj_scan_token(187)) return true;
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_187()
 {
    if (jj_scan_token(K_TIME_KEY_EXPR)) return true;
    return false;
  }

  private boolean jj_3_77()
 {
    if (jj_3R_120()) return true;
    return false;
  }

  private boolean jj_3_76()
 {
    if (jj_3R_145()) return true;
    return false;
  }

  private boolean jj_3_78()
 {
    if (jj_3R_146()) return true;
    return false;
  }

  private boolean jj_3R_186()
 {
    if (jj_scan_token(S_HEX)) return true;
    return false;
  }

  private boolean jj_3R_185()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_294()
 {
    if (jj_scan_token(187)) return true;
    if (jj_3R_95()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_454()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_184()
 {
    if (jj_scan_token(S_DOUBLE)) return true;
    return false;
  }

  private boolean jj_3_74()
 {
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_183()
 {
    if (jj_3R_120()) return true;
    return false;
  }

  private boolean jj_3R_182()
 {
    if (jj_3R_145()) return true;
    return false;
  }

  private boolean jj_3R_181()
 {
    if (jj_3R_297()) return true;
    return false;
  }

  private boolean jj_3_16()
 {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3_75()
 {
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3R_180()
 {
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_86()
 {
    if (jj_3R_95()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_173()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_173()
 {
    if (jj_scan_token(187)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_16()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_294()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_73()
 {
    if (jj_3R_142()) return true;
    return false;
  }

  private boolean jj_3R_179()
 {
    if (jj_3R_296()) return true;
    return false;
  }

  private boolean jj_3_72()
 {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3R_178()
 {
    if (jj_3R_211()) return true;
    return false;
  }

  private boolean jj_3R_177()
 {
    if (jj_3R_295()) return true;
    return false;
  }

  private boolean jj_3R_176()
 {
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_175()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(190)) {
    jj_scanpos = xsp;
    if (jj_scan_token(202)) {
    jj_scanpos = xsp;
    if (jj_scan_token(194)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_89()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_175()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_176()) {
    jj_scanpos = xsp;
    if (jj_3R_177()) {
    jj_scanpos = xsp;
    if (jj_3R_178()) {
    jj_scanpos = xsp;
    if (jj_3_72()) {
    jj_scanpos = xsp;
    if (jj_3R_179()) {
    jj_scanpos = xsp;
    if (jj_3_73()) {
    jj_scanpos = xsp;
    if (jj_3R_180()) {
    jj_scanpos = xsp;
    if (jj_3_75()) {
    jj_scanpos = xsp;
    if (jj_3R_181()) {
    jj_scanpos = xsp;
    if (jj_3R_182()) {
    jj_scanpos = xsp;
    if (jj_3R_183()) {
    jj_scanpos = xsp;
    if (jj_3R_184()) {
    jj_scanpos = xsp;
    if (jj_3R_185()) {
    jj_scanpos = xsp;
    if (jj_3R_186()) {
    jj_scanpos = xsp;
    if (jj_3_78()) {
    jj_scanpos = xsp;
    if (jj_3R_187()) {
    jj_scanpos = xsp;
    if (jj_3_79()) {
    jj_scanpos = xsp;
    if (jj_3R_188()) {
    jj_scanpos = xsp;
    if (jj_3R_189()) {
    jj_scanpos = xsp;
    if (jj_3_81()) {
    jj_scanpos = xsp;
    if (jj_3R_190()) {
    jj_scanpos = xsp;
    if (jj_3R_191()) {
    jj_scanpos = xsp;
    if (jj_3R_192()) {
    jj_scanpos = xsp;
    if (jj_3R_193()) {
    jj_scanpos = xsp;
    if (jj_3R_194()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_498()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_139()
 {
    if (jj_scan_token(209)) return true;
    return false;
  }

  private boolean jj_3R_138()
 {
    if (jj_scan_token(208)) return true;
    return false;
  }

  private boolean jj_3R_446()
 {
    if (jj_scan_token(210)) return true;
    if (jj_3R_89()) return true;
    return false;
  }

  private boolean jj_3R_140()
 {
    if (jj_3R_89()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_446()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_94()
 {
    if (jj_scan_token(K_WHEN)) return true;
    if (jj_scan_token(K_MATCHED)) return true;
    return false;
  }

  private boolean jj_3R_137()
 {
    if (jj_scan_token(186)) return true;
    return false;
  }

  private boolean jj_3R_135()
 {
    if (jj_scan_token(202)) return true;
    return false;
  }

  private boolean jj_3_71()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_137()) {
    jj_scanpos = xsp;
    if (jj_3R_138()) {
    jj_scanpos = xsp;
    if (jj_3R_139()) return true;
    }
    }
    if (jj_3R_140()) return true;
    return false;
  }

  private boolean jj_3_15()
 {
    if (jj_3R_94()) return true;
    return false;
  }

  private boolean jj_3R_136()
 {
    if (jj_3R_140()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_71()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_93()
 {
    if (jj_3R_196()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_197()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(K_FROM)) return true;
    return false;
  }

  private boolean jj_3R_134()
 {
    if (jj_scan_token(190)) return true;
    return false;
  }

  private boolean jj_3_70()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_134()) {
    jj_scanpos = xsp;
    if (jj_3R_135()) return true;
    }
    if (jj_3R_136()) return true;
    return false;
  }

  private boolean jj_3_14()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_93()) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) return true;
    }
    return false;
  }

  private boolean jj_3R_269()
 {
    if (jj_3R_136()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_70()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_197()
 {
    if (jj_scan_token(183)) return true;
    return false;
  }

  private boolean jj_3R_329()
 {
    if (jj_scan_token(207)) return true;
    return false;
  }

  private boolean jj_3R_328()
 {
    if (jj_scan_token(206)) return true;
    return false;
  }

  private boolean jj_3R_327()
 {
    if (jj_scan_token(205)) return true;
    return false;
  }

  private boolean jj_3R_326()
 {
    if (jj_scan_token(204)) return true;
    return false;
  }

  private boolean jj_3R_270()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_326()) {
    jj_scanpos = xsp;
    if (jj_3R_327()) {
    jj_scanpos = xsp;
    if (jj_3R_328()) {
    jj_scanpos = xsp;
    if (jj_3R_329()) return true;
    }
    }
    }
    if (jj_3R_269()) return true;
    return false;
  }

  private boolean jj_3R_133()
 {
    if (jj_3R_269()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_270()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_267()
 {
    if (jj_scan_token(K_SOME)) return true;
    return false;
  }

  private boolean jj_3_12()
 {
    if (jj_scan_token(184)) return true;
    if (jj_3R_90()) return true;
    return false;
  }

  private boolean jj_3_69()
 {
    if (jj_scan_token(OP_CONCAT)) return true;
    if (jj_3R_133()) return true;
    return false;
  }

  private boolean jj_3R_174()
 {
    if (jj_3R_133()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_69()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_92()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(151)) {
    jj_scanpos = xsp;
    if (jj_scan_token(150)) return true;
    }
    return false;
  }

  private boolean jj_3_13()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_92()) jj_scanpos = xsp;
    if (jj_scan_token(184)) return true;
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3R_87()
 {
    if (jj_3R_174()) return true;
    return false;
  }

  private boolean jj_3_11()
 {
    if (jj_scan_token(184)) return true;
    if (jj_3R_86()) return true;
    return false;
  }

  private boolean jj_3R_325()
 {
    if (jj_scan_token(183)) return true;
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3R_266()
 {
    if (jj_scan_token(K_ANY)) return true;
    return false;
  }

  private boolean jj_3R_131()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_266()) {
    jj_scanpos = xsp;
    if (jj_3R_267()) return true;
    }
    if (jj_scan_token(184)) return true;
    if (jj_3R_103()) return true;
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_264()
 {
    if (jj_scan_token(183)) return true;
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3R_318()
 {
    if (jj_scan_token(K_ALL)) return true;
    if (jj_scan_token(184)) return true;
    if (jj_3R_103()) return true;
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3_67()
 {
    if (jj_3R_132()) return true;
    return false;
  }

  private boolean jj_3R_256()
 {
    if (jj_3R_319()) return true;
    return false;
  }

  private boolean jj_3_68()
 {
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3R_255()
 {
    if (jj_3R_132()) return true;
    return false;
  }

  private boolean jj_3_66()
 {
    if (jj_3R_131()) return true;
    return false;
  }

  private boolean jj_3R_254()
 {
    if (jj_3R_318()) return true;
    return false;
  }

  private boolean jj_3R_444()
 {
    if (jj_scan_token(K_ILIKE)) return true;
    return false;
  }

  private boolean jj_3R_121()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_254()) {
    jj_scanpos = xsp;
    if (jj_3_66()) {
    jj_scanpos = xsp;
    if (jj_3R_255()) {
    jj_scanpos = xsp;
    if (jj_3_68()) {
    jj_scanpos = xsp;
    if (jj_3R_256()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_268()
 {
    if (jj_3R_87()) return true;
    Token xsp;
    if (jj_3R_325()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_325()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_402()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_324()
 {
    if (jj_scan_token(K_IS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_402()) jj_scanpos = xsp;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_322()
 {
    if (jj_scan_token(K_IS)) return true;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_126()
 {
    if (jj_3R_87()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_264()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_130()
 {
    if (jj_scan_token(K_ILIKE)) return true;
    return false;
  }

  private boolean jj_3R_259()
 {
    if (jj_3R_126()) return true;
    return false;
  }

  private boolean jj_3_9()
 {
    if (jj_scan_token(184)) return true;
    if (jj_3R_90()) return true;
    return false;
  }

  private boolean jj_3R_91()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(151)) {
    jj_scanpos = xsp;
    if (jj_scan_token(150)) return true;
    }
    return false;
  }

  private boolean jj_3R_263()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_125()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_263()) jj_scanpos = xsp;
    if (jj_scan_token(K_EXISTS)) return true;
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3R_323()
 {
    if (jj_scan_token(K_ISNULL)) return true;
    return false;
  }

  private boolean jj_3_10()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_91()) jj_scanpos = xsp;
    if (jj_scan_token(184)) return true;
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3R_321()
 {
    if (jj_scan_token(K_ISNULL)) return true;
    return false;
  }

  private boolean jj_3_8()
 {
    if (jj_scan_token(184)) return true;
    if (jj_3R_86()) return true;
    return false;
  }

  private boolean jj_3R_262()
 {
    if (jj_3R_87()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_323()) {
    jj_scanpos = xsp;
    if (jj_3R_324()) return true;
    }
    return false;
  }

  private boolean jj_3R_261()
 {
    if (jj_scan_token(K_NOT)) return true;
    if (jj_3R_87()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_321()) {
    jj_scanpos = xsp;
    if (jj_3R_322()) return true;
    }
    return false;
  }

  private boolean jj_3R_124()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_261()) {
    jj_scanpos = xsp;
    if (jj_3R_262()) return true;
    }
    return false;
  }

  private boolean jj_3R_445()
 {
    if (jj_scan_token(K_ESCAPE)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_443()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3_64()
 {
    if (jj_3R_103()) return true;
    return false;
  }

  private boolean jj_3R_442()
 {
    if (jj_scan_token(K_ESCAPE)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_129()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_396()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_443()) jj_scanpos = xsp;
    if (jj_3R_87()) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(80)) {
    jj_scanpos = xsp;
    if (jj_3R_444()) return true;
    }
    if (jj_3R_87()) return true;
    xsp = jj_scanpos;
    if (jj_3R_445()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_65()
 {
    if (jj_3R_87()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_129()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(80)) {
    jj_scanpos = xsp;
    if (jj_3R_130()) return true;
    }
    if (jj_3R_87()) return true;
    xsp = jj_scanpos;
    if (jj_3R_442()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_309()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_65()) {
    jj_scanpos = xsp;
    if (jj_3R_396()) return true;
    }
    return false;
  }

  private boolean jj_3R_260()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_123()
 {
    if (jj_3R_87()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_260()) jj_scanpos = xsp;
    if (jj_scan_token(K_BETWEEN)) return true;
    if (jj_3R_87()) return true;
    if (jj_scan_token(K_AND)) return true;
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3R_88()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(151)) {
    jj_scanpos = xsp;
    if (jj_scan_token(150)) return true;
    }
    return false;
  }

  private boolean jj_3_62()
 {
    if (jj_3R_126()) return true;
    return false;
  }

  private boolean jj_3R_320()
 {
    if (jj_scan_token(184)) return true;
    if (jj_scan_token(190)) return true;
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_265()
 {
    if (jj_scan_token(184)) return true;
    if (jj_scan_token(190)) return true;
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_258()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_257()
 {
    if (jj_3R_87()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_320()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_128()
 {
    if (jj_3R_87()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_265()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_7()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_88()) jj_scanpos = xsp;
    if (jj_scan_token(184)) return true;
    if (jj_3R_89()) return true;
    return false;
  }

  private boolean jj_3R_127()
 {
    if (jj_3R_126()) return true;
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_scan_token(184)) return true;
    if (jj_3R_86()) return true;
    return false;
  }

  private boolean jj_3_63()
 {
    if (jj_scan_token(184)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_127()) {
    jj_scanpos = xsp;
    if (jj_3R_128()) return true;
    }
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_122()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_63()) {
    jj_scanpos = xsp;
    if (jj_3R_257()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_258()) jj_scanpos = xsp;
    if (jj_scan_token(K_IN)) return true;
    if (jj_scan_token(184)) return true;
    xsp = jj_scanpos;
    if (jj_3_64()) {
    jj_scanpos = xsp;
    if (jj_3R_259()) return true;
    }
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3_61()
 {
    if (jj_3R_125()) return true;
    return false;
  }

  private boolean jj_3_60()
 {
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3_59()
 {
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3_58()
 {
    if (jj_3R_122()) return true;
    return false;
  }

  private boolean jj_3R_222()
 {
    if (jj_3R_309()) return true;
    return false;
  }

  private boolean jj_3R_221()
 {
    if (jj_3R_125()) return true;
    return false;
  }

  private boolean jj_3R_220()
 {
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3R_564()
 {
    if (jj_scan_token(K_WAIT)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_219()
 {
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3R_218()
 {
    if (jj_3R_122()) return true;
    return false;
  }

  private boolean jj_3R_118()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_218()) {
    jj_scanpos = xsp;
    if (jj_3R_219()) {
    jj_scanpos = xsp;
    if (jj_3R_220()) {
    jj_scanpos = xsp;
    if (jj_3R_221()) {
    jj_scanpos = xsp;
    if (jj_3R_222()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_82()
 {
    if (jj_scan_token(K_ALTER)) return true;
    if (jj_scan_token(K_TABLE)) return true;
    return false;
  }

  private boolean jj_3R_247()
 {
    if (jj_scan_token(184)) return true;
    if (jj_scan_token(190)) return true;
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_246()
 {
    if (jj_3R_121()) return true;
    return false;
  }

  private boolean jj_3R_245()
 {
    if (jj_scan_token(203)) return true;
    return false;
  }

  private boolean jj_3R_244()
 {
    if (jj_scan_token(202)) return true;
    return false;
  }

  private boolean jj_3_57()
 {
    if (jj_scan_token(K_PRIOR)) return true;
    if (jj_3R_121()) return true;
    return false;
  }

  private boolean jj_3R_243()
 {
    if (jj_scan_token(OP_CONCAT)) return true;
    return false;
  }

  private boolean jj_3R_242()
 {
    if (jj_scan_token(201)) return true;
    return false;
  }

  private boolean jj_3R_241()
 {
    if (jj_scan_token(200)) return true;
    return false;
  }

  private boolean jj_3R_310()
 {
    if (jj_scan_token(K_BINARY)) return true;
    return false;
  }

  private boolean jj_3R_311()
 {
    if (jj_scan_token(K_BINARY)) return true;
    return false;
  }

  private boolean jj_3R_240()
 {
    if (jj_scan_token(188)) return true;
    return false;
  }

  private boolean jj_3R_239()
 {
    if (jj_scan_token(199)) return true;
    return false;
  }

  private boolean jj_3R_238()
 {
    if (jj_scan_token(198)) return true;
    return false;
  }

  private boolean jj_3_100()
 {
    if (jj_scan_token(K_COLUMN)) return true;
    return false;
  }

  private boolean jj_3R_237()
 {
    if (jj_scan_token(197)) return true;
    return false;
  }

  private boolean jj_3R_236()
 {
    if (jj_scan_token(196)) return true;
    return false;
  }

  private boolean jj_3R_235()
 {
    if (jj_scan_token(195)) return true;
    return false;
  }

  private boolean jj_3R_234()
 {
    if (jj_scan_token(K_RLIKE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_311()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_233()
 {
    if (jj_scan_token(K_REGEXP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_310()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_232()
 {
    if (jj_scan_token(194)) return true;
    return false;
  }

  private boolean jj_3R_231()
 {
    if (jj_scan_token(193)) return true;
    return false;
  }

  private boolean jj_3R_230()
 {
    if (jj_scan_token(OP_NOTEQUALSBANG)) return true;
    return false;
  }

  private boolean jj_3R_229()
 {
    if (jj_scan_token(OP_NOTEQUALSSTANDARD)) return true;
    return false;
  }

  private boolean jj_3R_228()
 {
    if (jj_scan_token(OP_MINORTHANEQUALS)) return true;
    return false;
  }

  private boolean jj_3R_227()
 {
    if (jj_scan_token(OP_GREATERTHANEQUALS)) return true;
    return false;
  }

  private boolean jj_3R_226()
 {
    if (jj_scan_token(182)) return true;
    return false;
  }

  private boolean jj_3R_225()
 {
    if (jj_scan_token(192)) return true;
    return false;
  }

  private boolean jj_3_56()
 {
    if (jj_scan_token(191)) return true;
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_3R_86()) return true;
    if (jj_scan_token(182)) return true;
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3R_224()
 {
    if (jj_scan_token(184)) return true;
    if (jj_scan_token(190)) return true;
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_223()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3_55()
 {
    if (jj_scan_token(K_PRIOR)) return true;
    return false;
  }

  private boolean jj_3R_119()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_55()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_223()) jj_scanpos = xsp;
    if (jj_3R_121()) return true;
    xsp = jj_scanpos;
    if (jj_3R_224()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_56()) {
    jj_scanpos = xsp;
    if (jj_3R_225()) {
    jj_scanpos = xsp;
    if (jj_3R_226()) {
    jj_scanpos = xsp;
    if (jj_3R_227()) {
    jj_scanpos = xsp;
    if (jj_3R_228()) {
    jj_scanpos = xsp;
    if (jj_3R_229()) {
    jj_scanpos = xsp;
    if (jj_3R_230()) {
    jj_scanpos = xsp;
    if (jj_3R_231()) {
    jj_scanpos = xsp;
    if (jj_3R_232()) {
    jj_scanpos = xsp;
    if (jj_3R_233()) {
    jj_scanpos = xsp;
    if (jj_3R_234()) {
    jj_scanpos = xsp;
    if (jj_3R_235()) {
    jj_scanpos = xsp;
    if (jj_3R_236()) {
    jj_scanpos = xsp;
    if (jj_3R_237()) {
    jj_scanpos = xsp;
    if (jj_3R_238()) {
    jj_scanpos = xsp;
    if (jj_3R_239()) {
    jj_scanpos = xsp;
    if (jj_3R_240()) {
    jj_scanpos = xsp;
    if (jj_3R_241()) {
    jj_scanpos = xsp;
    if (jj_3R_242()) {
    jj_scanpos = xsp;
    if (jj_3R_243()) {
    jj_scanpos = xsp;
    if (jj_3R_244()) {
    jj_scanpos = xsp;
    if (jj_3R_245()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_57()) {
    jj_scanpos = xsp;
    if (jj_3R_246()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_247()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_54()
 {
    if (jj_3R_120()) return true;
    return false;
  }

  private boolean jj_3_53()
 {
    if (jj_3R_119()) return true;
    return false;
  }

  private boolean jj_3_52()
 {
    if (jj_3R_118()) return true;
    return false;
  }

  private boolean jj_3R_217()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_216()
 {
    if (jj_3R_86()) return true;
    return false;
  }

  private boolean jj_3R_215()
 {
    if (jj_scan_token(K_NOT)) return true;
    if (jj_3R_86()) return true;
    return false;
  }

  private boolean jj_3R_214()
 {
    if (jj_3R_120()) return true;
    return false;
  }

  private boolean jj_3R_213()
 {
    if (jj_3R_119()) return true;
    return false;
  }

  private boolean jj_3R_212()
 {
    if (jj_3R_118()) return true;
    return false;
  }

  private boolean jj_3R_117()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_212()) {
    jj_scanpos = xsp;
    if (jj_3R_213()) {
    jj_scanpos = xsp;
    if (jj_3R_214()) {
    jj_scanpos = xsp;
    if (jj_3R_215()) {
    jj_scanpos = xsp;
    if (jj_3R_216()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = "0".equals(getToken(1).image) || "1".equals(getToken(1).image);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_217()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_51()
 {
    if (jj_3R_117()) return true;
    return false;
  }

  private boolean jj_3R_502()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_457()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_502()) jj_scanpos = xsp;
    if (jj_scan_token(184)) return true;
    if (jj_3R_279()) return true;
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_456()
 {
    if (jj_3R_117()) return true;
    return false;
  }

  private boolean jj_3R_409()
 {
    if (jj_scan_token(K_AND)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_456()) {
    jj_scanpos = xsp;
    if (jj_3R_457()) return true;
    }
    return false;
  }

  private boolean jj_3_50()
 {
    if (jj_3R_117()) return true;
    return false;
  }

  private boolean jj_3R_455()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_408()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_455()) jj_scanpos = xsp;
    if (jj_scan_token(184)) return true;
    if (jj_3R_279()) return true;
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_407()
 {
    if (jj_3R_117()) return true;
    return false;
  }

  private boolean jj_3R_340()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_407()) {
    jj_scanpos = xsp;
    if (jj_3R_408()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_409()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_49()
 {
    if (jj_scan_token(K_OR)) return true;
    return false;
  }

  private boolean jj_3_99()
 {
    if (jj_scan_token(K_PRIMARY)) return true;
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3R_341()
 {
    if (jj_scan_token(K_OR)) return true;
    if (jj_3R_340()) return true;
    return false;
  }

  private boolean jj_3_47()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_98()
 {
    if (jj_scan_token(K_COLUMN)) return true;
    return false;
  }

  private boolean jj_3R_279()
 {
    if (jj_3R_340()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_341()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_3R_85()) return true;
    return false;
  }

  private boolean jj_3R_203()
 {
    if (jj_3R_211()) return true;
    return false;
  }

  private boolean jj_3R_148()
 {
    if (jj_3R_279()) return true;
    return false;
  }

  private boolean jj_3R_202()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_200()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    return false;
  }

  private boolean jj_3R_201()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_199()
 {
    if (jj_scan_token(K_FIRST)) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3R_99()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_199()) {
    jj_scanpos = xsp;
    if (jj_3R_200()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_201()) {
    jj_scanpos = xsp;
    if (jj_3R_202()) {
    jj_scanpos = xsp;
    if (jj_3R_203()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_550()
 {
    if (jj_3R_211()) return true;
    return false;
  }

  private boolean jj_3R_549()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_548()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_510()
 {
    if (jj_scan_token(K_SKIP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_548()) {
    jj_scanpos = xsp;
    if (jj_3R_549()) {
    jj_scanpos = xsp;
    if (jj_3R_550()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_529()
 {
    if (jj_scan_token(K_ROW)) return true;
    return false;
  }

  private boolean jj_3_48()
 {
    if (jj_scan_token(K_PERCENT)) return true;
    return false;
  }

  private boolean jj_3R_555()
 {
    if (jj_scan_token(184)) return true;
    if (jj_3R_269()) return true;
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_554()
 {
    if (jj_scan_token(189)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_47()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_553()
 {
    if (jj_3R_211()) return true;
    return false;
  }

  private boolean jj_3R_552()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_514()
 {
    if (jj_scan_token(K_TOP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_552()) {
    jj_scanpos = xsp;
    if (jj_3R_553()) {
    jj_scanpos = xsp;
    if (jj_3R_554()) {
    jj_scanpos = xsp;
    if (jj_3R_555()) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_48()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_488()
 {
    if (jj_3R_211()) return true;
    return false;
  }

  private boolean jj_3R_489()
 {
    if (jj_scan_token(K_ROWS)) return true;
    return false;
  }

  private boolean jj_3_46()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_486()
 {
    if (jj_scan_token(K_FIRST)) return true;
    return false;
  }

  private boolean jj_3R_487()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3_44()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_547()
 {
    if (jj_scan_token(182)) return true;
    return false;
  }

  private boolean jj_3R_528()
 {
    if (jj_scan_token(K_ROWS)) return true;
    return false;
  }

  private boolean jj_3R_433()
 {
    if (jj_scan_token(K_FETCH)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_486()) {
    jj_scanpos = xsp;
    if (jj_scan_token(89)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_487()) {
    jj_scanpos = xsp;
    if (jj_3R_488()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_489()) {
    jj_scanpos = xsp;
    if (jj_scan_token(121)) return true;
    }
    if (jj_scan_token(K_ONLY)) return true;
    return false;
  }

  private boolean jj_3_43()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_484()
 {
    if (jj_3R_211()) return true;
    return false;
  }

  private boolean jj_3R_485()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_528()) {
    jj_scanpos = xsp;
    if (jj_3R_529()) return true;
    }
    return false;
  }

  private boolean jj_3R_483()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_377()
 {
    if (jj_scan_token(183)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(176)) {
    jj_scanpos = xsp;
    if (jj_scan_token(180)) return true;
    }
    return false;
  }

  private boolean jj_3R_150()
 {
    if (jj_scan_token(184)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(176)) {
    jj_scanpos = xsp;
    if (jj_scan_token(180)) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_377()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_432()
 {
    if (jj_scan_token(K_OFFSET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_483()) {
    jj_scanpos = xsp;
    if (jj_3R_484()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_485()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_546()
 {
    if (jj_scan_token(183)) return true;
    return false;
  }

  private boolean jj_3R_503()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_546()) {
    jj_scanpos = xsp;
    if (jj_3R_547()) return true;
    }
    return false;
  }

  private boolean jj_3R_460()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(170)) {
    jj_scanpos = xsp;
    if (jj_scan_token(169)) {
    jj_scanpos = xsp;
    if (jj_scan_token(179)) {
    jj_scanpos = xsp;
    if (jj_scan_token(176)) {
    jj_scanpos = xsp;
    if (jj_scan_token(180)) return true;
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_503()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_569()
 {
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_568()
 {
    if (jj_scan_token(K_ALL)) return true;
    return false;
  }

  private boolean jj_3R_415()
 {
    if (jj_scan_token(184)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_460()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_567()
 {
    if (jj_scan_token(189)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_46()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_566()
 {
    if (jj_3R_211()) return true;
    return false;
  }

  private boolean jj_3R_565()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_369()
 {
    if (jj_scan_token(K_TEMPORARY)) return true;
    return false;
  }

  private boolean jj_3R_368()
 {
    if (jj_scan_token(K_TEMP)) return true;
    return false;
  }

  private boolean jj_3R_367()
 {
    if (jj_scan_token(K_UNSIGNED)) return true;
    return false;
  }

  private boolean jj_3R_366()
 {
    if (jj_scan_token(K_WHERE)) return true;
    return false;
  }

  private boolean jj_3R_527()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_565()) {
    jj_scanpos = xsp;
    if (jj_3R_566()) {
    jj_scanpos = xsp;
    if (jj_3R_567()) {
    jj_scanpos = xsp;
    if (jj_3R_568()) {
    jj_scanpos = xsp;
    if (jj_3R_569()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_365()
 {
    if (jj_scan_token(K_EXCLUDE)) return true;
    return false;
  }

  private boolean jj_3R_364()
 {
    if (jj_scan_token(K_WITH)) return true;
    return false;
  }

  private boolean jj_3R_116()
 {
    if (jj_scan_token(189)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_44()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_363()
 {
    if (jj_scan_token(K_CONSTRAINT)) return true;
    return false;
  }

  private boolean jj_3R_113()
 {
    if (jj_scan_token(189)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_43()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_115()
 {
    if (jj_3R_211()) return true;
    return false;
  }

  private boolean jj_3R_482()
 {
    if (jj_3R_527()) return true;
    return false;
  }

  private boolean jj_3R_362()
 {
    if (jj_scan_token(K_CHECK)) return true;
    if (jj_scan_token(184)) return true;
    if (jj_3R_148()) return true;
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_112()
 {
    if (jj_3R_211()) return true;
    return false;
  }

  private boolean jj_3R_361()
 {
    if (jj_3R_415()) return true;
    return false;
  }

  private boolean jj_3R_114()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_111()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_360()
 {
    if (jj_scan_token(K_TABLESPACE)) return true;
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_504()
 {
    if (jj_scan_token(183)) return true;
    return false;
  }

  private boolean jj_3_97()
 {
    if (jj_scan_token(K_USING)) return true;
    if (jj_scan_token(K_INDEX)) return true;
    if (jj_scan_token(K_TABLESPACE)) return true;
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_459()
 {
    if (jj_scan_token(202)) return true;
    return false;
  }

  private boolean jj_3R_359()
 {
    if (jj_scan_token(182)) return true;
    return false;
  }

  private boolean jj_3R_358()
 {
    if (jj_scan_token(K_TIME_KEY_EXPR)) return true;
    return false;
  }

  private boolean jj_3R_357()
 {
    if (jj_scan_token(K_UPDATE)) return true;
    return false;
  }

  private boolean jj_3R_356()
 {
    if (jj_scan_token(K_DELETE)) return true;
    return false;
  }

  private boolean jj_3R_355()
 {
    if (jj_scan_token(K_CASCADE)) return true;
    return false;
  }

  private boolean jj_3R_354()
 {
    if (jj_scan_token(K_UNIQUE)) return true;
    return false;
  }

  private boolean jj_3R_353()
 {
    if (jj_scan_token(K_ROWS)) return true;
    return false;
  }

  private boolean jj_3_45()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_111()) {
    jj_scanpos = xsp;
    if (jj_3R_112()) {
    jj_scanpos = xsp;
    if (jj_3R_113()) return true;
    }
    }
    if (jj_scan_token(183)) return true;
    xsp = jj_scanpos;
    if (jj_3R_114()) {
    jj_scanpos = xsp;
    if (jj_3R_115()) {
    jj_scanpos = xsp;
    if (jj_3R_116()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_352()
 {
    if (jj_scan_token(K_COMMIT)) return true;
    return false;
  }

  private boolean jj_3R_351()
 {
    if (jj_scan_token(K_ON)) return true;
    return false;
  }

  private boolean jj_3R_414()
 {
    if (jj_scan_token(S_DOUBLE)) return true;
    return false;
  }

  private boolean jj_3R_413()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3_42()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_412()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_458()) {
    jj_scanpos = xsp;
    if (jj_3R_459()) return true;
    }
    return false;
  }

  private boolean jj_3R_458()
 {
    if (jj_scan_token(190)) return true;
    return false;
  }

  private boolean jj_3R_431()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_45()) {
    jj_scanpos = xsp;
    if (jj_3R_482()) return true;
    }
    return false;
  }

  private boolean jj_3R_350()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_412()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_413()) {
    jj_scanpos = xsp;
    if (jj_3R_414()) return true;
    }
    return false;
  }

  private boolean jj_3R_349()
 {
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_348()
 {
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3R_347()
 {
    if (jj_scan_token(K_REFERENCES)) return true;
    return false;
  }

  private boolean jj_3R_346()
 {
    if (jj_scan_token(K_FOREIGN)) return true;
    return false;
  }

  private boolean jj_3R_345()
 {
    if (jj_scan_token(K_PRIMARY)) return true;
    return false;
  }

  private boolean jj_3R_211()
 {
    if (jj_scan_token(188)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_42()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_344()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_411()
 {
    if (jj_scan_token(187)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(176)) {
    jj_scanpos = xsp;
    if (jj_scan_token(180)) return true;
    }
    return false;
  }

  private boolean jj_3R_499()
 {
    if (jj_scan_token(K_DESC)) return true;
    return false;
  }

  private boolean jj_3R_343()
 {
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_342()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(176)) {
    jj_scanpos = xsp;
    if (jj_scan_token(180)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_411()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_542()
 {
    if (jj_scan_token(K_LAST)) return true;
    return false;
  }

  private boolean jj_3R_541()
 {
    if (jj_scan_token(K_FIRST)) return true;
    return false;
  }

  private boolean jj_3R_500()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_541()) {
    jj_scanpos = xsp;
    if (jj_3R_542()) return true;
    }
    return false;
  }

  private boolean jj_3R_283()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_342()) {
    jj_scanpos = xsp;
    if (jj_3R_343()) {
    jj_scanpos = xsp;
    if (jj_3R_344()) {
    jj_scanpos = xsp;
    if (jj_3R_345()) {
    jj_scanpos = xsp;
    if (jj_3R_346()) {
    jj_scanpos = xsp;
    if (jj_3R_347()) {
    jj_scanpos = xsp;
    if (jj_3R_348()) {
    jj_scanpos = xsp;
    if (jj_3R_349()) {
    jj_scanpos = xsp;
    if (jj_3R_350()) {
    jj_scanpos = xsp;
    if (jj_3R_351()) {
    jj_scanpos = xsp;
    if (jj_3R_352()) {
    jj_scanpos = xsp;
    if (jj_3R_353()) {
    jj_scanpos = xsp;
    if (jj_3R_354()) {
    jj_scanpos = xsp;
    if (jj_3R_355()) {
    jj_scanpos = xsp;
    if (jj_3R_356()) {
    jj_scanpos = xsp;
    if (jj_3R_357()) {
    jj_scanpos = xsp;
    if (jj_3R_358()) {
    jj_scanpos = xsp;
    if (jj_3R_359()) {
    jj_scanpos = xsp;
    if (jj_3_97()) {
    jj_scanpos = xsp;
    if (jj_3R_360()) {
    jj_scanpos = xsp;
    if (jj_3R_361()) {
    jj_scanpos = xsp;
    if (jj_3R_362()) {
    jj_scanpos = xsp;
    if (jj_3R_363()) {
    jj_scanpos = xsp;
    if (jj_3R_364()) {
    jj_scanpos = xsp;
    if (jj_3R_365()) {
    jj_scanpos = xsp;
    if (jj_3R_366()) {
    jj_scanpos = xsp;
    if (jj_3R_367()) {
    jj_scanpos = xsp;
    if (jj_3R_368()) {
    jj_scanpos = xsp;
    if (jj_3R_369()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_448()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_3R_499()) return true;
    }
    return false;
  }

  private boolean jj_3R_449()
 {
    if (jj_scan_token(K_NULLS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_500()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_404()
 {
    if (jj_3R_87()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_448()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_449()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_405()
 {
    if (jj_scan_token(183)) return true;
    if (jj_3R_404()) return true;
    return false;
  }

  private boolean jj_3R_334()
 {
    if (jj_scan_token(K_ORDER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(127)) jj_scanpos = xsp;
    if (jj_scan_token(K_BY)) return true;
    if (jj_3R_404()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_405()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_585()
 {
    if (jj_scan_token(K_NOCYCLE)) return true;
    return false;
  }

  private boolean jj_3R_584()
 {
    if (jj_scan_token(K_NOCYCLE)) return true;
    return false;
  }

  private boolean jj_3R_522()
 {
    if (jj_scan_token(K_HAVING)) return true;
    if (jj_3R_148()) return true;
    return false;
  }

  private boolean jj_3R_576()
 {
    if (jj_scan_token(K_OUTER)) return true;
    return false;
  }

  private boolean jj_3R_171()
 {
    if (jj_3R_150()) return true;
    return false;
  }

  private boolean jj_3R_292()
 {
    if (jj_scan_token(K_TEMPORARY)) return true;
    return false;
  }

  private boolean jj_3R_509()
 {
    if (jj_scan_token(K_NO)) return true;
    if (jj_scan_token(K_ACTION)) return true;
    return false;
  }

  private boolean jj_3R_170()
 {
    if (jj_scan_token(K_MATERIALIZED)) return true;
    return false;
  }

  private boolean jj_3R_169()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_291()) {
    jj_scanpos = xsp;
    if (jj_3R_292()) return true;
    }
    return false;
  }

  private boolean jj_3R_291()
 {
    if (jj_scan_token(K_TEMP)) return true;
    return false;
  }

  private boolean jj_3R_290()
 {
    if (jj_scan_token(K_FORCE)) return true;
    return false;
  }

  private boolean jj_3R_563()
 {
    if (jj_scan_token(183)) return true;
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3R_168()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_289()) {
    jj_scanpos = xsp;
    if (jj_3R_290()) return true;
    }
    return false;
  }

  private boolean jj_3R_289()
 {
    if (jj_scan_token(K_NO)) return true;
    if (jj_scan_token(K_FORCE)) return true;
    return false;
  }

  private boolean jj_3R_586()
 {
    if (jj_scan_token(K_START)) return true;
    if (jj_scan_token(K_WITH)) return true;
    if (jj_3R_340()) return true;
    return false;
  }

  private boolean jj_3R_521()
 {
    if (jj_scan_token(K_GROUP)) return true;
    if (jj_scan_token(K_BY)) return true;
    if (jj_3R_87()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_563()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_95()
 {
    if (jj_scan_token(K_PRECISION)) return true;
    return false;
  }

  private boolean jj_3R_167()
 {
    if (jj_scan_token(K_OR)) return true;
    if (jj_scan_token(K_REPLACE)) return true;
    return false;
  }

  private boolean jj_3R_157()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(170)) {
    jj_scanpos = xsp;
    if (jj_scan_token(179)) {
    jj_scanpos = xsp;
    if (jj_scan_token(176)) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_504()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_85()
 {
    if (jj_scan_token(K_CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_167()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_168()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_169()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_170()) jj_scanpos = xsp;
    if (jj_scan_token(K_VIEW)) return true;
    if (jj_3R_159()) return true;
    xsp = jj_scanpos;
    if (jj_3R_171()) jj_scanpos = xsp;
    if (jj_scan_token(K_AS)) return true;
    if (jj_3R_172()) return true;
    return false;
  }

  private boolean jj_3R_562()
 {
    if (jj_scan_token(K_CONNECT)) return true;
    if (jj_scan_token(K_BY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_585()) jj_scanpos = xsp;
    if (jj_3R_340()) return true;
    xsp = jj_scanpos;
    if (jj_3R_586()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_561()
 {
    if (jj_scan_token(K_START)) return true;
    if (jj_scan_token(K_WITH)) return true;
    if (jj_3R_340()) return true;
    if (jj_scan_token(K_CONNECT)) return true;
    if (jj_scan_token(K_BY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_584()) jj_scanpos = xsp;
    if (jj_3R_340()) return true;
    return false;
  }

  private boolean jj_3R_419()
 {
    if (jj_scan_token(K_UNSIGNED)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_418()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(176)) {
    jj_scanpos = xsp;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_scan_token(160)) {
    jj_scanpos = xsp;
    if (jj_scan_token(70)) {
    jj_scanpos = xsp;
    if (jj_scan_token(168)) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_417()
 {
    if (jj_scan_token(K_DOUBLE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_95()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_416()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) return true;
    }
    xsp = jj_scanpos;
    if (jj_scan_token(152)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_461()
 {
    if (jj_scan_token(222)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(170)) jj_scanpos = xsp;
    if (jj_scan_token(223)) return true;
    return false;
  }

  private boolean jj_3R_421()
 {
    if (jj_scan_token(K_CHARACTER)) return true;
    if (jj_scan_token(K_SET)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_420()
 {
    Token xsp;
    if (jj_3R_461()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_461()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_520()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_561()) {
    jj_scanpos = xsp;
    if (jj_3R_562()) return true;
    }
    return false;
  }

  private boolean jj_3_96()
 {
    if (jj_scan_token(184)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_157()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_575()
 {
    if (jj_scan_token(K_SEMI)) return true;
    return false;
  }

  private boolean jj_3R_536()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_575()) {
    jj_scanpos = xsp;
    if (jj_3R_576()) return true;
    }
    return false;
  }

  private boolean jj_3R_371()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_416()) {
    jj_scanpos = xsp;
    if (jj_3R_417()) {
    jj_scanpos = xsp;
    if (jj_3R_418()) {
    jj_scanpos = xsp;
    if (jj_3R_419()) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_96()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_420()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_421()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_519()
 {
    if (jj_scan_token(K_WHERE)) return true;
    if (jj_3R_148()) return true;
    return false;
  }

  private boolean jj_3R_540()
 {
    if (jj_scan_token(183)) return true;
    if (jj_3R_86()) return true;
    return false;
  }

  private boolean jj_3R_109()
 {
    if (jj_scan_token(K_ON)) return true;
    if (jj_3R_148()) return true;
    return false;
  }

  private boolean jj_3_94()
 {
    if (jj_scan_token(184)) return true;
    if (jj_3R_90()) return true;
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_439()
 {
    if (jj_scan_token(183)) return true;
    return false;
  }

  private boolean jj_3R_376()
 {
    if (jj_3R_90()) return true;
    return false;
  }

  private boolean jj_3R_110()
 {
    if (jj_scan_token(K_USING)) return true;
    if (jj_scan_token(184)) return true;
    if (jj_3R_86()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_540()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_375()
 {
    if (jj_scan_token(184)) return true;
    if (jj_3R_90()) return true;
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3_41()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_109()) {
    jj_scanpos = xsp;
    if (jj_3R_110()) return true;
    }
    return false;
  }

  private boolean jj_3R_539()
 {
    if (jj_scan_token(K_OUTER)) return true;
    return false;
  }

  private boolean jj_3R_538()
 {
    if (jj_scan_token(K_FULL)) return true;
    return false;
  }

  private boolean jj_3R_537()
 {
    if (jj_scan_token(K_RIGHT)) return true;
    return false;
  }

  private boolean jj_3R_508()
 {
    if (jj_scan_token(K_CASCADE)) return true;
    return false;
  }

  private boolean jj_3R_497()
 {
    if (jj_scan_token(K_CROSS)) return true;
    return false;
  }

  private boolean jj_3R_374()
 {
    if (jj_3R_283()) return true;
    return false;
  }

  private boolean jj_3R_496()
 {
    if (jj_scan_token(K_NATURAL)) return true;
    return false;
  }

  private boolean jj_3R_494()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_537()) {
    jj_scanpos = xsp;
    if (jj_3R_538()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_539()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_495()
 {
    if (jj_scan_token(K_INNER)) return true;
    return false;
  }

  private boolean jj_3R_288()
 {
    if (jj_scan_token(K_AS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_375()) {
    jj_scanpos = xsp;
    if (jj_3R_376()) return true;
    }
    return false;
  }

  private boolean jj_3R_464()
 {
    if (jj_3R_283()) return true;
    return false;
  }

  private boolean jj_3R_438()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_493()) {
    jj_scanpos = xsp;
    if (jj_3R_494()) {
    jj_scanpos = xsp;
    if (jj_3R_495()) {
    jj_scanpos = xsp;
    if (jj_3R_496()) {
    jj_scanpos = xsp;
    if (jj_3R_497()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_493()
 {
    if (jj_scan_token(K_LEFT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_536()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_392()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_438()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(74)) {
    jj_scanpos = xsp;
    if (jj_3R_439()) return true;
    }
    if (jj_3R_206()) return true;
    xsp = jj_scanpos;
    if (jj_3_41()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_463()
 {
    if (jj_scan_token(184)) return true;
    if (jj_3R_148()) return true;
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_156()
 {
    if (jj_scan_token(184)) return true;
    if (jj_3R_148()) return true;
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_423()
 {
    if (jj_3R_95()) return true;
    if (jj_3R_371()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_464()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_422()
 {
    if (jj_scan_token(K_EXCLUDE)) return true;
    if (jj_scan_token(K_WHERE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_463()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_507()
 {
    if (jj_scan_token(K_SET)) return true;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_506()
 {
    if (jj_scan_token(K_NO)) return true;
    if (jj_scan_token(K_ACTION)) return true;
    return false;
  }

  private boolean jj_3R_305()
 {
    if (jj_3R_392()) return true;
    return false;
  }

  private boolean jj_3R_207()
 {
    Token xsp;
    if (jj_3R_305()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_305()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_505()
 {
    if (jj_scan_token(K_CASCADE)) return true;
    return false;
  }

  private boolean jj_3R_155()
 {
    if (jj_scan_token(K_CONSTRAINT)) return true;
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3_88()
 {
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(K_UPDATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_508()) {
    jj_scanpos = xsp;
    if (jj_3R_509()) return true;
    }
    return false;
  }

  private boolean jj_3R_560()
 {
    if (jj_3R_392()) return true;
    return false;
  }

  private boolean jj_3_93()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_155()) jj_scanpos = xsp;
    if (jj_scan_token(K_CHECK)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_156()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_518()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_560()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_87()
 {
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(K_DELETE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_505()) {
    jj_scanpos = xsp;
    if (jj_3R_506()) {
    jj_scanpos = xsp;
    if (jj_3R_507()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_102()
 {
    if (jj_3R_206()) return true;
    if (jj_3R_207()) return true;
    return false;
  }

  private boolean jj_3R_154()
 {
    if (jj_scan_token(K_CONSTRAINT)) return true;
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3_92()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_154()) jj_scanpos = xsp;
    if (jj_scan_token(K_FOREIGN)) return true;
    if (jj_scan_token(K_KEY)) return true;
    if (jj_3R_150()) return true;
    if (jj_scan_token(K_REFERENCES)) return true;
    if (jj_3R_159()) return true;
    if (jj_3R_150()) return true;
    xsp = jj_scanpos;
    if (jj_3_87()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_88()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_436()
 {
    if (jj_scan_token(K_LATERAL)) return true;
    if (jj_scan_token(184)) return true;
    if (jj_3R_103()) return true;
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_395()
 {
    if (jj_scan_token(183)) return true;
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_462()
 {
    if (jj_3R_283()) return true;
    return false;
  }

  private boolean jj_3R_437()
 {
    if (jj_3R_490()) return true;
    return false;
  }

  private boolean jj_3_91()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(141)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(57)) jj_scanpos = xsp;
    if (jj_scan_token(K_KEY)) return true;
    if (jj_3R_95()) return true;
    if (jj_3R_150()) return true;
    return false;
  }

  private boolean jj_3R_308()
 {
    if (jj_scan_token(184)) return true;
    if (jj_3R_95()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_395()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_394()
 {
    if (jj_scan_token(183)) return true;
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3R_153()
 {
    if (jj_scan_token(K_UNIQUE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(76)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_152()
 {
    if (jj_scan_token(K_PRIMARY)) return true;
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3R_210()
 {
    if (jj_3R_149()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_308()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_307()
 {
    if (jj_scan_token(183)) return true;
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3R_151()
 {
    if (jj_scan_token(K_CONSTRAINT)) return true;
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_306()
 {
    if (jj_scan_token(183)) return true;
    if (jj_scan_token(184)) return true;
    if (jj_3R_87()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_394()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(185)) return true;
    return false;
  }

  private boolean jj_3R_108()
 {
    if (jj_scan_token(183)) return true;
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3R_209()
 {
    if (jj_3R_87()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_307()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_90()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_151()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_152()) {
    jj_scanpos = xsp;
    if (jj_3R_153()) return true;
    }
    if (jj_3R_150()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_462()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_40()
 {
    if (jj_scan_token(184)) return true;
    if (jj_3R_87()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_108()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(185)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_306()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  /** Generated Token Manager. */
  public CCJSqlParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  /** Whether we are looking ahead. */
  private boolean jj_lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[373];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static private int[] jj_la1_5;
  static private int[] jj_la1_6;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	   jj_la1_init_2();
	   jj_la1_init_3();
	   jj_la1_init_4();
	   jj_la1_init_5();
	   jj_la1_init_6();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x0,0x80000000,0x0,0x408020,0x0,0x0,0x82408020,0x0,0x0,0x0,0x0,0x0,0x0,0x10650084,0x0,0x0,0x0,0x0,0x10670084,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x40000000,0x0,0x0,0x100,0x10650184,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10670084,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10650084,0x10650084,0x0,0x0,0x0,0x10650084,0x10650184,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x10650084,0x10650084,0x10650084,0x10650084,0x10650084,0x10650084,0x10650084,0x10650084,0x10650184,0x0,0x0,0x0,0x10,0x10,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10650184,0x0,0x10670084,0x100,0x10650084,0x0,0x0,0x0,0x0,0x10650184,0x0,0x10650084,0x0,0x0,0x10650184,0x0,0x0,0x10650184,0x0,0x0,0x0,0x10650084,0x0,0x10650084,0x10650184,0x0,0x0,0x10650084,0x0,0x0,0x0,0x0,0x10670084,0x0,0x0,0x10650184,0x4000000,0x4000000,0x0,0x0,0x0,0x0,0x4000000,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x200,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x10650084,0x0,0x0,0x1000,0x1000,0x0,0x10670094,0x0,0x10670084,0x0,0x10670084,0x0,0x10670084,0x0,0x10670084,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10670084,0x0,0x0,0x0,0x10670084,0x0,0x0,0x0,0x0,0x10,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x10650084,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10670084,0x10670084,0x0,0x0,0x0,0x0,0x0,0x0,0x18670884,0x0,0x0,0x18670084,0x0,0x10670084,0x0,0x10670094,0x0,0x10670084,0x0,0x8000,0x10670084,0x0,0x0,0x0,0x10,0x10,0x0,0x10670094,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x81510000,0x0,0x81510200,0x81510200,0x0,0x0,0x81510200,0x81510200,0x81510000,0x0,0x81510000,0x0,0x81510000,0x0,0x1000000,0x0,0x0,0x81510000,0x0,0x0,0x1000000,0x10000,0x10000,0x1000000,0x0,0x0,0x81510000,0x10650084,0x81510000,0x0,0x100,0x100,0x82000,0x0,0x10000000,0x10082000,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80410000,0x1100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x10000,0x81510000,0x20000000,0x20000000,0x8,0x0,0x0,0x10000,0x0,0x0,0x100000,0x11650084,0x0,0x10000,0x0,0x1200000,0x8,0x0,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x0,0x0,0x0,0x6020,0x0,0x0,0x6020,0x0,0x0,0x0,0x0,0x0,0x0,0xd0308,0x800000,0x0,0x0,0x0,0x480d0318,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x20000000,0x80000000,0x0,0x0,0xd0308,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x480d0318,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8d0308,0xd0308,0x0,0x0,0x0,0xd0308,0xd0308,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xd0308,0xd0308,0x400d0318,0x408d0318,0xd0308,0xd0308,0xd0308,0xd0308,0xd0308,0x0,0x0,0x0,0x4,0x4,0x0,0x0,0x800000,0x0,0x0,0x4000000,0x10000000,0x0,0x100000,0x0,0x800,0x4,0x4,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0xd0308,0x0,0x480d0318,0x0,0xd0308,0x80200000,0x0,0x0,0x0,0xd0308,0x0,0xd0308,0x0,0x0,0xd0308,0x0,0x0,0xd0308,0x0,0x0,0x0,0x400d0318,0x0,0xd0308,0xd0308,0x0,0x0,0x400d0318,0x0,0x0,0x0,0x0,0x480d0318,0x0,0x0,0xd0308,0x1000000,0x1000000,0x0,0x0,0x1000000,0x0,0x1000000,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x1,0x40000,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0xd0308,0x0,0x0,0x0,0x0,0x0,0x480d0318,0x0,0x480d0318,0x0,0x480d0318,0x0,0x480d0318,0x0,0x480d0318,0x0,0x0,0x0,0x400,0x0,0x0,0x400,0x480d0318,0x0,0x0,0x0,0x480d0318,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0xd0308,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x4,0x0,0x0,0x480d0318,0x480d031c,0x0,0x0,0x0,0x0,0x0,0x0,0x480d0318,0x80000,0x80000,0x480d0318,0x0,0x480d0318,0x0,0x480d0318,0x80,0x480d0318,0x0,0x6000,0x480d0318,0x0,0x0,0x0,0x4,0x4,0x0,0x480d031c,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x401000,0x0,0x401001,0x401001,0x0,0x0,0x401001,0x401001,0x401000,0x0,0x401000,0x40000000,0x401000,0x0,0x0,0x0,0x0,0x401000,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x401000,0xd1308,0x401000,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x401000,0x102,0x102,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x4d0308,0x0,0x0,0x0,0x0,0x20,0x0,};
	}
	private static void jj_la1_init_2() {
	   jj_la1_2 = new int[] {0x0,0x10,0x200000,0x0,0x0,0x0,0x200010,0x0,0x0,0x0,0x0,0x0,0x0,0x84103014,0x0,0x0,0x0,0x20000,0xc410b054,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x40000,0x0,0x80,0x0,0x84103014,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc410b054,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x84103014,0x84103014,0x0,0x0,0x20000,0x84103014,0x84103014,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x84103014,0x84103014,0x8410b014,0x8410b014,0x84103014,0x84103014,0x84103014,0x84103014,0x84103014,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400020,0x0,0x0,0x400020,0x0,0x0,0x0,0x0,0x0,0x0,0x84103014,0x0,0xc410b054,0x0,0x84103014,0x0,0x1004,0x0,0x0,0x84103014,0x0,0x84103014,0x0,0x0,0x84103014,0x0,0x0,0x84103014,0x0,0x0,0x0,0x8410f014,0x0,0x84107014,0x84103014,0x0,0x0,0x8410f014,0x0,0x0,0x0,0x0,0xc410b054,0x0,0x0,0x84103014,0x1008408,0x1008408,0x0,0x0,0x0,0x0,0x1008008,0x1008008,0x400,0x0,0x0,0x8000000,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x2000,0x80000000,0x0,0x0,0x20000,0x40000000,0x0,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x20000,0x0,0x10000000,0x10000000,0x0,0x10000000,0x10000000,0x94103014,0x10000000,0x0,0x0,0x0,0x0,0xc410b054,0x0,0xd410b054,0x0,0xc410b054,0x0,0xc410b054,0x10000000,0xc410b054,0x10000000,0x10000000,0x10001,0x0,0x10000000,0x10001,0x0,0xd410b054,0x300,0x10000000,0x300,0xd410b054,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x84103014,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0xc410b054,0xc410b054,0x800,0x0,0x0,0x0,0x0,0x0,0xc410b054,0x0,0x0,0xc410b054,0x0,0xc410b054,0x0,0xd410b054,0x0,0xc410b054,0x0,0x0,0xc410b054,0x0,0x0,0x0,0x0,0x0,0x0,0xc410b054,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x50001000,0x0,0x50001000,0x50001000,0x0,0x0,0x50001000,0x50001000,0x50001000,0x0,0x50001000,0x0,0x50001000,0x0,0x0,0x1000,0x0,0x50001000,0x0,0x0,0x0,0x4000000,0x4000000,0x0,0x0,0x0,0x50001000,0x84103014,0x50001000,0x0,0x0,0x0,0x0,0x0,0x40,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x4000000,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x50001000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x50001000,0x30000000,0x30000000,0x800000,0x0,0x0,0x0,0x0,0x0,0x1000,0x84103014,0x0,0x0,0x0,0x0,0x800000,0x0,};
	}
	private static void jj_la1_init_3() {
	   jj_la1_3 = new int[] {0x0,0x8200000,0x0,0x40000000,0x0,0x0,0x48200000,0x0,0x0,0x0,0x0,0x0,0x0,0xa621e710,0x0,0x0,0x40,0x0,0xe721e710,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x48000000,0x0,0x0,0x0,0x0,0x0,0x0,0xa621e710,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x48000000,0x0,0x4,0xe721e710,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x8000000,0x0,0x4,0x0,0xa621e710,0xa621e710,0x0,0x40,0x0,0xa621e710,0xa621e710,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa621e710,0xa621e710,0xe721e710,0xe721e710,0xa621e710,0xa621e710,0xa621e710,0xa621e710,0xa621e710,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x8000000,0x0,0x0,0x0,0x0,0x8000000,0x40,0x0,0x20000,0x0,0x0,0xa621e710,0x0,0xe721e710,0x0,0xa621e710,0x0,0x0,0x0,0x0,0xa621e710,0x0,0xa621e710,0x0,0x0,0xa621e710,0x0,0x0,0xa621e710,0x8000000,0x0,0x0,0xe721e710,0x0,0xa621e710,0xa621e710,0x800,0x800,0xe721e710,0x0,0x0,0x0,0x0,0xe721e710,0x0,0x0,0xa621e710,0x1000000,0x1000000,0x10000080,0x10000080,0x1000000,0x80,0x1000000,0x1000000,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6000000,0x6000000,0x0,0x0,0x6000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa621e710,0x0,0x0,0x0,0x0,0x180000,0xe721e710,0x0,0xe721e710,0x0,0xe721e710,0x0,0xe721e710,0x0,0xe721e710,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe721e710,0x0,0x0,0x0,0xe721e710,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa621e710,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe721e710,0xe721e710,0x0,0x100,0x200,0x4010000,0x40,0x4010000,0xe721e710,0x1000,0x1000,0xe721e710,0x0,0xe721e710,0x0,0xe721e710,0x0,0xe721e710,0x2000000,0x0,0xe721e710,0x0,0x0,0x0,0x0,0x0,0x8000000,0xef21e710,0x0,0x0,0x0,0x0,0x40,0x20000000,0x0,0x4044004,0x0,0x4044004,0x4044004,0x0,0x0,0x4044004,0x4044004,0x4044004,0x0,0x4044004,0x0,0x4044004,0x0,0x0,0x0,0x4000,0x4044004,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x4044004,0xa621e710,0x4044004,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4044004,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x400000,0x4044004,0x0,0x0,0x0,0x0,0x0,0x40400000,0x4,0x0,0x4000,0xa621e710,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_4() {
	   jj_la1_4 = new int[] {0x0,0x20018000,0x0,0x20400,0x0,0x0,0x20038400,0x0,0x0,0x0,0x0,0x0,0x0,0xd004c8,0x0,0x10000000,0x0,0x0,0xd005c8,0x0,0x0,0x0,0x0,0xc00000,0xc00000,0x0,0x0,0x0,0x20000000,0x20c00000,0x0,0x0,0x0,0x0,0x0,0x0,0x1004c8,0x0,0xc00000,0xc00000,0x0,0x0,0x0,0x20000000,0x0,0x20000000,0x0,0x0,0xd005c8,0x0,0x0,0x0,0xc00000,0xc00000,0x0,0x0,0x0,0x20000000,0x20000000,0x0,0x0,0x0,0xd004c8,0xd004c8,0x10000000,0x0,0x0,0xd004c8,0xd004c8,0x8000000,0x8000000,0x8000000,0x8000000,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x1004c8,0xd004c8,0xd004c8,0xd006c8,0xd004c8,0xd004c8,0xd004c8,0xd004c8,0xd004c8,0x20000000,0x1,0x0,0x42000,0x42000,0x200,0x0,0x0,0x10000000,0x4,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0xd004c8,0x0,0xd005c8,0x0,0xd004c8,0x20000,0x0,0x0,0x0,0xd004c8,0x0,0xd004c8,0x0,0x0,0xd004c8,0x0,0x0,0xd004c8,0x0,0x0,0x0,0xd004c8,0x0,0xd004c8,0xd004c8,0x0,0x0,0xd004c8,0x0,0x0,0x0,0x0,0xd005c8,0x0,0x0,0xd004c8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x4,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xd004c8,0x0,0x0,0x0,0x0,0x0,0xd005ca,0x0,0xd005c8,0x0,0xd005c8,0x0,0xd005c8,0x0,0xd005c8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xd005c8,0x0,0x0,0x0,0xd005c8,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0xd004c8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xd005c8,0xd005c8,0x0,0x40000000,0x0,0x0,0x0,0x0,0xd00dc8,0x0,0x0,0xd00dc8,0x8000000,0xd005c8,0x8000000,0x8d005ca,0x0,0xd005c8,0x0,0x0,0xd005c8,0x0,0x0,0x0,0x0,0x0,0x20000000,0x20d005c8,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x3018a1d0,0x0,0x3018a1d0,0x3018a1d0,0x0,0x0,0x3018a1d0,0x3018a1d0,0x3018a1d0,0x4000,0x3018a1d0,0x0,0x3018a1d0,0x0,0x0,0x0,0x2000,0x3018a1d0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3018a1d0,0xd004c8,0x3018a1d0,0x20000000,0x0,0x0,0x0,0x1000000,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0,0xc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa100,0x301000d0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000008,0x0,0x0,0x0,0x3018a1d0,0x200000,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0xd024c8,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_5() {
	   jj_la1_5 = new int[] {0x4,0x1000000,0x0,0x0,0x4,0x4,0x1000000,0x400000,0x800000,0x800000,0x1000000,0x800000,0x2000000,0x1110001,0x0,0x0,0x0,0x0,0x75191601,0x0,0x0,0x800000,0x800000,0x0,0x0,0x800000,0x800000,0x800000,0x1000000,0x1000000,0x800000,0x0,0x0,0x0,0x0,0x0,0x110001,0x800000,0x0,0x0,0x800000,0x800000,0x800000,0x1000000,0x800000,0x1000000,0x800000,0x0,0x75191601,0x0,0x0,0x800000,0x0,0x0,0x800000,0x800000,0x800000,0x1000000,0x1000000,0x800000,0x0,0x800000,0x110001,0x110001,0x0,0x0,0x0,0x1110001,0x190001,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x800000,0x800000,0x8000000,0x8000000,0x8000000,0x110001,0x110001,0x110001,0x110001,0x110001,0x110001,0x110001,0x110001,0x190001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x1000000,0x0,0x800000,0x0,0x1000000,0x800000,0x190001,0x4000000,0x71191601,0x0,0x190001,0x0,0x0,0x800000,0x110000,0x190001,0x800000,0x1110001,0x800000,0x800000,0x190001,0x800000,0x1000000,0x190001,0x1000000,0x1000000,0x800000,0x1110001,0x1000000,0x110001,0x190001,0x0,0x0,0x1110001,0x800000,0x800000,0x800000,0x800000,0x71191601,0x800000,0x1000000,0x190001,0x800000,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x800000,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x30000400,0x30000400,0x0,0x30000400,0x10000400,0x0,0x0,0x0,0x10000400,0x0,0x31000400,0x10010400,0x0,0x10010400,0x0,0x1000000,0x0,0x0,0x1000000,0x110001,0x0,0x1000000,0x0,0x0,0x104000f8,0x71191601,0x1000000,0x71191601,0x1000000,0x71191601,0x1000000,0x71191601,0x0,0x71191601,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x71191601,0x0,0x0,0x0,0x71191601,0x0,0x800000,0x800000,0x800000,0x0,0x1000000,0x0,0x0,0x0,0x40000000,0x4000000,0x0,0x40000000,0x40000000,0x10000000,0x0,0x0,0x1600,0x0,0x110001,0x80000,0x0,0x0,0x0,0x0,0x0,0x80600,0x0,0x0,0x800000,0x800000,0x75191601,0x75191601,0x0,0x0,0x0,0x0,0x0,0x0,0x71191601,0x0,0x0,0x71191601,0x0,0x71191601,0x0,0x71191601,0x0,0x71191601,0x0,0x0,0x71191601,0x0,0x8000000,0x8000000,0x0,0x0,0x5000000,0x75191601,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x41590600,0x110000,0x41590600,0x41590600,0x800000,0x110000,0x41590600,0x41590600,0x41590600,0x0,0x41590600,0x0,0x41590600,0x800000,0x0,0x0,0x0,0x41590600,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x1000000,0x41590600,0x110001,0x41590600,0x1000000,0x1000000,0x1000000,0x0,0x0,0x10101,0x10101,0x90400,0x90400,0x800000,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x1000000,0x110000,0x110000,0x8000000,0x40000000,0x40000000,0x600,0x40590600,0x1000000,0x190600,0x190600,0xc00000,0xc00000,0x110000,0x800000,0x110000,0x10000,0x0,0x10000,0x10000,0x41590600,0x0,0x0,0x0,0x800000,0x110000,0x0,0x0,0x1000000,0x0,0x1110001,0x110000,0x0,0x110000,0x110000,0x0,0x800000,};
	}
	private static void jj_la1_init_6() {
	   jj_la1_6 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x21680406,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x21680406,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x21680406,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x21680406,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfff,0x21680406,0x0,0x21680406,0x0,0x21680406,0x0,0x21680406,0x0,0x21680406,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x21680406,0x0,0x0,0x0,0x21680406,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf000,0xf000,0x400,0x30000,0x40000,0x404,0x404,0x0,0x1000002,0x0,0x0,0x0,0x0,0x680000,0x800000,0x1000002,0x1e000000,0x1e000000,0x400,0x0,0x0,0x0,0x0,0x0,0x21680406,0x21680406,0x0,0x0,0x0,0x0,0x0,0x0,0x21680406,0x0,0x0,0x21680406,0x0,0x21680406,0x0,0x21680406,0x0,0x21680406,0x0,0x0,0x21680406,0x20000000,0x0,0x0,0x0,0x0,0x0,0x21680406,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x400,0x0,0x400,0x400,0x0,0x0,0x400,0x400,0x400,0x0,0x400,0x0,0x400,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x400,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
  final private JJCalls[] jj_2_rtns = new JJCalls[100];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor. */
  public CCJSqlParser(Provider stream) {
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new CCJSqlParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 373; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public CCJSqlParser(String dsl) throws ParseException, TokenMgrException {
	   this(new StringProvider(dsl));
  }

  public void ReInit(String s) {
	  ReInit(new StringProvider(s));
  }
  /** Reinitialise. */
  public void ReInit(Provider stream) {
	if (jj_input_stream == null) {
	   jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	   jj_input_stream.ReInit(stream, 1, 1);
	}
	if (token_source == null) {
 token_source = new CCJSqlParserTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jjtree.reset();
	 jj_gen = 0;
	 for (int i = 0; i < 373; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public CCJSqlParser(CCJSqlParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 373; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(CCJSqlParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jjtree.reset();
	 jj_gen = 0;
	 for (int i = 0; i < 373; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken;
	 if ((oldToken = token).next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 if (token.kind == kind) {
	   jj_gen++;
	   if (++jj_gc > 100) {
		 jj_gc = 0;
		 for (int i = 0; i < jj_2_rtns.length; i++) {
		   JJCalls c = jj_2_rtns[i];
		   while (c != null) {
			 if (c.gen < jj_gen) c.first = null;
			 c = c.next;
		   }
		 }
	   }
	   return token;
	 }
	 token = oldToken;
	 jj_kind = kind;
	 throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.RuntimeException { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		 jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		 jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
	 Token t = jj_lookingAhead ? jj_scanpos : token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  private int jj_ntk_f() {
	 if ((jj_nt=token.next) == null)
	   return (jj_ntk = (token.next=token_source.getNextToken()).kind);
	 else
	   return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
	 if (pos >= 100) {
		return;
	 }

	 if (pos == jj_endpos + 1) {
	   jj_lasttokens[jj_endpos++] = kind;
	 } else if (jj_endpos != 0) {
	   jj_expentry = new int[jj_endpos];

	   for (int i = 0; i < jj_endpos; i++) {
		 jj_expentry[i] = jj_lasttokens[i];
	   }

	   for (int[] oldentry : jj_expentries) {
		 if (oldentry.length == jj_expentry.length) {
		   boolean isMatched = true;

		   for (int i = 0; i < jj_expentry.length; i++) {
			 if (oldentry[i] != jj_expentry[i]) {
			   isMatched = false;
			   break;
			 }

		   }
		   if (isMatched) {
			 jj_expentries.add(jj_expentry);
			 break;
		   }
		 }
	   }

	   if (pos != 0) {
		 jj_lasttokens[(jj_endpos = pos) - 1] = kind;
	   }
	 }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
	 jj_expentries.clear();
	 boolean[] la1tokens = new boolean[224];
	 if (jj_kind >= 0) {
	   la1tokens[jj_kind] = true;
	   jj_kind = -1;
	 }
	 for (int i = 0; i < 373; i++) {
	   if (jj_la1[i] == jj_gen) {
		 for (int j = 0; j < 32; j++) {
		   if ((jj_la1_0[i] & (1<<j)) != 0) {
			 la1tokens[j] = true;
		   }
		   if ((jj_la1_1[i] & (1<<j)) != 0) {
			 la1tokens[32+j] = true;
		   }
		   if ((jj_la1_2[i] & (1<<j)) != 0) {
			 la1tokens[64+j] = true;
		   }
		   if ((jj_la1_3[i] & (1<<j)) != 0) {
			 la1tokens[96+j] = true;
		   }
		   if ((jj_la1_4[i] & (1<<j)) != 0) {
			 la1tokens[128+j] = true;
		   }
		   if ((jj_la1_5[i] & (1<<j)) != 0) {
			 la1tokens[160+j] = true;
		   }
		   if ((jj_la1_6[i] & (1<<j)) != 0) {
			 la1tokens[192+j] = true;
		   }
		 }
	   }
	 }
	 for (int i = 0; i < 224; i++) {
	   if (la1tokens[i]) {
		 jj_expentry = new int[1];
		 jj_expentry[0] = i;
		 jj_expentries.add(jj_expentry);
	   }
	 }
	 jj_endpos = 0;
	 jj_rescan_token();
	 jj_add_error_token(0, 0);
	 int[][] exptokseq = new int[jj_expentries.size()][];
	 for (int i = 0; i < jj_expentries.size(); i++) {
	   exptokseq[i] = jj_expentries.get(i);
	 }
	 return new ParseException(token, exptokseq, tokenImage, token_source == null ? null : CCJSqlParserTokenManager.lexStateNames[token_source.curLexState]);
  }

  private int trace_indent = 0;
  private boolean trace_enabled;

/** Trace enabled. */
  final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
	 jj_rescan = true;
	 for (int i = 0; i < 100; i++) {
	   try {
		 JJCalls p = jj_2_rtns[i];

		 do {
		   if (p.gen > jj_gen) {
			 jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
			 switch (i) {
			   case 0: jj_3_1(); break;
			   case 1: jj_3_2(); break;
			   case 2: jj_3_3(); break;
			   case 3: jj_3_4(); break;
			   case 4: jj_3_5(); break;
			   case 5: jj_3_6(); break;
			   case 6: jj_3_7(); break;
			   case 7: jj_3_8(); break;
			   case 8: jj_3_9(); break;
			   case 9: jj_3_10(); break;
			   case 10: jj_3_11(); break;
			   case 11: jj_3_12(); break;
			   case 12: jj_3_13(); break;
			   case 13: jj_3_14(); break;
			   case 14: jj_3_15(); break;
			   case 15: jj_3_16(); break;
			   case 16: jj_3_17(); break;
			   case 17: jj_3_18(); break;
			   case 18: jj_3_19(); break;
			   case 19: jj_3_20(); break;
			   case 20: jj_3_21(); break;
			   case 21: jj_3_22(); break;
			   case 22: jj_3_23(); break;
			   case 23: jj_3_24(); break;
			   case 24: jj_3_25(); break;
			   case 25: jj_3_26(); break;
			   case 26: jj_3_27(); break;
			   case 27: jj_3_28(); break;
			   case 28: jj_3_29(); break;
			   case 29: jj_3_30(); break;
			   case 30: jj_3_31(); break;
			   case 31: jj_3_32(); break;
			   case 32: jj_3_33(); break;
			   case 33: jj_3_34(); break;
			   case 34: jj_3_35(); break;
			   case 35: jj_3_36(); break;
			   case 36: jj_3_37(); break;
			   case 37: jj_3_38(); break;
			   case 38: jj_3_39(); break;
			   case 39: jj_3_40(); break;
			   case 40: jj_3_41(); break;
			   case 41: jj_3_42(); break;
			   case 42: jj_3_43(); break;
			   case 43: jj_3_44(); break;
			   case 44: jj_3_45(); break;
			   case 45: jj_3_46(); break;
			   case 46: jj_3_47(); break;
			   case 47: jj_3_48(); break;
			   case 48: jj_3_49(); break;
			   case 49: jj_3_50(); break;
			   case 50: jj_3_51(); break;
			   case 51: jj_3_52(); break;
			   case 52: jj_3_53(); break;
			   case 53: jj_3_54(); break;
			   case 54: jj_3_55(); break;
			   case 55: jj_3_56(); break;
			   case 56: jj_3_57(); break;
			   case 57: jj_3_58(); break;
			   case 58: jj_3_59(); break;
			   case 59: jj_3_60(); break;
			   case 60: jj_3_61(); break;
			   case 61: jj_3_62(); break;
			   case 62: jj_3_63(); break;
			   case 63: jj_3_64(); break;
			   case 64: jj_3_65(); break;
			   case 65: jj_3_66(); break;
			   case 66: jj_3_67(); break;
			   case 67: jj_3_68(); break;
			   case 68: jj_3_69(); break;
			   case 69: jj_3_70(); break;
			   case 70: jj_3_71(); break;
			   case 71: jj_3_72(); break;
			   case 72: jj_3_73(); break;
			   case 73: jj_3_74(); break;
			   case 74: jj_3_75(); break;
			   case 75: jj_3_76(); break;
			   case 76: jj_3_77(); break;
			   case 77: jj_3_78(); break;
			   case 78: jj_3_79(); break;
			   case 79: jj_3_80(); break;
			   case 80: jj_3_81(); break;
			   case 81: jj_3_82(); break;
			   case 82: jj_3_83(); break;
			   case 83: jj_3_84(); break;
			   case 84: jj_3_85(); break;
			   case 85: jj_3_86(); break;
			   case 86: jj_3_87(); break;
			   case 87: jj_3_88(); break;
			   case 88: jj_3_89(); break;
			   case 89: jj_3_90(); break;
			   case 90: jj_3_91(); break;
			   case 91: jj_3_92(); break;
			   case 92: jj_3_93(); break;
			   case 93: jj_3_94(); break;
			   case 94: jj_3_95(); break;
			   case 95: jj_3_96(); break;
			   case 96: jj_3_97(); break;
			   case 97: jj_3_98(); break;
			   case 98: jj_3_99(); break;
			   case 99: jj_3_100(); break;
			 }
		   }
		   p = p.next;
		 } while (p != null);

		 } catch(LookaheadSuccess ls) { }
	 }
	 jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
	 JJCalls p = jj_2_rtns[index];
	 while (p.gen > jj_gen) {
	   if (p.next == null) { p = p.next = new JJCalls(); break; }
	   p = p.next;
	 }

	 p.gen = jj_gen + xla - jj_la; 
	 p.first = token;
	 p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
