/* Generated By:JavaCC: Do not edit this line. StringProvider.java Version 7.0 */
/* JavaCCOptions:KEEP_LINE_COLUMN=true */
/*
 * #%L
 * JSQLParser library
 * %%
 * Copyright (C) 2004 - 2014 JSQLParser
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-2.1.html>.
 * #L%
 */

package net.sf.jsqlparser.parser;

	
	import java.io.IOException;
	
	public class StringProvider implements Provider {

		String _string;
		int _position = 0;
		int _size;
		
		public StringProvider(String string) {
			_string = string;
			_size = string.length();
		}
		
		@Override
		public int read(char[] cbuf, int off, int len) throws IOException {
			int numCharsOutstandingInString = _size - _position;
			
			if (numCharsOutstandingInString == 0) {
				return -1;
			}
			
			int numBytesInBuffer = cbuf.length;
			int numBytesToRead = numBytesInBuffer -off;
			numBytesToRead = numBytesToRead > len ? len : numBytesToRead;
			
			if (numBytesToRead > numCharsOutstandingInString) {
				numBytesToRead = numCharsOutstandingInString;
			}
			
			_string.getChars(_position, _position + numBytesToRead, cbuf, off);
			
			_position += numBytesToRead;
			
			return numBytesToRead;
		}

		@Override
		public void close() throws IOException {
			_string = null;
		}
		
	}
/* JavaCC - OriginalChecksum=d1a78cf502a4b49df56a246a05801926 (do not edit this line) */
