/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.Edge;
import java.io.PrintStream;
import java.util.Iterator;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.InstructionHandle;

public class CFGPrinter {
    private final CFG cfg;
    private boolean isForwards;

    public CFGPrinter(CFG cfg) {
        this.cfg = cfg;
        this.isForwards = true;
    }

    public void setIsForwards(boolean isForwards) {
        this.isForwards = isForwards;
    }

    public boolean isForwards() {
        return this.isForwards;
    }

    public void print(PrintStream out) {
        Iterator<BasicBlock> i = this.cfg.blockIterator();
        while (i.hasNext()) {
            Iterator edgeIter;
            CodeExceptionGen exceptionGen;
            BasicBlock bb = i.next();
            out.println();
            out.println("BASIC BLOCK: " + bb.getLabel() + (bb.isExceptionThrower() ? " [EXCEPTION THROWER]" : "") + this.blockStartAnnotate(bb));
            if (bb.isExceptionThrower()) {
                out.println("  Exception thrower: " + bb.getExceptionThrower());
            }
            if ((exceptionGen = bb.getExceptionGen()) != null) {
                out.println("\tCATCHES " + exceptionGen.getCatchType());
            }
            Iterator<InstructionHandle> j = this.instructionIterator(bb);
            while (j.hasNext()) {
                InstructionHandle handle = j.next();
                out.println(handle + this.instructionAnnotate(handle, bb));
            }
            out.println("END" + this.blockAnnotate(bb));
            Iterator iterator = edgeIter = this.isForwards ? this.cfg.outgoingEdgeIterator(bb) : this.cfg.incomingEdgeIterator(bb);
            while (edgeIter.hasNext()) {
                Edge edge = (Edge)edgeIter.next();
                out.println("  " + edge.formatAsString(!this.isForwards) + " " + this.edgeAnnotate(edge));
            }
        }
    }

    public String edgeAnnotate(Edge edge) {
        return "";
    }

    public String blockStartAnnotate(BasicBlock block) {
        return "";
    }

    public String blockAnnotate(BasicBlock block) {
        return "";
    }

    public String instructionAnnotate(InstructionHandle handle, BasicBlock bb) {
        return "";
    }

    protected Iterator<InstructionHandle> instructionIterator(BasicBlock bb) {
        if (this.isForwards) {
            return bb.instructionIterator();
        }
        return bb.instructionReverseIterator();
    }
}

