/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import java.util.Arrays;
import java.util.List;

public class InefficientIndexOf
extends OpcodeStackDetector {
    private final BugReporter bugReporter;
    private static final List<MethodDescriptor> methods = Arrays.asList(new MethodDescriptor("java/lang/String", "indexOf", "(Ljava/lang/String;)I"), new MethodDescriptor("java/lang/String", "lastIndexOf", "(Ljava/lang/String;)I"), new MethodDescriptor("java/lang/String", "indexOf", "(Ljava/lang/String;I)I"), new MethodDescriptor("java/lang/String", "lastIndexOf", "(Ljava/lang/String;I)I"));

    public InefficientIndexOf(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        if (InefficientIndexOf.hasInterestingMethod(classContext.getJavaClass().getConstantPool(), methods)) {
            super.visitClassContext(classContext);
        }
    }

    @Override
    public void sawOpcode(int seen) {
        boolean lastIndexOf;
        if (seen == 182 && this.stack.getStackDepth() > 0 && "java/lang/String".equals(this.getClassConstantOperand()) && ((lastIndexOf = "lastIndexOf".equals(this.getNameConstantOperand())) || "indexOf".equals(this.getNameConstantOperand()))) {
            OpcodeStack.Item item;
            Object o;
            int stackOff = -1;
            if ("(Ljava/lang/String;)I".equals(this.getSigConstantOperand())) {
                stackOff = 0;
            } else if ("(Ljava/lang/String;I)I".equals(this.getSigConstantOperand())) {
                stackOff = 1;
            }
            if (stackOff > -1 && (o = (item = this.stack.getStackItem(stackOff)).getConstant()) != null && ((String)o).length() == 1) {
                this.bugReporter.reportBug(new BugInstance(this, lastIndexOf ? "IIO_INEFFICIENT_LAST_INDEX_OF" : "IIO_INEFFICIENT_INDEX_OF", 3).addClassAndMethod(this).describe("STRING_MESSAGE").addCalledMethod(this).addSourceLine(this));
            }
        }
    }
}

