/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.tools;

import java.io.DataInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class CheckClassfileVersion {
    private static boolean isJarFile(File f) {
        String name = f.getName();
        return name.endsWith(".jar") || name.endsWith(".zip") || name.endsWith("war") || name.endsWith(".ear");
    }

    public static void main(String[] args) throws Exception {
        boolean fail = false;
        ArrayList<File> s = new ArrayList<File>(args.length);
        for (String f : args) {
            File file = new File(f);
            if (!file.canRead()) {
                System.out.println("Can't read " + f);
            }
            if (file.isDirectory()) {
                for (File f2 : file.listFiles()) {
                    if (!CheckClassfileVersion.isJarFile(f2)) continue;
                    s.add(f2);
                }
                continue;
            }
            if (!CheckClassfileVersion.isJarFile(file)) continue;
            s.add(file);
        }
        for (File jarFile : s) {
            String jarFileName = jarFile.getName();
            System.out.println("Checking " + jarFileName);
            JarFile z = new JarFile(jarFile);
            Throwable throwable = null;
            try {
                Enumeration<JarEntry> e = z.entries();
                while (e.hasMoreElements()) {
                    String name;
                    boolean isClassFile;
                    JarEntry ze = e.nextElement();
                    if (ze.isDirectory() || !(isClassFile = (name = ze.getName()).endsWith(".class"))) continue;
                    DataInputStream zipIn = new DataInputStream(z.getInputStream(ze));
                    int magic = zipIn.readInt();
                    int minorVersion = zipIn.readUnsignedShort();
                    if (magic != -889275714) {
                        System.out.printf("bad magic %x: %s %s%n", magic, jarFileName, name);
                        fail = true;
                    } else if (minorVersion >= 60) {
                        System.out.printf("bad version %d:%s %s%n", minorVersion, jarFileName, name);
                        fail = true;
                    }
                    zipIn.close();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (z == null) continue;
                if (throwable != null) {
                    try {
                        z.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                z.close();
            }
        }
        if (fail) {
            System.exit(1);
        }
    }
}

