/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.tools.html;

import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.tools.html.ColorAlternator;
import edu.umd.cs.findbugs.tools.html.PlainPrintBugDescriptions;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

public class PrettyPrintBugDescriptions
extends PlainPrintBugDescriptions {
    private final Set<BugPattern> bugPatternSet = new TreeSet<BugPattern>(new BugPatternComparator());
    private String headerText = "";
    private String beginBodyText = "";
    private String prologueText = "";
    private String endBodyText = "";
    private boolean unabridged;
    private static final String[] TABLE_COLORS = new String[]{"#eeeeee", "#ffffff"};

    public PrettyPrintBugDescriptions(String docTitle, OutputStream out) {
        super(docTitle, out);
    }

    public void setHeaderText(String headerText) {
        this.headerText = headerText;
    }

    public void setBeginBodyText(String beginBodyText) {
        this.beginBodyText = beginBodyText;
    }

    public void setPrologueText(String prologueText) {
        this.prologueText = prologueText;
    }

    public void setEndBodyText(String endBodyText) {
        this.endBodyText = endBodyText;
    }

    @Override
    protected void prologue() throws IOException {
        super.prologue();
        PrintStream out = this.getPrintStream();
        out.println(this.prologueText);
    }

    @Override
    protected void emit(BugPattern bugPattern) throws IOException {
        this.bugPatternSet.add(bugPattern);
    }

    @Override
    protected void epilogue() throws IOException {
        this.emitSummaryTable();
        this.emitBugDescriptions();
        super.epilogue();
    }

    @Override
    protected void header() throws IOException {
        PrintStream out = this.getPrintStream();
        out.println(this.headerText);
    }

    @Override
    protected void beginBody() throws IOException {
        PrintStream out = this.getPrintStream();
        out.println(this.beginBodyText);
    }

    @Override
    protected void endBody() throws IOException {
        PrintStream out = this.getPrintStream();
        out.println(this.endBodyText);
    }

    private void emitSummaryTable() {
        PrintStream out = this.getPrintStream();
        out.println("<h2>Summary</h2>");
        out.println("<table width=\"100%\">");
        out.println("<tr bgcolor=\"#b9b9fe\"><th>Description</th><th>Category</th></tr>");
        ColorAlternator colorAlternator = new ColorAlternator(TABLE_COLORS);
        for (BugPattern bugPattern : this.bugPatternSet) {
            out.print("<tr bgcolor=\"" + colorAlternator.nextColor() + "\">");
            out.print("<td><a href=\"#" + bugPattern.getType() + "\">" + bugPattern.getAbbrev() + ": " + bugPattern.getShortDescription() + "</a></td>");
            out.println("<td>" + I18N.instance().getBugCategoryDescription(bugPattern.getCategory()) + "</td></tr>");
        }
        out.println("</table>");
    }

    private void emitBugDescriptions() {
        PrintStream out = this.getPrintStream();
        out.println("<h2>Descriptions</h2>");
        for (BugPattern bugPattern : this.bugPatternSet) {
            out.println("<h3><a name=\"" + bugPattern.getType() + "\">" + bugPattern.getAbbrev() + ": " + bugPattern.getShortDescription() + " (" + bugPattern.getType() + ")" + "</a></h3>");
            out.println(bugPattern.getDetailText());
        }
    }

    @Override
    protected boolean isEnabled(DetectorFactory factory) {
        return this.unabridged || super.isEnabled(factory);
    }

    public static void main(String[] args) throws Exception {
        int argCount = 0;
        boolean unabridged = false;
        if (argCount < args.length && "-unabridged".equals(args[argCount])) {
            ++argCount;
            unabridged = true;
        }
        if (Boolean.getBoolean("findbugs.bugdesc.unabridged")) {
            unabridged = true;
        }
        String docTitle = "FindBugs Bug Descriptions";
        if (argCount < args.length) {
            docTitle = args[argCount++];
        }
        PrettyPrintBugDescriptions pp = new PrettyPrintBugDescriptions(docTitle, System.out);
        if (argCount < args.length) {
            pp.setHeaderText(args[argCount++]);
        }
        if (argCount < args.length) {
            pp.setBeginBodyText(args[argCount++]);
        }
        if (argCount < args.length) {
            pp.setPrologueText(args[argCount++]);
        }
        if (argCount < args.length) {
            pp.setEndBodyText(args[argCount++]);
        }
        if (unabridged) {
            pp.unabridged = true;
        }
        pp.print();
    }

    private static class BugPatternComparator
    implements Comparator<BugPattern>,
    Serializable {
        private BugPatternComparator() {
        }

        @Override
        public int compare(BugPattern a, BugPattern b) {
            int cmp = a.getCategory().compareTo(b.getCategory());
            if (cmp != 0) {
                return cmp;
            }
            cmp = a.getAbbrev().compareTo(b.getAbbrev());
            if (cmp != 0) {
                return cmp;
            }
            return a.getType().compareTo(b.getType());
        }
    }
}

