/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.util;

import edu.umd.cs.findbugs.internalAnnotations.StaticConstant;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class Archive {
    @StaticConstant
    public static final Set<String> ARCHIVE_EXTENSION_SET = new HashSet<String>();

    public static boolean isArchiveFileName(String fileName) {
        String extension = Archive.getExtension(fileName);
        return ARCHIVE_EXTENSION_SET.contains(extension);
    }

    private static String getExtension(String fileName) {
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot < 0) {
            return fileName;
        }
        String extension = fileName.substring(lastDot).toLowerCase(Locale.ENGLISH);
        return extension;
    }

    public static boolean isLibraryFileName(String fileName) {
        String extension = Archive.getExtension(fileName);
        return ".jar".equals(extension);
    }

    static {
        ARCHIVE_EXTENSION_SET.add(".jar");
        ARCHIVE_EXTENSION_SET.add(".zip");
        ARCHIVE_EXTENSION_SET.add(".war");
        ARCHIVE_EXTENSION_SET.add(".ear");
        ARCHIVE_EXTENSION_SET.add(".sar");
    }
}

