/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.charsets.UTF8;
import java.io.IOException;
import java.io.PrintWriter;
import org.dom4j.DocumentException;

public class CloudReport {
    private static final String USAGE = "Usage: <cmd>   [<bugs.xml>]";

    public static void main(String[] args) throws IOException, DocumentException {
        FindBugs.setNoAnalysis();
        DetectorFactoryCollection.instance();
        if (args.length > 1) {
            System.out.println(USAGE);
            return;
        }
        SortedBugCollection bugs = new SortedBugCollection();
        if (args.length == 0) {
            bugs.readXML(System.in);
        } else {
            bugs.readXML(args[0]);
        }
        bugs.getCloud().waitUntilIssueDataDownloaded();
        PrintWriter out = UTF8.printWriter(System.out);
        bugs.getCloud().printCloudSummary(out, bugs, new String[0]);
        out.close();
    }
}

