/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneToken;
import com.google.errorprone.util.ErrorProneTokens;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TypeAnnotations;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;

@BugPattern(name="AnnotationPosition", summary="Annotations should be positioned after Javadocs, but before modifiers..", severity=BugPattern.SeverityLevel.WARNING, tags={"Style"}, linkType=BugPattern.LinkType.CUSTOM, link="https://google.github.io/styleguide/javaguide.html#s4.8.5-annotations", providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public final class AnnotationPosition
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final ImmutableMap<String, Tokens.TokenKind> TOKEN_KIND_BY_NAME = (ImmutableMap)Arrays.stream(Tokens.TokenKind.values()).collect(ImmutableMap.toImmutableMap(tk -> tk.name(), tk -> tk));
    private static final ImmutableSet<Tokens.TokenKind> MODIFIERS = (ImmutableSet)Arrays.stream(Modifier.values()).map(m -> (Tokens.TokenKind)TOKEN_KIND_BY_NAME.get((Object)m.name())).collect(ImmutableSet.toImmutableSet());

    public Description matchClass(ClassTree tree, VisitorState state) {
        return this.handle(tree, tree.getSimpleName(), tree.getModifiers(), state);
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        return this.handle(tree, tree.getName(), tree.getModifiers(), state);
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)tree);
        if (((Symbol)symbol).getKind() != ElementKind.FIELD) {
            return Description.NO_MATCH;
        }
        return this.handle(tree, tree.getName(), tree.getModifiers(), state);
    }

    private Description handle(Tree tree, Name name, ModifiersTree modifiers, VisitorState state) {
        int lastModifierPos;
        int firstModifierPos;
        Description description;
        java.util.List<? extends AnnotationTree> annotations = modifiers.getAnnotations();
        if (annotations.isEmpty()) {
            return Description.NO_MATCH;
        }
        int treePos = ((JCTree)tree).getStartPosition();
        ImmutableList<ErrorProneToken> tokens = AnnotationPosition.annotationTokens(tree, state, treePos);
        Tokens.Comment danglingJavadoc = AnnotationPosition.findOrphanedJavadoc(name, tokens);
        ImmutableList modifierTokens = (ImmutableList)tokens.stream().filter(t -> MODIFIERS.contains((Object)t.kind())).collect(ImmutableList.toImmutableList());
        if (!modifierTokens.isEmpty() && !(description = this.checkAnnotations(tree, treePos, annotations, danglingJavadoc, firstModifierPos = treePos + ((ErrorProneToken)modifierTokens.get(0)).pos(), lastModifierPos = treePos + ((ErrorProneToken)Iterables.getLast((Iterable)modifierTokens)).endPos(), state)).equals(Description.NO_MATCH)) {
            return description;
        }
        if (danglingJavadoc != null) {
            SuggestedFix.Builder builder = SuggestedFix.builder();
            String javadoc = AnnotationPosition.removeJavadoc(state, treePos, danglingJavadoc, builder);
            String message = "Javadocs should appear before any modifiers or annotations.";
            return this.buildDescription(tree).setMessage(message).addFix((Fix)builder.prefixWith(tree, javadoc).build()).build();
        }
        return Description.NO_MATCH;
    }

    private static ImmutableList<ErrorProneToken> annotationTokens(Tree tree, VisitorState state, int annotationEnd) {
        int endPos;
        if (tree instanceof JCTree.JCMethodDecl) {
            JCTree.JCMethodDecl methodTree = (JCTree.JCMethodDecl)tree;
            endPos = methodTree.getBody() == null ? state.getEndPosition((Tree)methodTree) : methodTree.getBody().getStartPosition();
        } else if (tree instanceof JCTree.JCVariableDecl) {
            endPos = ((JCTree.JCVariableDecl)tree).getType().getStartPosition();
        } else if (tree instanceof JCTree.JCClassDecl) {
            JCTree.JCClassDecl classTree = (JCTree.JCClassDecl)tree;
            endPos = ((List)classTree.getMembers()).isEmpty() ? state.getEndPosition((Tree)classTree) : ((JCTree)((List)classTree.getMembers()).get(0)).getStartPosition();
        } else {
            throw new AssertionError();
        }
        return ErrorProneTokens.getTokens((String)state.getSourceCode().subSequence(annotationEnd, endPos).toString(), (Context)state.context);
    }

    private Description checkAnnotations(Tree tree, int treePos, java.util.List<? extends AnnotationTree> annotations, Tokens.Comment danglingJavadoc, int firstModifierPos, int lastModifierPos, VisitorState state) {
        SuggestedFix.Builder builder = SuggestedFix.builder();
        ArrayList<AnnotationTree> moveBefore = new ArrayList<AnnotationTree>();
        ArrayList<AnnotationTree> moveAfter = new ArrayList<AnnotationTree>();
        boolean annotationProblem = false;
        for (AnnotationTree annotationTree : annotations) {
            int annotationPos = ((JCTree)((Object)annotationTree)).getStartPosition();
            if (annotationPos <= firstModifierPos) continue;
            TypeAnnotations.AnnotationType annotationType = ASTHelpers.getAnnotationType((AnnotationTree)annotationTree, (Symbol)ASTHelpers.getSymbol((Tree)tree), (VisitorState)state);
            if (annotationPos >= lastModifierPos) {
                if (!(tree instanceof ClassTree) && annotationType != TypeAnnotations.AnnotationType.DECLARATION) continue;
                annotationProblem = true;
                moveBefore.add(annotationTree);
                continue;
            }
            annotationProblem = true;
            if (tree instanceof ClassTree || annotationType == TypeAnnotations.AnnotationType.DECLARATION || annotationType == null) {
                moveBefore.add(annotationTree);
                continue;
            }
            moveAfter.add(annotationTree);
        }
        if (annotationProblem) {
            for (AnnotationTree annotationTree : moveBefore) {
                builder.delete((Tree)annotationTree);
            }
            for (AnnotationTree annotationTree : moveAfter) {
                builder.delete((Tree)annotationTree);
            }
            String javadoc = danglingJavadoc == null ? "" : AnnotationPosition.removeJavadoc(state, treePos, danglingJavadoc, builder);
            builder.replace(firstModifierPos, firstModifierPos, String.format("%s%s ", javadoc, AnnotationPosition.joinSource(state, moveBefore))).replace(lastModifierPos, lastModifierPos, String.format("%s ", AnnotationPosition.joinSource(state, moveAfter)));
            ImmutableList immutableList = (ImmutableList)annotations.stream().map(ASTHelpers::getSymbol).filter(Objects::nonNull).map(Symbol::getSimpleName).map(a -> "@" + a).collect(ImmutableList.toImmutableList());
            String flattened = immutableList.stream().collect(Collectors.joining(", "));
            String isAre = immutableList.size() > 1 ? "are not type annotations" : "is not a type annotation";
            String message = String.format("%s %s, so should appear before any modifiers and after Javadocs.", flattened, isAre);
            return this.buildDescription(tree).setMessage(message).addFix((Fix)builder.build()).build();
        }
        return Description.NO_MATCH;
    }

    private static String joinSource(VisitorState state, java.util.List<AnnotationTree> moveBefore) {
        return moveBefore.stream().map(arg_0 -> ((VisitorState)state).getSourceForNode(arg_0)).collect(Collectors.joining(" "));
    }

    private static String removeJavadoc(VisitorState state, int startPos, Tokens.Comment danglingJavadoc, SuggestedFix.Builder builder) {
        int javadocStart = startPos + danglingJavadoc.getSourcePos(0);
        int javadocEnd = javadocStart + danglingJavadoc.getText().length();
        if (state.getSourceCode().charAt(javadocEnd) == '\n') {
            ++javadocEnd;
        }
        builder.replace(javadocStart, javadocEnd, "");
        return danglingJavadoc.getText();
    }

    @Nullable
    private static Tokens.Comment findOrphanedJavadoc(Name name, java.util.List<ErrorProneToken> tokens) {
        for (ErrorProneToken token : tokens) {
            for (Tokens.Comment comment : token.comments()) {
                if (!comment.getText().startsWith("/**")) continue;
                return comment;
            }
            if (token.kind() != Tokens.TokenKind.IDENTIFIER || !token.name().equals(name)) continue;
            return null;
        }
        return null;
    }
}

