/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.ArrayList;
import java.util.List;

@BugPattern(name="EqualsUnsafeCast", summary="The contract of #equals states that it should return false for incompatible types, while this implementation may throw ClassCastException.", providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION, severity=BugPattern.SeverityLevel.WARNING)
public final class EqualsUnsafeCast
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final String INSTANCEOF_CHECK = "if (!(%s instanceof %s)) { return false; }";

    public Description matchMethod(MethodTree tree, final VisitorState state) {
        if (!Matchers.equalsMethodDeclaration().matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        final Symbol.VarSymbol parameter = ASTHelpers.getSymbol((VariableTree)((VariableTree)Iterables.getOnlyElement(tree.getParameters())));
        new TreePathScanner<Void, Void>(){
            private boolean methodInvoked = false;
            private final List<Type> checkedTypes = new ArrayList<Type>();

            @Override
            public Void visitInstanceOf(InstanceOfTree node, Void unused) {
                this.checkedTypes.add(ASTHelpers.getType((Tree)node.getType()));
                return (Void)super.visitInstanceOf(node, null);
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree node, Void unused) {
                this.methodInvoked = true;
                return null;
            }

            @Override
            public Void visitTypeCast(TypeCastTree node, Void unused) {
                ExpressionTree expression = node.getExpression();
                if (!this.methodInvoked && expression.getKind() == Tree.Kind.IDENTIFIER && parameter.equals(ASTHelpers.getSymbol((Tree)expression)) && this.checkedTypes.stream().noneMatch(t -> ASTHelpers.isSubtype((Type)t, (Type)ASTHelpers.getType((Tree)node.getType()), (VisitorState)state))) {
                    StatementTree enclosingStatement = (StatementTree)ASTHelpers.findEnclosingNode((TreePath)this.getCurrentPath(), StatementTree.class);
                    state.reportMatch(EqualsUnsafeCast.this.describeMatch(node, (Fix)SuggestedFix.prefixWith((Tree)enclosingStatement, (String)String.format(EqualsUnsafeCast.INSTANCEOF_CHECK, state.getSourceForNode((Tree)expression), state.getSourceForNode(node.getType())))));
                }
                return (Void)super.visitTypeCast(node, null);
            }
        }.scan(state.getPath(), (Void)null);
        return Description.NO_MATCH;
    }
}

