/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import java.util.Optional;

@BugPattern(name="IdentityBinaryExpression", altNames={"SelfEquality"}, category=BugPattern.Category.JDK, summary="A binary expression where both operands are the same is usually incorrect.", severity=BugPattern.SeverityLevel.ERROR)
public class IdentityBinaryExpression
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    private static final Matcher<Tree> ASSERTION = Matchers.toType(ExpressionTree.class, (Matcher)MethodMatchers.staticMethod().anyClass().namedAnyOf(new String[]{"assertTrue", "assertFalse", "assertThat"}));

    public Description matchBinary(BinaryTree tree, VisitorState state) {
        String replacement;
        if (ASTHelpers.constValue((Tree)tree.getLeftOperand()) != null) {
            switch (tree.getKind()) {
                case LEFT_SHIFT: 
                case DIVIDE: 
                case MINUS: {
                    return Description.NO_MATCH;
                }
            }
        }
        switch (tree.getKind()) {
            case DIVIDE: {
                replacement = "1";
                break;
            }
            case MINUS: 
            case REMAINDER: {
                replacement = "0";
                break;
            }
            case GREATER_THAN_EQUAL: 
            case LESS_THAN_EQUAL: 
            case EQUAL_TO: {
                if (ASSERTION.matches(state.getPath().getParentPath().getLeaf(), state)) {
                    return Description.NO_MATCH;
                }
                replacement = "true";
                break;
            }
            case LESS_THAN: 
            case GREATER_THAN: 
            case NOT_EQUAL_TO: 
            case XOR: {
                if (ASSERTION.matches(state.getPath().getParentPath().getLeaf(), state)) {
                    return Description.NO_MATCH;
                }
                replacement = "false";
                break;
            }
            case AND: 
            case OR: 
            case CONDITIONAL_AND: 
            case CONDITIONAL_OR: {
                replacement = state.getSourceForNode((Tree)tree.getLeftOperand());
                break;
            }
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: {
                replacement = null;
                break;
            }
            default: {
                return Description.NO_MATCH;
            }
        }
        if (!tree.getLeftOperand().toString().equals(tree.getRightOperand().toString())) {
            return Description.NO_MATCH;
        }
        switch (tree.getKind()) {
            case EQUAL_TO: {
                replacement = IdentityBinaryExpression.isNanReplacement(tree, state).orElse(replacement);
                break;
            }
            case NOT_EQUAL_TO: {
                replacement = IdentityBinaryExpression.isNanReplacement(tree, state).map(r -> "!" + r).orElse(replacement);
                break;
            }
        }
        Description.Builder description = this.buildDescription(tree);
        if (replacement != null) {
            description.setMessage(String.format("A binary expression where both operands are the same is usually incorrect; the value of this expression is equivalent to `%s`.", replacement));
        }
        return description.build();
    }

    private static Optional<String> isNanReplacement(BinaryTree tree, VisitorState state) {
        String name;
        Types types = state.getTypes();
        Symtab symtab = state.getSymtab();
        Type type = ASTHelpers.getType((Tree)tree.getLeftOperand());
        if (type == null) {
            return Optional.empty();
        }
        if (ASTHelpers.isSameType((Type)(type = types.unboxedTypeOrType(type)), (Type)symtab.floatType, (VisitorState)state)) {
            name = "Float";
        } else if (ASTHelpers.isSameType((Type)type, (Type)symtab.doubleType, (VisitorState)state)) {
            name = "Double";
        } else {
            return Optional.empty();
        }
        return Optional.of(String.format("%s.isNaN(%s)", name, state.getSourceForNode((Tree)tree.getLeftOperand())));
    }
}

