/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(name="ImmutableModification", category=BugPattern.Category.GUAVA, summary="Modifying an immutable collection is guaranteed to throw an exception and leave the collection unmodified", severity=BugPattern.SeverityLevel.ERROR)
public class ImmutableModification
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    public static final ImmutableMultimap<String, String> ILLEGAL = ImmutableMultimap.builder().putAll((Object)"com.google.common.collect.ImmutableBiMap", (Object[])new String[]{"forcePut"}).putAll((Object)"com.google.common.collect.ImmutableClassToInstanceMap", (Object[])new String[]{"putInstance"}).putAll((Object)"com.google.common.collect.ImmutableCollection", (Object[])new String[]{"add", "remove", "addAll", "removeAll", "removeIf", "retainAll", "clear"}).putAll((Object)"com.google.common.collect.ImmutableList", (Object[])new String[]{"addAll", "set", "add", "remove", "replaceAll", "sort"}).putAll((Object)"com.google.common.collect.ImmutableListMultimap", (Object[])new String[]{"removeAll", "replaceValues"}).putAll((Object)"com.google.common.collect.ImmutableMap", (Object[])new String[]{"put", "putIfAbsent", "replace", "computeIfAbsent", "computeIfPresent", "compute", "merge", "putAll", "replaceAll", "remove", "clear"}).putAll((Object)"com.google.common.collect.ImmutableMultimap", (Object[])new String[]{"removeAll", "replaceValues", "clear", "put", "putAll", "remove"}).putAll((Object)"com.google.common.collect.ImmutableMultiset", (Object[])new String[]{"add", "remove", "setCount"}).putAll((Object)"com.google.common.collect.ImmutableRangeMap", (Object[])new String[]{"put", "putAll", "clear", "remove"}).putAll((Object)"com.google.common.collect.ImmutableRangeSet", (Object[])new String[]{"add", "addAll", "remove", "removeAll"}).putAll((Object)"com.google.common.collect.ImmutableSetMultimap", (Object[])new String[]{"removeAll", "replaceValues"}).putAll((Object)"com.google.common.collect.ImmutableSortedMap", (Object[])new String[]{"pollFirstEntry", "pollLastEntry"}).putAll((Object)"com.google.common.collect.ImmutableSortedSet", (Object[])new String[]{"pollFirst", "pollLast"}).putAll((Object)"com.google.common.collect.ImmutableTable", (Object[])new String[]{"clear", "put", "putAll", "remove"}).putAll((Object)"com.google.common.collect.UnmodifiableIterator", (Object[])new String[]{"remove"}).putAll((Object)"com.google.common.collect.UnmodifiableListIterator", (Object[])new String[]{"add", "set"}).putAll((Object)"com.google.common.collect.Sets.SetView", (Object[])new String[]{"add", "remove", "addAll", "removeAll", "removeIf", "retainAll", "clear"}).build();
    static final Matcher<ExpressionTree> MATCHER = Matchers.anyOf((Iterable)((Iterable)ILLEGAL.asMap().entrySet().stream().map(e -> MethodMatchers.instanceMethod().onDescendantOf((String)e.getKey()).namedAnyOf((Iterable)e.getValue())).collect(ImmutableList.toImmutableList())));

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return MATCHER.matches((Tree)tree, state) ? this.describeMatch(tree) : Description.NO_MATCH;
    }
}

