/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;

@BugPattern(name="LockNotBeforeTry", summary="Calls to Lock#lock should be immediately followed by a try block which releases the lock.", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"}, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public final class LockNotBeforeTry
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final MethodMatchers.MethodClassMatcher LOCK_METHOD = MethodMatchers.instanceMethod().onDescendantOf("java.util.concurrent.locks.Lock");
    private static final Matcher<ExpressionTree> LOCK = LOCK_METHOD.named("lock");
    private static final Matcher<ExpressionTree> UNLOCK = LOCK_METHOD.named("unlock");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        StatementTree nextStatement;
        if (!LOCK.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (!(parent instanceof StatementTree)) {
            return Description.NO_MATCH;
        }
        Tree enclosing = state.getPath().getParentPath().getParentPath().getLeaf();
        if (!(enclosing instanceof BlockTree)) {
            return Description.NO_MATCH;
        }
        BlockTree block = (BlockTree)enclosing;
        int index = block.getStatements().indexOf(parent);
        if (index + 1 < block.getStatements().size() && (nextStatement = block.getStatements().get(index + 1)) instanceof TryTree) {
            return Description.NO_MATCH;
        }
        return this.describe(tree, state.getPath().getParentPath(), state);
    }

    private Description describe(MethodInvocationTree lockInvocation, TreePath statementPath, VisitorState state) {
        Tree lockStatement = statementPath.getLeaf();
        ExpressionTree lockee = ASTHelpers.getReceiver((ExpressionTree)lockInvocation);
        TryTree enclosingTry = (TryTree)state.findEnclosing(new Class[]{TryTree.class});
        if (enclosingTry != null && LockNotBeforeTry.releases(enclosingTry, lockee, state)) {
            SuggestedFix fix = SuggestedFix.builder().replace(lockStatement, "").prefixWith((Tree)enclosingTry, state.getSourceForNode(lockStatement)).build();
            return this.buildDescription(lockInvocation).addFix((Fix)fix).setMessage(String.format("Prefer obtaining the lock for %s outside the try block. That way, if #lock throws, the lock is not erroneously released.", state.getSourceForNode((Tree)ASTHelpers.getReceiver((ExpressionTree)lockInvocation)))).build();
        }
        Tree enclosing = state.getPath().getParentPath().getParentPath().getLeaf();
        if (!(enclosing instanceof BlockTree)) {
            return Description.NO_MATCH;
        }
        BlockTree block = (BlockTree)enclosing;
        int index = block.getStatements().indexOf(lockStatement);
        for (StatementTree maybeTry : Iterables.skip(block.getStatements(), (int)(index + 1))) {
            if (!(maybeTry instanceof TryTree) || !LockNotBeforeTry.releases((TryTree)maybeTry, lockee, state)) continue;
            SuggestedFix fix = SuggestedFix.builder().replace(lockStatement, "").prefixWith((Tree)maybeTry, state.getSourceForNode(lockStatement)).build();
            return this.buildDescription(lockInvocation).addFix((Fix)fix).setMessage("Prefer locking *immediately* before the try block which releases the lock to avoid the possibility of any intermediate statements throwing.").build();
        }
        for (StatementTree maybeUnlock : Iterables.skip(block.getStatements(), (int)(index + 1))) {
            ExpressionTree expression;
            if (!(maybeUnlock instanceof ExpressionStatementTree) || !LockNotBeforeTry.releases(expression = ((ExpressionStatementTree)maybeUnlock).getExpression(), lockee, state)) continue;
            SuggestedFix fix = SuggestedFix.builder().postfixWith(lockStatement, "try {").prefixWith((Tree)maybeUnlock, "} finally {").postfixWith((Tree)maybeUnlock, "}").build();
            return this.buildDescription(lockInvocation).addFix((Fix)fix).setMessage(String.format("Prefer releasing the lock on %s inside a finally block.", state.getSourceForNode((Tree)ASTHelpers.getReceiver((ExpressionTree)lockInvocation)))).build();
        }
        return Description.NO_MATCH;
    }

    private static boolean releases(TryTree tryTree, final ExpressionTree lockee, final VisitorState state) {
        if (tryTree.getFinallyBlock() == null) {
            return false;
        }
        Boolean released = (Boolean)new TreeScanner<Boolean, Void>(){

            @Override
            public Boolean reduce(Boolean r1, Boolean r2) {
                return r1 == null ? r2 : (r2 == null ? null : Boolean.valueOf(r1 != false && r2 != false));
            }

            @Override
            public Boolean visitMethodInvocation(MethodInvocationTree node, Void unused) {
                if (UNLOCK.matches((Tree)node, state)) {
                    return LockNotBeforeTry.releases(node, lockee, state);
                }
                return (Boolean)super.visitMethodInvocation(node, null);
            }
        }.scan(tryTree.getFinallyBlock(), null);
        return released == null ? false : released;
    }

    private static boolean releases(ExpressionTree node, ExpressionTree lockee, VisitorState state) {
        return UNLOCK.matches((Tree)node, state) && state.getSourceForNode((Tree)ASTHelpers.getReceiver((ExpressionTree)node)).equals(state.getSourceForNode((Tree)lockee));
    }
}

