/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AutoValue_MissingTestCall_MethodPairing;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.HashSet;
import javax.annotation.Nullable;
import javax.lang.model.element.ElementKind;

@BugPattern(name="MissingTestCall", summary="A terminating method call is required for a test helper to have any effect.", severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.NO_FIX)
public final class MissingTestCall
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final MethodMatchers.MethodClassMatcher EQUALS_TESTER = MethodMatchers.instanceMethod().onDescendantOf("com.google.common.testing.EqualsTester");
    private static final MethodMatchers.MethodClassMatcher REFACTORING_HELPER = MethodMatchers.instanceMethod().onDescendantOf("com.google.errorprone.BugCheckerRefactoringTestHelper");
    private static final MethodMatchers.MethodClassMatcher COMPILATION_HELPER = MethodMatchers.instanceMethod().onDescendantOf("com.google.errorprone.CompilationTestHelper");
    private static final ImmutableSet<MethodPairing> PAIRINGS = ImmutableSet.of((Object)MethodPairing.access$000("EqualsTester", (Matcher)EQUALS_TESTER.named("addEqualityGroup"), (Matcher)EQUALS_TESTER.named("testEquals")), (Object)MethodPairing.access$000("BugCheckerRefactoringTestHelper", (Matcher)REFACTORING_HELPER.namedAnyOf(new String[]{"addInput", "addInputLines", "addInputFile", "addOutput", "addOutputLines", "addOutputFile"}), (Matcher)REFACTORING_HELPER.named("doTest")), (Object)MethodPairing.access$000("CompilationTestHelper", (Matcher)COMPILATION_HELPER.namedAnyOf(new String[]{"addSourceLines", "addSourceFile"}), (Matcher)COMPILATION_HELPER.named("doTest")));

    public Description matchMethod(MethodTree tree, final VisitorState state) {
        if (!JUnitMatchers.TEST_CASE.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        final HashSet required = new HashSet();
        final HashSet called = new HashSet();
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitMethodInvocation(MethodInvocationTree node, Void unused) {
                for (MethodPairing pairing : PAIRINGS) {
                    if (pairing.ifCall().matches((Tree)node, state) && (!MissingTestCall.isField(MissingTestCall.getUltimateReceiver(node)) || MissingTestCall.isLastStatementInBlock(state.findPathToEnclosing(new Class[]{StatementTree.class})))) {
                        required.add(pairing);
                    }
                    if (!pairing.mustCall().matches((Tree)node, state)) continue;
                    called.add(pairing);
                }
                return (Void)super.visitMethodInvocation(node, null);
            }
        }.scan(state.getPath(), (Void)null);
        return Sets.difference(required, called).stream().findFirst().map(p -> this.buildDescription(tree).setMessage(String.format("%s requires a terminating method call to have any effect.", p.name())).build()).orElse(Description.NO_MATCH);
    }

    @Nullable
    private static ExpressionTree getUltimateReceiver(ExpressionTree tree) {
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
        while (receiver instanceof MemberSelectTree || receiver instanceof MethodInvocationTree) {
            tree = receiver;
            receiver = ASTHelpers.getReceiver((ExpressionTree)receiver);
        }
        return receiver;
    }

    private static boolean isField(@Nullable ExpressionTree tree) {
        if (!(tree instanceof IdentifierTree)) {
            return false;
        }
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        return symbol != null && symbol.getKind() == ElementKind.FIELD;
    }

    private static boolean isLastStatementInBlock(@Nullable TreePath pathToStatement) {
        if (pathToStatement == null) {
            return false;
        }
        Tree parent = pathToStatement.getParentPath().getLeaf();
        if (!(parent instanceof BlockTree)) {
            return false;
        }
        return ((StatementTree)Iterables.getLast(((BlockTree)parent).getStatements())).equals(pathToStatement.getLeaf());
    }

    @AutoValue
    static abstract class MethodPairing {
        MethodPairing() {
        }

        abstract String name();

        abstract Matcher<ExpressionTree> ifCall();

        abstract Matcher<ExpressionTree> mustCall();

        private static MethodPairing of(String name, Matcher<ExpressionTree> ifCall, Matcher<ExpressionTree> mustCall) {
            return new AutoValue_MissingTestCall_MethodPairing(name, ifCall, mustCall);
        }

        static /* synthetic */ MethodPairing access$000(String x0, Matcher x1, Matcher x2) {
            return MethodPairing.of(x0, (Matcher<ExpressionTree>)x1, (Matcher<ExpressionTree>)x2);
        }
    }
}

