/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.IsSubtypeOf;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.type.DescendantOfAny;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.SideEffectAnalysis;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@BugPattern(name="ModifiedButNotUsed", summary="A collection or proto builder was created, but its values were never accessed.", category=BugPattern.Category.JDK, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION, severity=BugPattern.SeverityLevel.WARNING)
public class ModifiedButNotUsed
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final ImmutableSet<String> GUAVA_IMMUTABLES = ImmutableSet.of((Object)"com.google.common.collect.ImmutableCollection", (Object)"com.google.common.collect.ImmutableMap", (Object)"com.google.common.collect.ImmutableMultimap");
    private static final ImmutableSet<String> COLLECTIONS = (ImmutableSet)Streams.concat((Stream[])new Stream[]{GUAVA_IMMUTABLES.stream().map(i -> i + ".Builder"), Stream.of("java.util.Collection", "java.util.Map", "com.google.common.collect.Multimap")}).collect(ImmutableSet.toImmutableSet());
    private static final Matcher<ExpressionTree> COLLECTION_SETTER = MethodMatchers.instanceMethod().onDescendantOfAny(COLLECTIONS).namedAnyOf(new String[]{"add", "addAll", "clear", "put", "putAll", "remove", "removeAll", "removeIf", "replaceAll", "retainAll", "set", "sort"});
    private static final ImmutableSet<String> PROTO_CLASSES = ImmutableSet.of((Object)"com.google.protobuf.GeneratedMessage", (Object)"com.google.protobuf.GeneratedMessageLite");
    private static final Matcher<ExpressionTree> FLUENT_SETTER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOfAny((Iterable)PROTO_CLASSES.stream().map(p -> p + ".Builder").collect(ImmutableList.toImmutableList())).withNameMatching(Pattern.compile("(add|set|clear|remove|merge).+")), MethodMatchers.instanceMethod().onDescendantOfAny((Iterable)GUAVA_IMMUTABLES.stream().map(c -> c + ".Builder").collect(ImmutableSet.toImmutableSet())).namedAnyOf(new String[]{"add", "addAll", "put", "putAll"})});
    private static final Matcher<Tree> COLLECTION_TYPE = Matchers.anyOf((Iterable)((Iterable)COLLECTIONS.stream().map(IsSubtypeOf::new).collect(ImmutableList.toImmutableList())));
    private static final Matcher<Tree> PROTO_TYPE = Matchers.anyOf((Iterable)((Iterable)PROTO_CLASSES.stream().map(p -> new IsSubtypeOf(p + ".Builder")).collect(ImmutableList.toImmutableList())));
    private static final Matcher<ExpressionTree> FLUENT_CONSTRUCTOR = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.constructor().forClass((TypePredicate)new DescendantOfAny((Iterable)GUAVA_IMMUTABLES.stream().map(i -> Suppliers.typeFromString((String)(i + ".Builder"))).collect(ImmutableList.toImmutableList()))), Matchers.staticMethod().onClass((TypePredicate)new DescendantOfAny((Iterable)GUAVA_IMMUTABLES.stream().map(Suppliers::typeFromString).collect(ImmutableList.toImmutableList()))).namedAnyOf(new String[]{"builder", "builderWithExpectedSize"}), MethodMatchers.constructor().forClass((TypePredicate)new DescendantOfAny((Iterable)PROTO_CLASSES.stream().map(c -> Suppliers.typeFromString((String)(c + ".Builder"))).collect(ImmutableList.toImmutableList()))), Matchers.staticMethod().onClass((TypePredicate)new DescendantOfAny((Iterable)PROTO_CLASSES.stream().map(Suppliers::typeFromString).collect(ImmutableList.toImmutableList()))).named("newBuilder"), MethodMatchers.instanceMethod().onClass((TypePredicate)new DescendantOfAny((Iterable)PROTO_CLASSES.stream().map(Suppliers::typeFromString).collect(ImmutableList.toImmutableList()))).namedAnyOf(new String[]{"toBuilder", "newBuilderForType"})});
    private static final Matcher<ExpressionTree> NEW_COLLECTION = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.constructor().forClass((TypePredicate)new DescendantOfAny((Iterable)COLLECTIONS.stream().map(Suppliers::typeFromString).collect(ImmutableList.toImmutableList()))), Matchers.staticMethod().onClassAny(new String[]{"com.google.common.collect.Lists", "com.google.common.collect.Maps", "com.google.common.collect.Sets"}).withNameMatching(Pattern.compile("new.+"))});

    private static boolean newFluentChain(ExpressionTree tree, VisitorState state) {
        while (tree instanceof MethodInvocationTree && FLUENT_SETTER.matches((Tree)tree, state)) {
            tree = ASTHelpers.getReceiver((ExpressionTree)tree);
        }
        return FLUENT_CONSTRUCTOR.matches((Tree)tree, state);
    }

    private static boolean collectionUsed(VisitorState state) {
        TreePath path = state.getPath();
        return !(path.getParentPath().getLeaf() instanceof MemberSelectTree) || !(path.getParentPath().getParentPath().getLeaf() instanceof MethodInvocationTree) || !COLLECTION_SETTER.matches((Tree)((MethodInvocationTree)path.getParentPath().getParentPath().getLeaf()), state) || ASTHelpers.targetType((VisitorState)state.withPath(path.getParentPath().getParentPath())) != null;
    }

    private static boolean fluentUsed(VisitorState state) {
        TreePath path = state.getPath();
        while (path != null) {
            if (path.getParentPath().getLeaf() instanceof ExpressionStatementTree) {
                return false;
            }
            if (!(path.getParentPath().getLeaf() instanceof MemberSelectTree) || !(path.getParentPath().getParentPath().getLeaf() instanceof MethodInvocationTree) || !FLUENT_SETTER.matches((Tree)((MethodInvocationTree)path.getParentPath().getParentPath().getLeaf()), state)) break;
            path = path.getParentPath().getParentPath();
        }
        return true;
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        final Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)tree);
        if (!ModifiedButNotUsed.effectivelyFinal(symbol)) {
            return Description.NO_MATCH;
        }
        if (state.getPath().getParentPath().getLeaf() instanceof ClassTree) {
            return Description.NO_MATCH;
        }
        if (!COLLECTION_TYPE.matches((Tree)tree, state) && !PROTO_TYPE.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        final ArrayList<TreePath> initializers = new ArrayList<TreePath>();
        if (tree.getInitializer() == null) {
            new TreePathScanner<Void, Void>(){

                @Override
                public Void visitAssignment(AssignmentTree node, Void aVoid) {
                    if (symbol.equals(ASTHelpers.getSymbol((Tree)node.getVariable()))) {
                        initializers.add(new TreePath(this.getCurrentPath(), node.getExpression()));
                    }
                    return (Void)super.visitAssignment(node, aVoid);
                }
            }.scan(state.getPath().getParentPath(), (Void)null);
        } else {
            initializers.add(new TreePath(state.getPath(), tree.getInitializer()));
        }
        if (initializers.size() != 1) {
            return Description.NO_MATCH;
        }
        TreePath initializerPath = (TreePath)Iterables.getOnlyElement(initializers);
        ExpressionTree initializer = (ExpressionTree)initializerPath.getLeaf();
        if (!NEW_COLLECTION.matches((Tree)initializer, state) && !ModifiedButNotUsed.newFluentChain(initializer, state)) {
            return Description.NO_MATCH;
        }
        UnusedScanner isUnusedScanner = new UnusedScanner(symbol, state, ModifiedButNotUsed.getMatcher(tree, state));
        isUnusedScanner.scan(state.getPath().getParentPath(), null);
        if (isUnusedScanner.isUsed) {
            return Description.NO_MATCH;
        }
        ImmutableList removals = tree.getInitializer() == null ? ImmutableList.of((Object)state.getPath(), (Object)initializerPath) : ImmutableList.of((Object)initializerPath);
        return this.buildDescription(initializer).addAllFixes((List)isUnusedScanner.buildFixes((List)removals)).build();
    }

    private static Matcher<IdentifierTree> getMatcher(Tree tree, VisitorState state) {
        return COLLECTION_TYPE.matches(tree, state) ? (Matcher & Serializable)(t, s) -> ModifiedButNotUsed.collectionUsed(s) : (Matcher & Serializable)(t, s) -> ModifiedButNotUsed.fluentUsed(s);
    }

    private static boolean effectivelyFinal(Symbol symbol) {
        return (symbol.flags() & 0x20000000010L) != 0L;
    }

    private static class UnusedScanner
    extends TreePathScanner<Void, Void> {
        private final Symbol symbol;
        private final VisitorState state;
        private final Matcher<IdentifierTree> matcher;
        private final List<TreePath> usageSites = new ArrayList<TreePath>();
        private boolean isUsed = false;

        private UnusedScanner(Symbol symbol, VisitorState state, Matcher<IdentifierTree> matcher) {
            this.symbol = symbol;
            this.state = state;
            this.matcher = matcher;
        }

        @Override
        public Void visitIdentifier(IdentifierTree identifierTree, Void unused) {
            if (!Objects.equals(ASTHelpers.getSymbol((Tree)identifierTree), this.symbol)) {
                return null;
            }
            if (this.matcher.matches((Tree)identifierTree, this.state.withPath(this.getCurrentPath()))) {
                this.isUsed = true;
                return null;
            }
            this.usageSites.add(this.getCurrentPath());
            return null;
        }

        @Override
        public Void visitVariable(VariableTree variableTree, Void unused) {
            if (Objects.equals(ASTHelpers.getSymbol((VariableTree)variableTree), this.symbol)) {
                return null;
            }
            return (Void)super.visitVariable(variableTree, null);
        }

        @Override
        public Void visitAssignment(AssignmentTree assignmentTree, Void unused) {
            if (Objects.equals(ASTHelpers.getSymbol((Tree)assignmentTree.getVariable()), this.symbol)) {
                return (Void)this.scan(assignmentTree.getExpression(), null);
            }
            return (Void)super.visitAssignment(assignmentTree, null);
        }

        private ImmutableList<SuggestedFix> buildFixes(List<TreePath> removals) {
            boolean encounteredSideEffects = false;
            SuggestedFix.Builder withoutSideEffects = SuggestedFix.builder().setShortDescription("remove unused variable and any side effects");
            SuggestedFix.Builder withSideEffects = SuggestedFix.builder().setShortDescription("remove unused variable");
            for (TreePath usageSite : Iterables.concat(removals, this.usageSites)) {
                ArrayList keepingSideEffects = new ArrayList();
                TreePath path = usageSite;
                while (!(path.getLeaf() instanceof StatementTree)) {
                    block9: {
                        List<? extends ExpressionTree> arguments;
                        block8: {
                            block7: {
                                if (!(path.getLeaf() instanceof MethodInvocationTree)) break block7;
                                arguments = ((MethodInvocationTree)path.getLeaf()).getArguments();
                                break block8;
                            }
                            if (!(path.getLeaf() instanceof NewClassTree)) break block9;
                            arguments = ((NewClassTree)path.getLeaf()).getArguments();
                        }
                        arguments.stream().filter(SideEffectAnalysis::hasSideEffect).map(e -> this.state.getSourceForNode((Tree)e) + ";").forEach(keepingSideEffects::add);
                    }
                    path = path.getParentPath();
                }
                StatementTree enclosingStatement = (StatementTree)this.state.withPath(usageSite).findEnclosing(new Class[]{StatementTree.class});
                if (!keepingSideEffects.isEmpty()) {
                    encounteredSideEffects = true;
                    withSideEffects.replace((Tree)enclosingStatement, keepingSideEffects.stream().collect(Collectors.joining("")));
                } else {
                    withSideEffects.replace((Tree)enclosingStatement, "");
                }
                withoutSideEffects.replace((Tree)enclosingStatement, "");
            }
            return encounteredSideEffects ? ImmutableList.of((Object)withSideEffects.build(), (Object)withoutSideEffects.build()) : ImmutableList.of((Object)withoutSideEffects.build());
        }
    }
}

