/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreCollectors;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.doctree.ParamTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.util.DocSourcePositions;
import com.sun.source.util.DocTreeScanner;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Name;

@BugPattern(name="TypeParameterShadowing", summary="Type parameter declaration overrides another type parameter already declared", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, tags={"Style"}, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class TypeParameterShadowing
extends BugChecker
implements BugChecker.MethodTreeMatcher,
BugChecker.ClassTreeMatcher {
    private static final Pattern TRAILING_DIGIT_EXTRACTOR = Pattern.compile("^(.*?)(\\d+)$");

    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (tree.getTypeParameters().isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.findDuplicatesOf(tree, tree.getTypeParameters(), state);
    }

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (tree.getTypeParameters().isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.findDuplicatesOf(tree, tree.getTypeParameters(), state);
    }

    private Description findDuplicatesOf(Tree tree, List<? extends TypeParameterTree> typeParameters, VisitorState state) {
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        if (symbol == null) {
            return Description.NO_MATCH;
        }
        List<Symbol.TypeVariableSymbol> enclosingTypeSymbols = TypeParameterShadowing.typeVariablesEnclosing(symbol);
        if (enclosingTypeSymbols.isEmpty()) {
            return Description.NO_MATCH;
        }
        ArrayList conflictingTypeSymbols = new ArrayList();
        typeParameters.forEach(param -> enclosingTypeSymbols.stream().filter(tvs -> tvs.name.contentEquals(param.getName())).findFirst().ifPresent(conflictingTypeSymbols::add));
        if (conflictingTypeSymbols.isEmpty()) {
            return Description.NO_MATCH;
        }
        Description.Builder descriptionBuilder = this.buildDescription(tree);
        String message = "Found aliased type parameters: " + conflictingTypeSymbols.stream().map(tvs -> tvs.name + " declared in " + tvs.owner.getSimpleName()).collect(Collectors.joining("\n"));
        descriptionBuilder.setMessage(message);
        Set typeVarsInScope = (Set)Streams.concat((Stream[])new Stream[]{enclosingTypeSymbols.stream(), symbol.getTypeParameters().stream()}).map(v -> v.name.toString()).collect(ImmutableSet.toImmutableSet());
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        conflictingTypeSymbols.stream().map(v -> TypeParameterShadowing.renameTypeVariable(TypeParameterShadowing.typeParameterInList(typeParameters, v), tree, TypeParameterShadowing.replacementTypeVarName(v.name, typeVarsInScope), state)).forEach(arg_0 -> ((SuggestedFix.Builder)fixBuilder).merge(arg_0));
        descriptionBuilder.addFix((Fix)fixBuilder.build());
        return descriptionBuilder.build();
    }

    static TypeParameterTree typeParameterInList(List<? extends TypeParameterTree> typeParameters, Symbol v) {
        return (TypeParameterTree)typeParameters.stream().filter(t -> t.getName().contentEquals(v.name)).collect(MoreCollectors.onlyElement());
    }

    static String replacementTypeVarName(Name name, Set<String> superTypeVars) {
        String replacementName;
        String baseName = name.toString();
        int typeVarNum = 2;
        Matcher matcher = TRAILING_DIGIT_EXTRACTOR.matcher(name);
        if (matcher.matches()) {
            baseName = matcher.group(1);
            typeVarNum = Integer.parseInt(matcher.group(2)) + 1;
        }
        while (superTypeVars.contains(replacementName = baseName + typeVarNum)) {
            ++typeVarNum;
        }
        return replacementName;
    }

    static SuggestedFix renameTypeVariable(TypeParameterTree typeParameter, Tree owningTree, final String typeVarReplacement, final VisitorState state) {
        final Symbol typeVariableSymbol = ASTHelpers.getSymbol((Tree)typeParameter);
        final String name = typeParameter.getName().toString();
        int pos = ((JCTree)((Object)typeParameter)).getStartPosition();
        final SuggestedFix.Builder fixBuilder = SuggestedFix.builder().replace(pos, pos + name.length(), typeVarReplacement);
        ((JCTree)owningTree).accept(new TreeScanner(){

            @Override
            public void visitIdent(JCTree.JCIdent tree) {
                Symbol identSym = ASTHelpers.getSymbol((Tree)tree);
                if (Objects.equal((Object)identSym, (Object)typeVariableSymbol) && Objects.equal((Object)state.getSourceForNode((Tree)tree), (Object)name)) {
                    fixBuilder.replace((Tree)tree, typeVarReplacement);
                }
            }
        });
        final DCTree.DCDocComment docCommentTree = (DCTree.DCDocComment)JavacTrees.instance(state.context).getDocCommentTree(state.getPath());
        if (docCommentTree != null) {
            docCommentTree.accept(new DocTreeScanner<Void, Void>(){

                @Override
                public Void visitParam(ParamTree paramTree, Void unused) {
                    if (paramTree.isTypeParameter() && paramTree.getName().getName().contentEquals(name)) {
                        DocSourcePositions positions = JavacTrees.instance(state.context).getSourcePositions();
                        CompilationUnitTree compilationUnitTree = state.getPath().getCompilationUnit();
                        int startPos = (int)positions.getStartPosition(compilationUnitTree, docCommentTree, paramTree.getName());
                        int endPos = (int)positions.getEndPosition(compilationUnitTree, docCommentTree, paramTree.getName());
                        fixBuilder.replace(startPos, endPos, typeVarReplacement);
                    }
                    return (Void)super.visitParam(paramTree, null);
                }
            }, null);
        }
        return fixBuilder.build();
    }

    private static List<Symbol.TypeVariableSymbol> typeVariablesEnclosing(Symbol sym) {
        ArrayList<Symbol.TypeVariableSymbol> typeVarScopes = new ArrayList<Symbol.TypeVariableSymbol>();
        block4: while (!sym.isStatic()) {
            sym = sym.owner;
            switch (sym.getKind()) {
                case PACKAGE: {
                    break block4;
                }
                case METHOD: 
                case CLASS: {
                    typeVarScopes.addAll(sym.getTypeParameters());
                    continue block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        return typeVarScopes;
    }
}

