/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@BugPattern(name="UndefinedEquals", summary="Collection, Iterable, Multimap, and Queue do not have well-defined equals behavior", severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public final class UndefinedEquals
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> ASSERT_THAT_EQUALS = Matchers.allOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.Subject").namedAnyOf(new String[]{"isEqualTo", "isNotEqualTo"}), Matchers.receiverOfInvocation((Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("com.google.common.truth.Truth").named("assertThat"), MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.StandardSubjectBuilder").named("that")}))});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Tree argument;
        Tree receiver;
        List<? extends ExpressionTree> arguments = tree.getArguments();
        if (Matchers.staticEqualsInvocation().matches((Tree)tree, state) || Matchers.assertEqualsInvocation().matches((Tree)tree, state) || Matchers.assertNotEqualsInvocation().matches((Tree)tree, state)) {
            receiver = arguments.get(arguments.size() - 2);
            argument = (Tree)Iterables.getLast(arguments);
        } else if (Matchers.instanceEqualsInvocation().matches((Tree)tree, state)) {
            receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
            argument = arguments.get(0);
        } else if (ASSERT_THAT_EQUALS.matches((Tree)tree, state)) {
            receiver = (Tree)Iterables.getOnlyElement(arguments);
            argument = (Tree)Iterables.getOnlyElement(((MethodInvocationTree)ASTHelpers.getReceiver((ExpressionTree)tree)).getArguments());
        } else {
            return Description.NO_MATCH;
        }
        return Arrays.stream(BadClass.values()).filter(b -> ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)receiver), (Type)((BadClass)b).type(state), (VisitorState)state) || ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)argument), (Type)((BadClass)b).type(state), (VisitorState)state)).findFirst().map(b -> this.buildDescription(tree).setMessage(((BadClass)b).typeName() + " does not have well-defined equals behavior").addFix(b.generateFix(receiver, argument, state)).build()).orElse(Description.NO_MATCH);
    }

    private static enum BadClass {
        MULTIMAP("com.google.common.collect.Multimap"){

            @Override
            Optional<SuggestedFix> generateFix(Tree receiver, Tree argument, VisitorState state) {
                return Optional.empty();
            }
        }
        ,
        CHARSEQUENCE("java.lang.CharSequence"){

            @Override
            Optional<SuggestedFix> generateFix(Tree receiver, Tree argument, VisitorState state) {
                if (ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)receiver), (Type)2.CHARSEQUENCE.type(state), (VisitorState)state) && ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)argument), (Type)state.getSymtab().stringType, (VisitorState)state)) {
                    return Optional.of(SuggestedFix.postfixWith((Tree)receiver, (String)".toString()"));
                }
                if (ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)argument), (Type)2.CHARSEQUENCE.type(state), (VisitorState)state) && ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)receiver), (Type)state.getSymtab().stringType, (VisitorState)state)) {
                    return Optional.of(SuggestedFix.postfixWith((Tree)argument, (String)".toString()"));
                }
                return Optional.empty();
            }
        }
        ,
        ITERABLE("java.lang.Iterable"){

            @Override
            Optional<SuggestedFix> generateFix(Tree receiver, Tree argument, VisitorState state) {
                return Optional.empty();
            }
        }
        ,
        COLLECTION("java.util.Collection"){

            @Override
            Optional<SuggestedFix> generateFix(Tree receiver, Tree argument, VisitorState state) {
                return Optional.empty();
            }
        }
        ,
        QUEUE("java.util.Queue"){

            @Override
            Optional<SuggestedFix> generateFix(Tree receiver, Tree argument, VisitorState state) {
                return Optional.empty();
            }
        };

        private final String typeName;

        private BadClass(String typeName) {
            this.typeName = typeName;
        }

        abstract Optional<SuggestedFix> generateFix(Tree var1, Tree var2, VisitorState var3);

        private Type type(VisitorState state) {
            return state.getTypeFromString(this.typeName);
        }

        private String typeName() {
            return this.typeName;
        }
    }
}

