/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Reachability;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ElementKind;

@BugPattern(name="UnnecessaryDefaultInEnumSwitch", summary="Switch handles all enum values: an explicit default case is unnecessary and defeats error checking for non-exhaustive switches.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class UnnecessaryDefaultInEnumSwitch
extends BugChecker
implements BugChecker.SwitchTreeMatcher {
    private static final String DESCRIPTION_MOVED_DEFAULT = "Switch handles all enum values: move code from the default case to execute after the switch statement to enable checking for non-exhaustive switches. That is, prefer: `switch (...) { ... } throw new AssertionError();` to `switch (...) { ... default: throw new AssertionError(); }`";
    private static final String DESCRIPTION_REMOVED_DEFAULT = "Switch handles all enum values: the default case can be omitted to enable enforcement at compile-time that the switch statement is exhaustive.";

    public Description matchSwitch(SwitchTree tree, VisitorState state) {
        List<? extends StatementTree> defaultStatements;
        boolean bl;
        Symbol.TypeSymbol switchType = ((JCTree.JCSwitch)tree).getExpression().type.tsym;
        if (switchType.getKind() != ElementKind.ENUM) {
            return Description.NO_MATCH;
        }
        CaseTree caseBeforeDefault = null;
        CaseTree defaultCase = null;
        for (CaseTree caseTree : tree.getCases()) {
            if (caseTree.getExpression() == null) {
                defaultCase = caseTree;
                break;
            }
            caseBeforeDefault = caseTree;
        }
        if (caseBeforeDefault == null || defaultCase == null) {
            return Description.NO_MATCH;
        }
        Set handledCases = (Set)tree.getCases().stream().map(CaseTree::getExpression).filter(IdentifierTree.class::isInstance).map(p -> ((IdentifierTree)p).getName().toString()).collect(ImmutableSet.toImmutableSet());
        boolean bl2 = false;
        Sets.SetView setDifference = Sets.difference((Set)ASTHelpers.enumValues((Symbol.TypeSymbol)switchType), (Set)handledCases);
        if (!setDifference.isEmpty()) {
            if (setDifference.contains((Object)"UNRECOGNIZED") && setDifference.size() == 1) {
                bl = true;
            } else {
                return Description.NO_MATCH;
            }
        }
        if (this.trivialDefault(defaultStatements = defaultCase.getStatements())) {
            SuggestedFix fix = SuggestedFix.replace((Tree)defaultCase, (String)(bl ? "case UNRECOGNIZED: \n // continue below" : ""));
            return this.buildDescription(defaultCase).setMessage(DESCRIPTION_REMOVED_DEFAULT).addFix((Fix)fix).build();
        }
        String defaultSource = state.getSourceCode().subSequence(((JCTree)((Object)defaultStatements.get(0))).getStartPosition(), state.getEndPosition((Tree)Iterables.getLast(defaultStatements))).toString();
        String initialComments = this.comments(state, defaultCase, defaultStatements);
        if (!Reachability.canCompleteNormally((StatementTree)tree)) {
            SuggestedFix fix = SuggestedFix.builder().replace((Tree)defaultCase, bl ? "case UNRECOGNIZED: \n break;" : "").postfixWith((Tree)tree, initialComments + defaultSource).build();
            return this.buildDescription(defaultCase).setMessage(DESCRIPTION_MOVED_DEFAULT).addFix((Fix)fix).build();
        }
        if (!SuggestedFixes.compilesWithFix((Fix)SuggestedFix.delete((Tree)defaultCase), (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        if (!Reachability.canCompleteNormally((CaseTree)caseBeforeDefault)) {
            return this.buildDescription(defaultCase).setMessage(DESCRIPTION_REMOVED_DEFAULT).addFix((Fix)(bl ? SuggestedFix.builder().replace((Tree)defaultCase, "case UNRECOGNIZED:" + initialComments + defaultSource).build() : SuggestedFix.delete((Tree)defaultCase))).build();
        }
        SuggestedFix.Builder fix = SuggestedFix.builder().delete((Tree)defaultCase);
        if (bl) {
            fix.prefixWith((Tree)defaultCase, "case UNRECOGNIZED:").postfixWith((Tree)defaultCase, initialComments + defaultSource);
        } else {
            fix.postfixWith((Tree)caseBeforeDefault, initialComments + defaultSource);
        }
        return this.buildDescription(defaultCase).setMessage(DESCRIPTION_REMOVED_DEFAULT).addFix((Fix)fix.build()).build();
    }

    private boolean trivialDefault(List<? extends StatementTree> defaultStatements) {
        if (defaultStatements.isEmpty()) {
            return true;
        }
        return defaultStatements.size() == 1 && ((StatementTree)Iterables.getOnlyElement(defaultStatements)).getKind() == Tree.Kind.BREAK;
    }

    private String comments(VisitorState state, CaseTree defaultCase, List<? extends StatementTree> defaultStatements) {
        if (defaultStatements.isEmpty()) {
            return "";
        }
        int defaultStart = ((JCTree)((Object)defaultCase)).getStartPosition();
        int statementStart = ((JCTree)((Object)defaultStatements.get(0))).getStartPosition();
        String defaultAndComments = state.getSourceCode().subSequence(defaultStart, statementStart).toString();
        String comments = defaultAndComments.substring(defaultAndComments.indexOf("default:") + "default:".length()).trim();
        if (!comments.isEmpty()) {
            comments = "\n" + comments + "\n";
        }
        return comments;
    }
}

