/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.apidiff;

import com.google.common.io.Resources;
import com.google.errorprone.BugPattern;
import com.google.errorprone.bugpatterns.apidiff.ApiDiff;
import com.google.errorprone.bugpatterns.apidiff.ApiDiffChecker;
import com.google.errorprone.bugpatterns.apidiff.ApiDiffProto;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;

@BugPattern(name="Java7ApiChecker", summary="Use of class, field, or method that is not compatible with JDK 7", explanation="Code that needs to be compatible with Java 7 cannot use types or members that are only present in the JDK 8 class libraries", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, suppressionAnnotations={SuppressWarnings.class})
public class Java7ApiChecker
extends ApiDiffChecker {
    static final ApiDiff API_DIFF = Java7ApiChecker.loadApiDiff();

    private static ApiDiff loadApiDiff() {
        try {
            ApiDiffProto.Diff.Builder diffBuilder = ApiDiffProto.Diff.newBuilder();
            byte[] diffData = Resources.toByteArray((URL)Resources.getResource(Java7ApiChecker.class, (String)"7to8diff.binarypb"));
            diffBuilder.mergeFrom(diffData);
            diffBuilder.addClassDiff(ApiDiffProto.ClassDiff.newBuilder().setMemberDiff(ApiDiffProto.MemberDiff.newBuilder().setClassName("com/google/common/base/Predicate").addMember(ApiDiffProto.ClassMember.newBuilder().setIdentifier("test").setMemberDescriptor("(Ljava/lang/Object;)Z")))).addClassDiff(ApiDiffProto.ClassDiff.newBuilder().setMemberDiff(ApiDiffProto.MemberDiff.newBuilder().setClassName("com/google/common/base/BinaryPredicate").addMember(ApiDiffProto.ClassMember.newBuilder().setIdentifier("test").setMemberDescriptor("(Ljava/lang/Object;Ljava/lang/Object;)Z"))));
            return ApiDiff.fromProto(diffBuilder.build());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Java7ApiChecker() {
        super(API_DIFF);
    }
}

