/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.formatstring;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.formatstring.FormatStringValidation;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.ArrayDeque;
import java.util.Locale;

@BugPattern(name="FormatString", summary="Invalid printf-style format string", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR)
public class FormatString
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> FORMAT_METHOD = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("java.io.PrintStream").namedAnyOf(new String[]{"format", "printf"}), MethodMatchers.instanceMethod().onDescendantOf("java.io.PrintWriter").namedAnyOf(new String[]{"format", "printf"}), MethodMatchers.instanceMethod().onDescendantOf("java.util.Formatter").named("format"), Matchers.staticMethod().onClass("java.lang.String").named("format"), Matchers.staticMethod().onClass("java.io.Console").namedAnyOf(new String[]{"format", "printf", "readline", "readPassword"})});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        FormatStringValidation.ValidationResult result;
        if (!FORMAT_METHOD.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        ArrayDeque<? extends ExpressionTree> args = new ArrayDeque<ExpressionTree>(tree.getArguments());
        if (ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)((Tree)args.peekFirst())), (Type)state.getTypeFromString(Locale.class.getName()), (VisitorState)state)) {
            args.removeFirst();
        }
        if ((result = FormatStringValidation.validate(sym, args, state)) == null) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(result.message()).build();
    }
}

