/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.javadoc;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.javadoc.Utils;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.matchers.Description;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;
import com.sun.tools.javac.tree.DCTree;
import java.util.Optional;

@BugPattern(name="InvalidParam", summary="This @param tag doesn't refer to a parameter of the method.", severity=BugPattern.SeverityLevel.WARNING, tags={"Style"}, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public final class InvalidParam
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.MethodTreeMatcher {
    public Description matchClass(ClassTree classTree, VisitorState state) {
        DocTreePath path = Utils.getDocTreePath(state);
        if (path != null) {
            ImmutableSet parameters = ImmutableSet.of();
            ImmutableSet typeParameters = (ImmutableSet)classTree.getTypeParameters().stream().map(t -> t.getName().toString()).collect(ImmutableSet.toImmutableSet());
            new ParamsChecker(state, classTree, parameters, typeParameters).scan(path, null);
        }
        return Description.NO_MATCH;
    }

    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        DocTreePath path = Utils.getDocTreePath(state);
        if (path != null) {
            ImmutableSet parameters = (ImmutableSet)methodTree.getParameters().stream().map(v -> v.getName().toString()).collect(ImmutableSet.toImmutableSet());
            ImmutableSet typeParameters = (ImmutableSet)methodTree.getTypeParameters().stream().map(t -> t.getName().toString()).collect(ImmutableSet.toImmutableSet());
            new ParamsChecker(state, methodTree, parameters, typeParameters).scan(path, null);
        }
        return Description.NO_MATCH;
    }

    private static ImmutableSet<String> extractDocumentedParams(DCTree.DCDocComment docCommentTree, boolean isTypeParameter) {
        ImmutableSet.Builder parameters = ImmutableSet.builder();
        for (DocTree docTree : docCommentTree.getBlockTags()) {
            ParamTree paramTree;
            if (!(docTree instanceof ParamTree) || (paramTree = (ParamTree)docTree).isTypeParameter() != isTypeParameter) continue;
            parameters.add((Object)paramTree.getName().getName().toString());
        }
        return parameters.build();
    }

    private final class ParamsChecker
    extends DocTreePathScanner<Void, Void> {
        private final VisitorState state;
        private final ImmutableSet<String> documentedParameters;
        private final ImmutableSet<String> documentedTypeParameters;
        private final ImmutableSet<String> parameters;
        private final ImmutableSet<String> typeParameters;

        private ParamsChecker(VisitorState state, Tree tree, ImmutableSet<String> parameters, ImmutableSet<String> typeParameters) {
            this.state = state;
            DCTree.DCDocComment dcDocComment = Utils.getDocComment(state, tree);
            this.documentedParameters = InvalidParam.extractDocumentedParams(dcDocComment, false);
            this.documentedTypeParameters = InvalidParam.extractDocumentedParams(dcDocComment, true);
            this.parameters = parameters;
            this.typeParameters = typeParameters;
        }

        @Override
        public Void visitParam(ParamTree paramTree, Void unused) {
            ImmutableSet<String> paramNames;
            ImmutableSet<String> immutableSet = paramNames = paramTree.isTypeParameter() ? this.typeParameters : this.parameters;
            if (!paramNames.contains((Object)paramTree.getName().toString())) {
                ImmutableSet<String> documentedParamNames = paramTree.isTypeParameter() ? this.documentedTypeParameters : this.documentedParameters;
                Sets.SetView undocumentedParameters = Sets.difference(paramNames, documentedParamNames);
                Optional<String> bestMatch = Utils.getBestMatch(paramTree.getName().toString(), (Iterable<String>)undocumentedParameters);
                String message = String.format("Parameter name `%s` is unknown.", paramTree.getName().toString());
                this.state.reportMatch(bestMatch.map(bm -> InvalidParam.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message + String.format(" Did you mean %s?", bm)).addFix((Fix)Utils.replace(paramTree.getName(), bm, this.state)).build()).orElse(InvalidParam.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message).addFix((Fix)Utils.replace(paramTree, "", this.state)).build()));
            }
            return (Void)super.visitParam(paramTree, null);
        }
    }
}

