/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.javadoc;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.javadoc.Utils;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.FindIdentifiers;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.ErroneousTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.UnknownBlockTagTree;
import com.sun.source.doctree.UnknownInlineTagTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.DCTree;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@BugPattern(name="InvalidTag", summary="This tag is invalid.", severity=BugPattern.SeverityLevel.WARNING, tags={"Style"}, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public final class InvalidTag
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final ImmutableSet<String> KNOWN_OTHER_TAGS = ImmutableSet.of((Object)"attr", (Object)"required", (Object)"hide");
    private static final ImmutableSet<String> CODE_TAGS = ImmutableSet.of((Object)"code", (Object)"pre");
    private static final ImmutableSet<String> VALID_METHOD_TAGS = ImmutableSet.of((Object)"author", (Object)"code", (Object)"deprecated", (Object)"docRoot", (Object)"exception", (Object)"inheritDoc", (Object[])new String[]{"link", "linkplain", "literal", "param", "return", "see", "serial", "since", "throws", "serialData", "serialField", "value", "version"});
    private static final ImmutableSet<String> VALID_VARIABLE_TAGS = ImmutableSet.of((Object)"code", (Object)"deprecated", (Object)"docRoot", (Object)"link", (Object)"linkplain", (Object)"literal", (Object[])new String[]{"see", "serial", "serialData", "serialField", "since", "value"});
    private static final ImmutableSet<String> VALID_CLASS_TAGS = ImmutableSet.of((Object)"author", (Object)"code", (Object)"deprecated", (Object)"docRoot", (Object)"inheritDoc", (Object)"link", (Object[])new String[]{"linkplain", "literal", "param", "see", "since", "value", "version"});
    private static final Pattern PARAM_MATCHER = Pattern.compile("\\{@param (.*)}");

    public Description matchClass(ClassTree classTree, VisitorState state) {
        DocTreePath path = Utils.getDocTreePath(state);
        if (path != null) {
            ImmutableSet parameters = ImmutableSet.of();
            new InvalidTagChecker(state, VALID_CLASS_TAGS, parameters).scan(path, null);
        }
        return Description.NO_MATCH;
    }

    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        DocTreePath path = Utils.getDocTreePath(state);
        if (path != null) {
            ImmutableSet parameters = (ImmutableSet)methodTree.getParameters().stream().map(v -> v.getName().toString()).collect(ImmutableSet.toImmutableSet());
            new InvalidTagChecker(state, VALID_METHOD_TAGS, parameters).scan(path, null);
        }
        return Description.NO_MATCH;
    }

    public Description matchVariable(VariableTree variableTree, VisitorState state) {
        DocTreePath path = Utils.getDocTreePath(state);
        if (path != null) {
            new InvalidTagChecker(state, VALID_VARIABLE_TAGS, ImmutableSet.of()).scan(path, null);
        }
        return Description.NO_MATCH;
    }

    private final class InvalidTagChecker
    extends DocTreePathScanner<Void, Void> {
        private final VisitorState state;
        private final ImmutableSet<String> validTags;
        private final ImmutableSet<String> parameters;
        private final Set<DocTree> fixedTags = new HashSet<DocTree>();
        private boolean withinCodeTag = false;

        private InvalidTagChecker(VisitorState state, ImmutableSet<String> validTags, ImmutableSet<String> parameters) {
            this.state = state;
            this.validTags = validTags;
            this.parameters = parameters;
        }

        @Override
        public Void visitStartElement(StartElementTree startElementTree, Void unused) {
            if (CODE_TAGS.contains((Object)startElementTree.getName().toString())) {
                this.withinCodeTag = true;
            }
            return (Void)super.visitStartElement(startElementTree, null);
        }

        @Override
        public Void visitEndElement(EndElementTree endElementTree, Void unused) {
            if (CODE_TAGS.contains((Object)endElementTree.getName().toString())) {
                this.withinCodeTag = false;
            }
            return (Void)super.visitEndElement(endElementTree, null);
        }

        @Override
        public Void visitErroneous(ErroneousTree erroneousTree, Void unused) {
            String parameterName;
            Matcher matcher = PARAM_MATCHER.matcher(erroneousTree.getBody());
            if (matcher.find() && this.parameters.contains((Object)(parameterName = matcher.group(1)))) {
                String message = String.format("@param cannot be used inline to refer to parameters; {@code %s} is recommended", parameterName);
                this.state.reportMatch(InvalidTag.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message).addFix((Fix)Utils.replace(erroneousTree, String.format("{@code %s}", parameterName), this.state)).build());
            }
            return null;
        }

        @Override
        public Void visitUnknownBlockTag(UnknownBlockTagTree unknownBlockTagTree, Void unused) {
            String tagName = unknownBlockTagTree.getTagName();
            if (KNOWN_OTHER_TAGS.contains((Object)tagName)) {
                return (Void)super.visitUnknownBlockTag(unknownBlockTagTree, null);
            }
            if (this.withinCodeTag) {
                int startPos = Utils.getStartPosition(unknownBlockTagTree, this.state);
                String message = String.format("@%s is not a valid block tag. Did you mean to escape it?", tagName);
                this.state.reportMatch(InvalidTag.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message).addFix((Fix)SuggestedFix.replace((int)startPos, (int)(startPos + 1), (String)"{@literal @}")).build());
                this.fixedTags.add(unknownBlockTagTree);
                return (Void)super.visitUnknownBlockTag(unknownBlockTagTree, null);
            }
            if (this.parameters.contains((Object)tagName)) {
                int startPos = Utils.getStartPosition(unknownBlockTagTree, this.state);
                String message = String.format("@%1$s is not a valid tag, but is a parameter name. Use {@code %1%s} to refer to parameter names inline.", tagName);
                this.state.reportMatch(InvalidTag.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message).addFix((Fix)SuggestedFix.replace((int)startPos, (int)(startPos + 1), (String)"@param ")).build());
                this.fixedTags.add(unknownBlockTagTree);
                return (Void)super.visitUnknownBlockTag(unknownBlockTagTree, null);
            }
            this.reportUnknownTag(unknownBlockTagTree, tagName);
            return (Void)super.visitUnknownBlockTag(unknownBlockTagTree, null);
        }

        @Override
        public Void visitUnknownInlineTag(UnknownInlineTagTree unknownInlineTagTree, Void unused) {
            String name = unknownInlineTagTree.getTagName();
            if (this.parameters.contains((Object)name)) {
                String message = String.format("`%1$s` is a parameter name, but not a valid tag. Use {@code %1$s} to refer to parameters.", name);
                this.state.reportMatch(InvalidTag.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message).addFix((Fix)Utils.replace(unknownInlineTagTree, String.format("{@code %s}", name), this.state)).build());
                this.fixedTags.add(unknownInlineTagTree);
                return (Void)super.visitUnknownInlineTag(unknownInlineTagTree, null);
            }
            if (this.isProbablyType(name)) {
                int startPos = Utils.getStartPosition(unknownInlineTagTree, this.state);
                String message = String.format("The tag {@%1$s} is not valid, and will not display or cross-link to the type %1$s correctly. Prefer {@link %1$s}.", name);
                this.state.reportMatch(InvalidTag.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message).addFix((Fix)SuggestedFix.replace((int)startPos, (int)(startPos + 2), (String)"{@link ")).build());
                this.fixedTags.add(unknownInlineTagTree);
                return (Void)super.visitUnknownInlineTag(unknownInlineTagTree, null);
            }
            this.reportUnknownTag(unknownInlineTagTree, unknownInlineTagTree.getTagName());
            return (Void)super.visitUnknownInlineTag(unknownInlineTagTree, null);
        }

        private boolean isProbablyType(String name) {
            Symbol typeSymbol = FindIdentifiers.findIdent((String)name, (VisitorState)this.state, (Kinds.KindSelector)Kinds.KindSelector.TYP);
            return typeSymbol instanceof Symbol.TypeSymbol || name.chars().filter(c -> c == 46).count() >= 3L || name.contains("#");
        }

        private void reportUnknownTag(DocTree docTree, String tagName) {
            Optional<String> bestMatch = Utils.getBestMatch(tagName, this.validTags);
            int pos = Utils.getStartPosition(docTree, this.state) + docTree.toString().indexOf(tagName);
            String message = String.format("Tag name `%s` is unknown.", tagName);
            this.state.reportMatch(bestMatch.map(bm -> InvalidTag.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message + String.format(" Did you mean tag `%s`?", bm)).addFix((Fix)SuggestedFix.replace((int)pos, (int)(pos + tagName.length()), (String)bm)).build()).orElse(InvalidTag.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message + " If this is a commonly-used custom tag, please click 'not useful' and file a bug.").build()));
            this.fixedTags.add(docTree);
        }

        @Override
        public Void scan(DocTree docTree, Void unused) {
            super.scan(docTree, null);
            if (this.fixedTags.contains(docTree)) {
                return null;
            }
            String tagName = null;
            if (docTree instanceof DCTree.DCBlockTag) {
                tagName = ((DCTree.DCBlockTag)docTree).getTagName();
            }
            if (docTree instanceof DCTree.DCInlineTag) {
                tagName = ((DCTree.DCInlineTag)docTree).getTagName();
            }
            if (tagName != null && !this.validTags.contains((Object)tagName) && !KNOWN_OTHER_TAGS.contains((Object)tagName)) {
                String message = String.format("The block tag @%s is not allowed on this type of element.", tagName);
                this.state.reportMatch(InvalidTag.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message).addFix((Fix)Utils.replace(docTree, "", this.state)).build());
            }
            return null;
        }
    }
}

