/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.nullness;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.TrustingNullnessAnalysis;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import javax.lang.model.type.TypeKind;

@BugPattern(name="NullableDereference", summary="Dereference of possibly-null value", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.NO_FIX)
public class NullableDereference
extends BugChecker
implements BugChecker.MemberSelectTreeMatcher {
    public Description matchMemberSelect(MemberSelectTree tree, VisitorState state) {
        JCTree.JCExpression receiverTree = (JCTree.JCExpression)tree.getExpression();
        if (receiverTree == null || receiverTree.type == null || receiverTree.type.getKind() == TypeKind.PACKAGE) {
            return Description.NO_MATCH;
        }
        if (tree instanceof JCTree.JCIdent && ((JCTree.JCIdent)((Object)tree)).sym.isStatic() || tree instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)tree).sym.isStatic()) {
            return Description.NO_MATCH;
        }
        Nullness nullness = TrustingNullnessAnalysis.instance((Context)state.context).getNullness(new TreePath(state.getPath(), receiverTree), state.context);
        Description.Builder descBuilder = this.buildDescription(tree);
        switch (nullness) {
            case NONNULL: 
            case BOTTOM: {
                return Description.NO_MATCH;
            }
            case NULL: {
                descBuilder.setMessage(String.format("Dereferencing method/field \"%s\" of definitely null receiver %s", tree.getIdentifier(), receiverTree));
                break;
            }
            case NULLABLE: {
                descBuilder.setMessage(String.format("Dereferencing method/field \"%s\" of possibly null receiver %s", tree.getIdentifier(), receiverTree));
            }
        }
        return descBuilder.build();
    }
}

