/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.configuration;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.netflix.governator.configuration.ConfigurationKey;
import com.netflix.governator.configuration.ConfigurationProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class CompositeConfigurationProvider
implements ConfigurationProvider {
    private final List<ConfigurationProvider> providers;

    public CompositeConfigurationProvider(ConfigurationProvider ... providers) {
        this(Lists.newArrayList(Arrays.asList(providers)));
    }

    public CompositeConfigurationProvider(Collection<ConfigurationProvider> providers) {
        this.providers = new CopyOnWriteArrayList<ConfigurationProvider>(providers);
    }

    @VisibleForTesting
    public void add(ConfigurationProvider configurationProvider) {
        this.providers.add(0, configurationProvider);
    }

    @Override
    public boolean has(ConfigurationKey key) {
        for (ConfigurationProvider provider : this.providers) {
            if (!provider.has(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Supplier<Boolean> getBooleanSupplier(ConfigurationKey key, Boolean defaultValue) {
        for (ConfigurationProvider provider : this.providers) {
            if (!provider.has(key)) continue;
            return provider.getBooleanSupplier(key, defaultValue);
        }
        return null;
    }

    @Override
    public Supplier<Integer> getIntegerSupplier(ConfigurationKey key, Integer defaultValue) {
        for (ConfigurationProvider provider : this.providers) {
            if (!provider.has(key)) continue;
            return provider.getIntegerSupplier(key, defaultValue);
        }
        return null;
    }

    @Override
    public Supplier<Long> getLongSupplier(ConfigurationKey key, Long defaultValue) {
        for (ConfigurationProvider provider : this.providers) {
            if (!provider.has(key)) continue;
            return provider.getLongSupplier(key, defaultValue);
        }
        return null;
    }

    @Override
    public Supplier<Double> getDoubleSupplier(ConfigurationKey key, Double defaultValue) {
        for (ConfigurationProvider provider : this.providers) {
            if (!provider.has(key)) continue;
            return provider.getDoubleSupplier(key, defaultValue);
        }
        return null;
    }

    @Override
    public Supplier<String> getStringSupplier(ConfigurationKey key, String defaultValue) {
        for (ConfigurationProvider provider : this.providers) {
            if (!provider.has(key)) continue;
            return provider.getStringSupplier(key, defaultValue);
        }
        return null;
    }

    @Override
    public Supplier<Date> getDateSupplier(ConfigurationKey key, Date defaultValue) {
        for (ConfigurationProvider provider : this.providers) {
            if (!provider.has(key)) continue;
            return provider.getDateSupplier(key, defaultValue);
        }
        return null;
    }

    @Override
    public <T> Supplier<T> getObjectSupplier(ConfigurationKey key, T defaultValue, Class<T> objectType) {
        for (ConfigurationProvider provider : this.providers) {
            if (!provider.has(key)) continue;
            return provider.getObjectSupplier(key, defaultValue, objectType);
        }
        return null;
    }
}

