/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.configuration;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.netflix.governator.configuration.ConfigurationKeyPart;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationKey {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String rawKey;
    private final List<ConfigurationKeyPart> parts;

    public ConfigurationKey(String rawKey, List<ConfigurationKeyPart> parts) {
        this.rawKey = rawKey;
        this.parts = ImmutableList.copyOf(parts);
    }

    public String getRawKey() {
        return this.rawKey;
    }

    public String getKey(Map<String, String> variableValues) {
        StringBuilder key = new StringBuilder();
        for (ConfigurationKeyPart p : this.parts) {
            if (p.isVariable()) {
                String value = variableValues.get(p.getValue());
                if (value == null) {
                    this.log.warn("No value found for variable: " + p.getValue());
                    value = "";
                }
                key.append(value);
                continue;
            }
            key.append(p.getValue());
        }
        return key.toString();
    }

    public List<ConfigurationKeyPart> getParts() {
        return this.parts;
    }

    public Collection<String> getVariableNames() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ConfigurationKeyPart p : this.parts) {
            if (!p.isVariable()) continue;
            builder.add((Object)p.getValue());
        }
        return builder.build();
    }

    public String toString() {
        return this.rawKey;
    }
}

