/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.configuration;

import com.google.common.base.Supplier;
import com.netflix.governator.configuration.ConfigurationKey;
import com.netflix.governator.configuration.ConfigurationProvider;
import com.netflix.governator.configuration.Property;
import java.util.Date;

public abstract class DefaultConfigurationProvider
implements ConfigurationProvider {
    @Override
    public boolean has(ConfigurationKey key) {
        return false;
    }

    @Override
    public Supplier<Boolean> getBooleanSupplier(ConfigurationKey key, Boolean defaultValue) {
        return Property.from(this.getBooleanProperty(key, defaultValue));
    }

    @Override
    public Supplier<Integer> getIntegerSupplier(ConfigurationKey key, Integer defaultValue) {
        return Property.from(this.getIntegerProperty(key, defaultValue));
    }

    @Override
    public Supplier<Long> getLongSupplier(ConfigurationKey key, Long defaultValue) {
        return Property.from(this.getLongProperty(key, defaultValue));
    }

    @Override
    public Supplier<Double> getDoubleSupplier(ConfigurationKey key, Double defaultValue) {
        return Property.from(this.getDoubleProperty(key, defaultValue));
    }

    @Override
    public Supplier<String> getStringSupplier(ConfigurationKey key, String defaultValue) {
        return Property.from(this.getStringProperty(key, defaultValue));
    }

    @Override
    public Supplier<Date> getDateSupplier(ConfigurationKey key, Date defaultValue) {
        return Property.from(this.getDateProperty(key, defaultValue));
    }

    @Override
    public <T> Supplier<T> getObjectSupplier(ConfigurationKey key, T defaultValue, Class<T> objectType) {
        return Property.from(this.getObjectProperty(key, defaultValue, objectType));
    }

    public abstract Property<Boolean> getBooleanProperty(ConfigurationKey var1, Boolean var2);

    public abstract Property<Integer> getIntegerProperty(ConfigurationKey var1, Integer var2);

    public abstract Property<Long> getLongProperty(ConfigurationKey var1, Long var2);

    public abstract Property<Double> getDoubleProperty(ConfigurationKey var1, Double var2);

    public abstract Property<String> getStringProperty(ConfigurationKey var1, String var2);

    public abstract Property<Date> getDateProperty(ConfigurationKey var1, Date var2);

    public abstract <T> Property<T> getObjectProperty(ConfigurationKey var1, T var2, Class<T> var3);
}

