/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice.bootstrap;

import com.google.inject.Inject;
import com.google.inject.ProvisionException;
import com.netflix.governator.guice.BootstrapBinder;
import com.netflix.governator.guice.BootstrapModule;
import com.netflix.governator.guice.PostInjectorAction;
import com.netflix.governator.guice.annotations.GovernatorConfiguration;

public class GovernatorBootstrap
implements BootstrapModule {
    private final GovernatorConfiguration config;

    @Inject
    public GovernatorBootstrap(GovernatorConfiguration config) {
        this.config = config;
    }

    @Override
    public void configure(BootstrapBinder binder) {
        if (!this.config.enableAutoBindSingleton()) {
            binder.disableAutoBinding();
        }
        binder.inStage(this.config.stage());
        binder.inMode(this.config.mode());
        for (Class<? extends PostInjectorAction> clazz : this.config.actions()) {
            try {
                binder.bindPostInjectorAction().to(clazz);
            }
            catch (Exception e) {
                throw new ProvisionException("Error creating postInjectorAction '" + clazz.getName() + "'", (Throwable)e);
            }
        }
        for (Class<Object> clazz : this.config.transformers()) {
            try {
                binder.bindModuleTransformer().to(clazz);
            }
            catch (Exception e) {
                throw new ProvisionException("Error creating postInjectorAction '" + clazz.getName() + "'", (Throwable)e);
            }
        }
    }
}

