/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice.runner.standalone;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.TypeLiteral;
import com.netflix.governator.annotations.binding.Main;
import com.netflix.governator.guice.BootstrapBinder;
import com.netflix.governator.guice.BootstrapModule;
import com.netflix.governator.guice.lazy.LazySingleton;
import com.netflix.governator.guice.lazy.LazySingletonScope;
import com.netflix.governator.guice.runner.LifecycleRunner;
import com.netflix.governator.guice.runner.TerminationEvent;
import com.netflix.governator.guice.runner.events.BlockingTerminationEvent;
import com.netflix.governator.lifecycle.LifecycleManager;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneRunnerModule
implements BootstrapModule {
    private static Logger LOG = LoggerFactory.getLogger(StandaloneRunnerModule.class);
    private final List<String> args;
    private final Class<?> main;
    private final TerminationEvent terminateEvent;

    public static Builder builder() {
        return new Builder();
    }

    public StandaloneRunnerModule(String[] args, Class<?> main) {
        this.args = ImmutableList.copyOf((Object[])args);
        this.main = main;
        this.terminateEvent = null;
    }

    private StandaloneRunnerModule(Builder builder) {
        this.args = builder.args;
        this.main = builder.main;
        this.terminateEvent = builder.terminateEvent;
    }

    @Override
    public void configure(BootstrapBinder binder) {
        binder.bind(MainInjectorModule.class);
        if (this.main != null) {
            binder.bind(this.main).in(LazySingletonScope.get());
            binder.bind(new TypeLiteral<Class<?>>(){}).annotatedWith(Main.class).toInstance(this.main);
        }
        if (this.args != null) {
            binder.bind(new TypeLiteral<List<String>>(){}).annotatedWith(Main.class).toInstance(this.args);
        }
        if (this.terminateEvent == null) {
            binder.bind(TerminationEvent.class).annotatedWith(Main.class).to(BlockingTerminationEvent.class);
        } else {
            binder.bind(TerminationEvent.class).annotatedWith(Main.class).toInstance((Object)this.terminateEvent);
        }
    }

    @Singleton
    public static class MainInjectorModule
    extends AbstractModule {
        protected void configure() {
            this.bind(LifecycleRunner.class).to(StandaloneFramework.class).asEagerSingleton();
        }
    }

    @LazySingleton
    public static class StandaloneFramework
    implements LifecycleRunner {
        @Inject
        private Injector injector;
        @Inject
        private LifecycleManager manager;
        @Inject(optional=true)
        @Main
        private Class<?> mainClass;
        @Inject(optional=true)
        @Main
        private List<String> args;
        @Inject
        @Main
        private TerminationEvent terminateEvent;

        @PostConstruct
        public void init() {
            try {
                LOG.info("Starting application");
                this.manager.start();
                if (this.mainClass != null) {
                    this.injector.getInstance(this.mainClass);
                }
                final ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("GovernatorStandaloneTerminator-%d").build());
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        LOG.info("Waiting for terminate event");
                        try {
                            StandaloneFramework.this.terminateEvent.await();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        LOG.info("Terminating application");
                        StandaloneFramework.this.manager.close();
                        executor.shutdown();
                    }
                });
            }
            catch (Exception e) {
                LOG.error("Error executing application ", (Throwable)e);
            }
        }
    }

    public static class Builder {
        private List<String> args = Lists.newArrayList();
        private Class<?> main;
        private TerminationEvent terminateEvent;

        public Builder withArgs(String[] args) {
            this.args.addAll(Lists.newArrayList((Object[])args));
            return this;
        }

        public Builder withMainClass(Class<?> main) {
            this.main = main;
            return this;
        }

        public Builder withTerminateEvent(TerminationEvent event) {
            this.terminateEvent = event;
            return this;
        }

        public StandaloneRunnerModule build() {
            return new StandaloneRunnerModule(this);
        }
    }
}

