/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice.serviceloader;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderWithExtensionVisitor;
import com.google.inject.spi.Toolable;
import com.google.inject.util.Types;
import com.netflix.governator.guice.lazy.LazySingletonScope;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.Callable;

public abstract class ServiceLoaderModule
extends AbstractModule {
    private final List<ServiceBinderImpl<?>> binders = Lists.newArrayList();

    public final void configure() {
        this.configureServices();
        for (ServiceBinderImpl<?> binder : this.binders) {
            this.install((Module)binder);
        }
    }

    protected abstract void configureServices();

    public <S> ServiceBinder<S> bindServices(Class<S> type) {
        ServiceBinderImpl<S> binder = new ServiceBinderImpl<S>(type);
        this.binders.add(binder);
        return binder;
    }

    public static class ServiceProvider<S>
    implements ProviderWithExtensionVisitor<S> {
        private S service;

        public ServiceProvider(S service) {
            this.service = service;
        }

        public S get() {
            System.out.println("Get : " + this.service.getClass().getName());
            return this.service;
        }

        public <B, V> V acceptExtensionVisitor(BindingTargetVisitor<B, V> visitor, ProviderInstanceBinding<? extends B> binding) {
            return (V)visitor.visit(binding);
        }

        @Inject
        @Toolable
        void initialize(Injector injector) {
            injector.injectMembers(this.service);
        }
    }

    public static class ServiceSetProvider<S>
    implements ProviderWithExtensionVisitor<Set<S>> {
        private Injector injector;
        private Callable<ServiceLoader<S>> loader;

        public ServiceSetProvider(Callable<ServiceLoader<S>> loader) {
            this.loader = loader;
        }

        public Set<S> get() {
            HashSet services = Sets.newHashSet();
            try {
                for (S obj : this.loader.call()) {
                    this.injector.injectMembers(obj);
                    services.add(obj);
                }
            }
            catch (Exception e) {
                throw new ProvisionException("Failed to laod services", (Throwable)e);
            }
            return services;
        }

        public <B, V> V acceptExtensionVisitor(BindingTargetVisitor<B, V> visitor, ProviderInstanceBinding<? extends B> binding) {
            return (V)visitor.visit(binding);
        }

        @Inject
        @Toolable
        void initialize(Injector injector) {
            this.injector = injector;
        }
    }

    static class ServiceBinderImpl<S>
    extends AbstractModule
    implements ServiceBinder<S> {
        private final Class<S> type;
        private ClassLoader classLoader;
        private boolean installed = false;
        private boolean asMultibinding = false;

        ServiceBinderImpl(Class<S> type) {
            this.type = type;
        }

        @Override
        public ServiceBinder<S> usingClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        @Override
        public ServiceBinder<S> forInstalledServices(Boolean installed) {
            this.installed = installed;
            return this;
        }

        @Override
        public ServiceBinder<S> usingMultibinding(Boolean usingMultibinding) {
            this.asMultibinding = usingMultibinding;
            return this;
        }

        protected void configure() {
            Callable loader;
            if (this.installed) {
                if (this.classLoader != null) {
                    throw new RuntimeException("Class loader may not be combined with loading installed services");
                }
                loader = new Callable<ServiceLoader<S>>(){

                    @Override
                    public ServiceLoader<S> call() throws Exception {
                        return ServiceLoader.loadInstalled(ServiceBinderImpl.this.type);
                    }
                };
            } else {
                loader = this.classLoader != null ? new Callable<ServiceLoader<S>>(){

                    @Override
                    public ServiceLoader<S> call() throws Exception {
                        return ServiceLoader.load(ServiceBinderImpl.this.type, ServiceBinderImpl.this.classLoader);
                    }
                } : new Callable<ServiceLoader<S>>(){

                    @Override
                    public ServiceLoader<S> call() throws Exception {
                        return ServiceLoader.load(ServiceBinderImpl.this.type);
                    }
                };
            }
            if (this.asMultibinding) {
                Multibinder binding = Multibinder.newSetBinder((Binder)this.binder(), this.type);
                try {
                    for (Object service : loader.call()) {
                        System.out.println("Adding binding for service : " + service.getClass().getName());
                        ServiceProvider provider = new ServiceProvider(service);
                        binding.addBinding().toProvider(provider).in(Scopes.SINGLETON);
                    }
                }
                catch (Exception e) {
                    throw new ProvisionException("Failed to load services for '" + this.type + "'", (Throwable)e);
                }
            } else {
                TypeLiteral typeLiteral = TypeLiteral.get((Type)Types.setOf(this.type));
                this.bind(typeLiteral).toProvider(new ServiceSetProvider(loader)).in(LazySingletonScope.get());
            }
        }
    }

    public static interface ServiceBinder<S> {
        public ServiceBinder<S> usingClassLoader(ClassLoader var1);

        public ServiceBinder<S> forInstalledServices(Boolean var1);

        public ServiceBinder<S> usingMultibinding(Boolean var1);
    }
}

