/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.lifecycle;

import com.netflix.governator.lifecycle.ClasspathUrlDecoder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

class DirectoryClassFilter {
    private final ClassLoader loader;

    DirectoryClassFilter(ClassLoader loader) {
        this.loader = loader;
    }

    public List<String> filesInPackage(URL url, String basePackage) {
        File dir = ClasspathUrlDecoder.toFile(url);
        ArrayList<String> classNames = new ArrayList<String>();
        if (dir.isDirectory()) {
            this.scanDir(dir, classNames, basePackage.length() > 0 ? basePackage + "." : "");
        }
        return classNames;
    }

    public InputStream bytecodeOf(String className) throws IOException {
        URL resource;
        int pos = className.indexOf("<");
        if (pos > -1) {
            className = className.substring(0, pos);
        }
        if ((pos = className.indexOf(">")) > -1) {
            className = className.substring(0, pos);
        }
        if (!className.endsWith(".class")) {
            className = className.replace('.', '/') + ".class";
        }
        if ((resource = this.loader.getResource(className)) != null) {
            return new BufferedInputStream(resource.openStream());
        }
        throw new IOException("Unable to open class with name " + className + " because the class loader was unable to locate it");
    }

    private void scanDir(File dir, List<String> classNames, String packageName) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                this.scanDir(file, classNames, packageName + file.getName() + ".");
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String name = file.getName();
            if ((name = name.replaceFirst(".class$", "")).contains(".")) continue;
            classNames.add(packageName + name);
        }
    }
}

