/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.lifecycle;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.netflix.governator.annotations.Configuration;
import com.netflix.governator.annotations.ConfigurationVariable;
import com.netflix.governator.annotations.PreConfiguration;
import com.netflix.governator.annotations.WarmUp;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.annotation.Resources;
import javax.validation.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleMethods {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Multimap<Class<? extends Annotation>, Field> fieldMap = ArrayListMultimap.create();
    private final Multimap<Class<? extends Annotation>, Method> methodMap = ArrayListMultimap.create();
    private final Multimap<Class<? extends Annotation>, Annotation> classMap = ArrayListMultimap.create();
    private boolean hasValidations = false;
    private static final Collection<Class<? extends Annotation>> fieldAnnotations;
    private static final Collection<Class<? extends Annotation>> methodAnnotations;
    private static final Collection<Class<? extends Annotation>> classAnnotations;

    public LifecycleMethods(Class<?> clazz) {
        this.addLifeCycleMethods(clazz, (Multimap<Class<? extends Annotation>, String>)ArrayListMultimap.create());
    }

    public boolean hasLifecycleAnnotations() {
        return this.hasValidations || this.methodMap.size() > 0 || this.fieldMap.size() > 0;
    }

    public Collection<Method> methodsFor(Class<? extends Annotation> annotation) {
        Collection methods = this.methodMap.get(annotation);
        return methods != null ? methods : Lists.newArrayList();
    }

    public Collection<Field> fieldsFor(Class<? extends Annotation> annotation) {
        Collection fields = this.fieldMap.get(annotation);
        return fields != null ? fields : Lists.newArrayList();
    }

    public <T extends Annotation> Collection<T> classAnnotationsFor(Class<T> annotation) {
        Collection annotations = this.classMap.get(annotation);
        return Collections2.transform((Collection)annotations, (Function)new Function<Annotation, T>(){

            public T apply(Annotation annotation) {
                return annotation;
            }
        });
    }

    private void addLifeCycleMethods(Class<?> clazz, Multimap<Class<? extends Annotation>, String> usedNames) {
        if (clazz == null) {
            return;
        }
        for (Class<? extends Annotation> annotationClass : classAnnotations) {
            if (!clazz.isAnnotationPresent(annotationClass)) continue;
            this.classMap.put(annotationClass, (Object)clazz.getAnnotation(annotationClass));
        }
        for (Field field : this.getDeclardFields(clazz)) {
            if (field.isSynthetic()) continue;
            if (!this.hasValidations) {
                this.checkForValidations(field);
            }
            for (Class<? extends Annotation> annotationClass : fieldAnnotations) {
                this.processField(field, annotationClass, usedNames);
            }
        }
        for (AccessibleObject accessibleObject : this.getDeclaredMethods(clazz)) {
            if (((Method)accessibleObject).isSynthetic() || ((Method)accessibleObject).isBridge()) continue;
            for (Class<? extends Annotation> annotationClass : methodAnnotations) {
                this.processMethod((Method)accessibleObject, annotationClass, usedNames);
            }
        }
        this.addLifeCycleMethods(clazz.getSuperclass(), usedNames);
        for (AnnotatedElement annotatedElement : clazz.getInterfaces()) {
            this.addLifeCycleMethods((Class<?>)annotatedElement, usedNames);
        }
    }

    private Method[] getDeclaredMethods(Class<?> clazz) {
        try {
            return clazz.getDeclaredMethods();
        }
        catch (Throwable e) {
            this.handleReflectionError(clazz, e);
            return new Method[0];
        }
    }

    private Field[] getDeclardFields(Class<?> clazz) {
        try {
            return clazz.getDeclaredFields();
        }
        catch (Throwable e) {
            this.handleReflectionError(clazz, e);
            return new Field[0];
        }
    }

    private void handleReflectionError(Class<?> clazz, Throwable e) {
        if (e != null) {
            if (e instanceof NoClassDefFoundError || e instanceof ClassNotFoundException) {
                this.log.debug(String.format("Class %s could not be resolved because of a class path error. Governator cannot further process the class.", clazz.getName()), e);
                return;
            }
            this.handleReflectionError(clazz, e.getCause());
        }
    }

    private void checkForValidations(Field field) {
        for (Annotation annotation : field.getDeclaredAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(Constraint.class)) continue;
            this.hasValidations = true;
            break;
        }
    }

    private void processField(Field field, Class<? extends Annotation> annotationClass, Multimap<Class<? extends Annotation>, String> usedNames) {
        if (field.isAnnotationPresent(annotationClass) && !usedNames.get(annotationClass).contains(field.getName())) {
            field.setAccessible(true);
            usedNames.put(annotationClass, (Object)field.getName());
            this.fieldMap.put(annotationClass, (Object)field);
        }
    }

    private void processMethod(Method method, Class<? extends Annotation> annotationClass, Multimap<Class<? extends Annotation>, String> usedNames) {
        if (method.isAnnotationPresent(annotationClass) && !usedNames.get(annotationClass).contains(method.getName())) {
            method.setAccessible(true);
            usedNames.put(annotationClass, (Object)method.getName());
            this.methodMap.put(annotationClass, (Object)method);
        }
    }

    static {
        ImmutableSet.Builder methodAnnotationsBuilder = ImmutableSet.builder();
        methodAnnotationsBuilder.add(PreConfiguration.class);
        methodAnnotationsBuilder.add(PostConstruct.class);
        methodAnnotationsBuilder.add(PreDestroy.class);
        methodAnnotationsBuilder.add(Resource.class);
        methodAnnotationsBuilder.add(Resources.class);
        methodAnnotationsBuilder.add(WarmUp.class);
        methodAnnotations = methodAnnotationsBuilder.build();
        ImmutableSet.Builder fieldAnnotationsBuilder = ImmutableSet.builder();
        fieldAnnotationsBuilder.add(Configuration.class);
        fieldAnnotationsBuilder.add(Resource.class);
        fieldAnnotationsBuilder.add(Resources.class);
        fieldAnnotationsBuilder.add(ConfigurationVariable.class);
        fieldAnnotations = fieldAnnotationsBuilder.build();
        ImmutableSet.Builder classAnnotationsBuilder = ImmutableSet.builder();
        classAnnotationsBuilder.add(Resource.class);
        classAnnotationsBuilder.add(Resources.class);
        classAnnotations = classAnnotationsBuilder.build();
    }
}

