/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator;

import com.google.inject.Module;
import com.google.inject.util.Modules;
import com.netflix.governator.GovernatorFeature;
import com.netflix.governator.InjectorBuilder;
import com.netflix.governator.LifecycleInjector;
import com.netflix.governator.LifecycleInjectorCreator;
import com.netflix.governator.annotations.SuppressLifecycleUninitialized;
import com.netflix.governator.internal.DefaultPropertySource;
import com.netflix.governator.internal.GovernatorFeatureSet;
import com.netflix.governator.internal.ModulesEx;
import com.netflix.governator.spi.LifecycleListener;
import com.netflix.governator.spi.ModuleListTransformer;
import com.netflix.governator.spi.ModuleTransformer;
import com.netflix.governator.spi.PropertySource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Deprecated
public class Governator {
    protected Set<String> profiles = new LinkedHashSet<String>();
    protected List<Module> modules = new ArrayList<Module>();
    protected List<ModuleListTransformer> transformers = new ArrayList<ModuleListTransformer>();
    protected List<Module> overrideModules = new ArrayList<Module>();
    protected IdentityHashMap<GovernatorFeature<?>, Object> featureOverrides = new IdentityHashMap();

    public Governator addModules(Module ... modules) {
        if (modules != null) {
            this.modules.addAll(Arrays.asList(modules));
        }
        return this;
    }

    public Governator addModules(List<Module> modules) {
        if (modules != null) {
            this.modules.addAll(modules);
        }
        return this;
    }

    public Governator addProfile(String profile) {
        if (profile != null) {
            this.profiles.add(profile);
        }
        return this;
    }

    public Governator addProfiles(String ... profiles) {
        if (profiles != null) {
            this.profiles.addAll(Arrays.asList(profiles));
        }
        return this;
    }

    public Governator addProfiles(Collection<String> profiles) {
        if (profiles != null) {
            this.profiles.addAll(profiles);
        }
        return this;
    }

    public Governator enableFeature(GovernatorFeature<Boolean> feature) {
        return this.setFeature(feature, true);
    }

    public Governator enableFeature(GovernatorFeature<Boolean> feature, boolean enabled) {
        return this.setFeature(feature, enabled);
    }

    public Governator disableFeature(GovernatorFeature<Boolean> feature) {
        return this.setFeature(feature, false);
    }

    public <T> Governator setFeature(GovernatorFeature<T> feature, T value) {
        this.featureOverrides.put(feature, value);
        return this;
    }

    public Governator addModuleListTransformer(ModuleListTransformer transformer) {
        if (transformer != null) {
            this.transformers.add(transformer);
        }
        return this;
    }

    public Governator addOverrideModules(Module ... modules) {
        if (modules != null) {
            this.overrideModules.addAll(Arrays.asList(modules));
        }
        return this;
    }

    public Governator addOverrideModules(List<Module> modules) {
        if (modules != null) {
            this.overrideModules.addAll(modules);
        }
        return this;
    }

    @Deprecated
    public LifecycleInjector createInjector(Module ... modules) {
        return new Governator().addModules(modules).run();
    }

    public LifecycleInjector createInjector(Collection<Module> modules) {
        return new Governator().addModules(new ArrayList<Module>(modules)).run();
    }

    public LifecycleInjector run() {
        return this.run(ModulesEx.emptyModule(), new String[0]);
    }

    public LifecycleInjector run(String[] args) {
        return this.run(ModulesEx.emptyModule(), args);
    }

    public LifecycleInjector run(Class<? extends LifecycleListener> mainClass) {
        return this.run(mainClass, new String[0]);
    }

    public LifecycleInjector run(LifecycleListener mainClass) {
        return this.run(ModulesEx.fromInstance(mainClass), new String[0]);
    }

    public LifecycleInjector run(LifecycleListener mainClass, String[] args) {
        return this.run(ModulesEx.fromInstance(mainClass), args);
    }

    public LifecycleInjector run(Class<? extends LifecycleListener> mainClass, String[] args) {
        return this.run(ModulesEx.fromEagerSingleton(mainClass), args);
    }

    private LifecycleInjector run(Module externalModule, String[] args) {
        return InjectorBuilder.fromModules(this.modules).combineWith(externalModule).map(new ModuleTransformer(){

            @Override
            public Module transform(Module module) {
                List<Module> modulesToTransform = Collections.singletonList(module);
                for (ModuleListTransformer transformer : Governator.this.transformers) {
                    modulesToTransform = transformer.transform(Collections.unmodifiableList(modulesToTransform));
                }
                return Modules.combine(modulesToTransform);
            }
        }).overrideWith(this.overrideModules).createInjector(new LifecycleInjectorCreator().withArguments(args).withFeatures(this.featureOverrides).withProfiles(this.profiles));
    }

    static {
        System.setProperty("archaius.default.configuration.class", "com.netflix.archaius.bridge.StaticAbstractConfiguration");
        System.setProperty("archaius.default.deploymentContext.class", "com.netflix.archaius.bridge.StaticDeploymentContext");
    }

    @Singleton
    @SuppressLifecycleUninitialized
    class GovernatorFeatureSetImpl
    implements GovernatorFeatureSet {
        private final IdentityHashMap<GovernatorFeature<?>, Object> featureOverrides;
        @Inject
        private PropertySource properties = new DefaultPropertySource();

        @Inject
        public GovernatorFeatureSetImpl(IdentityHashMap<GovernatorFeature<?>, Object> featureOverrides) {
            this.featureOverrides = featureOverrides;
        }

        @Override
        public <T> T get(GovernatorFeature<T> feature) {
            return (T)(this.featureOverrides.containsKey(feature) ? this.featureOverrides.get(feature) : this.properties.get(feature.getKey(), feature.getType(), feature.getDefaultValue()));
        }
    }
}

