/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator;

import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Singleton;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.ProvisionListener;
import com.netflix.governator.ProvisionMetrics;
import com.netflix.governator.SimpleProvisionMetrics;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvisionMetricsModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(ProvisionMetricsModule.class);
    private MetricsProvisionListener listener = new MetricsProvisionListener();

    protected void configure() {
        this.bindListener(Matchers.any(), new ProvisionListener[]{this.listener});
        this.requestStaticInjection(new Class[]{MetricsProvisionListener.class});
        this.bind(MetricsProvisionListener.class).toInstance((Object)this.listener);
        this.bind(ProvisionMetrics.class).to(SimpleProvisionMetrics.class);
    }

    @Singleton
    private static class MetricsProvisionListener
    implements ProvisionListener {
        private ProvisionMetrics metrics;

        private MetricsProvisionListener() {
        }

        @Inject
        public static void initialize(MetricsProvisionListener listener, ProvisionMetrics metrics) {
            listener.metrics = metrics;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
            Key key = provision.getBinding().getKey();
            if (this.metrics == null) {
                LOG.debug("LifecycleProvisionListener not initialized yet : {} source={}", (Object)key, provision.getBinding().getSource());
                return;
            }
            this.metrics.push(key);
            try {
                provision.provision();
            }
            finally {
                this.metrics.pop();
            }
        }
    }
}

