/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator;

import com.netflix.governator.spi.LifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SafeLifecycleListener
implements LifecycleListener {
    private static final Logger LOG = LoggerFactory.getLogger(SafeLifecycleListener.class);
    private final LifecycleListener delegate;

    public static SafeLifecycleListener wrap(LifecycleListener listener) {
        return new SafeLifecycleListener(listener);
    }

    private SafeLifecycleListener(LifecycleListener delegate) {
        this.delegate = delegate;
    }

    public void onStarted() {
        LOG.info("Starting LifecycleListener '{}'", (Object)this.delegate);
        this.delegate.onStarted();
    }

    public void onStopped(Throwable t) {
        LOG.info("Stopping LifecycleListener '{}'", (Object)this.delegate, (Object)t);
        try {
            this.delegate.onStopped(t);
        }
        catch (Exception e) {
            LOG.info("onStopped failed for listener {}", (Object)this.delegate, (Object)e);
        }
    }

    public String toString() {
        return "Safe[" + this.delegate.toString() + "]";
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SafeLifecycleListener other = (SafeLifecycleListener)obj;
        return !this.delegate.equals(other.delegate);
    }
}

