/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator;

import com.google.inject.Key;
import com.netflix.governator.ProvisionMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;

@Singleton
public class SimpleProvisionMetrics
implements ProvisionMetrics {
    private final ThreadLocal<Data> context = new ThreadLocal();
    private final CopyOnWriteArraySet<Data> threads = new CopyOnWriteArraySet();

    @Override
    public void push(Key<?> type) {
        Data data = this.context.get();
        if (data == null) {
            data = new Data();
            this.context.set(data);
            this.threads.add(data);
        }
        Entry entry = new Entry(type);
        if (data.stack.isEmpty()) {
            data.children.add(entry);
        } else {
            data.stack.peek().add(entry);
        }
        data.stack.push(entry);
    }

    @Override
    public void pop() {
        Data data = this.context.get();
        Entry entry = data.stack.pop();
        entry.finish();
    }

    @Override
    public void accept(ProvisionMetrics.Visitor visitor) {
        for (Data data : this.threads) {
            data.accept(visitor);
        }
    }

    public static class Entry
    implements ProvisionMetrics.Element {
        final Key<?> key;
        final List<Entry> children = new ArrayList<Entry>();
        final long startTime = System.nanoTime();
        long endTime;

        Entry(Key<?> key) {
            this.key = key;
        }

        void add(Entry child) {
            this.children.add(child);
        }

        void finish() {
            this.endTime = System.nanoTime();
        }

        @Override
        public Key<?> getKey() {
            return this.key;
        }

        @Override
        public void accept(ProvisionMetrics.Visitor visit) {
            for (Entry entry : this.children) {
                visit.visit(entry);
            }
        }

        @Override
        public long getDuration(TimeUnit units) {
            long childDuration = 0L;
            for (Entry child : this.children) {
                childDuration += child.getDuration(units);
            }
            return this.getTotalDuration(units) - childDuration;
        }

        @Override
        public long getTotalDuration(TimeUnit units) {
            return units.convert(this.endTime - this.startTime, TimeUnit.NANOSECONDS);
        }
    }

    public static class Data {
        List<Entry> children = new ArrayList<Entry>();
        Stack<Entry> stack = new Stack();

        void accept(ProvisionMetrics.Visitor visit) {
            for (Entry entry : this.children) {
                visit.visit(entry);
            }
        }
    }
}

