/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.internal;

import com.netflix.governator.LifecycleAction;
import com.netflix.governator.LifecycleFeature;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

abstract class AbstractLifecycleFeature
implements LifecycleFeature {
    AbstractLifecycleFeature() {
    }

    private void visitFieldsAndMethods(Class<?> type, List<LifecycleAction> actions) {
        if (type == null) {
            return;
        }
        for (Field field : type.getDeclaredFields()) {
            actions.addAll(this.getFieldActions(type, field));
        }
        for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
            actions.addAll(this.getMethodActions(type, (Method)accessibleObject));
        }
        this.visitFieldsAndMethods(type.getSuperclass(), actions);
        for (AnnotatedElement annotatedElement : type.getInterfaces()) {
            this.visitFieldsAndMethods((Class<?>)annotatedElement, actions);
        }
    }

    protected List<LifecycleAction> getFieldActions(Class<?> type, Field field) {
        return Collections.emptyList();
    }

    protected List<LifecycleAction> getMethodActions(Class<?> type, Method method) {
        return Collections.emptyList();
    }

    @Override
    public List<LifecycleAction> getActionsForType(Class<?> type) {
        ArrayList<LifecycleAction> actions = new ArrayList<LifecycleAction>();
        this.visitFieldsAndMethods(type, actions);
        return actions;
    }
}

