/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.internal;

import com.netflix.governator.LifecycleAction;
import com.netflix.governator.internal.AbstractLifecycleFeature;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;

public final class PostConstructLifecycleActions
extends AbstractLifecycleFeature {
    public static PostConstructLifecycleActions INSTANCE = new PostConstructLifecycleActions();

    private PostConstructLifecycleActions() {
    }

    @Override
    protected List<LifecycleAction> getMethodActions(final Class<?> type, final Method method) {
        if (null != method.getAnnotation(PostConstruct.class)) {
            method.setAccessible(true);
            return Collections.singletonList(new LifecycleAction(){

                @Override
                public void call(Object obj) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                    method.invoke(obj, new Object[0]);
                }

                public String toString() {
                    return "PostConstruct[" + type.getName() + "#" + method.getName() + "]";
                }
            });
        }
        return Collections.emptyList();
    }

    public String toString() {
        return "PostConstruct";
    }
}

